/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.packets.server.ability.components;

import com.google.common.base.Strings;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import xyz.pixelatedw.mineminenomi.api.ModRegistries;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;

public class SChangeMorphPacket {
    private int entityId;
    private int abilityId;
    private String morph;
    private MorphInfo morphInfo;

    public SChangeMorphPacket() {
    }

    public SChangeMorphPacket(LivingEntity entity, IAbility ability, MorphInfo morphInfo, String morph) {
        this.entityId = entity.func_145782_y();
        this.abilityId = AbilityDataCapability.get(entity).getEquippedAbilitySlot(ability);
        this.morphInfo = morphInfo;
        this.morph = morph;
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.entityId);
        buffer.writeInt(this.abilityId);
        buffer.func_192572_a(this.morphInfo.getRegistryName());
        int len = this.morph.length();
        buffer.writeInt(len);
        buffer.func_211400_a(this.morph, len);
    }

    public static SChangeMorphPacket decode(PacketBuffer buffer) {
        SChangeMorphPacket msg = new SChangeMorphPacket();
        msg.entityId = buffer.readInt();
        msg.abilityId = buffer.readInt();
        msg.morphInfo = (MorphInfo)ModRegistries.MORPHS.getValue(buffer.func_192575_l());
        int len = buffer.readInt();
        msg.morph = buffer.func_150789_c(len);
        return msg;
    }

    public static void handle(SChangeMorphPacket message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            ctx.get().enqueueWork(() -> ClientHandler.handle(message));
        }
        ctx.get().setPacketHandled(true);
    }

    public static class ClientHandler {
        @OnlyIn(value=Dist.CLIENT)
        public static void handle(SChangeMorphPacket message) {
            Entity target = Minecraft.func_71410_x().field_71441_e.func_73045_a(message.entityId);
            if (target == null || !(target instanceof LivingEntity)) {
                return;
            }
            if (message.morphInfo == null) {
                return;
            }
            LivingEntity entity = (LivingEntity)target;
            IAbilityData props = AbilityDataCapability.get(entity);
            Object abl = props.getEquippedAbility(message.abilityId);
            if (abl == null) {
                return;
            }
            abl.getComponent(ModAbilityKeys.MORPH).ifPresent(comp -> {
                if (Strings.isNullOrEmpty((String)message.morph)) {
                    comp.stopMorph(entity);
                } else {
                    comp.startMorph(entity, message.morphInfo);
                }
                message.morphInfo.updateMorphSize(entity);
            });
        }
    }
}

