/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.packets.server.entities;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import xyz.pixelatedw.mineminenomi.data.entity.kairosekicoating.IKairosekiCoating;
import xyz.pixelatedw.mineminenomi.data.entity.kairosekicoating.KairosekiCoatingCapability;

public class SKairosekiCoatingPacket {
    private int entityId;
    private int coatingLevel;

    public SKairosekiCoatingPacket() {
    }

    public SKairosekiCoatingPacket(int entityId, int coatingLevel) {
        this.entityId = entityId;
        this.coatingLevel = coatingLevel;
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.entityId);
        buffer.writeInt(this.coatingLevel);
    }

    public static SKairosekiCoatingPacket decode(PacketBuffer buffer) {
        SKairosekiCoatingPacket msg = new SKairosekiCoatingPacket();
        msg.entityId = buffer.readInt();
        msg.coatingLevel = buffer.readInt();
        return msg;
    }

    public static void handle(SKairosekiCoatingPacket message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            ctx.get().enqueueWork(() -> ClientHandler.handle(message));
        }
        ctx.get().setPacketHandled(true);
    }

    public static class ClientHandler {
        @OnlyIn(value=Dist.CLIENT)
        public static void handle(SKairosekiCoatingPacket message) {
            ClientWorld world = Minecraft.func_71410_x().field_71441_e;
            Entity entity = world.func_73045_a(message.entityId);
            if (entity == null) {
                return;
            }
            IKairosekiCoating coatingData = (IKairosekiCoating)KairosekiCoatingCapability.get(entity).orElse(null);
            if (coatingData == null) {
                return;
            }
            coatingData.setCoatingLevel(message.coatingLevel);
        }
    }
}

