/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.packets.server.entities;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;

public class SPinCameraPacket {
    private boolean clampYaw = false;
    private boolean clampPitch = false;
    private float initialYaw;
    private float initialPitch;
    private float maxYaw;
    private float maxPitch;
    private int ticks;

    public static SPinCameraPacket pinFixed() {
        SPinCameraPacket packet = new SPinCameraPacket();
        return packet;
    }

    public static SPinCameraPacket pinClampedYaw(float initialYaw, float maxYaw) {
        SPinCameraPacket packet = new SPinCameraPacket();
        packet.initialYaw = initialYaw % 360.0f;
        packet.maxYaw = maxYaw % 360.0f;
        packet.clampYaw = true;
        return packet;
    }

    public static SPinCameraPacket pinClampedPitch(float initialPitch, float maxPitch) {
        SPinCameraPacket packet = new SPinCameraPacket();
        packet.initialPitch = initialPitch % 360.0f;
        packet.maxPitch = maxPitch % 360.0f;
        packet.clampPitch = true;
        return packet;
    }

    public static SPinCameraPacket pinClampedYawAndPitch(float initialYaw, float maxYaw, float initialPitch, float maxPitch) {
        SPinCameraPacket packet = new SPinCameraPacket();
        packet.initialYaw = initialYaw % 360.0f;
        packet.initialPitch = initialPitch % 360.0f;
        packet.maxYaw = maxYaw % 360.0f;
        packet.maxPitch = maxPitch % 360.0f;
        packet.clampYaw = true;
        packet.clampPitch = true;
        return packet;
    }

    public SPinCameraPacket setTimed(int ticks) {
        this.ticks = ticks;
        return this;
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeBoolean(this.clampYaw);
        buffer.writeBoolean(this.clampPitch);
        buffer.writeFloat(this.initialYaw);
        buffer.writeFloat(this.initialPitch);
        buffer.writeFloat(this.maxYaw);
        buffer.writeFloat(this.maxPitch);
        buffer.writeInt(this.ticks);
    }

    public static SPinCameraPacket decode(PacketBuffer buffer) {
        SPinCameraPacket msg = new SPinCameraPacket();
        msg.clampYaw = buffer.readBoolean();
        msg.clampPitch = buffer.readBoolean();
        msg.initialYaw = buffer.readFloat();
        msg.initialPitch = buffer.readFloat();
        msg.maxYaw = buffer.readFloat();
        msg.maxPitch = buffer.readFloat();
        msg.ticks = buffer.readInt();
        return msg;
    }

    public static void handle(SPinCameraPacket message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            ctx.get().enqueueWork(() -> ClientHandler.handle(message));
        }
        ctx.get().setPacketHandled(true);
    }

    public static class ClientHandler {
        @OnlyIn(value=Dist.CLIENT)
        public static void handle(SPinCameraPacket message) {
            Minecraft mc = Minecraft.func_71410_x();
            ClientPlayerEntity player = mc.field_71439_g;
            ActiveRenderInfo camera = mc.field_71460_t.func_215316_n();
            IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
            if (props == null) {
                return;
            }
            props.pinCamera((PlayerEntity)player);
            if (message.clampYaw) {
                props.clampCameraYaw((PlayerEntity)player, message.initialYaw, message.maxYaw);
            }
            if (message.clampPitch) {
                props.clampCameraPitch((PlayerEntity)player, message.initialPitch, message.maxPitch);
            }
            props.setCameraPinTimer(message.ticks);
        }
    }
}

