/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.packets.server.quest;

import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

public class SDespawnQuestObjectivePacket {
    private UUID ownerUUID;
    private int targetId;

    public SDespawnQuestObjectivePacket() {
    }

    public SDespawnQuestObjectivePacket(UUID uuid, int targetId) {
        this.ownerUUID = uuid;
        this.targetId = targetId;
    }

    public void encode(PacketBuffer buffer) {
        buffer.func_179252_a(this.ownerUUID);
        buffer.writeInt(this.targetId);
    }

    public static SDespawnQuestObjectivePacket decode(PacketBuffer buffer) {
        SDespawnQuestObjectivePacket msg = new SDespawnQuestObjectivePacket();
        msg.ownerUUID = buffer.func_179253_g();
        msg.targetId = buffer.readInt();
        return msg;
    }

    public static void handle(SDespawnQuestObjectivePacket message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            ctx.get().enqueueWork(() -> ClientHandler.handle(message));
        }
        ctx.get().setPacketHandled(true);
    }

    public static class ClientHandler {
        @OnlyIn(value=Dist.CLIENT)
        public static void handle(SDespawnQuestObjectivePacket message) {
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            ClientWorld world = Minecraft.func_71410_x().field_71441_e;
            Entity target = world.func_73045_a(message.targetId);
            if (player.func_110124_au().equals(message.ownerUUID)) {
                return;
            }
            target.func_70106_y();
        }
    }
}

