/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.packets.server.randfruit;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import xyz.pixelatedw.mineminenomi.events.devilfruits.RandomFruitEvents;

public class SSetFruitSeedsPacket {
    private HashMap<Integer, Long> seeds = new HashMap();
    private long worldSeed;

    public SSetFruitSeedsPacket() {
    }

    public SSetFruitSeedsPacket(HashMap<Integer, Long> seeds, long worldSeed) {
        this.seeds = seeds;
        this.worldSeed = worldSeed;
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeLong(this.worldSeed);
        buffer.writeInt(this.seeds.entrySet().size());
        for (Map.Entry<Integer, Long> entry : this.seeds.entrySet()) {
            buffer.writeInt(entry.getKey().intValue());
            buffer.writeLong(entry.getValue().longValue());
        }
    }

    public static SSetFruitSeedsPacket decode(PacketBuffer buffer) {
        SSetFruitSeedsPacket msg = new SSetFruitSeedsPacket();
        msg.worldSeed = buffer.readLong();
        HashMap<Integer, Long> seeds = new HashMap<Integer, Long>();
        int size = buffer.readInt();
        for (int i = 0; i < size; ++i) {
            int key = buffer.readInt();
            long seed = buffer.readLong();
            seeds.put(key, seed);
        }
        msg.seeds = seeds;
        return msg;
    }

    public static void handle(SSetFruitSeedsPacket message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            ctx.get().enqueueWork(() -> ClientHandler.handle(message));
        }
        ctx.get().setPacketHandled(true);
    }

    public static class ClientHandler {
        @OnlyIn(value=Dist.CLIENT)
        public static void handle(SSetFruitSeedsPacket message) {
            RandomFruitEvents.Client.FRUIT_SEEDS = message.seeds;
            RandomFruitEvents.Client.DIRTY = true;
            RandomFruitEvents.Common.SEED = message.worldSeed;
        }
    }
}

