/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.packets.server.ui;

import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import xyz.pixelatedw.mineminenomi.screens.CharacterCreatorScreen;

public class SOpenCharacterCreatorScreenPacket {
    private boolean hasRandomizedRace;
    private boolean allowMinkRaceSelect;

    public SOpenCharacterCreatorScreenPacket() {
    }

    public SOpenCharacterCreatorScreenPacket(boolean hasRandomizedRace, boolean allowMinkRaceSelect) {
        this.hasRandomizedRace = hasRandomizedRace;
        this.allowMinkRaceSelect = allowMinkRaceSelect;
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeBoolean(this.hasRandomizedRace);
        buffer.writeBoolean(this.allowMinkRaceSelect);
    }

    public static SOpenCharacterCreatorScreenPacket decode(PacketBuffer buffer) {
        SOpenCharacterCreatorScreenPacket msg = new SOpenCharacterCreatorScreenPacket();
        msg.hasRandomizedRace = buffer.readBoolean();
        msg.allowMinkRaceSelect = buffer.readBoolean();
        return msg;
    }

    public static void handle(SOpenCharacterCreatorScreenPacket message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            ctx.get().enqueueWork(() -> ClientHandler.handle(message));
        }
        ctx.get().setPacketHandled(true);
    }

    public static class ClientHandler {
        @OnlyIn(value=Dist.CLIENT)
        public static void handle(SOpenCharacterCreatorScreenPacket message) {
            CharacterCreatorScreen.open(message.hasRandomizedRace, message.allowMinkRaceSelect);
        }
    }
}

