/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.packets.server.ui;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import xyz.pixelatedw.mineminenomi.api.entities.ITrainer;
import xyz.pixelatedw.mineminenomi.screens.TrainerScreen;

public class SOpenQuestChooseScreenPacket {
    private int questGiverEntity;
    private boolean isInCombat;

    public SOpenQuestChooseScreenPacket() {
    }

    public SOpenQuestChooseScreenPacket(int questGiverEntity, boolean isInCombat) {
        this.questGiverEntity = questGiverEntity;
        this.isInCombat = isInCombat;
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.questGiverEntity);
        buffer.writeBoolean(this.isInCombat);
    }

    public static SOpenQuestChooseScreenPacket decode(PacketBuffer buffer) {
        SOpenQuestChooseScreenPacket msg = new SOpenQuestChooseScreenPacket();
        msg.questGiverEntity = buffer.readInt();
        msg.isInCombat = buffer.readBoolean();
        return msg;
    }

    public static void handle(SOpenQuestChooseScreenPacket message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            ctx.get().enqueueWork(() -> ClientHandler.handle(message));
        }
        ctx.get().setPacketHandled(true);
    }

    public static class ClientHandler {
        @OnlyIn(value=Dist.CLIENT)
        public static void handle(SOpenQuestChooseScreenPacket message) {
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            Entity questGiver = Minecraft.func_71410_x().field_71441_e.func_73045_a(message.questGiverEntity);
            if (!(questGiver instanceof ITrainer)) {
                return;
            }
            Minecraft.func_71410_x().func_147108_a((Screen)new TrainerScreen((PlayerEntity)player, (LivingEntity)questGiver, ((ITrainer)questGiver).getAvailableQuests((PlayerEntity)player), message.isInCombat));
        }
    }
}

