/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.packets.server.ui;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import xyz.pixelatedw.mineminenomi.api.ModRegistries;
import xyz.pixelatedw.mineminenomi.api.interactions.Interaction;
import xyz.pixelatedw.mineminenomi.screens.DialogueScreen;

public class STriggerInteractionPacket {
    private Interaction interaction;

    public STriggerInteractionPacket() {
    }

    public STriggerInteractionPacket(Interaction interaction) {
        this.interaction = interaction;
    }

    public void encode(PacketBuffer buffer) {
        buffer.func_192572_a(this.interaction.getRegistryName());
    }

    public static STriggerInteractionPacket decode(PacketBuffer buffer) {
        STriggerInteractionPacket msg = new STriggerInteractionPacket();
        ResourceLocation res = buffer.func_192575_l();
        msg.interaction = (Interaction)ModRegistries.INTERACTIONS.getValue(res);
        return msg;
    }

    public static void handle(STriggerInteractionPacket message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            ctx.get().enqueueWork(() -> ClientHandler.handle(message));
        }
        ctx.get().setPacketHandled(true);
    }

    public static class ClientHandler {
        @OnlyIn(value=Dist.CLIENT)
        public static void handle(STriggerInteractionPacket message) {
            Minecraft minecraft = Minecraft.func_71410_x();
            ClientPlayerEntity player = minecraft.field_71439_g;
            ClientWorld world = minecraft.field_71441_e;
            if (!(minecraft.field_71462_r instanceof DialogueScreen)) {
                return;
            }
            DialogueScreen screen = (DialogueScreen)minecraft.field_71462_r;
            screen.triggerInteraction(message.interaction);
        }
    }
}

