/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.particles;

import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.TexturedParticle;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import xyz.pixelatedw.mineminenomi.api.math.EasingDirection;
import xyz.pixelatedw.mineminenomi.api.math.EasingFunction;
import xyz.pixelatedw.mineminenomi.particles.data.SimpleParticleData;
import xyz.pixelatedw.mineminenomi.particles.rendertypes.SimpleParticleRenderType;

@OnlyIn(value=Dist.CLIENT)
public class SimpleParticle
extends TexturedParticle {
    private boolean hasMotionDecay = true;
    private boolean hasScaleDecay = true;
    private Vector3f rotationVector;
    private float rotationSpeed;
    protected IParticleRenderType type;
    protected final float initialSize;
    private boolean faceCamera;
    private float yaw;
    private float pitch;
    private int animIdx = 0;
    private int animSpeed = 2;
    private int maxFrames = 8;
    private EasingFunction function;
    private EasingDirection easeDir;
    private float easeStrength = 1.0f;

    public SimpleParticle(SimpleParticleData data, IParticleRenderType type, ClientWorld world, double x, double y, double z, double xd, double yd, double zd) {
        super(world, x, y, z, 0.0, 0.0, 0.0);
        this.field_70547_e = 30 + this.field_187136_p.nextInt(10);
        this.field_70546_d = 0;
        this.field_70544_f = 0.2f;
        this.field_70545_g = 0.0f;
        this.func_70538_b(1.0f, 1.0f, 1.0f);
        this.field_190017_n = false;
        this.type = type;
        this.field_187129_i = xd;
        this.field_187130_j = yd;
        this.field_187131_k = zd;
        this.func_70538_b(data.getRed(), data.getGreen(), data.getBlue());
        this.setRotation(new Vector3f(data.getRotX(), data.getRotY(), data.getRotZ()));
        this.func_82338_g(data.getAlpha());
        this.setParticleSize(data.getSize() / 10.0f);
        this.setParticleRotation(data.getRotationSpeed());
        this.setParticleAge(data.getLife());
        this.setHasMotionDecay(data.hasMotionDecay());
        this.setHasScaleDecay(data.hasScaleDecay());
        this.faceCamera = data.faceCamera();
        this.yaw = data.getYaw();
        this.pitch = data.getPitch();
        this.animSpeed = data.getAnimationSpeed();
        this.function = data.getFunction();
        this.easeDir = data.getEaseDirecetion();
        this.easeStrength = data.getEaseStrength();
        this.initialSize = this.field_70544_f;
    }

    public void func_189213_a() {
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        if (this.field_70545_g != 0.0f) {
            this.field_187130_j = -0.04 * (double)this.field_70545_g;
        }
        if (this.field_70546_d % this.animSpeed == 0) {
            ++this.animIdx;
        }
        this.func_187110_a(this.field_187129_i, this.field_187130_j, this.field_187131_k);
        if (this.hasMotionDecay) {
            this.field_187129_i *= 0.99;
            this.field_187130_j *= 0.99;
            this.field_187131_k *= 0.99;
        }
        if (this.hasScaleDecay) {
            if (this.field_70546_d >= this.field_70547_e / 2 && this.field_70544_f > 0.0f) {
                this.field_70544_f /= 1.1f;
            }
            if (this.field_70546_d + 5 >= this.field_70547_e && this.field_82339_as > 0.0f) {
                this.field_82339_as = (float)((double)this.field_82339_as / 1.15);
            }
        } else {
            if (this.function != null) {
                float speedModifier = 0.0f;
                float progress = Math.min((float)this.field_70546_d / ((float)this.field_70547_e * (1.0f - speedModifier)), 1.0f);
                float result = this.function.apply(progress) * this.easeStrength;
                float quadSize = this.initialSize;
                switch (this.easeDir) {
                    case POSITIVE: {
                        quadSize = this.initialSize + this.initialSize * result;
                        break;
                    }
                    case NEGATIVE: {
                        quadSize = this.initialSize - this.initialSize * result;
                        break;
                    }
                    case HALF_HALF: {
                        quadSize = (double)progress < 0.5 ? this.initialSize + this.initialSize * result : this.initialSize - this.initialSize * result;
                        break;
                    }
                }
                this.field_70544_f = quadSize;
            }
            if (this.field_70546_d + 5 >= this.field_70547_e && this.field_82339_as > 0.0f) {
                this.field_82339_as = (float)((double)this.field_82339_as / 1.15);
            }
        }
        if (this.rotationSpeed != 0.0f) {
            this.field_190014_F -= this.rotationSpeed;
        }
        if (this.field_70546_d++ >= this.field_70547_e || this.field_187132_l) {
            this.func_187112_i();
        }
    }

    public void func_225606_a_(IVertexBuilder buffer, ActiveRenderInfo renderInfo, float partialTicks) {
        Vector3d Vector3d2 = renderInfo.func_216785_c();
        float f = (float)(MathHelper.func_219803_d((double)partialTicks, (double)this.field_187123_c, (double)this.field_187126_f) - Vector3d2.func_82615_a());
        float f1 = (float)(MathHelper.func_219803_d((double)partialTicks, (double)this.field_187124_d, (double)this.field_187127_g) - Vector3d2.func_82617_b());
        float f2 = (float)(MathHelper.func_219803_d((double)partialTicks, (double)this.field_187125_e, (double)this.field_187128_h) - Vector3d2.func_82616_c());
        Quaternion quaternion = new Quaternion(0.0f, 0.0f, 0.0f, 1.0f);
        if (this.faceCamera) {
            Quaternion quatX = new Quaternion(this.yaw, 0.0f, 0.0f, true);
            Quaternion quatY = new Quaternion(0.0f, -this.pitch, 0.0f, true);
            quaternion.func_195890_a(quatY);
            quaternion.func_195890_a(quatX);
        } else if (this.field_190014_F == 0.0f) {
            quaternion = renderInfo.func_227995_f_();
        } else {
            quaternion = new Quaternion(renderInfo.func_227995_f_());
            quaternion.func_195890_a(this.rotationVector.func_229193_c_(this.field_190014_F));
        }
        Vector3f vector3f1 = new Vector3f(-1.0f, -1.0f, 0.0f);
        vector3f1.func_214905_a(quaternion);
        Vector3f[] avector3f = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        float scale = this.func_217561_b(partialTicks);
        for (int i = 0; i < 4; ++i) {
            Vector3f vector3f = avector3f[i];
            vector3f.func_214905_a(quaternion);
            vector3f.func_195898_a(scale);
            vector3f.func_195904_b(f, f1, f2);
        }
        float minU = this.func_217563_c();
        float maxU = this.func_217564_d();
        float minV = this.func_217562_e();
        float maxV = this.func_217560_f();
        int brightness = this.func_189214_a(partialTicks);
        buffer.func_225582_a_((double)avector3f[0].func_195899_a(), (double)avector3f[0].func_195900_b(), (double)avector3f[0].func_195902_c()).func_225583_a_(maxU, maxV).func_227885_a_(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_227886_a_(brightness).func_181675_d();
        buffer.func_225582_a_((double)avector3f[1].func_195899_a(), (double)avector3f[1].func_195900_b(), (double)avector3f[1].func_195902_c()).func_225583_a_(maxU, minV).func_227885_a_(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_227886_a_(brightness).func_181675_d();
        buffer.func_225582_a_((double)avector3f[2].func_195899_a(), (double)avector3f[2].func_195900_b(), (double)avector3f[2].func_195902_c()).func_225583_a_(minU, minV).func_227885_a_(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_227886_a_(brightness).func_181675_d();
        buffer.func_225582_a_((double)avector3f[3].func_195899_a(), (double)avector3f[3].func_195900_b(), (double)avector3f[3].func_195902_c()).func_225583_a_(minU, maxV).func_227885_a_(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_227886_a_(brightness).func_181675_d();
    }

    public void setMaxFrames(int frames) {
        this.maxFrames = frames;
    }

    public SimpleParticle setAlphaF(float f) {
        this.func_82338_g(f);
        return this;
    }

    public SimpleParticle setParticleSize(float f) {
        this.field_70544_f = f;
        return this;
    }

    public SimpleParticle setParticleRotation(float f) {
        this.rotationSpeed = f;
        return this;
    }

    public SimpleParticle setParticleGravity(float f) {
        this.field_70545_g = f;
        return this;
    }

    public SimpleParticle setParticleAge(int i) {
        this.field_70547_e = i;
        return this;
    }

    public SimpleParticle setHasMotionDecay(boolean flag) {
        this.hasMotionDecay = flag;
        return this;
    }

    public Vector3f getRotationVec() {
        return this.rotationVector;
    }

    public SimpleParticle setRotation(Vector3f vec) {
        this.rotationVector = vec;
        return this;
    }

    public SimpleParticle setHasScaleDecay(boolean flag) {
        this.hasScaleDecay = flag;
        return this;
    }

    public BlockPos getPos() {
        return new BlockPos(this.field_187126_f, this.field_187127_g, this.field_187128_h);
    }

    public IParticleRenderType func_217558_b() {
        return this.type;
    }

    protected float func_217563_c() {
        return 0.0f;
    }

    protected float func_217562_e() {
        return (float)this.animIdx / (float)this.maxFrames;
    }

    protected float func_217564_d() {
        return 1.0f;
    }

    protected float func_217560_f() {
        return (float)(this.animIdx + 1) / (float)this.maxFrames;
    }

    public static class Factory
    implements IParticleFactory<SimpleParticleData> {
        private IParticleRenderType type;
        private int maxFrames = 0;

        public Factory(ResourceLocation res) {
            this(res, 1);
        }

        public Factory(ResourceLocation res, int maxFrames) {
            this.type = new SimpleParticleRenderType(res);
            this.maxFrames = maxFrames;
        }

        public Particle createParticle(SimpleParticleData data, ClientWorld world, double x, double y, double z, double velX, double velY, double velZ) {
            SimpleParticle part = new SimpleParticle(data, this.type, world, x, y, z, data.getDeltaMovementX(), data.getDeltaMovementY(), data.getDeltaMovementZ());
            part.setMaxFrames(this.maxFrames);
            return part;
        }
    }
}

