/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.particles.effects;

import java.awt.Color;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.world.World;
import xyz.pixelatedw.mineminenomi.api.math.EasingFunction;
import xyz.pixelatedw.mineminenomi.init.ModParticleTypes;
import xyz.pixelatedw.mineminenomi.particles.data.SimpleParticleData;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class CommandMarkParticleEffect
extends ParticleEffect<Details> {
    public CommandMarkParticleEffect() {
        super(Details::new);
    }

    @Override
    public void spawn(Entity entity, World world, double posX, double posY, double posZ, Details details) {
        Color color = details.getColor();
        SimpleParticleData particle = new SimpleParticleData((ParticleType)ModParticleTypes.COMMAND_MARK.get());
        particle.setLife(5);
        particle.setSize(details.isMainMark() ? 5.0f : 4.0f);
        particle.setColor((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, 1.0f);
        particle.setFunction(EasingFunction.BOUNCE_IN);
        particle.setMotion(0.0, 0.01, 0.0);
        world.func_195590_a((IParticleData)particle, true, posX, posY + 0.75, posZ, 0.0, 0.0, 0.0);
    }

    public static class Details
    extends ParticleEffect.Details {
        private boolean isMain;
        private int rgb;

        public Details() {
        }

        public Details(int rgb, boolean isMain) {
            this.rgb = rgb;
            this.isMain = true;
        }

        public Details(String hex, boolean isMain) {
            this(WyHelper.hexToRGB(hex).getRGB(), isMain);
        }

        @Override
        public void save(CompoundNBT nbt) {
            nbt.func_74768_a("rgb", this.rgb);
        }

        @Override
        public void load(CompoundNBT nbt) {
            this.rgb = nbt.func_74762_e("rgb");
        }

        public int getRGB() {
            return this.rgb;
        }

        public Color getColor() {
            return new Color(this.rgb);
        }

        public void setRGB(int rgb) {
            this.rgb = rgb;
        }

        public boolean isMainMark() {
            return this.isMain;
        }

        public void setMainMark() {
            this.isMain = true;
        }
    }
}

