/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.particles.effects.artofweather;

import java.awt.Color;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.world.World;
import xyz.pixelatedw.mineminenomi.particles.data.SimpleParticleData;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class ChargedWeatherBallParticleEffect
extends ParticleEffect<ParticleEffect.NoDetails> {
    private float red;
    private float green;
    private float blue;
    private Supplier<ParticleType<SimpleParticleData>> particle;

    public ChargedWeatherBallParticleEffect(Color color, Supplier<ParticleType<SimpleParticleData>> particle) {
        this.red = (float)color.getRed() / 255.0f;
        this.green = (float)color.getGreen() / 255.0f;
        this.blue = (float)color.getBlue() / 255.0f;
        this.particle = particle;
    }

    @Override
    public void spawn(Entity entity, World world, double posX, double posY, double posZ, ParticleEffect.NoDetails details) {
        for (int i = 0; i < 10; ++i) {
            double offsetX = WyHelper.randomDouble() / 1.5;
            double offsetY = WyHelper.randomDouble() / 1.5;
            double offsetZ = WyHelper.randomDouble() / 1.5;
            SimpleParticleData data = new SimpleParticleData(this.particle.get());
            data.setLife(4);
            data.setSize(2.0f);
            data.setMotion(0.0, 0.02, 0.0);
            data.setColor(this.red, this.green, this.blue);
            world.func_195590_a((IParticleData)data, true, posX + offsetX, posY + 1.0 + offsetY, posZ + offsetZ, 0.0, 0.0, 0.0);
        }
    }
}

