/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.particles.effects.mera;

import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.world.World;
import xyz.pixelatedw.mineminenomi.init.ModParticleTypes;
import xyz.pixelatedw.mineminenomi.particles.data.SimpleParticleData;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class HibashiraParticleEffect
extends ParticleEffect<Details> {
    public static final Details NO_DETAILS = new Details();

    public HibashiraParticleEffect() {
        super(Details::new);
    }

    @Override
    public void spawn(Entity entity, World world, double posX, double posY, double posZ, Details details) {
        double t = 0.0;
        double size = 2.5 * (double)details.getRadiusScale();
        Random rand = world.field_73012_v;
        while (t < 1.0) {
            t += 1.5707963267948966;
            for (double theta = 0.0; theta <= Math.PI * 2; theta += Math.PI / (8.0 * (double)details.getRadiusScale())) {
                double x = t * Math.cos(theta);
                double z = t * Math.sin(theta);
                double motionX = Math.sin(theta) / 10.0 * (double)details.getMotionScale();
                double motionY = 0.3 + rand.nextDouble() / 10.0 * (double)details.getMotionScale();
                double motionZ = -Math.cos(theta) / 10.0 * (double)details.getMotionScale();
                SimpleParticleData part = new SimpleParticleData((ParticleType)ModParticleTypes.MERA.get());
                part.setLife((int)WyHelper.randomWithRange(40, 50));
                part.setSize((float)WyHelper.randomWithRange(7, 10) * details.getDensityScale());
                float c = WyHelper.colorTolerance(0.7f);
                part.setColor(c, c, c, 0.5f);
                part.setMotion(motionX, motionY, motionZ);
                world.func_195590_a((IParticleData)part, true, posX + x * size + WyHelper.randomDouble() / 2.0, posY - 10.0, posZ + z * size + WyHelper.randomDouble() / 2.0, 0.0, 0.0, 0.0);
                world.func_195590_a((IParticleData)part, true, posX + x * size + WyHelper.randomDouble() / 2.0, posY - 5.0, posZ + z * size + WyHelper.randomDouble() / 2.0, 0.0, 0.0, 0.0);
                world.func_195590_a((IParticleData)part, true, posX + x * size + WyHelper.randomDouble() / 2.0, posY, posZ + z * size + WyHelper.randomDouble() / 2.0, 0.0, 0.0, 0.0);
                world.func_195590_a((IParticleData)part, true, posX + x * size + WyHelper.randomDouble() / 2.0, posY + 5.0 + WyHelper.randomWithRange(-2, 0), posZ + z * size + WyHelper.randomDouble() / 2.0, 0.0, 0.0, 0.0);
                world.func_195590_a((IParticleData)part, true, posX + x * size + WyHelper.randomDouble() / 2.0, posY + 10.0 + WyHelper.randomWithRange(-2, 0), posZ + z * size + WyHelper.randomDouble() / 2.0, 0.0, 0.0, 0.0);
            }
        }
    }

    public static class Details
    extends ParticleEffect.Details {
        private float radiusScale = 1.0f;
        private float densityScale = 1.0f;
        private float motionScale = 1.0f;

        public Details() {
        }

        public Details(float radiusScale, float densityScale, float motionScale) {
            this.radiusScale = radiusScale;
            this.densityScale = densityScale;
            this.motionScale = motionScale;
        }

        @Override
        public void save(CompoundNBT nbt) {
            nbt.func_74776_a("radiusScale", this.radiusScale);
            nbt.func_74776_a("densityScale", this.densityScale);
            nbt.func_74776_a("motionScale", this.motionScale);
        }

        @Override
        public void load(CompoundNBT nbt) {
            this.radiusScale = nbt.func_74760_g("radiusScale");
            this.densityScale = nbt.func_74760_g("densityScale");
            this.motionScale = nbt.func_74760_g("motionScale");
        }

        public float getRadiusScale() {
            return this.radiusScale;
        }

        public float getDensityScale() {
            return this.densityScale;
        }

        public float getMotionScale() {
            return this.motionScale;
        }
    }
}

