/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.quests.sniper;

import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import xyz.pixelatedw.mineminenomi.abilities.sniper.NemuriBoshiAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityUnlock;
import xyz.pixelatedw.mineminenomi.api.quests.Quest;
import xyz.pixelatedw.mineminenomi.api.quests.QuestId;
import xyz.pixelatedw.mineminenomi.api.quests.objectives.Objective;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.init.ModBlocks;
import xyz.pixelatedw.mineminenomi.init.ModQuests;
import xyz.pixelatedw.mineminenomi.quests.objectives.BrewPotionObjective;
import xyz.pixelatedw.mineminenomi.quests.objectives.KillEntityObjective;
import xyz.pixelatedw.mineminenomi.quests.objectives.ObtainItemObjective;
import xyz.pixelatedw.mineminenomi.quests.objectives.SharedKillChecks;

public class SniperTrial05Quest
extends Quest {
    public static final QuestId INSTANCE = new QuestId.Builder("Trial: Nemuri Boshi", SniperTrial05Quest::new).addRequirements(ModQuests.SNIPER_TRIAL_04).build();
    private static final Predicate<ItemStack> BREATH_DIAL_CHECK = itemStack -> itemStack.func_77973_b() == ((Block)ModBlocks.BREATH_DIAL.get()).func_199767_j();
    private Objective objective01 = new ObtainItemObjective("Collect %s breath dials", 3, BREATH_DIAL_CHECK);
    private Objective objective02 = new KillEntityObjective("Kill %s airborne enemies using a bow", 20, SharedKillChecks.AIRBORNE_ENEMY_CHECK);
    private Objective objective03 = new BrewPotionObjective("Brew %s splash potions", 12, new Item[]{Items.field_185155_bH}, null).addRequirements(this.objective01);

    public SniperTrial05Quest(QuestId id) {
        super(id);
        this.addObjectives(this.objective01, this.objective02, this.objective03);
        this.onCompleteEvent = this::giveReward;
    }

    private boolean giveReward(PlayerEntity player) {
        if (!this.removeQuestItem(player, ((Block)ModBlocks.BREATH_DIAL.get()).func_199767_j(), 3)) {
            return false;
        }
        IAbilityData props = AbilityDataCapability.get((LivingEntity)player);
        props.addUnlockedAbility(NemuriBoshiAbility.INSTANCE, AbilityUnlock.PROGRESSION);
        return true;
    }
}

