/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.renderers.blocks;

import com.google.common.base.Strings;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Map;
import java.util.UUID;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.TextFormatting;
import xyz.pixelatedw.mineminenomi.api.WantedPosterData;
import xyz.pixelatedw.mineminenomi.api.enums.CanvasSize;
import xyz.pixelatedw.mineminenomi.api.helpers.RendererHelper;
import xyz.pixelatedw.mineminenomi.blocks.FlagBlock;
import xyz.pixelatedw.mineminenomi.blocks.WantedPosterBlock;
import xyz.pixelatedw.mineminenomi.blocks.tileentities.WantedPosterTileEntity;
import xyz.pixelatedw.mineminenomi.init.ModRenderTypes;
import xyz.pixelatedw.mineminenomi.init.ModResources;
import xyz.pixelatedw.mineminenomi.models.blocks.WantedPosterModel;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class WantedPosterTileEntityRenderer
extends TileEntityRenderer<WantedPosterTileEntity> {
    private static final float[] SIZE_SCALE = new float[]{1.0f, 2.0f, 4.0f, 6.0f};
    private static final ResourceLocation TEXTURE = new ResourceLocation("mineminenomi", "textures/models/wantedposter.png");
    private static final String FONT_HEX_COLOR = "#513413";
    private WantedPosterModel posterModel;
    private final ModelRenderer face = new ModelRenderer(64, 64, 7, 7);
    private final ModelRenderer faceOverlay = new ModelRenderer(64, 64, 39, 7);
    private ResourceLocation skin;
    private ResourceLocation background;

    public WantedPosterTileEntityRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
        this.posterModel = new WantedPosterModel();
        this.face.func_228301_a_(0.0f, 0.0f, 0.0f, 8.0f, 8.0f, 1.0f, 0.0f);
        this.faceOverlay.func_228301_a_(0.0f, 0.0f, 0.0f, 8.0f, 8.0f, 1.0f, 0.0f);
    }

    public void render(WantedPosterTileEntity tileEntity, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        boolean flag;
        Map map;
        IVertexBuilder ivertexbuilder;
        BlockState blockstate = tileEntity.func_195044_w();
        WantedPosterData wantedPosterData = tileEntity.getWantedPosterData();
        String name = wantedPosterData.getOwnerName();
        UUID uuid = wantedPosterData.getOwnerId();
        ResourceLocation skinTexture = null;
        int idx = ((CanvasSize)((Object)blockstate.func_177229_b(FlagBlock.SIZE))).ordinal();
        float scale = SIZE_SCALE[idx];
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.5, 0.5, 0.5);
        matrixStack.func_227863_a_(new Quaternion(Vector3f.field_229181_d_, -((Direction)blockstate.func_177229_b((Property)WantedPosterBlock.FACING)).func_185119_l() + 180.0f, true));
        matrixStack.func_227863_a_(new Quaternion(Vector3f.field_229183_f_, 180.0f, true));
        matrixStack.func_227862_a_(scale, scale, 1.0f);
        matrixStack.func_227860_a_();
        matrixStack.func_227863_a_(new Quaternion(Vector3f.field_229183_f_, 180.0f, true));
        matrixStack.func_227861_a_(-0.36, 0.6, 0.5);
        matrixStack.func_227862_a_(0.6f, -0.6f, -0.01f);
        IVertexBuilder ivertexbuilder2 = buffer.getBuffer(ModRenderTypes.getWantedPoster(TEXTURE));
        this.posterModel.func_225598_a_(matrixStack, ivertexbuilder2, combinedLight, combinedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStack.func_227865_b_();
        if (Strings.isNullOrEmpty((String)name)) {
            matrixStack.func_227865_b_();
            return;
        }
        String bounty = wantedPosterData.getBountyString();
        matrixStack.func_227860_a_();
        if (wantedPosterData.isExpired()) {
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(-0.35, -0.389, 0.496);
            matrixStack.func_227862_a_(0.173f, 0.132f, 0.001f);
            ivertexbuilder = buffer.getBuffer(ModRenderTypes.getWantedPosterExpiration(ModResources.EXPIRED));
            RendererHelper.drawQuad(matrixStack, ivertexbuilder, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 3.9f, 3.9f, combinedLight);
            matrixStack.func_227865_b_();
        }
        matrixStack.func_227860_a_();
        skinTexture = wantedPosterData.getOwnerProfile().isPresent() ? ((map = Minecraft.func_71410_x().func_152342_ad().func_152788_a(wantedPosterData.getOwnerProfile().get())).containsKey(MinecraftProfileTexture.Type.SKIN) ? Minecraft.func_71410_x().func_152342_ad().func_152792_a((MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN) : DefaultPlayerSkin.func_177334_a((UUID)uuid)) : (wantedPosterData.getOwnerTexture().isPresent() ? wantedPosterData.getOwnerTexture().get() : DefaultPlayerSkin.func_177334_a((UUID)uuid));
        matrixStack.func_227861_a_(-0.21, -0.32, 0.498);
        matrixStack.func_227862_a_(0.8f, 0.8f, 0.001f);
        ivertexbuilder = buffer.getBuffer(ModRenderTypes.getWantedPoster(skinTexture));
        this.face.func_228309_a_(matrixStack, ivertexbuilder, combinedLight, combinedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
        this.faceOverlay.func_228309_a_(matrixStack, ivertexbuilder, combinedLight, combinedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStack.func_227865_b_();
        matrixStack.func_227860_a_();
        if (tileEntity.isPirate()) {
            if (wantedPosterData.getOwnerCrew().isPresent()) {
                matrixStack.func_227861_a_((double)0.11f, (double)-0.09f, (double)0.497f);
                matrixStack.func_227862_a_(0.2f, 0.2f, 1.0f);
                RendererHelper.drawPlayerJollyRoger(wantedPosterData.getOwnerCrew().get().getJollyRoger(), matrixStack, buffer, combinedLight);
            }
        } else if (tileEntity.isRevolutionary()) {
            matrixStack.func_227861_a_((double)-0.05f, (double)-0.21f, (double)0.497f);
            ivertexbuilder = buffer.getBuffer(ModRenderTypes.getWantedPoster(ModResources.REVOLUTIONARY_ARMY_ICON));
            RendererHelper.drawQuad(matrixStack, ivertexbuilder, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.5f, 0.5f, combinedLight);
        }
        matrixStack.func_227865_b_();
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(-0.35, -0.389, 0.499);
        matrixStack.func_227862_a_(0.173f, 0.132f, 0.001f);
        ResourceLocation texture = new ResourceLocation("mineminenomi", "textures/gui/wantedposters/backgrounds/" + wantedPosterData.getBackground() + ".jpg");
        IVertexBuilder ivertexbuilder3 = buffer.getBuffer(ModRenderTypes.getWantedPoster(texture));
        RendererHelper.drawQuad(matrixStack, ivertexbuilder3, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 3.9f, 3.9f, combinedLight);
        matrixStack.func_227865_b_();
        matrixStack.func_227865_b_();
        matrixStack.func_227860_a_();
        matrixStack.func_227862_a_(0.0075f, 0.008f, 0.0075f);
        matrixStack.func_227861_a_(-12.0, 29.9, 64.5);
        if (name.length() > 13) {
            name = name.substring(0, 10) + "...";
        }
        this.field_228858_b_.field_147557_n.func_228079_a_(TextFormatting.BOLD + name, 9.0f - (float)this.field_228858_b_.field_147557_n.func_78256_a(name) / 1.75f, -1.0f, WyHelper.hexToRGB(FONT_HEX_COLOR).getRGB(), false, matrixStack.func_227866_c_().func_227870_a_(), buffer, false, 0, combinedLight);
        matrixStack.func_227862_a_(1.2f, 1.2f, 1.2f);
        boolean bl = flag = bounty.length() > 9;
        if (flag) {
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(-5.0, 1.5, 0.0);
            matrixStack.func_227862_a_(0.72f, 0.89f, 1.005f);
        }
        this.field_228858_b_.field_147557_n.func_228079_a_(TextFormatting.BOLD + bounty, -18.0f, 9.5f, WyHelper.hexToRGB(FONT_HEX_COLOR).getRGB(), false, matrixStack.func_227866_c_().func_227870_a_(), buffer, false, 0, combinedLight);
        if (flag) {
            matrixStack.func_227865_b_();
        }
        matrixStack.func_227862_a_(0.7f, 0.9f, 0.8f);
        this.field_228858_b_.field_147557_n.func_228079_a_(TextFormatting.BOLD + wantedPosterData.getDate(), -40.0f, 25.0f, WyHelper.hexToRGB(FONT_HEX_COLOR).getRGB(), false, matrixStack.func_227866_c_().func_227870_a_(), buffer, false, 0, combinedLight);
        matrixStack.func_227865_b_();
        matrixStack.func_227865_b_();
    }
}

