/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.renderers.entities;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import xyz.pixelatedw.mineminenomi.entities.UnicycleEntity;
import xyz.pixelatedw.mineminenomi.models.entities.vehicles.UnicycleModel;

public class UnicycleRenderer
extends EntityRenderer<UnicycleEntity> {
    public static final ResourceLocation TEXTURE = new ResourceLocation("mineminenomi", "textures/models/unicycle.png");
    private UnicycleModel model = new UnicycleModel();

    protected UnicycleRenderer(EntityRendererManager manager) {
        super(manager);
    }

    public void render(UnicycleEntity entity, float entityYaw, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int packedLight) {
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.0, 1.5, 0.0);
        matrixStack.func_227862_a_(1.0f, 1.0f, 1.0f);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f - entityYaw));
        float hurtTime = (float)entity.getHurtTime() - partialTicks;
        if (hurtTime > 0.0f) {
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(MathHelper.func_76126_a((float)hurtTime) * hurtTime));
        }
        matrixStack.func_227862_a_(-1.0f, -1.0f, 1.0f);
        this.model.func_225597_a_(entity, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f);
        IVertexBuilder ivertexbuilder = buffer.getBuffer(this.model.func_228282_a_(this.getTextureLocation(entity)));
        this.model.func_225598_a_(matrixStack, ivertexbuilder, packedLight, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStack.func_227865_b_();
        super.func_225623_a_((Entity)entity, entityYaw, partialTicks, matrixStack, buffer, packedLight);
    }

    public ResourceLocation getTextureLocation(UnicycleEntity entity) {
        return TEXTURE;
    }

    public static class Factory
    implements IRenderFactory {
        public EntityRenderer createRenderFor(EntityRendererManager manager) {
            return new UnicycleRenderer(manager);
        }
    }
}

