/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.renderers.layers;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;
import xyz.pixelatedw.mineminenomi.abilities.haki.KenbunshokuHakiAuraAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.SlotDecorationComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.RendererHelper;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.DevilFruitCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.entity.haki.HakiDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.haki.IHakiData;
import xyz.pixelatedw.mineminenomi.init.ModAbilities;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;
import xyz.pixelatedw.mineminenomi.init.ModRenderTypeBuffers;
import xyz.pixelatedw.mineminenomi.init.ModRenderTypes;
import xyz.pixelatedw.mineminenomi.init.ModResources;
import xyz.pixelatedw.mineminenomi.renderers.buffers.HakiAuraBuffer;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class AuraLayer<T extends LivingEntity, M extends EntityModel<T>>
extends LayerRenderer<T, M> {
    private static final HashMap<Integer, ArrayList<AbilityDisplayData>> ABILITIES_TO_SHOW = new HashMap();
    private final long PHASE_IN_DURATION = 500L;
    private final long FULL_VISIBLE_DURATION = 3000L;
    private final long PHASE_OUT_DURATION = 500L;

    public AuraLayer(IEntityRenderer<T, M> renderer) {
        super(renderer);
    }

    public void render(MatrixStack matrixStack, IRenderTypeBuffer buffer, int packedLight, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        boolean isActive;
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayerEntity player = mc.field_71439_g;
        if (entity == player) {
            return;
        }
        IEntityStats entityData = EntityStatsCapability.get((LivingEntity)player);
        IAbilityData abilityData = AbilityDataCapability.get((LivingEntity)player);
        IHakiData hakiProps = HakiDataCapability.get((LivingEntity)player);
        if (abilityData == null) {
            return;
        }
        Ability auraAbility = abilityData.getEquippedAbility(KenbunshokuHakiAuraAbility.INSTANCE);
        boolean bl = isActive = auraAbility != null && auraAbility.isContinuous();
        if (!isActive) {
            return;
        }
        double dorikiPower = entityData.getDoriki() / 1000.0;
        float hakiPower = hakiProps.getKenbunshokuHakiExp() / 2.0f;
        double finalPower = (dorikiPower + (double)hakiPower) * 1.06 * (DevilFruitCapability.get((LivingEntity)player).hasDevilFruit(ModAbilities.GORO_GORO_NO_MI) ? 4.0 : 1.0);
        if ((double)entity.func_70032_d((Entity)player) > finalPower) {
            return;
        }
        matrixStack.func_227860_a_();
        String color = "#5555FF";
        if (entity instanceof AnimalEntity) {
            color = "#55FF55";
        } else if (entity instanceof MonsterEntity) {
            color = "#FF0000";
        } else if (entity instanceof PlayerEntity) {
            color = "#00FFFF";
        }
        Color rgbColor = WyHelper.hexToRGB(color);
        float red = (float)rgbColor.getRed() / 255.0f;
        float green = (float)rgbColor.getGreen() / 255.0f;
        float blue = (float)rgbColor.getBlue() / 255.0f;
        HakiAuraBuffer layerBuffer = ModRenderTypeBuffers.getInstance().getHakiAuraBuffer();
        layerBuffer.setColor((int)(red * 255.0f), (int)(green * 255.0f), (int)(blue * 255.0f), 255);
        IVertexBuilder vertex = layerBuffer.getBuffer(ModRenderTypes.getNewAuraRenderType());
        this.func_215332_c().func_225598_a_(matrixStack, vertex, packedLight, OverlayTexture.field_229196_a_, red, green, blue, 0.0f);
        layerBuffer.endBatch();
        matrixStack.func_227865_b_();
        if (hakiProps.getKenbunshokuHakiExp() < 50.0f) {
            return;
        }
        ArrayList<AbilityDisplayData> abilitiesToShow = ABILITIES_TO_SHOW.get(entity.func_145782_y());
        if (abilitiesToShow == null) {
            return;
        }
        float height = 0.0f;
        for (int i = 0; i < abilitiesToShow.size(); ++i) {
            AbilityDisplayData abilityDisplayData = abilitiesToShow.get(i);
            IAbility ability = abilityDisplayData.ability;
            long elapsedTime = System.currentTimeMillis() - abilityDisplayData.startTime;
            float iconAlpha = 0.0f;
            Optional<SlotDecorationComponent> slotDecorationComponentOptional = ability.getComponent(ModAbilityKeys.SLOT_DECORATION);
            if (slotDecorationComponentOptional.isPresent()) {
                SlotDecorationComponent slotDecorationComponent = slotDecorationComponentOptional.get();
                slotDecorationComponent.triggerPreRenderEvents((LivingEntity)player, mc, matrixStack, 1.25f, -entity.func_70047_e() + 1.0f - height, partialTicks);
                if (elapsedTime <= 500L) {
                    iconAlpha = slotDecorationComponent.getIconAlpha() / 500.0f * (float)elapsedTime;
                } else if (elapsedTime <= 3500L) {
                    iconAlpha = slotDecorationComponent.getIconAlpha();
                } else if (elapsedTime <= 4000L) {
                    iconAlpha = slotDecorationComponent.getIconAlpha() - (float)(elapsedTime - 3500L) / 500.0f;
                }
                matrixStack.func_227860_a_();
                mc.func_110434_K().func_110577_a(ModResources.WIDGETS);
                float number = slotDecorationComponent.getCurrentValue();
                float maxNumber = slotDecorationComponent.getMaxValue();
                float slotHeight = MathHelper.func_76131_a((float)(23.0f - number / maxNumber * 23.0f), (float)0.0f, (float)Float.MAX_VALUE);
                RendererHelper.drawTexturedModalRect(matrixStack, 1.25f, -entity.func_70047_e() + 1.0f - height, 0.0f, 0.0f, 23.0f, 23.0f, 0.0f, 0.0625f, 0.0625f, slotDecorationComponent.getSlotRed(), slotDecorationComponent.getSlotGreen(), slotDecorationComponent.getSlotBlue(), iconAlpha / slotDecorationComponent.getIconAlpha() * 1.0f);
                RendererHelper.drawTexturedModalRect(matrixStack, 1.25f, -entity.func_70047_e() + 1.0f - height, 24.0f, 0.0f, 23.0f, slotHeight, 0.0f, 0.0625f, 0.0625f, 1.0f, 1.0f, 1.0f, iconAlpha / slotDecorationComponent.getIconAlpha() * 1.0f);
                matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
                RendererHelper.drawTexturedModalRect(matrixStack, -2.25f, -entity.func_70047_e() + 1.0f - height, 0.0f, 0.0f, 23.0f, 23.0f, 0.0f, 0.0625f, 0.0625f, slotDecorationComponent.getSlotRed(), slotDecorationComponent.getSlotGreen(), slotDecorationComponent.getSlotBlue(), iconAlpha / slotDecorationComponent.getIconAlpha() * 1.0f);
                RendererHelper.drawTexturedModalRect(matrixStack, -2.25f, -entity.func_70047_e() + 1.0f - height, 24.0f, 0.0f, 23.0f, slotHeight, 0.0f, 0.0625f, 0.0625f, 1.0f, 1.0f, 1.0f, iconAlpha / slotDecorationComponent.getIconAlpha() * 1.0f);
                matrixStack.func_227865_b_();
                matrixStack.func_227860_a_();
                RendererHelper.drawIcon(ability.getIcon((LivingEntity)entity), matrixStack, 1.5f, -entity.func_70047_e() + 1.0f - height + 0.25f, 0.0f, 1.0f, 1.0f, slotDecorationComponent.getIconRed(), slotDecorationComponent.getIconGreen(), slotDecorationComponent.getIconBlue(), iconAlpha);
                matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
                RendererHelper.drawIcon(ability.getIcon((LivingEntity)entity), matrixStack, -2.0f, -entity.func_70047_e() + 1.0f - height + 0.25f, -0.0f, 1.0f, 1.0f, slotDecorationComponent.getIconRed(), slotDecorationComponent.getIconGreen(), slotDecorationComponent.getIconBlue(), iconAlpha, true, false);
                matrixStack.func_227865_b_();
                height += 1.5f;
            }
            if (elapsedTime < 4000L) continue;
            abilitiesToShow.remove(abilityDisplayData);
        }
    }

    public static void addAbilityIcon(LivingEntity entity, IAbility ability) {
        if (!entity.field_70170_p.field_72995_K) {
            return;
        }
        ABILITIES_TO_SHOW.putIfAbsent(entity.func_145782_y(), new ArrayList());
        ArrayList<AbilityDisplayData> abilitiesToShow = ABILITIES_TO_SHOW.get(entity.func_145782_y());
        boolean abilityFound = false;
        for (int i = 0; i < abilitiesToShow.size(); ++i) {
            if (!abilitiesToShow.get(i).ability.equals(ability)) continue;
            abilityFound = true;
        }
        if (!abilityFound) {
            abilitiesToShow.add(0, new AbilityDisplayData(ability, System.currentTimeMillis()));
        }
    }

    private static class AbilityDisplayData {
        private IAbility ability;
        private long startTime;

        private AbilityDisplayData(IAbility ability, long startTime) {
            this.ability = ability;
            this.startTime = startTime;
        }
    }
}

