/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.renderers.layers;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Optional;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.entity.model.IHasArm;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.HandSide;
import xyz.pixelatedw.mineminenomi.abilities.gomu.GearFourthAbility;
import xyz.pixelatedw.mineminenomi.abilities.haki.BusoshokuHakiFullBodyHardeningAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityOverlay;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.SkinOverlayComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.MorphHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.api.morph.MorphModel;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;
import xyz.pixelatedw.mineminenomi.init.ModRenderTypes;
import xyz.pixelatedw.mineminenomi.models.entities.mobs.animals.DugongModel;

public class BodyCoatingLayer<T extends LivingEntity, M extends EntityModel<T>>
extends LayerRenderer<T, M> {
    public BodyCoatingLayer(IEntityRenderer renderer) {
        super(renderer);
    }

    public void render(MatrixStack matrixStack, IRenderTypeBuffer buffer, int packedLight, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        IVertexBuilder vertex = null;
        Optional<Object> overlay = Optional.empty();
        IEntityStats props = EntityStatsCapability.get(entity);
        IAbilityData abilityProps = AbilityDataCapability.get(entity);
        GearFourthAbility g4Ability = abilityProps.getEquippedAbility(GearFourthAbility.INSTANCE);
        boolean hasG4 = g4Ability != null && g4Ability.isContinuous();
        for (IAbility ability : abilityProps.getEquippedAbilities()) {
            float alpha;
            float blue;
            float green;
            float red;
            Optional<SkinOverlayComponent> comp = ability.getComponent(ModAbilityKeys.SKIN_OVERLAY);
            if (comp == null || !comp.isPresent()) continue;
            overlay = comp.get().getShownOverlay(AbilityOverlay.OverlayPart.LIMB, AbilityOverlay.OverlayPart.LEG, AbilityOverlay.OverlayPart.ARM);
            if (overlay.isPresent() && this.func_215332_c() instanceof IHasArm) {
                boolean useArmModel;
                red = (float)((AbilityOverlay)overlay.get()).getColor().getRed() / 255.0f;
                green = (float)((AbilityOverlay)overlay.get()).getColor().getGreen() / 255.0f;
                blue = (float)((AbilityOverlay)overlay.get()).getColor().getBlue() / 255.0f;
                alpha = (float)((AbilityOverlay)overlay.get()).getColor().getAlpha() / 255.0f;
                vertex = ((AbilityOverlay)overlay.get()).getTexture() != null ? buffer.getBuffer(ModRenderTypes.getAbilityHand(((AbilityOverlay)overlay.get()).getTexture())) : (((AbilityOverlay)overlay.get()).getRenderType().equals((Object)AbilityOverlay.RenderType.ENERGY) ? buffer.getBuffer(ModRenderTypes.ENERGY) : buffer.getBuffer(ModRenderTypes.TRANSPARENT_COLOR));
                boolean isLeftHanded = entity.func_184591_cq() == HandSide.LEFT;
                ModelRenderer limbToRender = null;
                boolean useLegModel = ((AbilityOverlay)overlay.get()).getOverlayPart().equals((Object)AbilityOverlay.OverlayPart.LEG) || props.isBlackLeg() && ((AbilityOverlay)overlay.get()).getOverlayPart().equals((Object)AbilityOverlay.OverlayPart.LIMB);
                boolean bl = useArmModel = ((AbilityOverlay)overlay.get()).getOverlayPart().equals((Object)AbilityOverlay.OverlayPart.ARM) || !props.isBlackLeg() && ((AbilityOverlay)overlay.get()).getOverlayPart().equals((Object)AbilityOverlay.OverlayPart.LIMB);
                if (useLegModel) {
                    if (this.func_215332_c() instanceof MorphModel) break;
                    if (this.func_215332_c() instanceof PlayerModel) {
                        limbToRender = isLeftHanded ? ((PlayerModel)this.func_215332_c()).field_178733_c : ((PlayerModel)this.func_215332_c()).field_178731_d;
                    } else if (this.func_215332_c() instanceof BipedModel) {
                        limbToRender = isLeftHanded ? ((BipedModel)this.func_215332_c()).field_178722_k : ((BipedModel)this.func_215332_c()).field_178721_j;
                    } else if (this.func_215332_c() instanceof DugongModel) {
                        limbToRender = ((DugongModel)this.func_215332_c()).tailBase;
                    }
                } else if (useArmModel) {
                    if (this.func_215332_c() instanceof MorphModel) break;
                    if (this.func_215332_c() instanceof PlayerModel) {
                        limbToRender = isLeftHanded ? ((PlayerModel)this.func_215332_c()).field_178734_a : ((PlayerModel)this.func_215332_c()).field_178732_b;
                    } else if (this.func_215332_c() instanceof BipedModel) {
                        limbToRender = isLeftHanded ? ((BipedModel)this.func_215332_c()).field_178724_i : ((BipedModel)this.func_215332_c()).field_178723_h;
                    } else if (this.func_215332_c() instanceof DugongModel) {
                        ModelRenderer modelRenderer = limbToRender = isLeftHanded ? ((DugongModel)this.func_215332_c()).leftArm : ((DugongModel)this.func_215332_c()).rightArm;
                    }
                }
                if (limbToRender != null) {
                    limbToRender.func_228309_a_(matrixStack, vertex, packedLight, OverlayTexture.field_229196_a_, red, green, blue, alpha);
                }
            }
            if (!(overlay = comp.get().getShownOverlay(AbilityOverlay.OverlayPart.BODY)).isPresent()) continue;
            red = (float)((AbilityOverlay)overlay.get()).getColor().getRed() / 255.0f;
            green = (float)((AbilityOverlay)overlay.get()).getColor().getGreen() / 255.0f;
            blue = (float)((AbilityOverlay)overlay.get()).getColor().getBlue() / 255.0f;
            alpha = (float)((AbilityOverlay)overlay.get()).getColor().getAlpha() / 255.0f;
            if (hasG4 && ability instanceof BusoshokuHakiFullBodyHardeningAbility) {
                alpha = 0.0f;
            }
            boolean equalDepthTest = false;
            boolean culling = false;
            MorphInfo info = MorphHelper.getZoanInfo(entity);
            if (info != null) {
                equalDepthTest = info.hasEqualDepthTest();
                culling = info.hasCulling();
            }
            if (((AbilityOverlay)overlay.get()).getTexture() != null) {
                vertex = buffer.getBuffer(ModRenderTypes.getAbilityBody(((AbilityOverlay)overlay.get()).getTexture(), equalDepthTest, culling));
            } else {
                IVertexBuilder iVertexBuilder = vertex = ((AbilityOverlay)overlay.get()).getRenderType().equals((Object)AbilityOverlay.RenderType.ENERGY) ? buffer.getBuffer(ModRenderTypes.ENERGY) : buffer.getBuffer(ModRenderTypes.TRANSPARENT_COLOR);
            }
            if (this.func_215332_c() instanceof PlayerModel) {
                ((PlayerModel)this.func_215332_c()).func_225598_a_(matrixStack, vertex, packedLight, OverlayTexture.field_229196_a_, red, green, blue, alpha);
                continue;
            }
            matrixStack.func_227860_a_();
            matrixStack.func_227862_a_(1.06f, 1.06f, 1.06f);
            matrixStack.func_227861_a_(0.0, (double)-0.04f, 0.0);
            this.func_215332_c().func_225598_a_(matrixStack, vertex, packedLight, OverlayTexture.field_229196_a_, red, green, blue, alpha);
            matrixStack.func_227865_b_();
        }
    }
}

