/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.renderers.layers;

import com.google.common.base.Strings;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effects;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.ModMain;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.models.morphs.MinkBunnyPartialModel;
import xyz.pixelatedw.mineminenomi.models.morphs.MinkDogPartialModel;
import xyz.pixelatedw.mineminenomi.models.morphs.MinkLionPartialModel;

public class MinkFeaturesLayer<T extends LivingEntity, M extends BipedModel<T>>
extends LayerRenderer<T, M> {
    private static final MinkBunnyPartialModel BUNNY_MODEL = new MinkBunnyPartialModel();
    private static final ResourceLocation BUNNY_TEXTURE = new ResourceLocation("mineminenomi", "textures/models/zoanmorph/mink_bunny.png");
    private static final MinkDogPartialModel DOG_MODEL = new MinkDogPartialModel();
    private static final ResourceLocation DOG_TEXTURE = new ResourceLocation("mineminenomi", "textures/models/zoanmorph/mink_dog.png");
    private static final MinkLionPartialModel LION_MODEL = new MinkLionPartialModel();
    private static final ResourceLocation LION_TEXTURE = new ResourceLocation("mineminenomi", "textures/models/zoanmorph/mink_lion.png");
    public static final Map<String, Pair<BipedModel, ResourceLocation>> MAP;

    public MinkFeaturesLayer(IEntityRenderer renderer) {
        super(renderer);
    }

    public void render(MatrixStack matrixStack, IRenderTypeBuffer buffer, int packedLight, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        IEntityStats entityProps = EntityStatsCapability.get(entity);
        boolean isMink = entityProps.isMink();
        boolean isInvisible = entity.func_70644_a(Effects.field_76441_p);
        if (isMink && !isInvisible) {
            boolean isSubRaceNull = Strings.isNullOrEmpty((String)entityProps.getSubRace());
            if (isSubRaceNull) {
                entityProps.setSubRace("mink_dog");
                ModMain.LOGGER.error("Sub Race of this mink is empty, which should never happen.");
                return;
            }
            BipedModel model = (BipedModel)MAP.get(entityProps.getSubRace()).getLeft();
            ResourceLocation res = (ResourceLocation)MAP.get(entityProps.getSubRace()).getRight();
            if (model != null && res != null) {
                ((BipedModel)this.func_215332_c()).func_217148_a(model);
                model.func_212843_a_(entity, limbSwing, limbSwingAmount, partialTicks);
                model.func_225597_a_(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
                model.func_225598_a_(matrixStack, buffer.getBuffer(RenderType.func_228644_e_((ResourceLocation)res)), packedLight, LivingRenderer.func_229117_c_(entity, (float)0.0f), 1.0f, 1.0f, 1.0f, 1.0f);
            }
        }
    }

    static {
        HashMap<String, Pair> map = new HashMap<String, Pair>();
        map.put("mink_bunny", Pair.of((Object)((Object)BUNNY_MODEL), (Object)BUNNY_TEXTURE));
        map.put("mink_dog", Pair.of((Object)((Object)DOG_MODEL), (Object)DOG_TEXTURE));
        map.put("mink_lion", Pair.of((Object)((Object)LION_MODEL), (Object)LION_TEXTURE));
        MAP = Collections.unmodifiableMap(map);
    }
}

