/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.renderers.layers.morphs;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.UUID;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import xyz.pixelatedw.mineminenomi.entities.mobs.pirates.buggypirates.BuggyEntity;
import xyz.pixelatedw.mineminenomi.init.ModRenderTypes;
import xyz.pixelatedw.mineminenomi.models.morphs.BaraCarPartialModel;
import xyz.pixelatedw.mineminenomi.models.morphs.BaraCarWheelsPartialModel;

public class BaraCarLayer<T extends LivingEntity, M extends EntityModel<T>>
extends LayerRenderer<T, M> {
    private final BaraCarPartialModel bodyModel = new BaraCarPartialModel();
    private final BaraCarWheelsPartialModel wheelsModel = new BaraCarWheelsPartialModel();
    private static final ResourceLocation TEXTURE = new ResourceLocation("mineminenomi", "textures/models/zoanmorph/bara_car_wheels.png");
    private final IEntityRenderer<T, M> renderer;

    public BaraCarLayer(IEntityRenderer<T, M> renderer) {
        super(renderer);
        this.renderer = renderer;
    }

    public void render(MatrixStack matrixStack, IRenderTypeBuffer buffer, int packedLight, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        matrixStack.func_227860_a_();
        if (entity instanceof BuggyEntity) {
            if (((BuggyEntity)entity).clientCarState != 1) {
                matrixStack.func_227865_b_();
                return;
            }
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(netHeadYaw));
        } else if (entity.func_82150_aj()) {
            matrixStack.func_227865_b_();
            return;
        }
        ResourceLocation skin = DefaultPlayerSkin.func_177334_a((UUID)entity.func_110124_au());
        if (entity instanceof PlayerEntity) {
            PlayerEntity player = ((LivingEntity)entity).field_70170_p.func_217371_b(entity.func_110124_au());
            if (player != null) {
                skin = ((AbstractClientPlayerEntity)player).func_110306_p();
            }
        } else {
            skin = this.renderer.func_110775_a(entity);
        }
        RenderType renderType = ModRenderTypes.getZoanRenderType(skin);
        this.bodyModel.func_225597_a_(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        this.bodyModel.func_225598_a_(matrixStack, buffer.getBuffer(renderType), packedLight, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        renderType = ModRenderTypes.getZoanRenderType(TEXTURE);
        this.wheelsModel.func_225597_a_(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        this.wheelsModel.func_225598_a_(matrixStack, buffer.getBuffer(renderType), packedLight, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStack.func_227865_b_();
    }
}

