/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.renderers.morphs;

import com.google.common.base.Function;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.awt.Color;
import java.util.Random;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.LightType;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import org.apache.commons.lang3.tuple.Triple;
import xyz.pixelatedw.mineminenomi.abilities.goro.ElThorAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.RendererHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.api.morph.MorphModel;
import xyz.pixelatedw.mineminenomi.config.ClientConfig;
import xyz.pixelatedw.mineminenomi.renderers.layers.BodyCoatingLayer;
import xyz.pixelatedw.mineminenomi.renderers.morphs.ZoanMorphRenderer;

public class GlowingModelRenderer<T extends AbstractClientPlayerEntity, M extends MorphModel>
extends ZoanMorphRenderer<T, M> {
    protected Type type;

    public GlowingModelRenderer(EntityRendererManager rendererManager, MorphInfo info, Type type) {
        super(rendererManager, info);
        this.func_177094_a(new BodyCoatingLayer((IEntityRenderer)this));
        this.type = type;
    }

    @Override
    public void func_225623_a_(AbstractClientPlayerEntity entity, float entityYaw, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int packedLight) {
        super.func_225623_a_(entity, entityYaw, partialTicks, matrixStack, buffer, packedLight);
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.0, 2.6, 0.0);
        int lightLevel = entity.func_130014_f_().func_226658_a_(LightType.SKY, entity.func_233580_cy_()) - entity.func_130014_f_().func_175657_ab();
        if (this.type == Type.AMARU) {
            lightLevel = 8;
        }
        if (lightLevel > 7) {
            Random random = new Random(500L);
            float rays = 20 + lightLevel * 16;
            float randMovement = ((float)entity.field_70173_aa + partialTicks) / 500.0f;
            IVertexBuilder vertexBuilder = buffer.getBuffer(RenderType.func_228657_l_());
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(0.0, 0.75, 0.0);
            int i = 0;
            while ((float)i < rays) {
                float size = 9.6f + (this.type == Type.AMARU ? 0.0f : 1.4f);
                matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(random.nextFloat() * 360.0f));
                matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(random.nextFloat() * 360.0f));
                matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(random.nextFloat() * 360.0f));
                matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(random.nextFloat() * 360.0f));
                matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(random.nextFloat() * 360.0f));
                matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(random.nextFloat() * 360.0f + randMovement * 90.0f));
                float f3 = size * random.nextFloat();
                float f4 = size * random.nextFloat();
                Matrix4f matrix4f = matrixStack.func_227866_c_().func_227870_a_();
                int alpha = 8 + lightLevel / 2;
                Color color1 = (Color)this.type.getColorScheme(alpha).getRight();
                Color color2 = (Color)this.type.getColorScheme(alpha).getMiddle();
                Color color3 = (Color)this.type.getColorScheme(alpha).getLeft();
                RendererHelper.drawA(vertexBuilder, matrix4f, color3);
                RendererHelper.drawB(vertexBuilder, matrix4f, f3, f4, color2);
                RendererHelper.drawC(vertexBuilder, matrix4f, f3, f4, color1);
                RendererHelper.drawA(vertexBuilder, matrix4f, color3);
                RendererHelper.drawC(vertexBuilder, matrix4f, f3, f4, color2);
                RendererHelper.drawD(vertexBuilder, matrix4f, f3, f4, color1);
                RendererHelper.drawA(vertexBuilder, matrix4f, color3);
                RendererHelper.drawD(vertexBuilder, matrix4f, f3, f4, color1);
                RendererHelper.drawB(vertexBuilder, matrix4f, f3, f4, color2);
                ++i;
            }
            matrixStack.func_227865_b_();
        }
        matrixStack.func_227865_b_();
    }

    @Override
    public ResourceLocation func_110775_a(AbstractClientPlayerEntity entity) {
        return entity.func_110306_p();
    }

    public static enum Type {
        DAIBUTSU((Function<Integer, Triple>)((Function)alpha -> Triple.of((Object)new Color(255, 255, 0, 0), (Object)new Color(255, 100, 0, 0), (Object)new Color(255, 50, 0, (int)alpha)))),
        AMARU((Function<Integer, Triple>)((Function)alpha -> {
            if (ClientConfig.INSTANCE.isGoroBlue()) {
                Color weakBlue = new Color(ElThorAbility.BLUE_THUNDER.getRed(), ElThorAbility.BLUE_THUNDER.getGreen(), ElThorAbility.BLUE_THUNDER.getBlue(), 5);
                Color strongBlue = new Color(ElThorAbility.BLUE_THUNDER.getRed(), ElThorAbility.BLUE_THUNDER.getGreen(), ElThorAbility.BLUE_THUNDER.getBlue(), (int)alpha);
                return Triple.of((Object)weakBlue, (Object)weakBlue, (Object)strongBlue);
            }
            return Triple.of((Object)new Color(255, 249, 0, 0), (Object)new Color(225, 100, 20, 0), (Object)new Color(225, 180, 50, (int)alpha));
        }));

        private Function<Integer, Triple> colorScheme;

        private Type(Function<Integer, Triple> colorScheme) {
            this.colorScheme = colorScheme;
        }

        public Triple<Color, Color, Color> getColorScheme(int alpha) {
            return (Triple)this.colorScheme.apply((Object)alpha);
        }
    }

    public static class Factory<T extends PlayerEntity>
    implements IRenderFactory<T> {
        private MorphInfo info;
        private Type type;

        public Factory(MorphInfo info, Type type) {
            this.info = info;
            this.type = type;
        }

        public EntityRenderer<? super T> createRenderFor(EntityRendererManager manager) {
            GlowingModelRenderer renderer = new GlowingModelRenderer(manager, this.info, this.type);
            return renderer;
        }
    }
}

