/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.screens;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.ReadBookScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.button.ChangePageButton;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import xyz.pixelatedw.mineminenomi.api.DFEncyclopediaEntry;
import xyz.pixelatedw.mineminenomi.api.helpers.RendererHelper;
import xyz.pixelatedw.mineminenomi.init.ModResources;
import xyz.pixelatedw.mineminenomi.init.ModValues;
import xyz.pixelatedw.mineminenomi.items.AkumaNoMiItem;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

@OnlyIn(value=Dist.CLIENT)
public class EncyclopediaScreen
extends Screen {
    private int currPage;
    private ItemStack bookStack;
    private List<DFEncyclopediaEntry> entries = Lists.newArrayList();

    protected EncyclopediaScreen(ItemStack stack) {
        super((ITextComponent)new StringTextComponent(""));
        this.bookStack = stack;
        this.entries = this.getDefaultList(stack);
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        ResourceLocation baseIcon;
        Color stemColor;
        this.func_230446_a_(matrixStack);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(ReadBookScreen.field_214167_b);
        int posX = (this.field_230708_k_ - 192) / 2;
        int posY = 2;
        this.func_238474_b_(matrixStack, posX, posY, 0, 0, 192, 192);
        DFEncyclopediaEntry entry = !this.entries.isEmpty() ? this.entries.get(this.currPage) : null;
        TranslationTextComponent currentPageLabel = new TranslationTextComponent("book.pageIndicator", new Object[]{this.currPage + 1, Math.max(this.getPageCount(), 1)});
        int textSize = this.field_230712_o_.func_238414_a_((ITextProperties)currentPageLabel);
        this.field_230712_o_.func_243248_b(matrixStack, (ITextComponent)currentPageLabel, (float)(posX - textSize + 192 - 44), 18.0f, 0);
        RenderSystem.pushMatrix();
        RenderSystem.enableBlend();
        ResourceLocation stemIcon = null;
        Color baseColor = entry != null ? entry.getBaseColor().orElse(Color.BLACK) : Color.BLACK;
        Color color = stemColor = entry != null ? entry.getStemColor().orElse(Color.BLACK) : Color.BLACK;
        if (entry == null || !entry.getShape().isPresent() || entry.getShape().get() <= 0) {
            baseIcon = ModResources.QUESTION_MARK;
        } else {
            baseIcon = new ResourceLocation("mineminenomi", "textures/items/fruits/generic/generic_fruit_" + entry.getShape().get() + ".png");
            stemIcon = new ResourceLocation("mineminenomi", "textures/items/fruits/generic/generic_fruit_" + entry.getShape().get() + "_stem.png");
        }
        RenderSystem.translated((double)(posX + 55), (double)(posY + 40), (double)2.0);
        RenderSystem.translated((double)64.0, (double)64.0, (double)0.0);
        RenderSystem.scaled((double)0.8f, (double)0.8f, (double)0.8f);
        RenderSystem.translated((double)-64.0, (double)-64.0, (double)1.0);
        this.field_230706_i_.func_110434_K().func_110577_a(baseIcon);
        if (baseIcon.equals((Object)ModResources.QUESTION_MARK)) {
            EncyclopediaScreen.drawUpperIcon(baseIcon, matrixStack, 0, 0, 64, 32, (float)stemColor.getRed() / 255.0f, (float)stemColor.getGreen() / 255.0f, (float)stemColor.getBlue() / 255.0f, 1.0f);
            EncyclopediaScreen.drawLowerIcon(baseIcon, matrixStack, 0, 32, 64, 32, (float)baseColor.getRed() / 255.0f, (float)baseColor.getGreen() / 255.0f, (float)baseColor.getBlue() / 255.0f, 1.0f);
        } else {
            RendererHelper.drawIcon(baseIcon, matrixStack, 0.0f, 0.0f, 1.0f, 64.0f, 64.0f, (float)baseColor.getRed() / 255.0f, (float)baseColor.getGreen() / 255.0f, (float)baseColor.getBlue() / 255.0f, 1.0f);
        }
        if (stemIcon != null) {
            this.field_230706_i_.func_110434_K().func_110577_a(stemIcon);
            if (entry != null && entry.getShape().isPresent() && entry.getShape().get() > 0) {
                RendererHelper.drawIcon(stemIcon, matrixStack, 0.0f, 0.0f, 1.0f, 64.0f, 64.0f, (float)stemColor.getRed() / 255.0f, (float)stemColor.getGreen() / 255.0f, (float)stemColor.getBlue() / 255.0f, 1.0f);
            }
        }
        RenderSystem.popMatrix();
        if (entry != null) {
            String fruitName = new ItemStack((IItemProvider)entry.getDevilFruit()).func_200301_q().getString();
            int color2 = entry.isComplete() ? TextFormatting.GOLD.func_211163_e() : -1;
            List splitText = this.field_230712_o_.func_238425_b_((ITextProperties)new StringTextComponent(fruitName), 110);
            for (int j = 0; j < splitText.size(); ++j) {
                WyHelper.drawStringWithBorder(this.field_230712_o_, matrixStack, (IReorderingProcessor)splitText.get(j), posX + 93 - this.field_230712_o_.func_243245_a((IReorderingProcessor)splitText.get(j)) / 2, posY + 113 + j * 12, color2);
            }
        }
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
    }

    protected void func_231160_c_() {
        int posX = (this.field_230708_k_ - 192) / 2;
        int posY = 2;
        this.func_230480_a_((Widget)new ChangePageButton(posX + 116, posY + 159, true, button -> this.nextPage(), true));
        this.func_230480_a_((Widget)new ChangePageButton(posX + 43, posY + 159, false, button -> this.previousPage(), true));
        this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 150, 196, 98, 20, (ITextComponent)new StringTextComponent("All"), button -> {
            this.entries = this.getDefaultList(this.bookStack);
            this.currPage = 0;
        }));
        this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 50, 196, 98, 20, (ITextComponent)new StringTextComponent("Partially Complete"), button -> {
            this.entries = this.getDefaultList(this.bookStack).stream().filter(entry -> entry.getCompletion() > 0).collect(Collectors.toList());
            this.currPage = 0;
        }));
        this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 + 50, 196, 98, 20, (ITextComponent)new StringTextComponent("Only Complete"), button -> {
            this.entries = this.getDefaultList(this.bookStack).stream().filter(entry -> entry.getCompletion() >= 3).collect(Collectors.toList());
            this.currPage = 0;
        }));
        super.func_231160_c_();
    }

    private void previousPage() {
        if (this.currPage > 0) {
            --this.currPage;
        } else if (this.currPage == 0) {
            this.currPage = this.getPageCount() - 1;
        }
    }

    private void nextPage() {
        if (this.currPage < this.getPageCount() - 1) {
            ++this.currPage;
        } else if (this.currPage == this.getPageCount() - 1) {
            this.currPage = 0;
        }
    }

    private int getPageCount() {
        return this.entries.size();
    }

    public List<DFEncyclopediaEntry> getDefaultList(ItemStack stack) {
        ArrayList list = Lists.newArrayList();
        CompoundNBT nbt = stack.func_190925_c("unlocked");
        for (AkumaNoMiItem fruit : ModValues.DEVIL_FRUITS) {
            DFEncyclopediaEntry entry;
            if (fruit.getRegistryName() == null) continue;
            String key = fruit.getFruitKey();
            if (!nbt.isEmpty() && nbt.func_74764_b(key)) {
                entry = DFEncyclopediaEntry.of(nbt.func_74775_l(key));
                entry.setDevilFruit(fruit);
                list.add(entry);
                continue;
            }
            entry = DFEncyclopediaEntry.of(Optional.empty(), Optional.empty(), Optional.empty());
            entry.setDevilFruit(fruit);
            list.add(entry);
        }
        Collections.reverse(list);
        return list;
    }

    public boolean func_231177_au__() {
        return false;
    }

    public static void drawUpperIcon(ResourceLocation rs, MatrixStack matrixStack, int x, int y, int u, int v, float red, float green, float blue, float alpha) {
        Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(rs);
        BufferBuilder bufferbuilder = Tessellator.func_178181_a().func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_227851_o_);
        bufferbuilder.func_227888_a_(matrix, (float)x, (float)(y + v), 1.0f).func_227885_a_(red, green, blue, alpha).func_225583_a_(0.0f, 0.5f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix, (float)(x + u), (float)(y + v), 1.0f).func_227885_a_(red, green, blue, alpha).func_225583_a_(1.0f, 0.5f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix, (float)(x + u), (float)y, 1.0f).func_227885_a_(red, green, blue, alpha).func_225583_a_(1.0f, 0.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix, (float)x, (float)y, 1.0f).func_227885_a_(red, green, blue, alpha).func_225583_a_(0.0f, 0.0f).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
    }

    public static void drawLowerIcon(ResourceLocation rs, MatrixStack matrixStack, int x, int y, int u, int v, float red, float green, float blue, float alpha) {
        Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(rs);
        BufferBuilder bufferbuilder = Tessellator.func_178181_a().func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_227851_o_);
        bufferbuilder.func_227888_a_(matrix, (float)x, (float)(y + v), 1.0f).func_227885_a_(red, green, blue, alpha).func_225583_a_(0.0f, 1.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix, (float)(x + u), (float)(y + v), 1.0f).func_227885_a_(red, green, blue, alpha).func_225583_a_(1.0f, 1.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix, (float)(x + u), (float)y, 1.0f).func_227885_a_(red, green, blue, alpha).func_225583_a_(1.0f, 0.5f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix, (float)x, (float)y, 1.0f).func_227885_a_(red, green, blue, alpha).func_225583_a_(0.0f, 0.5f).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
    }

    public static void open(ItemStack stack) {
        Minecraft.func_71410_x().func_147108_a((Screen)new EncyclopediaScreen(stack));
    }
}

