/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.screens;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.INestedGuiEventHandler;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentUtils;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCoreUnlockWrapper;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.PassiveAbility2;
import xyz.pixelatedw.mineminenomi.api.helpers.RendererHelper;
import xyz.pixelatedw.mineminenomi.config.ClientConfig;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.events.CombatModeEvents;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.init.ModKeybindings;
import xyz.pixelatedw.mineminenomi.init.ModResources;
import xyz.pixelatedw.mineminenomi.packets.client.ability.CEquipAbilityPacket;
import xyz.pixelatedw.mineminenomi.packets.client.ability.CRemoveAbilityPacket;
import xyz.pixelatedw.mineminenomi.screens.extra.buttons.AbilitySlotButton;
import xyz.pixelatedw.mineminenomi.screens.extra.buttons.TextAnimatedButton;
import xyz.pixelatedw.mineminenomi.screens.extra.buttons.TexturedIconButton;
import xyz.pixelatedw.mineminenomi.screens.extra.panels.AbilitiesListScreenPanel;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

@OnlyIn(value=Dist.CLIENT)
public class SelectHotbarAbilitiesScreen<A extends IAbility>
extends Screen
implements INestedGuiEventHandler {
    private static final List<ITextComponent> EMPTY_TOOLTIPS = new ArrayList<ITextComponent>();
    protected PlayerEntity player;
    private AbilitiesListScreenPanel abilitiesList;
    public int groupSelected = 0;
    public int slotSelected = -1;
    public boolean isDirty;
    private int tickCount;
    private IAbilityData abilityDataProps;
    protected final List<AbilitySlotButton> abilitySlots = Lists.newArrayList();
    private final List<Widget> backgroundWidgets = new ArrayList<Widget>();
    private final List<Widget> foregroundWidgets = new ArrayList<Widget>();
    private static final Map<AbilityCore<? extends IAbility>, List<ITextComponent>> TOOLTIPS_CACHE = new HashMap<AbilityCore<? extends IAbility>, List<ITextComponent>>();
    private static final int TOOLTIP_BACKGROUND_START = WyHelper.hexToRGB("#A78342").getRGB();
    private static final int TOOLTIP_BACKGROUND_END = WyHelper.hexToRGB("#AD8F58").getRGB();
    private static final int TOOLTIP_BORDER_START = WyHelper.hexToRGB("#e3b160").getRGB();
    private static final int TOOLTIP_BORDER_END = WyHelper.hexToRGB("#cb7e23").getRGB();
    private static boolean hasStatsShown = false;
    private static boolean clearCache = false;
    private Compactness compactness;
    private Selection selection;
    private boolean showTooltips;
    private AbilityCore<?> draggedAbility = null;

    public SelectHotbarAbilitiesScreen(PlayerEntity player) {
        super((ITextComponent)new StringTextComponent(""));
        this.player = player;
        this.field_230706_i_ = Minecraft.func_71410_x();
        this.compactness = ClientConfig.INSTANCE.getCompactness();
        this.selection = ClientConfig.INSTANCE.getSelectionMode();
        this.showTooltips = ClientConfig.INSTANCE.getTooltipsShown();
        this.abilityDataProps = AbilityDataCapability.get((LivingEntity)player);
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        int i;
        this.func_230446_a_(matrixStack);
        int posX = this.field_230708_k_;
        int posY = this.field_230709_l_;
        this.field_230706_i_.func_110434_K().func_110577_a(ModResources.BOARD);
        this.func_230926_e_(this.func_230927_p_() + 100);
        this.func_238474_b_(matrixStack, (posX - 250) / 2, (posY - 230) / 2, 0, 0, 256, 256);
        this.func_238474_b_(matrixStack, (posX - 250) / 2, posY - 60, 0, 0, 256, 256);
        this.func_230926_e_(this.func_230927_p_() - 100);
        for (int i2 = 0; i2 < this.backgroundWidgets.size(); ++i2) {
            this.backgroundWidgets.get(i2).func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        }
        this.field_230706_i_.func_110434_K().func_110577_a(ModResources.BLANK_NEW);
        this.field_230706_i_.func_110434_K().func_110577_a(ModResources.BLANK_NEW);
        this.func_230926_e_(this.func_230927_p_() + 200);
        this.func_238474_b_(matrixStack, (posX - 250) / 2, (posY - 230) / 2, 0, 0, 256, 256);
        this.func_238474_b_(matrixStack, (posX - 250) / 2, posY - 60, 0, 0, 256, 256);
        this.func_230926_e_(this.func_230927_p_() - 200);
        String barId = 1 + this.groupSelected + "";
        matrixStack.func_227861_a_(0.0, 0.0, 250.0);
        WyHelper.drawStringWithBorder(this.field_230706_i_.field_71466_p, matrixStack, barId, (posX + 8) / 2 - (this.field_230706_i_.field_71466_p.func_78256_a(barId) + 104), posY - 24, 0xFFFFFF);
        matrixStack.func_227861_a_(0.0, 0.0, -250.0);
        if (this.abilitiesList != null) {
            matrixStack.func_227861_a_(0.0, 0.0, 250.0);
            this.abilitiesList.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
            matrixStack.func_227861_a_(0.0, 0.0, -250.0);
        }
        this.func_230926_e_(this.func_230927_p_() + 150);
        for (i = 0; i < this.abilitySlots.size(); ++i) {
            AbilitySlotButton slot = this.abilitySlots.get(i);
            slot.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        }
        this.func_230926_e_(this.func_230927_p_() - 150);
        this.func_230926_e_(this.func_230927_p_() + 150);
        for (i = 0; i < this.foregroundWidgets.size(); ++i) {
            this.foregroundWidgets.get(i).func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        }
        this.func_230926_e_(this.func_230927_p_() - 150);
        if (this.hasDraggedAbility()) {
            RendererHelper.drawIcon(this.getDraggedAbility().getIcon(), matrixStack, mouseX, mouseY, 1.0f, 16.0f, 16.0f);
        }
    }

    public void func_231160_c_() {
        int posX2 = this.field_230708_k_ / 2;
        int posY2 = this.field_230709_l_ / 2;
        TOOLTIPS_CACHE.clear();
        this.groupSelected = this.abilityDataProps.getCombatBarSet();
        this.foregroundWidgets.clear();
        this.backgroundWidgets.clear();
        this.updateSlots();
        this.setupOptionsAndHelp();
        int idx = 0;
        for (AbilityCategory category : AbilityCategory.values()) {
            AbilityCore core;
            if (category == AbilityCategory.ALL || (core = (AbilityCore)this.abilityDataProps.getUnlockedAbilities().stream().map(AbilityCoreUnlockWrapper::getAbilityCore).filter(category.isCorePartofCategory()).filter(AbilityCore::isVisible).findFirst().orElse(null)) == null) continue;
            boolean isFlipped = false;
            int iconOffset = 0;
            if (idx == 4) {
                posX2 += 250;
                posY2 -= 140;
            }
            if (idx >= 4) {
                isFlipped = true;
                iconOffset = 4;
            }
            int posY3 = posY2 - 100 + idx * 70 / 2;
            ResourceLocation icon = category.getIcon(this.player);
            if (icon == null) {
                Object abl = this.abilityDataProps.getEquippedOrPassiveAbility(core);
                icon = abl != null ? abl.getIcon((LivingEntity)this.player) : core.getIcon();
            }
            TexturedIconButton button = new TexturedIconButton(ModResources.BUTTON, posX2 - 145 + iconOffset, posY3, 40, 30, (ITextComponent)new StringTextComponent(""), btn -> this.updateListScreen(category));
            button = button.setTextureInfo(posX2 - 150, posY3 - 6, 55, 40).setFlipped(isFlipped).setIconInfo(icon, posX2 - 136 + iconOffset, posY3 + 2, 1.45);
            this.backgroundWidgets.add((Widget)button);
            this.func_230480_a_((Widget)button);
            ++idx;
        }
        this.updateListScreen(AbilityCategory.DEVIL_FRUITS);
    }

    public void updateSlots() {
        int posX = this.field_230708_k_;
        int posY = this.field_230709_l_;
        this.slotSelected = -1;
        this.field_230710_m_.removeIf(w -> w instanceof AbilitySlotButton && this.abilitySlots.contains(w));
        this.field_230705_e_.removeIf(w -> w instanceof AbilitySlotButton && this.abilitySlots.contains(w));
        this.abilitySlots.clear();
        posX += 10;
        for (int i = 0; i < 8; ++i) {
            RenderSystem.enableBlend();
            int id = i + this.groupSelected * 8;
            Object abl = this.abilityDataProps.getEquippedAbility(id);
            AbilitySlotButton slotButton = new AbilitySlotButton((IAbility)abl, posX / 2 - 101 + i * 25, posY - 31, 22, 21, this.player, btn -> this.onClickAbilitySlot(btn, id));
            this.func_230481_d_((IGuiEventListener)slotButton);
            this.abilitySlots.add(slotButton);
        }
    }

    public void setupOptionsAndHelp() {
        int posX = this.field_230708_k_;
        int posY = this.field_230709_l_;
        Button.ITooltip helpTooltip = (btn, matrix, mouseX, mouseY) -> {
            StringBuilder sb = new StringBuilder();
            if (this.selection == Selection.DRAG_AND_DROP) {
                sb.append(ModI18n.HELP_ABILITY_SELECTOR_DRAG_AND_DROP.getString());
            } else if (this.selection == Selection.KEYBIND) {
                sb.append(ModI18n.HELP_ABILITY_SELECTOR_KEYBIND.getString());
            }
            sb.append("\n\n");
            if (this.showTooltips) {
                sb.append(ModI18n.HELP_ABILITY_SELECTOR_HIDE_TOOLTIPS.getString());
            } else {
                sb.append(ModI18n.HELP_ABILITY_SELECTOR_SHOW_TOOLTIPS.getString());
            }
            this.func_238654_b_(matrix, this.field_230706_i_.field_71466_p.func_238425_b_((ITextProperties)new StringTextComponent(sb.toString()), Math.max(this.field_230708_k_ / 2 - 43, 170)), mouseX, mouseY);
        };
        TextAnimatedButton helpButton = new TextAnimatedButton(posX - 20, this.field_230709_l_ - 20, 20, 20, (ITextComponent)new StringTextComponent("?"), btn -> {}, helpTooltip);
        if (ClientConfig.INSTANCE.getHelpButtonShown()) {
            this.foregroundWidgets.add((Widget)helpButton);
            this.func_230480_a_((Widget)helpButton);
        }
        Button.ITooltip compactnessTooltip = (btn, matrix, mouseX, mouseY) -> {
            if (mouseY - 16 < 0) {
                mouseY = 16;
            }
            this.func_238654_b_(matrix, this.field_230706_i_.field_71466_p.func_238425_b_((ITextProperties)new StringTextComponent(this.compactness.toString()), Math.max(this.field_230708_k_ / 2 - 43, 170)), mouseX, mouseY);
        };
        Button compactnessButton = new Button(posX - 20, 0, 20, 20, (ITextComponent)new StringTextComponent(this.compactness.getShortNotation()), btn -> {
            this.compactness = this.compactness.nextElement();
            this.abilitiesList.setCompactness(this.compactness);
            btn.func_238482_a_((ITextComponent)new StringTextComponent(this.compactness.getShortNotation()));
            ClientConfig.INSTANCE.setCompactness(this.compactness);
            helpButton.setMarked();
        }, compactnessTooltip);
        this.foregroundWidgets.add((Widget)compactnessButton);
        this.func_230480_a_((Widget)compactnessButton);
        Button.ITooltip selectionTooltip = (btn, matrix, mouseX, mouseY) -> {
            if (mouseY - 16 < 0) {
                mouseY = 16;
            }
            this.func_238654_b_(matrix, this.field_230706_i_.field_71466_p.func_238425_b_((ITextProperties)new StringTextComponent(this.selection.toString()), Math.max(this.field_230708_k_ / 2 - 43, 170)), mouseX, mouseY);
        };
        Button selectionButton = new Button(posX - 40, 0, 20, 20, (ITextComponent)new StringTextComponent(this.selection.getShortNotation()), btn -> {
            this.slotSelected = -1;
            for (AbilitySlotButton slot : this.abilitySlots) {
                slot.setIsPressed(false);
            }
            this.selection = this.selection.nextElement();
            btn.func_238482_a_((ITextComponent)new StringTextComponent(this.selection.getShortNotation()));
            ClientConfig.INSTANCE.setSelectionMode(this.selection);
            helpButton.setMarked();
        }, selectionTooltip);
        this.foregroundWidgets.add((Widget)selectionButton);
        this.func_230480_a_((Widget)selectionButton);
        Button.ITooltip showTooltipsTooltip = (btn, matrix, mouseX, mouseY) -> {
            if (mouseY - 16 < 0) {
                mouseY = 16;
            }
            this.func_238654_b_(matrix, this.field_230706_i_.field_71466_p.func_238425_b_((ITextProperties)new StringTextComponent("Show tooltips"), Math.max(this.field_230708_k_ / 2 - 43, 170)), mouseX, mouseY);
        };
        Button showTooltips = new Button(posX - 60, 0, 20, 20, (ITextComponent)new StringTextComponent(this.showTooltips ? "O" : "X"), btn -> {
            ClientConfig.INSTANCE.toggleShowingTooltips();
            this.showTooltips = ClientConfig.INSTANCE.getTooltipsShown();
            btn.func_238482_a_((ITextComponent)new StringTextComponent(this.showTooltips ? "O" : "X"));
            helpButton.setMarked();
        }, showTooltipsTooltip);
        this.foregroundWidgets.add((Widget)showTooltips);
        this.func_230480_a_((Widget)showTooltips);
    }

    public void onClickAbilitySlot(Button btn, int id) {
        if (this.getSelectionMode() == Selection.DRAG_AND_DROP) {
            AbilitySlotButton slot = null;
            for (int btnid = 0; btnid < this.abilitySlots.size(); ++btnid) {
                slot = this.abilitySlots.get(btnid);
                if (slot == null || slot != btn) continue;
                int slotId = btnid + this.groupSelected * 8;
                Object ability = this.abilityDataProps.getEquippedAbility(slotId);
                if (ability != null) {
                    this.setDraggedAbility(ability.getCore());
                }
                WyNetwork.sendToServer(new CRemoveAbilityPacket(slotId));
                this.abilityDataProps.setEquippedAbility(slotId, null);
                ((AbilitySlotButton)btn).setAbility(null);
                break;
            }
            return;
        }
        if (this.slotSelected != id) {
            this.slotSelected = id;
            for (AbilitySlotButton slotBtn : this.abilitySlots) {
                slotBtn.setIsPressed(false);
            }
            ((AbilitySlotButton)btn).setIsPressed(true);
        } else {
            Object ability = this.abilityDataProps.getEquippedAbility(this.slotSelected);
            if (ability == null) {
                return;
            }
            if (ability.hasComponent(ModAbilityKeys.COOLDOWN) && ability.getComponent(ModAbilityKeys.COOLDOWN).get().isOnCooldown()) {
                return;
            }
            if (ability.hasComponent(ModAbilityKeys.DISABLE) && ability.getComponent(ModAbilityKeys.DISABLE).get().isDisabled()) {
                return;
            }
            if (ability.hasComponent(ModAbilityKeys.CONTINUOUS) && ability.getComponent(ModAbilityKeys.CONTINUOUS).get().isContinuous()) {
                return;
            }
            if (ability.hasComponent(ModAbilityKeys.CHARGE) && ability.getComponent(ModAbilityKeys.CHARGE).get().isCharging()) {
                return;
            }
            WyNetwork.sendToServer(new CRemoveAbilityPacket(this.slotSelected));
            this.abilityDataProps.setEquippedAbility(this.slotSelected, null);
            ((AbilitySlotButton)btn).setAbility(null);
        }
    }

    public void func_231023_e_() {
        if (this.isDirty && this.tickCount++ >= 1) {
            int i = 0;
            for (AbilitySlotButton slotBtn : this.abilitySlots) {
                int id = i + this.groupSelected * 8;
                Object abl = this.abilityDataProps.getEquippedAbility(id);
                slotBtn.setAbility((IAbility)abl);
                ++i;
            }
            this.isDirty = false;
            this.tickCount = 0;
        }
    }

    public boolean func_231046_a_(int key, int pScanCode, int pModifiers) {
        this.checkKeybinding(key);
        return super.func_231046_a_(key, pScanCode, pModifiers);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        this.checkKeybinding(button);
        if (button == 1) {
            int slotId = -1;
            AbilitySlotButton slot = null;
            for (int i = 0; i < this.abilitySlots.size(); ++i) {
                slot = this.abilitySlots.get(i);
                if (slot == null || !slot.func_231047_b_(mouseX, mouseY)) continue;
                slotId = i + this.groupSelected * 8;
                break;
            }
            if (slot != null && slotId >= 0) {
                if (this.getSelectionMode() == Selection.KEYBIND && this.slotSelected >= 0) {
                    WyNetwork.sendToServer(new CRemoveAbilityPacket(slotId));
                    this.abilityDataProps.setEquippedAbility(slotId, null);
                    this.abilitySlots.get(slotId % 8).setAbility(null);
                    this.slotSelected = -1;
                    slot.setIsPressed(false);
                } else if (this.getSelectionMode() == Selection.DRAG_AND_DROP) {
                    WyNetwork.sendToServer(new CRemoveAbilityPacket(slotId));
                    this.abilityDataProps.setEquippedAbility(slotId, null);
                    this.abilitySlots.get(slotId % 8).setAbility(null);
                }
            }
        }
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int button) {
        if (this.getSelectionMode() == Selection.DRAG_AND_DROP && this.hasDraggedAbility() && button == 0) {
            for (int i = 0; i < this.abilitySlots.size(); ++i) {
                AbilitySlotButton slot = this.abilitySlots.get(i);
                if (slot == null || !slot.func_231047_b_(mouseX, mouseY)) continue;
                int id = i + this.groupSelected * 8;
                WyNetwork.sendToServer(new CEquipAbilityPacket(id, this.getDraggedAbility()));
                this.isDirty = true;
                break;
            }
            this.setDraggedAbility(null);
        }
        return true;
    }

    private void checkKeybinding(int key) {
        if (this.getSelectionMode() == Selection.KEYBIND) {
            for (int i = 0; i < ModKeybindings.keyBindsCombatbar.size(); ++i) {
                int id;
                KeyBinding bind = ModKeybindings.keyBindsCombatbar.get(i);
                if (bind.getKey().func_197937_c() != key) continue;
                this.slotSelected = id = (i %= 8) + this.groupSelected * 8;
                AbilityCore<?> core = this.abilitiesList.getHoveredEntry();
                if (core == null) break;
                if (this.abilityDataProps.hasEquippedAbility(core)) {
                    int slotId = this.abilityDataProps.getEquippedAbilitySlot(core);
                    WyNetwork.sendToServer(new CRemoveAbilityPacket(slotId));
                    this.abilityDataProps.setEquippedAbility(slotId, null);
                    this.abilitySlots.get(i).setAbility(null);
                }
                WyNetwork.sendToServer(new CEquipAbilityPacket(id, core));
                this.isDirty = true;
                for (AbilitySlotButton slot : this.abilitySlots) {
                    slot.setIsPressed(false);
                }
                this.abilitySlots.get(i).setIsPressed(true);
                break;
            }
        }
        int clientMaxBars = CommonConfig.INSTANCE.getAbilityBars();
        int maxBars = Math.min(clientMaxBars, CombatModeEvents.Client.ABILITY_BARS);
        if (key == ModKeybindings.nextCombatBar.getKey().func_197937_c()) {
            this.groupSelected = this.groupSelected < maxBars - 1 ? ++this.groupSelected : 0;
            this.updateSlots();
        } else if (key == ModKeybindings.prevCombatBar.getKey().func_197937_c()) {
            this.groupSelected = this.groupSelected > 0 ? --this.groupSelected : maxBars - 1;
            this.updateSlots();
        }
    }

    public void updateListScreen(AbilityCategory category) {
        this.field_230705_e_.remove((Object)this.abilitiesList);
        this.abilitiesList = new AbilitiesListScreenPanel(this, this.abilityDataProps, category);
        this.field_230705_e_.add(this.abilitiesList);
        this.func_231035_a_((IGuiEventListener)this.abilitiesList);
    }

    public static boolean canShowTooltips() {
        boolean canShowTooltips = ClientConfig.INSTANCE.getTooltipsShown();
        if (canShowTooltips) {
            return !ModKeybindings.isAltKeyDown();
        }
        return ModKeybindings.isAltKeyDown();
    }

    private static List<ITextComponent> generateAbilityTooltip(IAbility ability) {
        boolean canShowAdvancedTooltips = Minecraft.func_71410_x().field_71474_y.field_82882_x;
        boolean canShowStats = !ClientConfig.INSTANCE.hidesAbilityStats() || ModKeybindings.isShiftKeyDown();
        Set<AbilityDescriptionLine> newSet = ability.getCore().getDescription();
        ArrayList<ITextComponent> tooltips = new ArrayList<ITextComponent>();
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        tooltips.add((ITextComponent)new StringTextComponent(ability.getDisplayName().getString() + (newSet != null && !newSet.isEmpty() ? "\n" : "")));
        if (newSet != null) {
            long advancedLines = newSet.stream().filter(line -> line.isAdvanced()).count();
            newSet.stream().filter(line -> !line.isAdvanced() || line.isAdvanced() && canShowStats).map(line -> line.getTextComponent((LivingEntity)player, ability)).map(text -> {
                if (text == null) {
                    return null;
                }
                try {
                    return TextComponentUtils.func_240645_a_(null, (ITextComponent)text, (Entity)player, (int)1);
                }
                catch (CommandSyntaxException e) {
                    e.printStackTrace();
                    return null;
                }
            }).filter(Objects::nonNull).forEach(tooltips::add);
            if (advancedLines > 0L && ClientConfig.INSTANCE.hidesAbilityStats() && !ModKeybindings.isShiftKeyDown()) {
                tooltips.add(AbilityDescriptionLine.NEW_LINE.expand((LivingEntity)player, ability));
                tooltips.add((ITextComponent)ModI18n.GUI_SHOW_ABILITY_STATS.func_230530_a_(Style.field_240709_b_.func_240722_b_(Boolean.valueOf(true)).func_240712_a_(TextFormatting.YELLOW)));
            }
        }
        if (canShowAdvancedTooltips) {
            ResourceLocation key;
            boolean isNew = false;
            if (ability instanceof Ability && ((Ability)ability).isNew) {
                isNew = true;
            } else if (ability instanceof PassiveAbility2) {
                isNew = true;
            }
            String color = "\u00a7c";
            if (isNew) {
                color = "\u00a77";
            }
            if ((key = ability.getCore().getRegistryName()) != null) {
                tooltips.add((ITextComponent)new StringTextComponent("\n" + color + key.toString()));
            }
        }
        return tooltips;
    }

    public static void renderAbilityTooltip(MatrixStack matrixStack, int mouseX, int mouseY, IAbility ability) {
        Minecraft mc = Minecraft.func_71410_x();
        MainWindow window = mc.func_228018_at_();
        if (ClientConfig.INSTANCE.hidesAbilityStats()) {
            if (ModKeybindings.isShiftKeyDown() && !hasStatsShown) {
                clearCache = true;
                hasStatsShown = true;
            } else if (!ModKeybindings.isShiftKeyDown() && hasStatsShown) {
                clearCache = true;
                hasStatsShown = false;
            }
            if (clearCache) {
                TOOLTIPS_CACHE.clear();
                clearCache = false;
            }
        }
        if (!TOOLTIPS_CACHE.containsKey(ability.getCore())) {
            TOOLTIPS_CACHE.putIfAbsent(ability.getCore(), SelectHotbarAbilitiesScreen.generateAbilityTooltip(ability));
        }
        List<ITextComponent> tooltips = TOOLTIPS_CACHE.getOrDefault(ability.getCore(), EMPTY_TOOLTIPS);
        RendererHelper.drawAbilityTooltip(ability, matrixStack, tooltips, mouseX, mouseY, window.func_198107_o(), window.func_198087_p(), 210, TOOLTIP_BACKGROUND_START, TOOLTIP_BACKGROUND_END, TOOLTIP_BORDER_START, TOOLTIP_BORDER_END, mc.field_71466_p);
        RenderSystem.enableBlend();
    }

    public void func_231175_as__() {
        super.func_231175_as__();
    }

    public boolean func_231177_au__() {
        return false;
    }

    public Compactness getCompactness() {
        return this.compactness;
    }

    public Selection getSelectionMode() {
        return this.selection;
    }

    public boolean showTooltips() {
        return this.showTooltips;
    }

    @Nullable
    public AbilityCore<?> getDraggedAbility() {
        return this.draggedAbility;
    }

    public boolean hasDraggedAbility() {
        return this.draggedAbility != null;
    }

    public void setDraggedAbility(AbilityCore<?> core) {
        this.draggedAbility = core;
    }

    public static enum Compactness implements Enumeration<Compactness>
    {
        SPATIOUS(1.25f, 16, 1.0f, 0, 4, 0, 0),
        COMPACT(1.05f, 16, 1.0f, 0, 4, 0, 0),
        MINIMAL(0.9f, 12, 0.8f, 5, 2, 5, 2);

        private final float spacing;
        private final int iconSize;
        private final float slotScale;
        private final int slotOffsetX;
        private final int slotOffsetY;
        private final int iconOffsetX;
        private final int iconOffsetY;

        private Compactness(float spacing, int iconSize, float slotScale, int slotOffsetX, int slotOffsetY, int iconOffsetX, int iconOffsetY) {
            this.spacing = spacing;
            this.iconSize = iconSize;
            this.slotScale = slotScale;
            this.slotOffsetX = slotOffsetX;
            this.slotOffsetY = slotOffsetY;
            this.iconOffsetX = iconOffsetX;
            this.iconOffsetY = iconOffsetY;
        }

        public float getSpacing() {
            return this.spacing;
        }

        public int getIconSize() {
            return this.iconSize;
        }

        public float getSlotScale() {
            return this.slotScale;
        }

        public int getSlotOffsetX() {
            return this.slotOffsetX;
        }

        public int getSlotOffsetY() {
            return this.slotOffsetY;
        }

        public int getIconOffsetX() {
            return this.iconOffsetX;
        }

        public int getIconOffsetY() {
            return this.iconOffsetY;
        }

        public String toString() {
            return WyHelper.capitalize(this.name());
        }

        public String getShortNotation() {
            switch (this) {
                case COMPACT: {
                    return "C";
                }
                case MINIMAL: {
                    return "M";
                }
                case SPATIOUS: {
                    return "S";
                }
            }
            return "S";
        }

        @Override
        public boolean hasMoreElements() {
            return true;
        }

        @Override
        public Compactness nextElement() {
            return Compactness.values()[(this.ordinal() + 1) % Compactness.values().length];
        }
    }

    public static enum Selection implements Enumeration<Selection>
    {
        DRAG_AND_DROP,
        KEYBIND;


        public String toString() {
            switch (this) {
                case DRAG_AND_DROP: {
                    return "Drag and Drop";
                }
                case KEYBIND: {
                    return "Keybind";
                }
            }
            return "None";
        }

        public String getShortNotation() {
            switch (this) {
                case DRAG_AND_DROP: {
                    return "D";
                }
                case KEYBIND: {
                    return "K";
                }
            }
            return "-";
        }

        @Override
        public boolean hasMoreElements() {
            return true;
        }

        @Override
        public Selection nextElement() {
            return Selection.values()[(this.ordinal() + 1) % Selection.values().length];
        }
    }
}

