/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.screens;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.InventoryScreen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.ToggleWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.gui.GuiUtils;
import xyz.pixelatedw.mineminenomi.api.TradeEntry;
import xyz.pixelatedw.mineminenomi.api.entities.TraderEntity;
import xyz.pixelatedw.mineminenomi.api.enums.Currency;
import xyz.pixelatedw.mineminenomi.api.helpers.CurrencyHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.RendererHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.entities.mobs.SkypieanTraderEntity;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.init.ModKeybindings;
import xyz.pixelatedw.mineminenomi.init.ModResources;
import xyz.pixelatedw.mineminenomi.packets.client.trade.CBuyFromTraderPacket;
import xyz.pixelatedw.mineminenomi.packets.client.trade.CSellToTraderPacket;
import xyz.pixelatedw.mineminenomi.screens.extra.FlickeringString;
import xyz.pixelatedw.mineminenomi.screens.extra.SequencedString;
import xyz.pixelatedw.mineminenomi.screens.extra.buttons.FactionButton;
import xyz.pixelatedw.mineminenomi.screens.extra.buttons.TexturedIconButton;
import xyz.pixelatedw.mineminenomi.screens.extra.panels.ItemListScreenPanel;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

@OnlyIn(value=Dist.CLIENT)
public class TraderScreen
extends Screen {
    private int guiState = 0;
    private int wantedAmount = 1;
    private ItemListScreenPanel listPanel;
    private TradeEntry selectedStack;
    private TradeEntry previousStack;
    private TradeEntry hoveredStack;
    private PlayerEntity player;
    private TraderEntity trader;
    private IEntityStats props;
    private SequencedString startMessage;
    private FlickeringString skipMessage;
    private ToggleWidget vearthAmountUp;
    private ToggleWidget vearthAmountDown;
    private int dirtBlocksAvailable;
    private TextFieldWidget quantityEdit;
    protected static final ResourceLocation RECIPE_BOOK = new ResourceLocation("textures/gui/recipe_book.png");

    public TraderScreen(TraderEntity entity) {
        super((ITextComponent)new StringTextComponent(""));
        this.trader = entity;
        this.player = Minecraft.func_71410_x().field_71439_g;
        this.props = EntityStatsCapability.get((LivingEntity)this.player);
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        switch (this.guiState) {
            case 0: {
                this.renderMenu(matrixStack, mouseX, mouseY, partialTicks);
                break;
            }
            case 1: {
                this.renderSellShop(matrixStack, mouseX, mouseY, partialTicks);
                break;
            }
            case 2: {
                this.renderBuyShop(matrixStack, mouseX, mouseY, partialTicks);
                break;
            }
        }
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
    }

    public void renderMenu(MatrixStack matrixStack, int x, int y, float partialTicks) {
        int posX = this.field_230708_k_ / 2;
        int posY = this.field_230709_l_ / 2;
        if (!this.trader.canBuyFromPlayers()) {
            this.startMessage.render(matrixStack, posX - 200, posY - 50, partialTicks);
            this.skipMessage.render(matrixStack, posX - 100, posY + 60, partialTicks);
            if ((float)this.startMessage.tickCount * partialTicks > (float)this.startMessage.delayTicks) {
                if (this.trader.canTrade(this.player)) {
                    this.guiState = 1;
                    this.func_231158_b_(this.getMinecraft(), this.field_230708_k_, this.field_230709_l_);
                } else {
                    this.func_231175_as__();
                }
            }
        } else {
            this.startMessage.render(matrixStack, posX - 150, posY - 105, partialTicks);
        }
        RenderSystem.pushMatrix();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        InventoryScreen.func_228187_a_((int)(posX + 150), (int)(posY + 150), (int)100, (float)40.0f, (float)5.0f, (LivingEntity)this.trader);
        RenderSystem.popMatrix();
    }

    public void renderSellShop(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.getMinecraft().func_110434_K().func_110577_a(ModResources.BLANK2);
        int posX = this.field_230708_k_ / 2;
        int posY = this.field_230709_l_ / 2;
        GuiUtils.drawTexturedModalRect((MatrixStack)matrixStack, (int)(posX - 128), (int)(posY - 110), (int)0, (int)0, (int)256, (int)256, (float)0.0f);
        this.renderUpperColumn(matrixStack);
        this.drawSizedString(matrixStack, new TranslationTextComponent(ModI18n.GUI_NAME).getString(), posX - 20, posY - 63, 0.9f, -1);
        this.drawSizedString(matrixStack, new TranslationTextComponent(ModI18n.GUI_PRICE).getString(), posX + 50, posY - 63, 0.9f, -1);
        this.getMinecraft().func_110434_K().func_110577_a(ModResources.CURRENCIES);
        int type = this.trader.getCurrency() == Currency.BELLY ? 0 : 34;
        GuiUtils.drawTexturedModalRect((MatrixStack)matrixStack, (int)(posX + 53), (int)(posY - 76), (int)type, (int)32, (int)32, (int)64, (float)1.0f);
        this.listPanel.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.hover(mouseX, mouseY);
        if (this.selectedStack != null) {
            this.field_230710_m_.forEach(button -> button.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks));
        }
    }

    public void renderBuyShop(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        int posX = this.field_230708_k_ / 2;
        int posY = this.field_230709_l_ / 2;
        this.startMessage.render(matrixStack, posX - 150, posY - 105, partialTicks);
        posX -= 110;
        if (this.trader instanceof SkypieanTraderEntity && ((SkypieanTraderEntity)this.trader).getTradesLeft() > 0) {
            this.renderItem(new ItemStack((IItemProvider)Blocks.field_150346_d.func_199767_j()), posX, posY - 30);
            String amount = this.wantedAmount + "";
            WyHelper.drawStringWithBorder(this.field_230712_o_, matrixStack, amount, posX + 8 - this.field_230712_o_.func_78256_a(amount) / 2, posY - 7, -1);
            WyHelper.drawStringWithBorder(this.field_230712_o_, matrixStack, "=", posX + 60, posY - 7, -1);
            WyHelper.drawStringWithBorder(this.field_230712_o_, matrixStack, CurrencyHelper.getExtolFromBelly(this.wantedAmount) + "", posX + 100, posY - 7, -1);
            this.getMinecraft().func_110434_K().func_110577_a(ModResources.CURRENCIES);
            GuiUtils.drawTexturedModalRect((MatrixStack)matrixStack, (int)(posX + 75), (int)(posY - 21), (int)34, (int)32, (int)32, (int)64, (float)1.0f);
        }
        RenderSystem.pushMatrix();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        InventoryScreen.func_228187_a_((int)((posX += 110) + 150), (int)(posY + 150), (int)100, (float)40.0f, (float)5.0f, (LivingEntity)this.trader);
        RenderSystem.popMatrix();
    }

    public void renderUpperColumn(MatrixStack matrixStack) {
        int posX = this.field_230708_k_ / 2;
        int posY = this.field_230709_l_ / 2;
        String amount = "";
        if (this.hoveredStack != null) {
            this.quantityEdit.func_230430_a_(matrixStack, 0, 0, 0.0f);
            RendererHelper.drawIcon(ModResources.BLANK, matrixStack, posX - 117, posY - 105, 1.0f, 32.0f, 42.0f);
            this.renderItem(this.hoveredStack.getItemStack(), posX - 110, posY - 100);
            amount = "/" + this.hoveredStack.getCount();
            if (this.hoveredStack.hasInfiniteStock()) {
                amount = "/\u221e";
            }
        } else if (this.getSelectedStack() != null) {
            this.quantityEdit.func_230430_a_(matrixStack, 0, 0, 0.0f);
            RendererHelper.drawIcon(ModResources.BLANK, matrixStack, posX - 117, posY - 105, 1.0f, 32.0f, 42.0f);
            this.renderItem(this.getSelectedStack().getItemStack(), posX - 110, posY - 100);
            amount = "/" + this.getSelectedStack().getCount();
            if (this.getSelectedStack().hasInfiniteStock()) {
                amount = "/\u221e";
            }
        }
        long currency = this.trader.getCurrency() == Currency.BELLY ? this.props.getBelly() : this.props.getExtol();
        matrixStack.func_227860_a_();
        matrixStack.func_227862_a_(1.2f, 1.2f, 1.2f);
        this.drawSizedString(matrixStack, amount, posX - 50, posY - 94, 0.9f, -1);
        matrixStack.func_227865_b_();
        this.drawSizedString(matrixStack, currency + "", posX + 85, posY - 95, 0.9f, -1);
        this.getMinecraft().func_110434_K().func_110577_a(ModResources.CURRENCIES);
        int type = this.trader.getCurrency() == Currency.BELLY ? 0 : 34;
        GuiUtils.drawTexturedModalRect((MatrixStack)matrixStack, (int)(posX + 102), (int)(posY - 108), (int)type, (int)32, (int)32, (int)64, (float)1.0f);
    }

    public void func_231158_b_(Minecraft mc, int width, int height) {
        super.func_231158_b_(mc, width, height);
        int posX = this.field_230708_k_ / 2;
        int posY = this.field_230709_l_ / 2;
        this.startMessage = new SequencedString("", 0, 0);
        if (this.skipMessage == null) {
            this.skipMessage = new FlickeringString("- " + new TranslationTextComponent(ModI18n.GUI_CLICK_TO_SKIP).getString() + " -", 20);
        }
        if (this.guiState == 0) {
            this.wantedAmount = 1;
            String message = "";
            message = this.trader.canTrade(this.player) ? new TranslationTextComponent(ModI18n.TRADER_WELCOME_MESSAGE).getString() : this.trader.getTradeFailMessage();
            this.startMessage = new SequencedString(message, 250, this.field_230712_o_.func_78256_a(message) / 2);
            if (this.trader.canBuyFromPlayers()) {
                FactionButton buyButton = new FactionButton(posX - 180, posY - 50, 100, 20, (ITextComponent)new TranslationTextComponent("gui.buy"), btn -> {
                    this.guiState = 1;
                    this.func_231158_b_(this.getMinecraft(), this.field_230708_k_, this.field_230709_l_);
                });
                this.func_230480_a_((Widget)buyButton);
                FactionButton sellButton = new FactionButton(posX - 180, posY - 20, 100, 20, (ITextComponent)new TranslationTextComponent("gui.sell"), btn -> {
                    this.guiState = 2;
                    this.func_231158_b_(this.getMinecraft(), this.field_230708_k_, this.field_230709_l_);
                });
                this.func_230480_a_((Widget)sellButton);
            }
        } else if (this.guiState == 1) {
            this.listPanel = new ItemListScreenPanel(this, this.trader.getTradingItems());
            this.field_230705_e_.add(this.listPanel);
            this.quantityEdit = new TextFieldWidget(this.field_230712_o_, posX - 80, posY - 100, 20, 20, (ITextComponent)new StringTextComponent(""));
            this.quantityEdit.func_146203_f(2);
            this.quantityEdit.func_146191_b("1");
            this.field_230705_e_.add(this.quantityEdit);
            TexturedIconButton buyBtn = new TexturedIconButton(ModResources.BLANK, posX - 10, posY - 100, 64, 22, (ITextComponent)new TranslationTextComponent(ModI18n.GUI_BUY), this::onBuy);
            buyBtn = buyBtn.setTextureInfo(posX - 10, posY - 100, 64, 32).setTextInfo(posX + 10, posY - 95, 1.0);
            this.func_230480_a_((Widget)buyBtn);
            if (this.trader.canBuyFromPlayers()) {
                FactionButton backButton = new FactionButton(posX - 200, posY + 78, 70, 20, (ITextComponent)new TranslationTextComponent("gui.cancel"), btn -> {
                    this.guiState = 0;
                    this.func_231158_b_(this.getMinecraft(), this.field_230708_k_, this.field_230709_l_);
                });
                this.func_230480_a_((Widget)backButton);
            }
        } else if (this.guiState == 2 && this.trader instanceof SkypieanTraderEntity) {
            this.wantedAmount = 0;
            SkypieanTraderEntity skypieanTrader = (SkypieanTraderEntity)this.trader;
            String message = new TranslationTextComponent(ModI18n.TRADER_SKYPIEAN_VEARTH, new Object[]{10000L, skypieanTrader.getExtolLeftInStock()}).getString();
            if (skypieanTrader.getTradesLeft() <= 0) {
                message = new TranslationTextComponent(ModI18n.TRADER_SKYPIEAN_NO_EXTOL).getString();
            }
            this.startMessage = new SequencedString(message, 250, this.field_230712_o_.func_78256_a(message) / 3, 5000000);
            if (skypieanTrader.getTradesLeft() > 0) {
                FactionButton tradeButton = new FactionButton(posX - 80, posY + 20, 70, 20, (ITextComponent)new TranslationTextComponent(ModI18n.GUI_SELL), btn -> {
                    WyNetwork.sendToServer(new CSellToTraderPacket(this.trader.func_145782_y(), this.wantedAmount));
                    Minecraft.func_71410_x().func_147108_a(null);
                });
                this.func_230480_a_((Widget)tradeButton);
            }
            FactionButton backButton = new FactionButton(posX - 200, posY + 78, 70, 20, (ITextComponent)new TranslationTextComponent("gui.cancel"), btn -> {
                this.guiState = 0;
                this.func_231158_b_(this.getMinecraft(), this.field_230708_k_, this.field_230709_l_);
            });
            this.func_230480_a_((Widget)backButton);
            this.dirtBlocksAvailable = 0;
            for (int i = 0; i < this.player.field_71071_by.func_70302_i_(); ++i) {
                ItemStack stack = this.player.field_71071_by.func_70301_a(i);
                if (stack == null || stack.func_190926_b() || stack.func_77973_b() != Blocks.field_150346_d.func_199767_j()) continue;
                this.dirtBlocksAvailable += stack.func_190916_E();
            }
            this.vearthAmountUp = new ToggleWidget(posX - 80, posY - 11, 12, 17, false);
            this.vearthAmountUp.func_191751_a(1, 208, 13, 18, RECIPE_BOOK);
            this.vearthAmountDown = new ToggleWidget(posX - 135, posY - 11, 12, 17, true);
            this.vearthAmountDown.func_191751_a(1, 208, 13, 18, RECIPE_BOOK);
            if (skypieanTrader.getTradesLeft() > 0) {
                this.func_230480_a_((Widget)this.vearthAmountUp);
                this.func_230480_a_((Widget)this.vearthAmountDown);
            }
        }
    }

    public void func_231152_a_(Minecraft minecraft, int x, int y) {
        if (this.quantityEdit != null) {
            String crewName = this.quantityEdit.func_146179_b();
            this.func_231158_b_(minecraft, x, y);
            this.quantityEdit.func_146191_b(crewName);
        }
    }

    public void func_231023_e_() {
        if (this.quantityEdit != null && this.getSelectedStack() != null) {
            this.quantityEdit.func_146178_a();
            try {
                int tempAmount = Integer.parseInt(this.quantityEdit.func_146179_b());
                boolean forceUpdate = false;
                if (this.hoveredStack != null & this.hoveredStack != this.getSelectedStack()) {
                    tempAmount = 1;
                    forceUpdate = true;
                }
                if (tempAmount != this.wantedAmount || this.getSelectedStack() != this.previousStack || forceUpdate) {
                    if (!this.getSelectedStack().hasInfiniteStock()) {
                        tempAmount = MathHelper.func_76125_a((int)tempAmount, (int)0, (int)this.getSelectedStack().getCount());
                    }
                    int cursor = this.quantityEdit.func_146198_h();
                    this.quantityEdit.func_146180_a(tempAmount + "");
                    this.quantityEdit.func_146190_e(cursor);
                    this.wantedAmount = tempAmount;
                    this.previousStack = this.getSelectedStack();
                }
            }
            catch (Exception e) {
                this.quantityEdit.func_146180_a("");
            }
        }
    }

    public void onBuy(Button btn) {
        long currency;
        if (this.getSelectedStack() == null) {
            return;
        }
        if (this.getWantedAmount() > this.getSelectedStack().getCount() && !this.getSelectedStack().hasInfiniteStock()) {
            return;
        }
        if (this.getEmptySlots() < this.calculateSlotsFromCount(this.getWantedAmount())) {
            return;
        }
        int totalPrice = this.getSelectedStack().getPrice() * this.getWantedAmount();
        long l = currency = this.trader.getCurrency() == Currency.BELLY ? this.props.getBelly() : this.props.getExtol();
        if (currency < (long)totalPrice) {
            return;
        }
        WyNetwork.sendToServer(new CBuyFromTraderPacket(this.trader.func_145782_y(), this.getSelectedStack().getItemStack(), this.getWantedAmount()));
        if (!this.getSelectedStack().hasInfiniteStock()) {
            int count = this.getSelectedStack().getCount() - this.wantedAmount;
            if (count <= 0) {
                this.trader.getTradingItems().remove(this.getSelectedStack());
            } else {
                this.getSelectedStack().setCount(count);
            }
            this.setSelectedStack(null);
        }
    }

    public void onIncreaseQuantity(Button btn) {
        if (this.getSelectedStack() != null && (this.getWantedAmount() < this.getSelectedStack().getCount() || this.getSelectedStack().hasInfiniteStock())) {
            this.setWantedAmount(this.getWantedAmount() + 1);
        }
    }

    public void onDecreaseQuantity(Button btn) {
        if (this.getSelectedStack() != null && this.getWantedAmount() > 1) {
            this.setWantedAmount(this.getWantedAmount() - 1);
        }
    }

    public void renderItem(ItemStack stack, int posX, int posY) {
        Minecraft.func_71410_x().func_175599_af().func_175042_a(stack, posX, posY);
    }

    public void drawSizedString(MatrixStack matrixStack, String txt, int x, int y, float scale, int color) {
        RenderSystem.pushMatrix();
        RenderSystem.translated((double)x, (double)y, (double)0.0);
        RenderSystem.scalef((float)scale, (float)scale, (float)scale);
        if (color == -1) {
            color = WyHelper.hexToRGB("#FFFFFF").getRGB();
        }
        this.drawCenteredString(matrixStack, txt, 0, 0, color);
        RenderSystem.popMatrix();
    }

    public void hover(int mouseX, int mouseY) {
        TradeEntry entry = this.listPanel.findStackEntry(mouseX, mouseY);
        if (entry != null) {
            this.hoveredStack = entry;
            this.setWantedAmount(1);
        } else {
            this.hoveredStack = null;
        }
    }

    public int getEmptySlots() {
        int i = 0;
        for (ItemStack stack : this.player.field_71071_by.field_70462_a) {
            if (!stack.func_190926_b()) continue;
            ++i;
        }
        return i;
    }

    public int calculateSlotsFromCount(int count) {
        double val = (double)count / 64.0;
        return MathHelper.func_76143_f((double)val);
    }

    public List<Integer> getStacks(int count) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        int j = 0;
        for (int i = 0; i < count; i += 64) {
            if (count - 64 * j < 64) {
                list.add(count - 64 * j);
            } else {
                list.add(64);
            }
            ++j;
        }
        return list;
    }

    public void drawCenteredString(MatrixStack matrixStack, String txt, int posX, int posY, int color) {
        WyHelper.drawStringWithBorder(this.field_230712_o_, matrixStack, txt, posX - this.field_230712_o_.func_78256_a(txt) / 2, posY, color);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int partialTicks) {
        boolean flag = super.func_231044_a_(mouseX, mouseY, partialTicks);
        if (this.guiState == 0 && !this.trader.canBuyFromPlayers()) {
            if (this.startMessage.tickCount < this.startMessage.maxTicks) {
                this.startMessage.tickCount = this.startMessage.maxTicks;
            } else if (this.trader.canTrade(this.player)) {
                this.guiState = 1;
                this.func_231158_b_(this.getMinecraft(), this.field_230708_k_, this.field_230709_l_);
            } else {
                this.func_231175_as__();
            }
        } else if (this.guiState == 2) {
            SkypieanTraderEntity skypieanTrader = (SkypieanTraderEntity)this.trader;
            if (this.vearthAmountUp.func_231044_a_(mouseX, mouseY, partialTicks)) {
                int increaseAmount = 1;
                if (ModKeybindings.isShiftKeyDown()) {
                    increaseAmount = 10;
                }
                this.wantedAmount = this.wantedAmount + increaseAmount < skypieanTrader.getTradesLeft() ? (this.wantedAmount + increaseAmount <= this.dirtBlocksAvailable ? (this.wantedAmount += increaseAmount) : 0) : skypieanTrader.getTradesLeft();
            } else if (this.vearthAmountDown.func_231044_a_(mouseX, mouseY, partialTicks)) {
                int decreaseAmount = 1;
                if (ModKeybindings.isShiftKeyDown()) {
                    decreaseAmount = 10;
                }
                this.wantedAmount = this.wantedAmount - decreaseAmount >= 0 ? (this.wantedAmount -= decreaseAmount) : skypieanTrader.getTradesLeft();
            }
        }
        return flag;
    }

    public TradeEntry getSelectedStack() {
        return this.selectedStack;
    }

    public void setSelectedStack(TradeEntry selectedStack) {
        this.selectedStack = selectedStack;
    }

    public int getWantedAmount() {
        return this.wantedAmount;
    }

    public void setWantedAmount(int wantedAmount) {
        this.wantedAmount = wantedAmount;
    }

    public boolean func_231177_au__() {
        return false;
    }

    public static void open(TraderEntity entity) {
        Minecraft.func_71410_x().func_147108_a((Screen)new TraderScreen(entity));
    }
}

