/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.screens.extra;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.awt.Color;
import java.util.List;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.Style;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class SequencedString {
    private static final Pattern FORMATTING_PATTERN = Pattern.compile("(?i)\u00a7[0-9A-FK-OR]");
    public String string;
    public int maxLength;
    public int color = Color.WHITE.getRGB();
    public char[] chars;
    public int maxTicks;
    public int tickCount;
    public Minecraft mc;
    public int delayTicks = this.maxTicks;
    public boolean isComplete;

    public SequencedString(String str, int maxLength, int maxTicks) {
        this(str, maxLength, maxTicks, maxTicks + 100);
    }

    public SequencedString(String str, int maxLength, int maxTicks, int delay) {
        this.mc = Minecraft.func_71410_x();
        this.string = str;
        this.maxLength = maxLength;
        this.chars = new char[this.string.length()];
        for (int i = 0; i < this.string.length(); ++i) {
            this.chars[i] = this.string.charAt(i);
        }
        this.maxTicks = maxTicks;
        this.tickCount = 0;
        this.delayTicks = delay;
    }

    public void render(MatrixStack matrixStack, int posX, int posY, float partialTicks) {
        int i;
        String tempStr = "";
        if (!this.isComplete) {
            for (i = 0; i < this.chars.length; ++i) {
                if (this.tickCount < this.calculateTicksNeeded(i) || !((float)this.tickCount * partialTicks < (float)this.delayTicks)) continue;
                tempStr = tempStr + this.chars[i];
            }
            if (tempStr.equals(this.string)) {
                this.isComplete = true;
            }
        } else {
            tempStr = this.string;
        }
        i = 0;
        List list = Minecraft.func_71410_x().field_71466_p.func_238420_b_().func_238365_g_(tempStr, this.maxLength, Style.field_240709_b_);
        for (ITextProperties text : list) {
            WyHelper.drawStringWithBorder(this.mc.field_71466_p, matrixStack, text.getString(), posX, posY + 10 * i, this.color);
            ++i;
        }
        ++this.tickCount;
    }

    public int calculateTicksNeeded(int index) {
        int oldRange = this.string.length();
        int newRange = this.maxTicks;
        int newValue = index * newRange / oldRange;
        return newValue;
    }
}

