/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.screens.extra.buttons;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraftforge.common.util.TextTable;
import xyz.pixelatedw.mineminenomi.api.helpers.FactionHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.RendererHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class FactionButton
extends Button {
    private IEntityStats entityData;
    private boolean isSelected;
    private TextTable.Alignment textAlignment = TextTable.Alignment.LEFT;
    private int lineThickness = 1;
    private boolean hasIcons = true;
    private int blackColor = WyHelper.hexToRGB("#000000").getRGB();

    public FactionButton(int posX, int posY, int width, int height, ITextComponent string, Button.IPressable onPress) {
        this(posX, posY, width, height, string, onPress, Button.field_238486_s_);
    }

    public FactionButton(int posX, int posY, int width, int height, ITextComponent string, Button.IPressable onPress, Button.ITooltip onTooltip) {
        super(posX, posY, width, height, string, onPress, onTooltip);
        this.entityData = EntityStatsCapability.get((LivingEntity)Minecraft.func_71410_x().field_71439_g);
    }

    public void setTextAlignment(TextTable.Alignment alignment) {
        this.textAlignment = alignment;
    }

    public void setLineThickness(int thickness) {
        this.lineThickness = thickness;
    }

    public void disableIcons() {
        this.hasIcons = false;
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        matrixStack.func_227860_a_();
        if (this.field_230694_p_) {
            ResourceLocation factionIcon;
            this.field_230692_n_ = mouseX >= this.field_230690_l_ && mouseY >= this.field_230691_m_ && mouseX < this.field_230690_l_ + this.field_230688_j_ && mouseY < this.field_230691_m_ + this.field_230689_k_;
            int rgb = WyHelper.hexToRGB("#FFFFFF").getRGB();
            int lineColor = WyHelper.hexToRGB("#EAEAEA").getRGB();
            if (!this.field_230693_o_) {
                rgb = lineColor = WyHelper.hexToRGB("#6B6B6B").getRGB();
            }
            if (this.field_230692_n_) {
                this.func_230443_a_(matrixStack, mouseX, mouseY);
                if (this.field_230693_o_) {
                    int factionColor;
                    matrixStack.func_227861_a_(0.0, 0.5, 0.0);
                    rgb = lineColor = (factionColor = FactionHelper.getFactionRGBColor(this.entityData));
                }
            }
            FontRenderer font = Minecraft.func_71410_x().field_71466_p;
            int textPosX = this.textAlignment == TextTable.Alignment.CENTER ? this.field_230690_l_ - font.func_238414_a_((ITextProperties)this.func_230458_i_()) / 2 + this.field_230688_j_ / 2 : (this.textAlignment == TextTable.Alignment.RIGHT ? this.field_230690_l_ : this.field_230690_l_);
            this.func_238468_a_(matrixStack, this.field_230690_l_ - 4, this.field_230691_m_ + this.field_230689_k_ - this.lineThickness + 2, this.field_230688_j_ + this.field_230690_l_ + 1, this.field_230691_m_ + this.field_230689_k_, this.blackColor, this.blackColor);
            this.func_238468_a_(matrixStack, this.field_230690_l_ - 5, this.field_230691_m_ + this.field_230689_k_ - this.lineThickness, this.field_230688_j_ + this.field_230690_l_, this.field_230691_m_ + this.field_230689_k_, lineColor, lineColor);
            int textOffset = 0;
            if (this.hasIcons && (factionIcon = FactionHelper.getFactionIcon(this.entityData)) != null) {
                RendererHelper.drawIcon(factionIcon, matrixStack, this.field_230690_l_ - 12, this.field_230691_m_ - 4, 1.0f, 32.0f, 32.0f, this.blackColor);
                RendererHelper.drawIcon(factionIcon, matrixStack, this.field_230690_l_ - 13, this.field_230691_m_ - 5, 1.0f, 32.0f, 32.0f, lineColor);
                textOffset = 13;
            }
            WyHelper.drawStringWithBorder(font, matrixStack, this.func_230458_i_().getString(), textPosX + textOffset, this.field_230691_m_ + this.field_230689_k_ / 2 - 4, rgb);
        }
        matrixStack.func_227865_b_();
    }
}

