/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.setup;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.FlatChunkGenerator;
import net.minecraft.world.gen.feature.StructureFeature;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.server.FMLServerStartedEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import xyz.pixelatedw.mineminenomi.api.crew.Crew;
import xyz.pixelatedw.mineminenomi.api.events.ability.ModifyDevilFruitEvent;
import xyz.pixelatedw.mineminenomi.commands.AbilityCommand;
import xyz.pixelatedw.mineminenomi.commands.AbilityProtectionCommand;
import xyz.pixelatedw.mineminenomi.commands.BellyCommand;
import xyz.pixelatedw.mineminenomi.commands.BountyCommand;
import xyz.pixelatedw.mineminenomi.commands.ChallengeCommand;
import xyz.pixelatedw.mineminenomi.commands.ChangeCharacterCommand;
import xyz.pixelatedw.mineminenomi.commands.CheckFruitsCommand;
import xyz.pixelatedw.mineminenomi.commands.CheckPlayerCommand;
import xyz.pixelatedw.mineminenomi.commands.CrewCommand;
import xyz.pixelatedw.mineminenomi.commands.DamageMultiplierCommand;
import xyz.pixelatedw.mineminenomi.commands.DorikiCommand;
import xyz.pixelatedw.mineminenomi.commands.EventsCommand;
import xyz.pixelatedw.mineminenomi.commands.ExtolCommand;
import xyz.pixelatedw.mineminenomi.commands.FGCommand;
import xyz.pixelatedw.mineminenomi.commands.GetWantedPosterCommand;
import xyz.pixelatedw.mineminenomi.commands.GoRogueCommand;
import xyz.pixelatedw.mineminenomi.commands.HakiExpCommand;
import xyz.pixelatedw.mineminenomi.commands.IssueBountyCommand;
import xyz.pixelatedw.mineminenomi.commands.LoyaltyCommand;
import xyz.pixelatedw.mineminenomi.commands.PouchCommand;
import xyz.pixelatedw.mineminenomi.commands.QuestCommand;
import xyz.pixelatedw.mineminenomi.commands.RemoveDFCommand;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.config.SystemConfig;
import xyz.pixelatedw.mineminenomi.data.world.ExtendedWorldData;
import xyz.pixelatedw.mineminenomi.data.world.NPCWorldData;
import xyz.pixelatedw.mineminenomi.init.ModEntities;
import xyz.pixelatedw.mineminenomi.init.ModFeatures;
import xyz.pixelatedw.mineminenomi.init.ModStructures;
import xyz.pixelatedw.mineminenomi.init.ModTags;
import xyz.pixelatedw.mineminenomi.init.ModValues;
import xyz.pixelatedw.mineminenomi.items.AkumaNoMiItem;
import xyz.pixelatedw.mineminenomi.world.features.structures.OPStructure;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.WyPatreon;

@Mod.EventBusSubscriber(modid="mineminenomi", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ForgeSetup {
    @SubscribeEvent
    public static void addReloadListeners(AddReloadListenerEvent event) {
        event.addListener(ModTags.Items.CONDUCTIVE);
        event.addListener(ModTags.Items.IRON);
        event.addListener(ModTags.Entities.CONDUCTIVE);
    }

    @SubscribeEvent
    public static void serverStarted(FMLServerStartedEvent event) {
        NPCWorldData.get().setup(event.getServer().func_71218_a(World.field_234918_g_));
    }

    @SubscribeEvent
    public static void registerCommands(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        LiteralArgumentBuilder masterBuilder = null;
        boolean masterCommandFlag = (Boolean)SystemConfig.MASTER_COMMAND.get();
        if (masterCommandFlag) {
            masterBuilder = Commands.func_197057_a((String)"mmnm");
        }
        AbilityProtectionCommand.register((CommandDispatcher<CommandSource>)dispatcher, (LiteralArgumentBuilder<CommandSource>)masterBuilder);
        DorikiCommand.register((CommandDispatcher<CommandSource>)dispatcher, (LiteralArgumentBuilder<CommandSource>)masterBuilder);
        BountyCommand.register((CommandDispatcher<CommandSource>)dispatcher, (LiteralArgumentBuilder<CommandSource>)masterBuilder);
        BellyCommand.register((CommandDispatcher<CommandSource>)dispatcher, (LiteralArgumentBuilder<CommandSource>)masterBuilder);
        ExtolCommand.register((CommandDispatcher<CommandSource>)dispatcher, (LiteralArgumentBuilder<CommandSource>)masterBuilder);
        IssueBountyCommand.register((CommandDispatcher<CommandSource>)dispatcher, (LiteralArgumentBuilder<CommandSource>)masterBuilder);
        GetWantedPosterCommand.register((CommandDispatcher<CommandSource>)dispatcher, (LiteralArgumentBuilder<CommandSource>)masterBuilder);
        RemoveDFCommand.register((CommandDispatcher<CommandSource>)dispatcher, (LiteralArgumentBuilder<CommandSource>)masterBuilder);
        AbilityCommand.register((CommandDispatcher<CommandSource>)dispatcher, (LiteralArgumentBuilder<CommandSource>)masterBuilder);
        QuestCommand.register((CommandDispatcher<CommandSource>)dispatcher, (LiteralArgumentBuilder<CommandSource>)masterBuilder);
        HakiExpCommand.register((CommandDispatcher<CommandSource>)dispatcher, (LiteralArgumentBuilder<CommandSource>)masterBuilder);
        PouchCommand.register((CommandDispatcher<CommandSource>)dispatcher, (LiteralArgumentBuilder<CommandSource>)masterBuilder);
        CheckFruitsCommand.register((CommandDispatcher<CommandSource>)dispatcher, (LiteralArgumentBuilder<CommandSource>)masterBuilder);
        CheckPlayerCommand.register((CommandDispatcher<CommandSource>)dispatcher, (LiteralArgumentBuilder<CommandSource>)masterBuilder);
        DamageMultiplierCommand.register((CommandDispatcher<CommandSource>)dispatcher, (LiteralArgumentBuilder<CommandSource>)masterBuilder);
        LoyaltyCommand.register((CommandDispatcher<CommandSource>)dispatcher, (LiteralArgumentBuilder<CommandSource>)masterBuilder);
        GoRogueCommand.register((CommandDispatcher<CommandSource>)dispatcher, (LiteralArgumentBuilder<CommandSource>)masterBuilder);
        ChallengeCommand.register((CommandDispatcher<CommandSource>)dispatcher, (LiteralArgumentBuilder<CommandSource>)masterBuilder);
        CrewCommand.register((CommandDispatcher<CommandSource>)dispatcher, (LiteralArgumentBuilder<CommandSource>)masterBuilder);
        ChangeCharacterCommand.register((CommandDispatcher<CommandSource>)dispatcher, (LiteralArgumentBuilder<CommandSource>)masterBuilder);
        EventsCommand.register((CommandDispatcher<CommandSource>)dispatcher, (LiteralArgumentBuilder<CommandSource>)masterBuilder);
        if (WyPatreon.BUILD_MODE != WyPatreon.BuildMode.RELEASE) {
            FGCommand.register((CommandDispatcher<CommandSource>)dispatcher, (LiteralArgumentBuilder<CommandSource>)masterBuilder);
        }
        if (masterCommandFlag) {
            dispatcher.register(masterBuilder);
        }
    }

    @SubscribeEvent
    public static void serverStarting(FMLServerStartingEvent event) {
        for (Crew crew : ExtendedWorldData.get().getCrews()) {
            if (crew.getCreationDate() != 0L) continue;
            crew.setCreationDate(Instant.now().getEpochSecond());
            ExtendedWorldData.get().func_76185_a();
        }
        for (AkumaNoMiItem fruit : ModValues.DEVIL_FRUITS) {
            ModifyDevilFruitEvent fruitEvent = new ModifyDevilFruitEvent(fruit, fruit.getAbilities());
            MinecraftForge.EVENT_BUS.post((Event)fruitEvent);
            fruit.setAbilities(fruitEvent.getAbilities());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void biomeModification(BiomeLoadingEvent event) {
        if (event.getName() == null || event.getCategory() == Biome.Category.NETHER || event.getCategory() == Biome.Category.THEEND || event.getName().equals((Object)Biomes.field_185440_P.func_240901_a_())) {
            return;
        }
        for (Map.Entry<Structure<?>, StructureFeature<?, ?>> entry : ModStructures.REGISTERED_STRUCTURES.entrySet()) {
            if (entry.getKey() instanceof OPStructure && !((OPStructure)entry.getKey()).biomeCheck(event)) continue;
            event.getGeneration().getStructures().add(() -> (StructureFeature)entry.getValue());
        }
        ModFeatures.setupFeatures(event);
        ModEntities.setupCategorySpawns(event);
    }

    @SubscribeEvent
    public static void addDimensionalSpacing(WorldEvent.Load event) {
        if (event.getWorld() instanceof ServerWorld) {
            ServerWorld serverWorld = (ServerWorld)event.getWorld();
            ResourceLocation dimensionId = serverWorld.func_234923_W_().getRegistryName();
            if (WyHelper.isInChallengeDimension((RegistryKey<World>)serverWorld.func_234923_W_())) {
                return;
            }
            for (ResourceLocation dim : CommonConfig.INSTANCE.getBannedDimensionsForStructures()) {
                if (!dimensionId.equals((Object)dim)) continue;
                return;
            }
            if (serverWorld.func_72863_F().func_201711_g() instanceof FlatChunkGenerator) {
                return;
            }
            HashMap tempMap = new HashMap(serverWorld.func_72863_F().func_201711_g().func_235957_b_().field_236193_d_);
            for (Map.Entry<Structure<?>, StructureFeature<?, ?>> entry : ModStructures.REGISTERED_STRUCTURES.entrySet()) {
                tempMap.put(entry.getKey(), DimensionStructuresSettings.field_236191_b_.get(entry.getKey()));
            }
            serverWorld.func_72863_F().func_201711_g().func_235957_b_().field_236193_d_ = tempMap;
        }
    }
}

