/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.setup;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.mojang.datafixers.util.Pair;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.PlayerRenderer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.command.arguments.ArgumentSerializer;
import net.minecraft.command.arguments.ArgumentTypes;
import net.minecraft.command.arguments.IArgumentSerializer;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.AxeItem;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.jigsaw.JigsawPatternRegistry;
import net.minecraft.world.gen.feature.jigsaw.JigsawPiece;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import xyz.pixelatedw.mineminenomi.ModMain;
import xyz.pixelatedw.mineminenomi.api.ModRegistries;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.commands.AbilityArgument;
import xyz.pixelatedw.mineminenomi.api.commands.AbilityGroupArgument;
import xyz.pixelatedw.mineminenomi.api.commands.ChallengeArgument;
import xyz.pixelatedw.mineminenomi.api.commands.CrewArgument;
import xyz.pixelatedw.mineminenomi.api.commands.CurrencyTypeArgument;
import xyz.pixelatedw.mineminenomi.api.commands.FactionArgument;
import xyz.pixelatedw.mineminenomi.api.commands.FightingStyleArgument;
import xyz.pixelatedw.mineminenomi.api.commands.HakiTypeArgument;
import xyz.pixelatedw.mineminenomi.api.commands.QuestArgument;
import xyz.pixelatedw.mineminenomi.api.commands.RaceArgument;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.containers.WhiteWalkieStorageContainer;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModBlocks;
import xyz.pixelatedw.mineminenomi.init.ModCapabilities;
import xyz.pixelatedw.mineminenomi.init.ModContainers;
import xyz.pixelatedw.mineminenomi.init.ModDimensions;
import xyz.pixelatedw.mineminenomi.init.ModDispenseBehaviors;
import xyz.pixelatedw.mineminenomi.init.ModEntities;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.init.ModI18nConfig;
import xyz.pixelatedw.mineminenomi.init.ModItemModelProps;
import xyz.pixelatedw.mineminenomi.init.ModKeybindings;
import xyz.pixelatedw.mineminenomi.init.ModNetwork;
import xyz.pixelatedw.mineminenomi.init.ModRenderTypeBuffers;
import xyz.pixelatedw.mineminenomi.init.ModRenderers;
import xyz.pixelatedw.mineminenomi.init.ModStructures;
import xyz.pixelatedw.mineminenomi.init.ModValues;
import xyz.pixelatedw.mineminenomi.integrations.curios.CuriosIntegration;
import xyz.pixelatedw.mineminenomi.mixins.RangedAttributeMixin;
import xyz.pixelatedw.mineminenomi.renderers.abilities.EleclawRenderer;
import xyz.pixelatedw.mineminenomi.renderers.layers.AuraLayer;
import xyz.pixelatedw.mineminenomi.renderers.layers.BindLayer;
import xyz.pixelatedw.mineminenomi.renderers.layers.BodyCoatingLayer;
import xyz.pixelatedw.mineminenomi.renderers.layers.HandcuffsLayer;
import xyz.pixelatedw.mineminenomi.renderers.layers.MinkFeaturesLayer;
import xyz.pixelatedw.mineminenomi.renderers.layers.PotionLayer;
import xyz.pixelatedw.mineminenomi.renderers.layers.abilities.GomuDawnWhipLayer;
import xyz.pixelatedw.mineminenomi.renderers.layers.abilities.GomuSmokeLayer;
import xyz.pixelatedw.mineminenomi.renderers.layers.abilities.HanaCalendulaLayer;
import xyz.pixelatedw.mineminenomi.renderers.layers.abilities.HanaHandsLayer;
import xyz.pixelatedw.mineminenomi.renderers.layers.abilities.HanaWingsLayer;
import xyz.pixelatedw.mineminenomi.renderers.layers.armor.CaptainCapeOverlayLayer;
import xyz.pixelatedw.mineminenomi.renderers.layers.armor.LowerHalfArmorLayer;
import xyz.pixelatedw.mineminenomi.renderers.layers.armor.UpperHalfArmorLayer;
import xyz.pixelatedw.mineminenomi.screens.WhiteWalkieStorageScreen;
import xyz.pixelatedw.mineminenomi.wypi.WyDebug;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

@Mod.EventBusSubscriber(modid="mineminenomi", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModSetup {
    @SubscribeEvent
    public static void enqueueIMC(InterModEnqueueEvent event) {
        if (ModMain.hasCuriosInstalled()) {
            CuriosIntegration.setup(event);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onStitch(TextureStitchEvent.Pre event) {
        if (ModMain.hasCuriosInstalled()) {
            CuriosIntegration.setupIcons(event);
        }
    }

    @SubscribeEvent
    public static void commonSetup(FMLCommonSetupEvent event) {
        ModCapabilities.init();
        ModDispenseBehaviors.init();
        ModNetwork.init();
        ModStructures.setupStructures();
        event.enqueueWork(ModDimensions::setupDimensions);
        ImmutableMultimap.Builder mapBuilder = ImmutableMultimap.builder();
        for (AbilityCore core : ModRegistries.ABILITIES.getValues()) {
            mapBuilder.put((Object)core.getCategory(), (Object)core);
        }
        ModValues.abilityCategoryMap = mapBuilder.build();
        ArgumentTypes.func_218136_a((String)"ability", AbilityArgument.class, (IArgumentSerializer)new ArgumentSerializer(AbilityArgument::ability));
        ArgumentTypes.func_218136_a((String)"quest", QuestArgument.class, (IArgumentSerializer)new ArgumentSerializer(QuestArgument::quest));
        ArgumentTypes.func_218136_a((String)"type", HakiTypeArgument.class, (IArgumentSerializer)new ArgumentSerializer(HakiTypeArgument::hakiType));
        ArgumentTypes.func_218136_a((String)"group", AbilityGroupArgument.class, (IArgumentSerializer)new ArgumentSerializer(AbilityGroupArgument::abilityGroup));
        ArgumentTypes.func_218136_a((String)"crew", CrewArgument.class, (IArgumentSerializer)new ArgumentSerializer(CrewArgument::crew));
        ArgumentTypes.func_218136_a((String)"challenge", ChallengeArgument.class, (IArgumentSerializer)new ArgumentSerializer(ChallengeArgument::challenge));
        ArgumentTypes.func_218136_a((String)"currency", CurrencyTypeArgument.class, (IArgumentSerializer)new ArgumentSerializer(CurrencyTypeArgument::currencyType));
        ArgumentTypes.func_218136_a((String)"faction", FactionArgument.class, (IArgumentSerializer)new ArgumentSerializer(FactionArgument::faction));
        ArgumentTypes.func_218136_a((String)"style", FightingStyleArgument.class, (IArgumentSerializer)new ArgumentSerializer(FightingStyleArgument::fightingStyle));
        ArgumentTypes.func_218136_a((String)"race", RaceArgument.class, (IArgumentSerializer)new ArgumentSerializer(RaceArgument::race));
        ModEntities.setupSpawnRules();
        ModSetup.addStructureAsHouse(new ResourceLocation("mineminenomi", "unaligned/blackleg_kitchen"), CommonConfig.INSTANCE.hasVillageCompat() ? 1 : 10);
        ModSetup.addStructureAsHouse(new ResourceLocation("mineminenomi", "unaligned/medic_tent"), CommonConfig.INSTANCE.hasVillageCompat() ? 1 : 5);
        ModSetup.addStructureAsHouse(new ResourceLocation("mineminenomi", "unaligned/tavern"), CommonConfig.INSTANCE.hasVillageCompat() ? 1 : 255);
        if (ModMain.hasCuriosInstalled()) {
            CuriosIntegration.registerCurioItems();
        }
    }

    private static void addStructureAsHouse(ResourceLocation structure, int weight) {
        ModSetup.addPieceToPattern(new ResourceLocation("village/plains/houses"), structure, weight);
        ModSetup.addPieceToPattern(new ResourceLocation("village/desert/houses"), structure, weight);
        ModSetup.addPieceToPattern(new ResourceLocation("village/savanna/houses"), structure, weight);
        ModSetup.addPieceToPattern(new ResourceLocation("village/snowy/houses"), structure, weight);
        ModSetup.addPieceToPattern(new ResourceLocation("village/taiga/houses"), structure, weight);
    }

    private static void addPieceToPattern(ResourceLocation id, ResourceLocation structure, int weight) {
        RegistryKey key = RegistryKey.func_240903_a_((RegistryKey)Registry.field_243555_ax, (ResourceLocation)id);
        JigsawPattern pattern = (JigsawPattern)WorldGenRegistries.field_243656_h.func_230516_a_(key);
        pattern.field_214952_d.add(Pair.of(JigsawPiece.func_242849_a((String)structure.toString()).apply(JigsawPattern.PlacementBehaviour.RIGID), (Object)weight));
        JigsawPatternRegistry.func_244094_a((JigsawPattern)pattern);
    }

    @SubscribeEvent
    public static void onLoadComplete(FMLLoadCompleteEvent event) {
        ((RangedAttributeMixin)Attributes.field_233818_a_).setMaxValue(3000.0);
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void clientSetup(FMLClientSetupEvent event) {
        ModKeybindings.init();
        ModI18n.init();
        ModI18nConfig.init();
        ModRenderers.registerRenderers();
        ModItemModelProps.register();
        ModRenderTypeBuffers.init();
        if (WyDebug.isDebug()) {
            WyHelper.generateJSONLangs();
        }
        event.enqueueWork(() -> {
            AxeItem.field_203176_a = new ImmutableMap.Builder().putAll(AxeItem.field_203176_a).put((Object)ModBlocks.MANGROVE_LOG.get(), (Object)ModBlocks.STRIPPED_MANGROVE_LOG.get()).put((Object)ModBlocks.MANGROVE_WOOD.get(), (Object)ModBlocks.STRIPPED_MANGROVE_WOOD.get()).build();
            ScreenManager.func_216911_a((ContainerType)((ContainerType)ModContainers.WHITE_WALKIE_STORAGE.get()), (container, inv, title) -> new WhiteWalkieStorageScreen((WhiteWalkieStorageContainer)container, inv));
            Minecraft mc = Minecraft.func_71410_x();
            for (Map.Entry entry : mc.func_175598_ae().field_78729_o.entrySet()) {
                EntityRenderer entityRenderer = (EntityRenderer)entry.getValue();
                if (!(entityRenderer instanceof LivingRenderer)) continue;
                LivingRenderer renderer = (LivingRenderer)entityRenderer;
                renderer.func_177094_a(new PotionLayer((IEntityRenderer)renderer));
                renderer.func_177094_a(new CaptainCapeOverlayLayer(renderer));
                renderer.func_177094_a(new AuraLayer(renderer));
                renderer.func_177094_a(new HandcuffsLayer((IEntityRenderer)renderer));
                renderer.func_177094_a(new BindLayer((IEntityRenderer)renderer));
                renderer.func_177094_a(new HanaWingsLayer((IEntityRenderer)renderer));
                renderer.func_177094_a(new HanaCalendulaLayer((IEntityRenderer)renderer));
                renderer.func_177094_a(new HanaHandsLayer((IEntityRenderer)renderer));
                renderer.func_177094_a(new EleclawRenderer((IEntityRenderer)renderer));
                if (!(renderer.func_217764_d() instanceof BipedModel)) continue;
                renderer.func_177094_a(new MinkFeaturesLayer((IEntityRenderer)renderer));
                renderer.func_177094_a(new UpperHalfArmorLayer(renderer));
                renderer.func_177094_a(new LowerHalfArmorLayer(renderer));
                renderer.func_177094_a(new GomuSmokeLayer((IEntityRenderer)renderer));
                renderer.func_177094_a(new GomuDawnWhipLayer((IEntityRenderer)renderer));
            }
            for (Map.Entry entry : mc.func_175598_ae().getSkinMap().entrySet()) {
                PlayerRenderer renderer = (PlayerRenderer)entry.getValue();
                renderer.func_177094_a(new PotionLayer((IEntityRenderer)renderer));
                renderer.func_177094_a(new CaptainCapeOverlayLayer(renderer));
                renderer.func_177094_a(new BodyCoatingLayer((IEntityRenderer)renderer));
                renderer.func_177094_a(new AuraLayer(renderer));
                renderer.func_177094_a(new HandcuffsLayer((IEntityRenderer)renderer));
                renderer.func_177094_a(new BindLayer((IEntityRenderer)renderer));
                renderer.func_177094_a(new HanaWingsLayer((IEntityRenderer)renderer));
                renderer.func_177094_a(new HanaCalendulaLayer((IEntityRenderer)renderer));
                renderer.func_177094_a(new HanaHandsLayer((IEntityRenderer)renderer));
                renderer.func_177094_a(new EleclawRenderer((IEntityRenderer)renderer));
                renderer.func_177094_a(new MinkFeaturesLayer((IEntityRenderer)renderer));
                renderer.func_177094_a(new UpperHalfArmorLayer(renderer));
                renderer.func_177094_a(new LowerHalfArmorLayer(renderer));
                renderer.func_177094_a(new GomuSmokeLayer((IEntityRenderer)renderer));
                renderer.func_177094_a(new GomuDawnWhipLayer((IEntityRenderer)renderer));
            }
            ModAnimations.clientInit();
            if (ModMain.hasCuriosInstalled()) {
                CuriosIntegration.registerCurioRenderers();
            }
        });
    }
}

