/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.world.spawners;

import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.entities.mobs.OPEntity;
import xyz.pixelatedw.mineminenomi.init.ModEntities;
import xyz.pixelatedw.mineminenomi.wypi.WyDebug;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class AmbushSpawner {
    private Random random = new Random();
    private int cooldown;

    public void tick(ServerWorld world) {
        world.func_217381_Z().func_76320_a("ambushSpawnerTick");
        if (--this.cooldown <= 0) {
            this.cooldown = CommonConfig.INSTANCE.getTimeBetweenAmbushSpawns();
            if (this.random.nextInt(100) <= CommonConfig.INSTANCE.getChanceForAmbushSpawn()) {
                this.spawn(world);
            }
        }
        world.func_217381_Z().func_76319_b();
    }

    public void spawn(ServerWorld world) {
        world.func_217381_Z().func_76320_a("ambushSpawnerSpawn");
        ServerPlayerEntity player = world.func_217472_l_();
        if (player == null) {
            return;
        }
        IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
        if (props.isPirate() || props.isBandit() || props.isRevolutionary()) {
            BlockPos spawnPos;
            int i;
            List dangers;
            BlockPos targetPos = player.func_233580_cy_();
            long bounty = props.getBounty();
            boolean canSpawnInBiome = world.func_226691_t_(targetPos).func_201856_r() != Biome.Category.OCEAN;
            boolean canSeeSky = player.field_70170_p.func_226660_f_(targetPos);
            if (!canSpawnInBiome || bounty < 10000L || !canSeeSky) {
                return;
            }
            EntityType captainEntity = (EntityType)ModEntities.MARINE_CAPTAIN.get();
            EntityType gruntEntity = (EntityType)ModEntities.MARINE_GRUNT.get();
            int r = this.random.nextInt(2);
            int r2 = this.random.nextInt(2);
            if (r == 1) {
                // empty if block
            }
            if ((dangers = WyHelper.getNearbyEntities(player.func_213303_ch(), (IWorld)world, 80.0, null, OPEntity.class)).size() > 50) {
                return;
            }
            int nrCaptains = 0 + (int)Math.ceil(bounty / 200000L);
            int nrGrunts = 3 + (int)Math.ceil(bounty / 100000L);
            String name = captainEntity.func_212546_e().getString();
            if (nrCaptains > 3) {
                nrCaptains = 3;
            }
            if (nrGrunts > 30) {
                nrGrunts = 30;
            }
            if (nrCaptains > 0) {
                for (i = 0; i < nrCaptains; ++i) {
                    spawnPos = WyHelper.findOnGroundSpawnLocation((World)world, captainEntity, targetPos, 10);
                    if (spawnPos == null) continue;
                    captainEntity.func_220342_a(world, (CompoundNBT)null, (ITextComponent)null, (PlayerEntity)null, spawnPos, SpawnReason.EVENT, false, false);
                }
            } else {
                name = "Officer";
            }
            for (i = 0; i < nrGrunts; ++i) {
                Entity e;
                spawnPos = WyHelper.findOnGroundSpawnLocation((World)world, gruntEntity, targetPos, 20);
                if (spawnPos == null || (e = gruntEntity.func_220342_a(world, (CompoundNBT)null, (ITextComponent)null, (PlayerEntity)null, spawnPos, SpawnReason.EVENT, false, false)) == null || !(e instanceof OPEntity)) continue;
                ((OPEntity)e).setFear(false);
            }
            StringTextComponent message = new StringTextComponent("<" + name + "> We've come to arrest you, surrender now criminal scum!");
            if (r2 == 1) {
                message = new StringTextComponent("<" + name + "> You're surrounded and have no escape, surrender now!");
            }
            player.field_70170_p.func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_219603_Y, SoundCategory.HOSTILE, 1.0f, 1.0f);
            player.func_145747_a((ITextComponent)message, Util.field_240973_b_);
            WyDebug.debug("Ambush spawned around these coords: " + targetPos);
        }
        world.func_217381_Z().func_76319_b();
    }
}

