/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.wypi;

import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.AirBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SPlayEntityEffectPacket;
import net.minecraft.network.play.server.SRemoveEntityEffectPacket;
import net.minecraft.network.play.server.SSpawnParticlePacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.Mirror;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ResourceLocationException;
import net.minecraft.util.Rotation;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.template.BlockIgnoreStructureProcessor;
import net.minecraft.world.gen.feature.template.IntegrityProcessor;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.server.ChunkHolder;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.spawner.WorldEntitySpawner;
import net.minecraftforge.common.extensions.IForgeWorld;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.versions.mcp.MCPVersion;
import xyz.pixelatedw.mineminenomi.ModMain;
import xyz.pixelatedw.mineminenomi.api.challenges.InProgressChallenge;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.world.ChallengesWorldData;
import xyz.pixelatedw.mineminenomi.entities.SphereEntity;
import xyz.pixelatedw.mineminenomi.entities.projectiles.goro.LightningEntity;
import xyz.pixelatedw.mineminenomi.init.ModEntityPredicates;
import xyz.pixelatedw.mineminenomi.init.ModValues;
import xyz.pixelatedw.mineminenomi.mixins.ITemplateMixin;
import xyz.pixelatedw.mineminenomi.packets.server.SSpawnParticleEffectPacket;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;
import xyz.pixelatedw.mineminenomi.wypi.WyPatreon;
import xyz.pixelatedw.mineminenomi.wypi.WyRegistry;

public class WyHelper {
    private static final Random RANDOM = new Random();
    private static final Collector<?, ?, ?> SHUFFLER = Collectors.collectingAndThen(Collectors.toCollection(ArrayList::new), list -> {
        Collections.shuffle(list);
        return list;
    });

    public static String formatBytes(long bytes) {
        int unit = 1024;
        if (bytes < (long)unit) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        String pre = "KMGTPE".charAt(exp - 1) + "";
        return String.format("%.1f %sB", (double)bytes / Math.pow(unit, exp), pre);
    }

    public static String capitalize(String text) {
        return Character.toUpperCase(text.charAt(0)) + text.substring(1).toLowerCase();
    }

    public static String getResourceName(String text) {
        return text.replaceAll("[ \\t]+$", "").replaceAll("\\(", "").replaceAll("\\)", "").replaceAll("\\s+", "_").replaceAll("[\\'\\:\\-\\,\\#]", "").replaceAll("\\&", "and").toLowerCase();
    }

    public static String escapeJSON(String raw) {
        String escaped = raw;
        escaped = escaped.replace("\\", "\\\\");
        escaped = escaped.replace("\"", "\\\"");
        escaped = escaped.replace("\b", "\\b");
        escaped = escaped.replace("\f", "\\f");
        escaped = escaped.replace("\n", "\\n");
        escaped = escaped.replace("\r", "\\r");
        escaped = escaped.replace("\t", "\\t");
        return escaped;
    }

    public static String formatTimeMMSS(long time) {
        return String.format("%02d:%02d", time / 60L, time % 60L);
    }

    public static Color hslToColor(float h, float s, float l) {
        if (s < 0.0f || s > 100.0f) {
            String message = "Color parameter outside of expected range - Saturation";
            throw new IllegalArgumentException(message);
        }
        if (l < 0.0f || l > 100.0f) {
            String message = "Color parameter outside of expected range - Luminance";
            throw new IllegalArgumentException(message);
        }
        h %= 360.0f;
        float q = 0.0f;
        q = (double)l < 0.5 ? l * (1.0f + s) : (l /= 100.0f) + (s /= 100.0f) - s * l;
        float p = 2.0f * l - q;
        float r = Math.max(0.0f, WyHelper.hueToRGB(p, q, (h /= 360.0f) + 0.33333334f));
        float g = Math.max(0.0f, WyHelper.hueToRGB(p, q, h));
        float b = Math.max(0.0f, WyHelper.hueToRGB(p, q, h - 0.33333334f));
        r = Math.min(r, 1.0f);
        g = Math.min(g, 1.0f);
        b = Math.min(b, 1.0f);
        return new Color(r, g, b);
    }

    private static float hueToRGB(float p, float q, float h) {
        if (h < 0.0f) {
            h += 1.0f;
        }
        if (h > 1.0f) {
            h -= 1.0f;
        }
        if (6.0f * h < 1.0f) {
            return p + (q - p) * 6.0f * h;
        }
        if (2.0f * h < 1.0f) {
            return q;
        }
        if (3.0f * h < 2.0f) {
            return p + (q - p) * 6.0f * (0.6666667f - h);
        }
        return p;
    }

    public static Color intToRGB(int rgb, int alpha) {
        int val = 0xFF000000 | rgb;
        int r = val >> 16 & 0xFF;
        int g = val >> 8 & 0xFF;
        int b = val >> 0 & 0xFF;
        return new Color(r, g, b, alpha);
    }

    public static String rgbToHex(int red, int green, int blue) {
        return String.format("#%02X%02X%02X", red, green, blue);
    }

    public static Color hexToRGB(String hexColor) {
        if (Strings.isNullOrEmpty((String)hexColor)) {
            return Color.WHITE;
        }
        if (hexColor.startsWith("#")) {
            hexColor = hexColor.substring(1);
        }
        if (hexColor.length() == 8) {
            int r = Integer.parseInt(hexColor.substring(0, 2), 16);
            int g = Integer.parseInt(hexColor.substring(2, 4), 16);
            int b = Integer.parseInt(hexColor.substring(4, 6), 16);
            int a = Integer.parseInt(hexColor.substring(6, 8), 16);
            return new Color(r, g, b, a);
        }
        return Color.decode("#" + hexColor);
    }

    public static Color getComplementaryColor(Color color) {
        return new Color(255 - color.getRed(), 255 - color.getGreen(), 255 - color.getBlue());
    }

    public static float colorTolerance(float tolerance) {
        return WyHelper.colorTolerance(tolerance, false);
    }

    public static float colorTolerance(float tolerance, boolean hasDisturbance) {
        float color = RANDOM.nextFloat();
        if (color <= tolerance || !hasDisturbance && (double)color >= (double)tolerance + 0.3) {
            return tolerance;
        }
        return color;
    }

    public static boolean isInCombat(LivingEntity entity) {
        LivingEntity lastAttacker = entity.func_70643_av();
        LivingEntity lastAttackerCache = EntityStatsCapability.get(entity).getLastAttacker();
        if (lastAttacker == null && lastAttackerCache != null) {
            lastAttacker = lastAttackerCache;
        }
        if (lastAttacker != null && lastAttacker.func_70089_S() && Math.abs(lastAttacker.func_70068_e((Entity)entity)) <= 10000.0) {
            return true;
        }
        IEntityStats props = EntityStatsCapability.get(entity);
        return props.isInCombatCache();
    }

    public static boolean isInChallengeDimension(World world) {
        return WyHelper.isInChallengeDimension((RegistryKey<World>)world.func_234923_W_());
    }

    public static boolean isInChallengeDimension(RegistryKey<World> world) {
        return WyHelper.isInChallengeDimension(world.func_240901_a_().toString());
    }

    public static boolean isInChallengeDimension(String dimensionId) {
        return dimensionId.contains("challenges_");
    }

    public static void sendApplyEffectToAllNearby(LivingEntity player, Vector3d pos, int distance, EffectInstance effect) {
        player.func_184102_h().func_184103_al().func_148543_a(null, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, (double)distance, player.func_130014_f_().func_234923_W_(), (IPacket)new SPlayEntityEffectPacket(player.func_145782_y(), effect));
    }

    public static void sendRemoveEffectToAllNearby(LivingEntity player, Vector3d pos, int distance, Effect effect) {
        player.func_184102_h().func_184103_al().func_148543_a(null, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, (double)distance, player.func_130014_f_().func_234923_W_(), (IPacket)new SRemoveEntityEffectPacket(player.func_145782_y(), effect));
    }

    public static void spawnParticles(IParticleData data, ServerWorld world, double posX, double posY, double posZ) {
        WyHelper.spawnParticles(data, world, posX, posY, posZ, 0.0f, 0.0f, 0.0f);
    }

    public static void spawnParticles(IParticleData data, ServerWorld world, double posX, double posY, double posZ, float offsetX, float offsetY, float offsetZ) {
        WyHelper.spawnParticles(data, world, posX, posY, posZ, offsetX, offsetY, offsetZ, 1);
    }

    public static void spawnParticles(IParticleData data, ServerWorld world, double posX, double posY, double posZ, float offsetX, float offsetY, float offsetZ, int amount) {
        if (world.field_72995_K) {
            return;
        }
        SSpawnParticlePacket ipacket = new SSpawnParticlePacket(data, true, (double)((float)posX), (double)((float)posY), (double)((float)posZ), offsetX, offsetY, offsetZ, 0.0f, amount);
        for (int j = 0; j < world.func_217369_A().size(); ++j) {
            ServerPlayerEntity player = (ServerPlayerEntity)world.func_217369_A().get(j);
            BlockPos blockpos = new BlockPos(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_());
            if (!blockpos.func_218137_a((IPosition)new Vector3d(posX, posY, posZ), 512.0)) continue;
            player.field_71135_a.func_147359_a((IPacket)ipacket);
        }
    }

    public static void spawnParticleEffect(ParticleEffect effect, Entity spawner, double posX, double posY, double posZ) {
        WyHelper.spawnParticleEffect(effect, spawner, posX, posY, posZ, null);
    }

    public static void spawnParticleEffect(ParticleEffect effect, Entity spawner, double posX, double posY, double posZ, @Nullable ParticleEffect.Details details) {
        if (spawner == null) {
            return;
        }
        if (spawner.field_70170_p.field_72995_K) {
            return;
        }
        WyNetwork.sendToAllAroundDistance(new SSpawnParticleEffectPacket(effect, spawner, posX, posY, posZ, details), spawner.field_70170_p, spawner.func_213303_ch(), 256);
    }

    public static void spawnParticleEffectForOwner(ParticleEffect effect, PlayerEntity spawner, double posX, double posY, double posZ, @Nullable ParticleEffect.Details details) {
        if (spawner == null || spawner.field_70170_p.field_72995_K) {
            return;
        }
        WyNetwork.sendTo(new SSpawnParticleEffectPacket(effect, (Entity)spawner, posX, posY, posZ, details), spawner);
    }

    @Deprecated
    public static Vector3d propulsion(LivingEntity entity, double extraVelX, double extraVelZ) {
        return WyHelper.propulsion(entity, extraVelX, 0.0, extraVelZ);
    }

    @Deprecated
    public static Vector3d propulsion(LivingEntity entity, double extraVelX, double extraVelY, double extraVelZ) {
        return entity.func_70040_Z().func_216372_d(extraVelX, extraVelY, extraVelZ);
    }

    public static <T extends Entity> List<T> getNearbyEntities(Vector3d pos, IWorld world, double radius, @Nullable Predicate<Entity> predicate, Class<? extends T> ... clazzez) {
        return WyHelper.getNearbyEntities(pos, world, radius, radius, radius, predicate, clazzez);
    }

    public static <T extends Entity> List<T> getNearbyEntities(Vector3d pos, IWorld world, double sizeX, double sizeY, double sizeZ, @Nullable Predicate<Entity> predicate, Class<? extends T> ... clazzez) {
        AxisAlignedBB aabb = new AxisAlignedBB(pos, pos.func_72441_c(1.0, 1.0, 1.0)).func_72314_b(sizeX, sizeY, sizeZ);
        return WyHelper.getNearbyEntities(world, aabb, predicate, clazzez);
    }

    @SafeVarargs
    public static <T extends Entity> List<T> getNearbyEntities(IWorld world, AxisAlignedBB aabb, @Nullable Predicate<Entity> predicate, Class<? extends T> ... clazzez) {
        if (clazzez.length <= 0) {
            clazzez = new Class[]{Entity.class};
        }
        if (predicate == null) {
            predicate = Predicates.alwaysTrue();
        }
        predicate = ModEntityPredicates.IS_ALIVE_AND_SURVIVAL.and(e -> !(e instanceof SphereEntity)).and((Predicate<Entity>)predicate);
        ArrayList<PartEntity> list = new ArrayList<PartEntity>();
        for (Class<T> clazz : clazzez) {
            list.addAll(world.func_175647_a(clazz, aabb, (Predicate)predicate));
            if (!(world instanceof IForgeWorld)) continue;
            for (PartEntity partEntity : ((IForgeWorld)world).getPartEntities()) {
                if (!clazz.isAssignableFrom(partEntity.getClass()) || !partEntity.func_174813_aQ().func_72326_a(aabb) || predicate != null && !predicate.test(partEntity)) continue;
                list.add(partEntity);
            }
        }
        return list;
    }

    public static <T extends LivingEntity> List<T> getNearbyLiving(Vector3d pos, IWorld world, double sizeX, double sizeY, double sizeZ, @Nullable Predicate<Entity> predicate) {
        return WyHelper.getNearbyEntities(pos, world, sizeX, sizeY, sizeZ, predicate, LivingEntity.class);
    }

    public static <T extends LivingEntity> List<T> getNearbyLiving(Vector3d pos, IWorld world, double radius, @Nullable Predicate<Entity> predicate) {
        return WyHelper.getNearbyEntities(pos, world, radius, predicate, LivingEntity.class);
    }

    public static <T extends PlayerEntity> List<T> getNearbyPlayers(Vector3d pos, IWorld world, double radius, @Nullable Predicate<Entity> predicate) {
        if (predicate == null) {
            predicate = Predicates.alwaysTrue();
        }
        predicate = ModEntityPredicates.IS_ALIVE_AND_SURVIVAL.and((Predicate<Entity>)predicate);
        return world.func_217369_A().stream().filter(predicate).filter(target -> {
            double d0 = target.func_70092_e(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
            double d1 = radius * radius;
            return d1 < 0.0 || d0 < d1;
        }).collect(Collectors.toList());
    }

    public static <T extends Entity> List<T> getEntitiesNearSphere(Vector3d pos, IWorld world, double radius, @Nullable Predicate<Entity> predicate, Class<? extends T> ... classEntities) {
        predicate = predicate != null ? predicate.and(EntityPredicates.field_180132_d) : EntityPredicates.field_180132_d;
        double x = pos.field_72450_a;
        double y = pos.field_72448_b;
        double z = pos.field_72449_c;
        AxisAlignedBB aabb = new AxisAlignedBB(x, y, z, x, y, z).func_72314_b(radius *= 2.0, radius, radius);
        ArrayList list = new ArrayList();
        for (Class<? extends T> clzz : classEntities) {
            list.addAll(world.func_175647_a(clzz, aabb, predicate));
        }
        for (int i = 0; i < list.size(); ++i) {
            if (!(((Entity)list.get(i)).func_70092_e(x, y, z) >= radius)) continue;
            list.remove(i);
            break;
        }
        return list;
    }

    public static <T extends Entity> List<T> getEntitiesAroundCircle(Vector3d pos, IWorld world, double radius, double innerDepth, @Nullable Predicate<Entity> predicate, Class<? extends T> ... classEntities) {
        predicate = predicate != null ? predicate.and(EntityPredicates.field_180132_d) : EntityPredicates.field_180132_d;
        double x = pos.field_72450_a;
        double y = pos.field_72448_b;
        double z = pos.field_72449_c;
        AxisAlignedBB aabb = new AxisAlignedBB(x, y, z, x, y, z).func_72314_b(radius, radius, radius);
        ArrayList<Entity> list = new ArrayList<Entity>();
        for (Class<? extends T> clzz : classEntities) {
            List entities = world.func_175647_a(clzz, aabb, predicate);
            for (Entity entity : entities) {
                double maxDistanceSqr;
                double distanceSqr = entity.func_70092_e(x, y, z);
                if (!(distanceSqr >= (maxDistanceSqr = (radius - innerDepth) * (radius - innerDepth)))) continue;
                list.add(entity);
            }
        }
        return list;
    }

    public static RayTraceResult rayTraceBlocksAndEntities(Entity entity) {
        return WyHelper.rayTraceBlocksAndEntities(entity, 1024.0, 0.4f);
    }

    public static RayTraceResult rayTraceBlocksAndEntities(Entity entity, double distance) {
        return WyHelper.rayTraceBlocksAndEntities(entity, distance, 0.2f);
    }

    public static RayTraceResult rayTraceBlocksAndEntities(Entity entity, double distance, float entityBoxRange) {
        Vector3d lookVec = entity.func_70040_Z();
        Vector3d startVec = entity.func_213303_ch().func_72441_c(0.0, (double)entity.func_70047_e(), 0.0);
        Vector3d endVec = startVec.func_178787_e(entity.func_70040_Z().func_186678_a(distance));
        BlockRayTraceResult blockResult = entity.field_70170_p.func_217299_a(new RayTraceContext(startVec, endVec, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, entity));
        EntityRayTraceResult entityResult = null;
        int i = 0;
        while ((double)i < distance * 2.0 && entityResult == null) {
            float scale = (float)i / 2.0f;
            Vector3d pos = startVec.func_178787_e(lookVec.func_186678_a((double)scale));
            Vector3d min = pos.func_72441_c((double)entityBoxRange, (double)entityBoxRange, (double)entityBoxRange);
            Vector3d max = pos.func_72441_c((double)(-entityBoxRange), (double)(-entityBoxRange), (double)(-entityBoxRange));
            List list = entity.field_70170_p.func_72839_b(entity, new AxisAlignedBB(min.field_72450_a, min.field_72448_b, min.field_72449_c, max.field_72450_a, max.field_72448_b, max.field_72449_c));
            list.remove(entity);
            for (Entity e : list) {
                if (e instanceof LightningEntity) continue;
                entityResult = new EntityRayTraceResult(e, pos);
                break;
            }
            ++i;
        }
        if (entityResult != null && entityResult.func_216347_e().func_72438_d(startVec) <= blockResult.func_216347_e().func_72438_d(startVec)) {
            return entityResult;
        }
        return blockResult;
    }

    public static BlockPos rayTraceBlockSafe(LivingEntity entity, float range) {
        BlockPos dashPos;
        Vector3d endVec;
        World world = entity.field_70170_p;
        Vector3d startVec = entity.func_213303_ch().func_72441_c(0.0, (double)entity.func_70047_e(), 0.0);
        BlockRayTraceResult result = world.func_217299_a(new RayTraceContext(startVec, endVec = startVec.func_178787_e(entity.func_70040_Z().func_186678_a((double)range)), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)entity));
        BlockPos blockPos = dashPos = result.func_216354_b().equals((Object)Direction.DOWN) ? result.func_216350_a().func_177979_c(2) : result.func_216350_a().func_177971_a(result.func_216354_b().func_176730_m());
        if (dashPos.func_177956_o() > entity.field_70170_p.func_217301_I()) {
            dashPos = dashPos.func_177982_a(0, entity.field_70170_p.func_217301_I() - dashPos.func_177956_o(), 0);
        }
        return dashPos;
    }

    public static boolean isPosClearForPlayer(World world, BlockPos pos) {
        return !(!world.func_175623_d(pos) && !world.func_180495_p(pos).func_196952_d((IBlockReader)world, pos).func_197766_b() || !world.func_175623_d(pos.func_177984_a()) && !world.func_180495_p(pos.func_177984_a()).func_196952_d((IBlockReader)world, pos.func_177984_a()).func_197766_b());
    }

    public static BlockPos getClearPositionForPlayer(LivingEntity entity, BlockPos pos) {
        Direction dir;
        boolean posIsFree = WyHelper.isPosClearForPlayer(entity.field_70170_p, pos);
        for (int i = 0; !posIsFree && !(posIsFree = WyHelper.isPosClearForPlayer(entity.field_70170_p, pos = pos.func_177982_a(-(dir = Direction.values()[i]).func_82601_c() * 2, -dir.func_96559_d() * 2, -dir.func_82599_e() * 2))) && i < Direction.values().length - 1; ++i) {
        }
        return posIsFree ? pos : null;
    }

    public static BlockRayTraceResult rayTraceBlocks(Entity source, double distance) {
        Vector3d startVec = source.func_213303_ch().func_72441_c(0.0, (double)source.func_70047_e(), 0.0);
        Vector3d endVec = startVec.func_178787_e(source.func_70040_Z().func_186678_a(distance));
        return source.field_70170_p.func_217299_a(new RayTraceContext(startVec, endVec, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, source));
    }

    public static BlockRayTraceResult rayTraceBlocks(World world, Vector3d startVec, Vector3d endVec) {
        return world.func_217299_a(new RayTraceContext(startVec, endVec, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, null));
    }

    public static EntityRayTraceResult rayTraceEntities(Entity source, double distance) {
        return WyHelper.rayTraceEntities(source, distance, 1.25, null);
    }

    public static EntityRayTraceResult rayTraceEntities(Entity source, double distance, double width, Predicate<Entity> check) {
        Vector3d startVec = source.func_213303_ch().func_72441_c(0.0, (double)source.func_70047_e(), 0.0);
        Vector3d endVec = startVec.func_178787_e(source.func_70040_Z().func_186678_a(distance));
        AxisAlignedBB boundingBox = source.func_174813_aQ().func_186662_g(distance);
        List entities = source.field_70170_p.func_175674_a(source, boundingBox, entity -> entity != source);
        for (Entity entity2 : entities) {
            Vector3d targetVec;
            double distFromSource;
            AxisAlignedBB entityBB = entity2.func_174813_aQ().func_186662_g(1.0);
            Optional optional = entityBB.func_216365_b(startVec, endVec);
            if (!optional.isPresent() || !((distFromSource = (double)MathHelper.func_76133_a((double)startVec.func_72436_e(targetVec = (Vector3d)optional.get()))) < distance)) continue;
            List targets = WyHelper.getNearbyEntities(targetVec, (IWorld)source.field_70170_p, width, check, new Class[0]);
            targets.remove(source);
            Optional target = targets.stream().findFirst();
            if (!target.isPresent()) continue;
            return new EntityRayTraceResult((Entity)target.get(), endVec);
        }
        return new EntityRayTraceResult(null, endVec);
    }

    public static boolean isBlockNearby(Entity entity, int radius, Predicate<BlockState> test) {
        BlockPos.Mutable pos = new BlockPos.Mutable();
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    pos.func_189532_c(entity.func_226277_ct_() + (double)x, entity.func_226278_cu_() + (double)y, entity.func_226281_cx_() + (double)z);
                    BlockState state = entity.field_70170_p.func_180495_p((BlockPos)pos);
                    if (!test.test(state)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isBlockNearby(Entity entity, int radius, Block ... blocks) {
        List<Block> list = Arrays.asList(blocks);
        return WyHelper.isBlockNearby(entity, radius, (BlockState state) -> list.contains(state.func_177230_c()));
    }

    public static List<BlockPos> getNearbyBlocks(Entity entity, int radius) {
        return WyHelper.getNearbyBlocks(entity.func_233580_cy_(), (IWorld)entity.field_70170_p, radius);
    }

    public static List<BlockPos> getNearbyBlocks(BlockPos pos, IWorld world, int radius) {
        return WyHelper.getNearbyBlocks(pos, world, radius, radius, radius, state -> !(state.func_177230_c() instanceof AirBlock));
    }

    @Deprecated
    public static List<BlockPos> getNearbyBlocks(BlockPos pos, IWorld world, int radius, List<Block> bannedBlocks) {
        return WyHelper.getNearbyBlocks(pos, world, radius, null, bannedBlocks);
    }

    @Deprecated
    public static List<BlockPos> getNearbyBlocks(BlockPos pos, IWorld world, int radius, @Nullable Predicate<BlockPos> predicate, List<Block> bannedBlocks) {
        predicate = predicate == null ? blockPos -> true : predicate;
        BlockPos.Mutable mutpos = new BlockPos.Mutable();
        ArrayList<BlockPos> blockLocations = new ArrayList<BlockPos>();
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    Block block;
                    mutpos.func_181079_c(pos.func_177958_n() + x, pos.func_177956_o() + y, pos.func_177952_p() + z);
                    if (!predicate.test((BlockPos)mutpos) || bannedBlocks.contains(block = world.func_180495_p((BlockPos)mutpos).func_177230_c())) continue;
                    blockLocations.add(mutpos.func_185334_h());
                }
            }
        }
        return blockLocations;
    }

    public static List<BlockPos> getNearbyBlocks(BlockPos pos, IWorld world, int sizeX, int sizeY, int sizeZ, @Nullable Predicate<BlockState> predicate) {
        predicate = predicate == null ? blockPos -> true : predicate;
        BlockPos.Mutable mutpos = new BlockPos.Mutable();
        ArrayList<BlockPos> blockLocations = new ArrayList<BlockPos>();
        for (int x = -sizeX; x <= sizeX; ++x) {
            for (int y = -sizeY; y <= sizeY; ++y) {
                for (int z = -sizeZ; z <= sizeZ; ++z) {
                    mutpos.func_181079_c(pos.func_177958_n() + x, pos.func_177956_o() + y, pos.func_177952_p() + z);
                    BlockState state = world.func_180495_p((BlockPos)mutpos);
                    if (!predicate.test(state)) continue;
                    blockLocations.add(mutpos.func_185334_h());
                }
            }
        }
        return blockLocations;
    }

    public static List<BlockPos> getNearbyTileEntities(Entity player, int radius) {
        return WyHelper.getNearbyTileEntities(player.func_233580_cy_(), player.field_70170_p, radius);
    }

    public static List<BlockPos> getNearbyTileEntities(BlockPos pos, World world, int radius) {
        BlockPos.Mutable mutpos = new BlockPos.Mutable();
        ArrayList<BlockPos> blockLocations = new ArrayList<BlockPos>();
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    mutpos.func_181079_c(pos.func_177958_n() + x, pos.func_177956_o() + y, pos.func_177952_p() + z);
                    if (world.func_180495_p((BlockPos)mutpos).func_177230_c() == Blocks.field_150350_a || world.func_175625_s((BlockPos)mutpos) == null) continue;
                    blockLocations.add(mutpos.func_185334_h());
                }
            }
        }
        return blockLocations;
    }

    @Nullable
    public static BlockPos findOnGroundSpawnLocation(World world, EntityType type, BlockPos spawnLocation, int radius) {
        return WyHelper.findOnGroundSpawnLocation(world, type, spawnLocation, radius, 0);
    }

    @Nullable
    public static BlockPos findOnGroundSpawnLocation(World world, EntityType type, BlockPos spawnLocation, int radius, int offset) {
        BlockPos blockpos = null;
        for (int i = 0; i < 10; ++i) {
            int z;
            int y;
            int x = (int)WyHelper.randomWithRange(spawnLocation.func_177958_n() - offset - radius, spawnLocation.func_177958_n() + offset + radius);
            BlockPos blockpos1 = new BlockPos(x, y = world.func_201676_a(Heightmap.Type.WORLD_SURFACE, x, z = (int)WyHelper.randomWithRange(spawnLocation.func_177952_p() - offset - radius, spawnLocation.func_177952_p() + offset + radius)), z);
            if (!WorldEntitySpawner.canSpawnAtBody((EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (IWorldReader)world, (BlockPos)blockpos1, (EntityType)type)) continue;
            blockpos = blockpos1;
            break;
        }
        return blockpos;
    }

    public static BlockPos findValidGroundLocation(World level, BlockPos spawnPos, int radius, int offset) {
        BlockPos blockpos = null;
        for (int i = 0; i < 10; ++i) {
            int x = (int)WyHelper.randomWithRange(spawnPos.func_177958_n() - offset - radius, spawnPos.func_177958_n() + offset + radius);
            int z = (int)WyHelper.randomWithRange(spawnPos.func_177952_p() - offset - radius, spawnPos.func_177952_p() + offset + radius);
            for (int j = -5; j < 0; ++j) {
                int y = spawnPos.func_177956_o() + j;
                BlockPos pos = new BlockPos(x, y, z);
                BlockState state = level.func_180495_p(pos.func_177977_b());
                if (state.func_196958_f() || !state.func_185904_a().func_76220_a() || state.func_196952_d((IBlockReader)level, pos).equals(VoxelShapes.func_197880_a())) continue;
                blockpos = pos;
                break;
            }
            if (blockpos != null) break;
        }
        return blockpos;
    }

    public static BlockPos findValidGroundLocation(Entity entity, BlockPos spawnPos, int radius, int offset) {
        BlockPos blockpos = entity.func_233580_cy_();
        for (int i = 0; i < 10; ++i) {
            int x = (int)WyHelper.randomWithRange(spawnPos.func_177958_n() - offset - radius, spawnPos.func_177958_n() + offset + radius);
            int z = (int)WyHelper.randomWithRange(spawnPos.func_177952_p() - offset - radius, spawnPos.func_177952_p() + offset + radius);
            BlockPos pos = new BlockPos(x, spawnPos.func_177956_o(), z);
            BlockState state = entity.field_70170_p.func_180495_p(pos.func_177977_b());
            if (state.func_196958_f() || !state.func_185904_a().func_76220_a() || state.func_196952_d((IBlockReader)entity.field_70170_p, pos).equals(VoxelShapes.func_197880_a())) continue;
            blockpos = pos;
            break;
        }
        return blockpos;
    }

    public static Vector3d findValidGroundLocation(World level, Vector3d origin, int radius, int offset) {
        for (int i = 0; i < 10; ++i) {
            int x = (int)WyHelper.randomWithRange(-offset - radius, offset + radius);
            int z = (int)WyHelper.randomWithRange(-offset - radius, offset + radius);
            int y = level.func_201676_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, (int)origin.field_72450_a, (int)origin.field_72449_c);
            BlockPos check = new BlockPos(origin.func_82615_a() + (double)x, (double)y, origin.func_82616_c() + (double)z);
            BlockState state = level.func_180495_p(check.func_177977_b());
            if (state.func_196958_f() || !state.func_185904_a().func_76220_a() || state.func_196952_d((IBlockReader)level, check).equals(VoxelShapes.func_197880_a())) continue;
            origin = origin.func_72441_c((double)x, (double)y - origin.func_82617_b(), (double)z);
            break;
        }
        return origin;
    }

    public static String getTextureName(String texture) {
        for (String s : texture.split("/")) {
            if (!s.contains(".png")) continue;
            return s.replace(".png", "");
        }
        return null;
    }

    public static boolean setBlockStateInChunk(World world, BlockPos pos, BlockState newState, int flags) {
        if (world instanceof ServerWorld && WyHelper.isInChallengeDimension(world) && (flags & 0x200) != 0) {
            try {
                boolean placed = WyHelper.swapBlockData((IWorld)world, pos, newState) != null;
                return placed;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (World.func_189509_E((BlockPos)pos)) {
            return false;
        }
        if (!world.field_72995_K && world.func_234925_Z_()) {
            return false;
        }
        Chunk chunk = world.func_175726_f(pos);
        pos = pos.func_185334_h();
        BlockState old = world.func_180495_p(pos);
        int oldLight = old.getLightValue((IBlockReader)world, pos);
        int oldOpacity = old.func_200016_a((IBlockReader)world, pos);
        BlockState blockstate = chunk.func_177436_a(pos, newState, (flags & 0x40) != 0);
        if (world instanceof ServerWorld && !newState.func_196958_f() && WyHelper.isInChallengeDimension(world)) {
            InProgressChallenge challenge = ChallengesWorldData.get().getInProgressChallengeFor((ServerWorld)world);
            challenge.trackBlockPos(pos);
        }
        if (blockstate != null) {
            BlockState blockstate1 = world.func_180495_p(pos);
            if ((flags & 0x80) == 0 && blockstate1 != blockstate && (blockstate1.func_200016_a((IBlockReader)world, pos) != oldOpacity || blockstate1.getLightValue((IBlockReader)world, pos) != oldLight || blockstate1.func_215691_g() || blockstate.func_215691_g())) {
                world.func_217381_Z().func_76320_a("queueCheckLight");
                world.func_72863_F().func_212863_j_().func_215568_a(pos);
                world.func_217381_Z().func_76319_b();
            }
            if ((flags & 0x100) != 0) {
                world.markAndNotifyBlock(pos, chunk, blockstate, newState, flags, 512);
            } else if ((flags & 2) != 0 && (!world.field_72995_K || (flags & 4) == 0) && (world.field_72995_K || chunk == null || chunk.func_217321_u() != null && chunk.func_217321_u().func_219065_a(ChunkHolder.LocationType.TICKING))) {
                world.func_184138_a(pos, blockstate, newState, flags);
            }
        }
        return true;
    }

    @Nullable
    public static BlockState swapBlockData(IWorld world, BlockPos pos, BlockState newState) {
        int i = pos.func_177958_n() & 0xF;
        int j = Math.abs(pos.func_177956_o());
        int k = pos.func_177952_p() & 0xF;
        IChunk chunk = world.func_217349_x(pos);
        ChunkSection cs = chunk.func_76587_i()[j >> 4];
        if (cs == Chunk.field_186036_a) {
            if (newState.func_196958_f()) {
                return null;
            }
            chunk.func_76587_i()[j >> 4] = cs = new ChunkSection(j >> 4 << 4);
        }
        boolean flag = cs.func_76663_a();
        BlockState state = cs.func_222629_a(i, j & 0xF, k, newState);
        if (state == newState) {
            return null;
        }
        boolean flag1 = cs.func_76663_a();
        if (flag != flag1) {
            world.func_72863_F().func_212863_j_().func_215567_a(pos, flag1);
        }
        int pRecursionLeft = 25;
        state.func_241483_b_(world, pos, i, pRecursionLeft - 1);
        newState.func_241482_a_(world, pos, i, pRecursionLeft - 1);
        newState.func_241483_b_(world, pos, i, pRecursionLeft - 1);
        chunk.func_177427_f(true);
        return state;
    }

    public static void spawnDamageIndicatorParticles(World world, LivingEntity target, int amount) {
        if (world instanceof ServerWorld) {
            ((ServerWorld)world).func_195598_a((IParticleData)ParticleTypes.field_197615_h, target.func_226277_ct_(), target.func_226283_e_(0.5), target.func_226281_cx_(), amount, 0.1, 0.0, 0.1, 0.2);
        }
    }

    public static boolean isAprilFirst() {
        Calendar cal = Calendar.getInstance();
        int day = cal.get(5);
        int month = cal.get(2) + 1;
        return month == 4 && day == 1;
    }

    public static long getDaysSince(Date date) {
        Date now = new Date();
        long diffInMillies = Math.abs(now.getTime() - date.getTime());
        long diff = TimeUnit.DAYS.convert(diffInMillies, TimeUnit.MILLISECONDS);
        return diff;
    }

    public static int roundToNiceNumber(float n) {
        float n1 = n - n % 10.0f;
        float n2 = n + 10.0f - n % 10.0f;
        float res = n - n1 > n2 - n ? n2 : n1;
        return (int)res;
    }

    public static float minutesToTicks(float minutes) {
        return WyHelper.secondsToTicks(minutes * 60.0f);
    }

    public static float secondsToTicks(float seconds) {
        return seconds * 20.0f;
    }

    public static double percentage(double percent, double value) {
        return percent / 100.0 * value;
    }

    public static double randomWithRange(int min, int max) {
        return RANDOM.nextInt(max + 1 - min) + min;
    }

    public static double randomWithRange(Random rand, int min, int max) {
        return rand.nextInt(max + 1 - min) + min;
    }

    public static double randomDouble(Random rand) {
        return rand.nextDouble() * 2.0 - 1.0;
    }

    public static double randomDouble() {
        return RANDOM.nextDouble() * 2.0 - 1.0;
    }

    public static double getScaledRandomValue(double index, double minRange, double maxRange, double maxIndex) {
        return WyHelper.randomDouble() * (maxRange - (maxRange - minRange) * index / maxIndex);
    }

    public static int round(int value) {
        String valueString = "" + value;
        if (valueString.length() < 1) {
            return value;
        }
        return WyHelper.round(value, valueString.length() - 1);
    }

    public static int round(int value, int nth) {
        String valueString = "" + value;
        if (valueString.length() < 1 || nth < 0) {
            return value;
        }
        if (nth == 0) {
            nth = 1;
        }
        int n = (int)Math.pow(10.0, nth - 1);
        int r = 5 * (n / 10);
        return (value + r) / n * n;
    }

    public static long clamp(long num, long min, long max) {
        return num < min ? min : Math.min(num, max);
    }

    public static void drawStringWithBorder(FontRenderer font, MatrixStack matrixStack, IReorderingProcessor text, int posX, int posY, int color) {
        matrixStack.func_227860_a_();
        font.func_238407_a_(matrixStack, text, (float)posX, (float)posY - 0.7f, 0);
        font.func_238407_a_(matrixStack, text, (float)posX, (float)posY + 0.7f, 0);
        font.func_238407_a_(matrixStack, text, (float)posX + 0.7f, (float)posY, 0);
        font.func_238407_a_(matrixStack, text, (float)posX - 0.7f, (float)posY, 0);
        matrixStack.func_227861_a_(0.0, 0.0, 1.0);
        font.func_238422_b_(matrixStack, text, (float)posX, (float)posY, color);
        matrixStack.func_227865_b_();
        RenderSystem.enableAlphaTest();
        RenderSystem.enableBlend();
    }

    public static void drawStringWithBorder(FontRenderer font, MatrixStack matrixStack, String text, int posX, int posY, int color) {
        matrixStack.func_227860_a_();
        String unformattedText = WyHelper.escapeTextFormattingChars(text);
        font.func_238405_a_(matrixStack, unformattedText, (float)posX, (float)posY - 0.7f, 0);
        font.func_238405_a_(matrixStack, unformattedText, (float)posX, (float)posY + 0.7f, 0);
        font.func_238405_a_(matrixStack, unformattedText, (float)posX + 0.7f, (float)posY, 0);
        font.func_238405_a_(matrixStack, unformattedText, (float)posX - 0.7f, (float)posY, 0);
        matrixStack.func_227861_a_(0.0, 0.0, 1.0);
        font.func_238421_b_(matrixStack, text, (float)posX, (float)posY, color);
        matrixStack.func_227865_b_();
        RenderSystem.enableAlphaTest();
        RenderSystem.enableBlend();
    }

    public static void drawStringWithBorder(FontRenderer font, MatrixStack matrixStack, ITextComponent text, int posX, int posY, int color) {
        matrixStack.func_227860_a_();
        font.func_243246_a(matrixStack, text, (float)posX, (float)posY - 0.7f, 0);
        font.func_243246_a(matrixStack, text, (float)posX, (float)posY + 0.7f, 0);
        font.func_243246_a(matrixStack, text, (float)posX + 0.7f, (float)posY, 0);
        font.func_243246_a(matrixStack, text, (float)posX - 0.7f, (float)posY, 0);
        matrixStack.func_227861_a_(0.0, 0.0, 1.0);
        font.func_243248_b(matrixStack, text, (float)posX, (float)posY, color);
        matrixStack.func_227865_b_();
        RenderSystem.enableAlphaTest();
        RenderSystem.enableBlend();
    }

    public static String escapeTextFormattingChars(String text) {
        return text.replaceAll("\u00a7[0-9a-f]", "");
    }

    @Deprecated
    public static void rotateCorpse(MatrixStack matrixStack, LivingEntity entityLiving, float ageInTicks, float headYawOffset, float partialTicks) {
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f + headYawOffset));
        if (entityLiving.field_70725_aQ > 0) {
            float animTime = ((float)entityLiving.field_70725_aQ + partialTicks - 1.0f) / 20.0f * 1.6f;
            if ((animTime = MathHelper.func_76129_c((float)animTime)) > 1.0f) {
                animTime = 1.0f;
            }
            matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(animTime * 90.0f));
        }
    }

    public static void generateJSONLangs() {
        Map<String, String> sorted = WyHelper.sortAlphabetically(WyRegistry.getLangMap());
        Set<Map.Entry<String, String>> set = sorted.entrySet();
        Iterator<Map.Entry<String, String>> iter = set.iterator();
        Map.Entry<String, String> prevEntry = null;
        File langFolder = new File(ModMain.getResourceFolderPath() + "/assets/" + "mineminenomi" + "/lang/");
        langFolder.mkdirs();
        if (langFolder.exists()) {
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(ModMain.getResourceFolderPath() + "/assets/" + "mineminenomi" + "/lang/en_us.json"), "UTF-8"));){
                writer.write("{\n");
                while (iter.hasNext()) {
                    Map.Entry<String, String> entry = iter.next();
                    if (prevEntry != null && !((String)prevEntry.getKey()).substring(0, 2).equals(entry.getKey().substring(0, 2))) {
                        writer.write("\n");
                    }
                    String value = WyHelper.escapeJSON(entry.getValue());
                    if (iter.hasNext()) {
                        writer.write("\t\"" + entry.getKey() + "\": \"" + value + "\",\n");
                    } else {
                        writer.write("\t\"" + entry.getKey() + "\": \"" + value + "\"\n");
                    }
                    prevEntry = entry;
                }
                writer.write("}\n");
                ((Writer)writer).close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static <T> List<T> shuffle(List<T> ar) {
        ArrayList<T> newList = new ArrayList<T>(ar);
        Collections.shuffle(newList);
        return newList;
    }

    public static <T> List<T> shuffle(List<T> ar, long seed) {
        ArrayList<T> newList = new ArrayList<T>(ar);
        Random rand = new Random(seed);
        Collections.shuffle(newList, rand);
        return newList;
    }

    public static <K extends Comparable, V extends Comparable> Map<K, V> sortAlphabetically(Map<K, V> map) {
        LinkedList<Map.Entry<K, V>> entries = new LinkedList<Map.Entry<K, V>>(map.entrySet());
        Collections.sort(entries, new Comparator<Map.Entry<K, V>>(){

            @Override
            public int compare(Map.Entry<K, V> o1, Map.Entry<K, V> o2) {
                return ((Comparable)o1.getKey()).compareTo(o2.getKey());
            }
        });
        LinkedHashMap sortedMap = new LinkedHashMap();
        for (Map.Entry entry : entries) {
            sortedMap.put(entry.getKey(), entry.getValue());
        }
        return sortedMap;
    }

    public static BlockPos[][] splitArray(BlockPos[] arrayToSplit, int chunkSize) {
        if (chunkSize <= 0) {
            return null;
        }
        int rest = arrayToSplit.length % chunkSize;
        int chunks = arrayToSplit.length / chunkSize + (rest > 0 ? 1 : 0);
        BlockPos[][] arrays = new BlockPos[chunks][];
        for (int i = 0; i < (rest > 0 ? chunks - 1 : chunks); ++i) {
            arrays[i] = Arrays.copyOfRange(arrayToSplit, i * chunkSize, i * chunkSize + chunkSize);
        }
        if (rest > 0) {
            arrays[chunks - 1] = Arrays.copyOfRange(arrayToSplit, (chunks - 1) * chunkSize, (chunks - 1) * chunkSize + rest);
        }
        return arrays;
    }

    public static final int getIndexOfItemStack(Item item, IInventory inven) {
        for (int i = 0; i < inven.func_70302_i_(); ++i) {
            if (inven.func_70301_a(i).func_77973_b() != item) continue;
            return i;
        }
        return -1;
    }

    public static boolean saveNBTStructure(ServerWorld world, String name, BlockPos pos, BlockPos size, List<Block> toIgnore) {
        if (!world.field_72995_K) {
            Template template;
            ServerWorld serverworld = world;
            TemplateManager templatemanager = serverworld.func_184163_y();
            ResourceLocation res = new ResourceLocation("mineminenomi", name);
            try {
                template = templatemanager.func_200220_a(res);
            }
            catch (ResourceLocationException ex) {
                ex.printStackTrace();
                return false;
            }
            toIgnore.add(Blocks.field_189881_dj);
            toIgnore.add(Blocks.field_150357_h);
            WyHelper.takeBlocksFromWorld(template, (World)world, pos, size, toIgnore);
            template.func_186254_a((World)serverworld, pos, size, true, Blocks.field_189881_dj);
            template.func_186252_a("?");
            try {
                return templatemanager.func_195429_b(res);
            }
            catch (ResourceLocationException var7) {
                return false;
            }
        }
        return false;
    }

    public static boolean loadNBTStructure(ServerWorld world, String name, BlockPos pos) {
        PlacementSettings placement = new PlacementSettings().func_186214_a(Mirror.NONE).func_186220_a(Rotation.NONE).func_186222_a(true).func_186218_a((ChunkPos)null);
        placement.func_215219_b().func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215206_c).func_215222_a((StructureProcessor)new IntegrityProcessor(1.0f)).func_189950_a(new Random(Util.func_211177_b()));
        return WyHelper.loadNBTStructure(world, name, pos, placement);
    }

    public static Optional<Template> getNBTStructure(ServerWorld world, String name, PlacementSettings settings) {
        if (!world.field_72995_K) {
            Template template;
            TemplateManager templatemanager = world.func_184163_y();
            ResourceLocation res = new ResourceLocation("mineminenomi", name);
            try {
                template = templatemanager.func_200219_b(res);
            }
            catch (ResourceLocationException ex) {
                ex.printStackTrace();
                return Optional.empty();
            }
            if (template == null) {
                return Optional.empty();
            }
            return Optional.of(template);
        }
        return Optional.empty();
    }

    public static boolean loadNBTStructure(ServerWorld world, String name, BlockPos pos, PlacementSettings settings) {
        Optional<Template> template;
        if (!world.field_72995_K && (template = WyHelper.getNBTStructure(world, name, settings)).isPresent()) {
            template.get().func_237144_a_((IServerWorld)world, pos, settings, new Random(Util.func_211177_b()));
            return true;
        }
        return false;
    }

    public static void takeBlocksFromWorld(Template template, World world, BlockPos startPos, BlockPos size, @Nullable List<Block> toIgnore) {
        if (size.func_177958_n() >= 1 && size.func_177956_o() >= 1 && size.func_177952_p() >= 1) {
            BlockPos blockpos = startPos.func_177971_a((Vector3i)size).func_177982_a(-1, -1, -1);
            ArrayList list = Lists.newArrayList();
            ArrayList list1 = Lists.newArrayList();
            ArrayList list2 = Lists.newArrayList();
            BlockPos blockpos1 = new BlockPos(Math.min(startPos.func_177958_n(), blockpos.func_177958_n()), Math.min(startPos.func_177956_o(), blockpos.func_177956_o()), Math.min(startPos.func_177952_p(), blockpos.func_177952_p()));
            BlockPos blockpos2 = new BlockPos(Math.max(startPos.func_177958_n(), blockpos.func_177958_n()), Math.max(startPos.func_177956_o(), blockpos.func_177956_o()), Math.max(startPos.func_177952_p(), blockpos.func_177952_p()));
            ((ITemplateMixin)template).setSize(size);
            BlockPos.func_218281_b((BlockPos)blockpos1, (BlockPos)blockpos2).forEach(blockpos3 -> {
                TileEntity tileentity;
                BlockPos blockpos4 = blockpos3.func_177973_b((Vector3i)blockpos1);
                BlockState blockstate = world.func_180495_p(blockpos3);
                if (toIgnore != null && toIgnore.contains(blockstate.func_177230_c())) {
                    world.func_175656_a(blockpos3, Blocks.field_150350_a.func_176223_P());
                    blockstate = world.func_180495_p(blockpos3);
                }
                if ((tileentity = world.func_175625_s(blockpos3)) != null) {
                    CompoundNBT compoundnbt = tileentity.func_189515_b(new CompoundNBT());
                    compoundnbt.func_82580_o("x");
                    compoundnbt.func_82580_o("y");
                    compoundnbt.func_82580_o("z");
                    list1.add(new Template.BlockInfo(blockpos4, blockstate, compoundnbt));
                } else if (!blockstate.func_200015_d((IBlockReader)world, blockpos3) && !blockstate.func_235785_r_((IBlockReader)world, blockpos3)) {
                    list2.add(new Template.BlockInfo(blockpos4, blockstate, (CompoundNBT)null));
                } else {
                    list.add(new Template.BlockInfo(blockpos4, blockstate, (CompoundNBT)null));
                }
            });
            ArrayList list3 = Lists.newArrayList();
            list3.addAll(list);
            list3.addAll(list1);
            list3.addAll(list2);
            ((ITemplateMixin)template).getBlocks().clear();
            ((ITemplateMixin)template).getEntities().clear();
        }
    }

    public static boolean isSurfaceFlat(IWorld world, int posX, int posZ, int difference) {
        int[] points;
        int offset = 16;
        int x0 = world.func_201676_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, posX, posZ);
        int z0 = world.func_201676_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, posX, posZ + offset);
        int x1 = world.func_201676_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, posX + offset, posZ);
        int z1 = world.func_201676_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, posX + offset, posZ + offset);
        int[] nArray = points = new int[]{x0, z0, x1, z1};
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            boolean isSolidGround;
            BlockPos centerOfChunk = new BlockPos(posX, 0, posZ);
            int point = nArray[i];
            BlockState midState = world.func_180495_p(centerOfChunk.func_177981_b(point - 1));
            boolean bl = isSolidGround = !midState.func_196958_f() && midState.func_204520_s().func_206888_e() && midState.func_185904_a().func_76220_a();
            if (isSolidGround) continue;
            return false;
        }
        int minHeight = Math.min(Math.min(x0, z0), Math.min(x1, z1));
        int maxHeight = Math.max(Math.max(x0, z0), Math.max(x1, z1));
        return Math.abs(maxHeight - minHeight) <= difference;
    }

    public static boolean isSurfaceFlat(ChunkGenerator chunkGen, int chunkPosX, int chunkPosZ, int difference) {
        int[] points;
        int offset = 16;
        int xStart = (chunkPosX << 4) + (7 - offset / 2);
        int zStart = (chunkPosZ << 4) + (7 - offset / 2);
        int x0 = chunkGen.func_222531_c(xStart, zStart, Heightmap.Type.WORLD_SURFACE_WG);
        int z0 = chunkGen.func_222531_c(xStart, zStart + offset, Heightmap.Type.WORLD_SURFACE_WG);
        int x1 = chunkGen.func_222531_c(xStart + offset, zStart, Heightmap.Type.WORLD_SURFACE_WG);
        int z1 = chunkGen.func_222531_c(xStart + offset, zStart + offset, Heightmap.Type.WORLD_SURFACE_WG);
        for (int point : points = new int[]{x0, z0, x1, z1}) {
            boolean isSolidGround;
            BlockPos centerOfChunk = new BlockPos(xStart, 0, zStart);
            IBlockReader columnOfBlocks = chunkGen.func_230348_a_(centerOfChunk.func_177958_n(), centerOfChunk.func_177952_p());
            BlockState midState = columnOfBlocks.func_180495_p(centerOfChunk.func_177981_b(point));
            boolean bl = isSolidGround = !midState.func_196958_f() && midState.func_204520_s().func_206888_e() && midState.func_185904_a().func_76220_a();
            if (isSolidGround) continue;
            return false;
        }
        int minHeight = Math.min(Math.min(x0, z0), Math.min(x1, z1));
        int maxHeight = Math.max(Math.max(x0, z0), Math.max(x1, z1));
        return Math.abs(maxHeight - minHeight) <= difference;
    }

    @Nullable
    public static <T> T sendGET(String sendUrl, Class resultType) throws IOException {
        Object result = null;
        URL url = new URL("https://pixelatedw.xyz/api/v1" + sendUrl);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        connection.setRequestProperty("User-Agent", "mineminenomi/0.10.10-" + MCPVersion.getMCVersion() + "-" + WyPatreon.BUILD_MODE.toString().toLowerCase());
        connection.setConnectTimeout(30000);
        int responseCode = connection.getResponseCode();
        if (responseCode == 200 || responseCode == 202) {
            String line;
            BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            StringBuilder sb = new StringBuilder();
            while ((line = in.readLine()) != null) {
                sb.append(line + "\n");
            }
            in.close();
            result = new Gson().fromJson(sb.toString(), resultType);
        } else {
            System.out.println("==============ERROR WHILE RETRIEVING SERVER DATA==============");
            System.out.println("Response Code: " + responseCode + " - " + connection.getResponseMessage());
            System.out.println("=============================================================");
        }
        return (T)result;
    }

    public static void removeAllModifiers(ModifiableAttributeInstance attr) {
        Set collection = attr.func_225505_c_();
        if (collection != null) {
            for (AttributeModifier attributemodifier : Lists.newArrayList((Iterable)collection)) {
                attr.func_111124_b(attributemodifier);
            }
        }
    }

    public static <T> T[] concatAllArrays(T[] first, T[] ... rest) {
        int totalLength = first.length;
        for (T[] array : rest) {
            totalLength += array.length;
        }
        T[] result = Arrays.copyOf(first, totalLength);
        int offset = first.length;
        for (T[] array : rest) {
            System.arraycopy(array, 0, result, offset, array.length);
            offset += array.length;
        }
        return result;
    }

    public static String stringToSnakeCase(String input) {
        String cleanedInput = input.replaceAll("[^a-zA-Z0-9 ]", "");
        return Arrays.stream(cleanedInput.split(" ")).map(String::toLowerCase).collect(Collectors.joining("_"));
    }

    public static ResourceLocation getResourceLocation(CompoundNBT nbt, String string) {
        if (!nbt.func_150297_b(string, 8) && string.equalsIgnoreCase("faction")) {
            return ModValues.CIVILIAN;
        }
        if (!nbt.func_150297_b(string, 8)) {
            return ModValues.EMPTY;
        }
        String id = nbt.func_74779_i(string);
        if (!id.contains(":")) {
            return new ResourceLocation("mineminenomi", id);
        }
        return new ResourceLocation(id);
    }

    public static <T> Collector<T, ?, List<T>> toShuffledList() {
        return SHUFFLER;
    }
}

