/*
 * Decompiled with CFR 0.152.
 */
package com.christofmeg.megaenderdrives;

import appeng.api.client.StorageCellModels;
import appeng.api.storage.cells.CellState;
import com.christofmeg.megaenderdrives.init.ItemRegistry;
import com.sts15.enderdrives.EnderDrives;
import com.sts15.enderdrives.client.ClientTapeCache;
import com.sts15.enderdrives.db.TapeDBManager;
import com.sts15.enderdrives.inventory.EnderDiskInventory;
import com.sts15.enderdrives.items.EnderDiskItem;
import com.sts15.enderdrives.items.TapeDiskItem;
import java.util.UUID;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;

@Mod(value="megaenderdrives", dist={Dist.CLIENT})
@EventBusSubscriber(modid="megaenderdrives", value={Dist.CLIENT})
public class MEGAEnderDrivesClient {
    public MEGAEnderDrivesClient(ModContainer container) {
        container.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
    }

    @SubscribeEvent
    static void onClientSetup(FMLClientSetupEvent event) {
        ItemRegistry.ITEMS.getEntries().stream().filter(item -> item.get() instanceof EnderDiskItem).forEach(disk -> StorageCellModels.registerModel((ItemLike)((ItemLike)disk.get()), (ResourceLocation)EnderDrives.id((String)"block/drive/ender_cell")));
        event.enqueueWork(() -> ItemRegistry.ITEMS.getEntries().stream().filter(item -> item.get() instanceof EnderDiskItem).forEach(disk -> ItemProperties.register((Item)((Item)disk.get()), (ResourceLocation)EnderDrives.id((String)"status"), (stack, level, entity, seed) -> {
            CellState state = EnderDiskInventory.getCellStateForStack((ItemStack)stack);
            return switch (state) {
                default -> throw new MatchException(null, null);
                case CellState.ABSENT, CellState.EMPTY -> 0.0f;
                case CellState.NOT_EMPTY -> 1.0f;
                case CellState.TYPES_FULL, CellState.FULL -> 2.0f;
            };
        })));
    }

    @SubscribeEvent
    public static void registerColorHandlers(RegisterColorHandlersEvent.Item event) {
        ItemColor itemColor = (stack, tintIndex) -> {
            if (tintIndex == 1) {
                if (stack.getItem() instanceof EnderDiskItem) {
                    CellState state = EnderDiskInventory.getCellStateForStack((ItemStack)stack);
                    return switch (state) {
                        default -> throw new MatchException(null, null);
                        case CellState.ABSENT -> 0;
                        case CellState.EMPTY -> 65280;
                        case CellState.NOT_EMPTY -> 255;
                        case CellState.TYPES_FULL, CellState.FULL -> 16753920;
                    };
                }
                if (stack.getItem() instanceof TapeDiskItem) {
                    UUID id = TapeDiskItem.getTapeId((ItemStack)stack);
                    if (id == null) {
                        return 0;
                    }
                    int typeCount = ClientTapeCache.getTypeCount((UUID)id);
                    long byteCount = ClientTapeCache.getByteCount((UUID)id);
                    int typeLimit = ((TapeDiskItem)stack.getItem()).getTypeLimit(stack);
                    long byteLimit = TapeDBManager.getByteLimit((UUID)id);
                    int typePercent = typeLimit > 0 ? typeCount * 100 / typeLimit : 0;
                    int bytePercent = byteLimit > 0L ? (int)(byteCount * 100L / byteLimit) : 0;
                    int usagePercent = Math.max(typePercent, bytePercent);
                    if ((usagePercent = Math.min(usagePercent, 100)) >= 99) {
                        return 0xFF5555;
                    }
                    if (usagePercent >= 75) {
                        return 0xFFAA00;
                    }
                    if (usagePercent > 0) {
                        return 43775;
                    }
                    return 65280;
                }
            }
            return -1;
        };
        ItemRegistry.ITEMS.getEntries().stream().filter(item -> item.get() instanceof EnderDiskItem).forEach(disk -> event.register(itemColor, new ItemLike[]{(ItemLike)disk.get()}));
    }
}

