/*
 * Decompiled with CFR 0.152.
 */
package com.christofmeg.megaenderdrives;

import appeng.api.storage.StorageCells;
import appeng.api.storage.cells.StorageCell;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.api.upgrades.IUpgradeableItem;
import appeng.core.localization.PlayerMessages;
import appeng.recipes.game.StorageCellDisassemblyRecipe;
import appeng.util.InteractionUtil;
import com.sts15.enderdrives.items.EnderDiskItem;
import java.util.List;
import java.util.Objects;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class Utils {
    public static boolean disassembleDrive(ItemStack stack, Level level, Player player) {
        Item disassembledStack2;
        if (!InteractionUtil.isInAlternateUseMode((Player)player)) {
            return false;
        }
        List disassembledStacks = StorageCellDisassemblyRecipe.getDisassemblyResult((Level)level, (Item)stack.getItem());
        if (disassembledStacks.isEmpty()) {
            return false;
        }
        Inventory playerInventory = player.getInventory();
        if (playerInventory.getSelected() != stack) {
            return false;
        }
        boolean isEnderDrive = stack.getItem() instanceof EnderDiskItem;
        StorageCell inv = StorageCells.getCellInventory((ItemStack)stack, null);
        if (inv != null && !isEnderDrive && !inv.getAvailableStacks().isEmpty()) {
            player.displayClientMessage((Component)PlayerMessages.OnlyEmptyCellsCanBeDisassembled.text(), true);
            return false;
        }
        playerInventory.setItem(playerInventory.selected, ItemStack.EMPTY);
        for (Item disassembledStack2 : disassembledStacks) {
            playerInventory.placeItemBackInInventory(disassembledStack2.copy());
        }
        disassembledStack2 = stack.getItem();
        if (disassembledStack2 instanceof IUpgradeableItem) {
            IUpgradeableItem iUpgradeableItem = (IUpgradeableItem)disassembledStack2;
            IUpgradeInventory var10000 = iUpgradeableItem.getUpgrades(stack);
            Objects.requireNonNull(playerInventory);
            var10000.forEach(arg_0 -> ((Inventory)playerInventory).placeItemBackInInventory(arg_0));
        }
        return true;
    }
}

