/*
 * Decompiled with CFR 0.152.
 */
package com.christofmeg.megaenderdrives.data;

import com.christofmeg.megaenderdrives.data.ModDataProvider;
import com.christofmeg.megaenderdrives.data.ModItemModelProvider;
import com.christofmeg.megaenderdrives.data.ModRecipeProvider;
import java.util.concurrent.CompletableFuture;
import net.minecraft.Util;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.registries.VanillaRegistries;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="megaenderdrives")
public class ModDataGenerator {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper fileHelper = event.getExistingFileHelper();
        CompletableFuture<HolderLookup.Provider> lookupProvider = CompletableFuture.supplyAsync(VanillaRegistries::createLookup, Util.backgroundExecutor());
        ModDataProvider provider = new ModDataProvider();
        provider.addSubProvider(event.includeClient(), (DataProvider)new ModItemModelProvider(packOutput, fileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ModRecipeProvider(packOutput, lookupProvider));
        generator.addProvider(true, (DataProvider)provider);
    }
}

