/*
 * Decompiled with CFR 0.152.
 */
package net.brdle.collectorsreap.client;

import com.teamabnormals.blueprint.core.util.DataUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.brdle.collectorsreap.client.model.ChieftainCrabModel;
import net.brdle.collectorsreap.client.model.ClamModel;
import net.brdle.collectorsreap.client.model.PlatinumBassModel;
import net.brdle.collectorsreap.client.model.TigerPrawnModel;
import net.brdle.collectorsreap.client.model.UrchinModel;
import net.brdle.collectorsreap.client.particle.AcidParticle;
import net.brdle.collectorsreap.client.particle.ShockwaveParticle;
import net.brdle.collectorsreap.client.particle.SurgeParticle;
import net.brdle.collectorsreap.client.renderer.ChieftainCrabRenderer;
import net.brdle.collectorsreap.client.renderer.ClamRenderer;
import net.brdle.collectorsreap.client.renderer.PlatinumBassRenderer;
import net.brdle.collectorsreap.client.renderer.TigerPrawnRenderer;
import net.brdle.collectorsreap.client.renderer.UrchinDartRenderer;
import net.brdle.collectorsreap.client.renderer.UrchinRenderer;
import net.brdle.collectorsreap.common.CRParticleTypes;
import net.brdle.collectorsreap.common.block.CRBlocks;
import net.brdle.collectorsreap.common.entity.CREntities;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.FoliageColor;
import net.minecraft.world.level.GrassColor;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.RegistryObject;

public class ClientEvents {
    private static final List<RegistryObject<Block>> FOLIAGE_COLOR_BLOCKS = Arrays.asList(CRBlocks.LUCUMA_LEAVES, CRBlocks.LUCUMA_LEAF_PILE);
    private static final List<RegistryObject<Block>> GRASS_COLOR_BLOCKS = Collections.emptyList();

    @SubscribeEvent
    public void registerBlockColors(RegisterColorHandlersEvent.Block e) {
        if (!FOLIAGE_COLOR_BLOCKS.isEmpty()) {
            DataUtil.registerBlockColor((BlockColors)e.getBlockColors(), (state, tint, pos, u) -> pos != null && tint != null ? BiomeColors.m_108804_((BlockAndTintGetter)tint, (BlockPos)pos) : FoliageColor.m_46113_(), FOLIAGE_COLOR_BLOCKS);
        }
        if (!GRASS_COLOR_BLOCKS.isEmpty()) {
            DataUtil.registerBlockColor((BlockColors)e.getBlockColors(), (state, tint, pos, u) -> pos != null && tint != null ? BiomeColors.m_108793_((BlockAndTintGetter)tint, (BlockPos)pos) : GrassColor.m_276205_(), GRASS_COLOR_BLOCKS);
        }
    }

    @SubscribeEvent
    public void registerItemColors(RegisterColorHandlersEvent.Item event) {
        if (!FOLIAGE_COLOR_BLOCKS.isEmpty()) {
            DataUtil.registerBlockItemColor((ItemColors)event.getItemColors(), (stack, c) -> event.getBlockColors().m_92577_(((BlockItem)stack.m_41720_()).m_40614_().m_49966_(), null, null, c), FOLIAGE_COLOR_BLOCKS);
        }
    }

    @SubscribeEvent
    public void registerLayerDefinition(EntityRenderersEvent.RegisterLayerDefinitions e) {
        e.registerLayerDefinition(TigerPrawnRenderer.LAYER_LOCATION, TigerPrawnModel::createBodyLayer);
        e.registerLayerDefinition(UrchinRenderer.LAYER_LOCATION, UrchinModel::createBodyLayer);
        e.registerLayerDefinition(PlatinumBassRenderer.LAYER_LOCATION, PlatinumBassModel::createBodyLayer);
        e.registerLayerDefinition(ChieftainCrabRenderer.LAYER_LOCATION, ChieftainCrabModel::createBodyLayer);
        e.registerLayerDefinition(ClamRenderer.LAYER_LOCATION, ClamModel::createBodyLayer);
    }

    @SubscribeEvent
    public void registerEntityRenders(EntityRenderersEvent.RegisterRenderers e) {
        e.registerEntityRenderer((EntityType)CREntities.TIGER_PRAWN.get(), TigerPrawnRenderer::new);
        e.registerEntityRenderer((EntityType)CREntities.URCHIN.get(), UrchinRenderer::new);
        e.registerEntityRenderer((EntityType)CREntities.PLATINUM_BASS.get(), PlatinumBassRenderer::new);
        e.registerEntityRenderer((EntityType)CREntities.CHIEFTAIN_CRAB.get(), ChieftainCrabRenderer::new);
        e.registerEntityRenderer((EntityType)CREntities.CLAM.get(), ClamRenderer::new);
        e.registerEntityRenderer((EntityType)CREntities.URCHIN_DART.get(), UrchinDartRenderer::new);
        e.registerEntityRenderer((EntityType)CREntities.SHIMMERING_PEARL.get(), ThrownItemRenderer::new);
    }

    @SubscribeEvent
    public void registerParticles(RegisterParticleProvidersEvent e) {
        e.registerSpriteSet((ParticleType)CRParticleTypes.ACID.get(), AcidParticle.Provider::new);
        e.registerSpriteSet((ParticleType)CRParticleTypes.SHOCKWAVE.get(), ShockwaveParticle.Provider::new);
        e.registerSpriteSet((ParticleType)CRParticleTypes.SURGE.get(), SurgeParticle.Provider::new);
    }
}

