/*
 * Decompiled with CFR 0.152.
 */
package net.brdle.collectorsreap.common.block;

import javax.annotation.Nullable;
import net.brdle.collectorsreap.common.block.CRBlocks;
import net.brdle.collectorsreap.common.event.CRSoundEvents;
import net.brdle.collectorsreap.common.item.CRItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import vectorwing.farmersdelight.common.Configuration;
import vectorwing.farmersdelight.common.registry.ModBlocks;
import vectorwing.farmersdelight.common.tag.ModTags;

public class DragonFruitVineBlock
extends CropBlock {
    public static final IntegerProperty VINE_AGE = BlockStateProperties.f_61407_;
    public static final BooleanProperty ROPELOGGED = BooleanProperty.m_61465_((String)"ropelogged");
    private static final VoxelShape SHAPE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);

    public DragonFruitVineBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)this.m_7959_(), (Comparable)Integer.valueOf(0))).m_61124_((Property)ROPELOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        if (this.m_52307_(state)) {
            RandomSource random = level.m_213780_();
            DragonFruitVineBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)CRItems.PINK_DRAGON_FRUIT.get(), 1 + random.m_188503_(2)));
            level.m_5594_(null, pos, (SoundEvent)CRSoundEvents.PICK_DRAGON_FRUIT.get(), SoundSource.BLOCKS, 1.0f, 0.8f + random.m_188501_() * 0.4f);
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)this.m_7959_(), (Comparable)Integer.valueOf(0)), 2);
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        return InteractionResult.PASS;
    }

    public boolean m_6724_(@NotNull BlockState state) {
        return true;
    }

    public void m_213898_(@NotNull BlockState state, ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        if (!level.isAreaLoaded(pos, 1)) {
            return;
        }
        if (level.m_45524_(pos, 0) >= 9) {
            float speed;
            int age = this.m_52305_(state);
            if (age < this.m_7419_() && ForgeHooks.onCropsGrowPre((Level)level, (BlockPos)pos, (BlockState)state, (random.m_188503_((int)(25.0f / (speed = DragonFruitVineBlock.m_52272_((Block)this, (BlockGetter)level, (BlockPos)pos))) + 1) == 0 ? 1 : 0) != 0)) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)this.m_7959_(), (Comparable)Integer.valueOf(age + 1)), 2);
                ForgeHooks.onCropsGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
            }
            this.attemptRopeClimb(level, pos, random);
        }
    }

    public void attemptRopeClimb(@NotNull ServerLevel level, @NotNull BlockPos pos, RandomSource random) {
        BlockPos posAbove;
        if (random.m_188501_() < 0.3f && level.m_8055_(posAbove = pos.m_7494_()).m_204336_(ModTags.ROPES)) {
            int vineHeight = 1;
            while (level.m_8055_(pos.m_6625_(vineHeight)).m_60713_((Block)this)) {
                ++vineHeight;
            }
            if (vineHeight < 3) {
                level.m_46597_(posAbove, (BlockState)this.m_49966_().m_61124_((Property)ROPELOGGED, (Comparable)Boolean.valueOf(true)));
            }
        }
    }

    @NotNull
    public BlockState m_52289_(int age) {
        return (BlockState)this.m_49966_().m_61124_((Property)this.m_7959_(), (Comparable)Integer.valueOf(age));
    }

    @NotNull
    public IntegerProperty m_7959_() {
        return VINE_AGE;
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return SHAPE;
    }

    public int m_7419_() {
        return 3;
    }

    @NotNull
    protected ItemLike m_6404_() {
        return (ItemLike)CRItems.DRAGON_FRUIT_SEEDS.get();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{VINE_AGE, ROPELOGGED});
    }

    protected int m_7125_(@NotNull Level level) {
        return super.m_7125_(level) / 2;
    }

    public void m_214148_(@NotNull ServerLevel level, @NotNull RandomSource random, @NotNull BlockPos pos, @NotNull BlockState state) {
        level.m_46597_(pos, (BlockState)state.m_61124_((Property)this.m_7959_(), (Comparable)Integer.valueOf(Math.min(this.m_7419_(), this.m_52305_(state) + this.m_7125_((Level)level)))));
        this.attemptRopeClimb(level, pos, random);
    }

    public boolean isLadder(BlockState state, @NotNull LevelReader level, @NotNull BlockPos pos, @NotNull LivingEntity entity) {
        return (Boolean)state.m_61143_((Property)ROPELOGGED) != false && state.m_204336_(BlockTags.f_13082_);
    }

    public boolean m_7898_(BlockState state, @NotNull LevelReader level, @NotNull BlockPos pos) {
        return ((Boolean)state.m_61143_((Property)ROPELOGGED)).booleanValue() ? level.m_8055_(pos.m_7495_()).m_60713_((Block)CRBlocks.PINK_DRAGON_FRUIT_CROP.get()) && (level.m_45524_(pos, 0) >= 8 || level.m_45527_(pos)) : super.m_7898_(state, level, pos);
    }

    public void m_6240_(@NotNull Level level, @NotNull Player player, @NotNull BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity, @NotNull ItemStack stack) {
        boolean isRopelogged = (Boolean)state.m_61143_((Property)ROPELOGGED);
        super.m_6240_(level, player, pos, state, blockEntity, stack);
        if (isRopelogged) {
            DragonFruitVineBlock.destroyAndPlaceRope(level, pos);
        }
    }

    @NotNull
    public BlockState m_7417_(BlockState state, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor level, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        if (!state.m_60710_((LevelReader)level, currentPos)) {
            level.m_186460_(currentPos, (Block)this, 1);
        }
        return state;
    }

    public void m_213897_(BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        if (!state.m_60710_((LevelReader)level, pos)) {
            level.m_46961_(pos, true);
            if (((Boolean)state.m_61143_((Property)ROPELOGGED)).booleanValue()) {
                DragonFruitVineBlock.destroyAndPlaceRope((Level)level, pos);
            }
        }
    }

    public static void destroyAndPlaceRope(Level level, @NotNull BlockPos pos) {
        Block configuredRopeBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation((String)Configuration.DEFAULT_TOMATO_VINE_ROPE.get()));
        Block finalRopeBlock = configuredRopeBlock != null ? configuredRopeBlock : (Block)ModBlocks.ROPE.get();
        level.m_46597_(pos, finalRopeBlock.m_49966_());
    }
}

