/*
 * Decompiled with CFR 0.152.
 */
package net.brdle.collectorsreap.common.config;

import java.util.HashMap;
import net.brdle.collectorsreap.Util;
import net.brdle.collectorsreap.common.item.CRItems;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.registries.RegistryObject;

public class CRConfig {
    public static final ForgeConfigSpec COMMON;
    private static final HashMap<String, ForgeConfigSpec.BooleanValue> ITEM_VALUES;
    public static final ForgeConfigSpec.BooleanValue LIME_POLLINATION;
    public static final ForgeConfigSpec.BooleanValue POMEGRANATE_POLLINATION;
    public static final ForgeConfigSpec.BooleanValue FAST_POLLINATE;
    public static final ForgeConfigSpec.IntValue STYGIAN_POMEGRANATE_RARITY;
    public static final ForgeConfigSpec.DoubleValue SURGE_ZERO_MULTIPLIER;
    public static final ForgeConfigSpec.DoubleValue SURGE_ONE_MULTIPLIER;
    public static final ForgeConfigSpec.DoubleValue SURGE_TWO_MULTIPLIER;
    public static final ForgeConfigSpec.DoubleValue REBOUND_CHANCE;

    public static boolean verify(String item) {
        return CRConfig.contains(item) && (Boolean)ITEM_VALUES.get(item).get() != false;
    }

    public static boolean verify(RegistryObject<Item> item) {
        return CRConfig.verify(item.getId().m_135815_());
    }

    public static boolean verify(Item item) {
        return CRConfig.verify(Util.name((ItemLike)item));
    }

    private static void defineItem(ForgeConfigSpec.Builder builder, String name) {
        ITEM_VALUES.put(name, builder.define(name, true));
    }

    private static boolean contains(String item) {
        return ITEM_VALUES.containsKey(item);
    }

    static {
        ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
        BUILDER.push("Behavior");
        FAST_POLLINATE = BUILDER.comment("Whether bee pollination of bushes should occur much quicker (when Bee collides with it) rather than on Bee's AI scheduled timing. Use this if having issues with pollination.").define("fast_pollinate", false);
        LIME_POLLINATION = BUILDER.comment("Whether Lime Bushes require Bee pollination to reach final growth stage.").define("lime_pollination", true);
        POMEGRANATE_POLLINATION = BUILDER.comment("Whether Pomegranate Bushes require Bee pollination to reach final growth stage in the Overworld.").define("pomegranate_pollination", true);
        STYGIAN_POMEGRANATE_RARITY = BUILDER.comment("(1/x) Chance to pick a Stygian Pomegranate from a bush when all conditions are met.").defineInRange("stygian_pomegranate_rarity", 10, 1, 100);
        BUILDER.pop();
        BUILDER.push("Effects");
        SURGE_ZERO_MULTIPLIER = BUILDER.comment("Attack damage multiplier gained from Surge I.").defineInRange("surge_zero_multiplier", 1.2, 1.0, 10.0);
        SURGE_ONE_MULTIPLIER = BUILDER.comment("Attack damage multiplier gained from Surge II.").defineInRange("surge_one_multiplier", 1.4, 1.0, 10.0);
        SURGE_TWO_MULTIPLIER = BUILDER.comment("Attack damage multiplier gained from Surge III.").defineInRange("surge_two_multiplier", 1.6, 1.0, 10.0);
        REBOUND_CHANCE = BUILDER.comment("Chance to regain health with Rebound").defineInRange("rebound_chance", 0.15, 0.01, 1.0);
        BUILDER.pop();
        ITEM_VALUES = new HashMap();
        BUILDER.push("Items");
        CRItems.HELPER.getDeferredRegister().getEntries().stream().map(obj -> obj.getId().m_135815_()).sorted().forEach(name -> CRConfig.defineItem(BUILDER, name));
        BUILDER.pop();
        COMMON = BUILDER.build();
    }
}

