/*
 * Decompiled with CFR 0.152.
 */
package net.brdle.collectorsreap.common.event;

import java.util.List;
import java.util.Objects;
import net.brdle.collectorsreap.Util;
import net.brdle.collectorsreap.common.CRParticleTypes;
import net.brdle.collectorsreap.common.block.CRBlocks;
import net.brdle.collectorsreap.common.config.CRConfig;
import net.brdle.collectorsreap.common.effect.CREffects;
import net.brdle.collectorsreap.common.effect.CorrosionEffect;
import net.brdle.collectorsreap.common.effect.SurgeEffect;
import net.brdle.collectorsreap.common.entity.BeeGoToFruitBushGoal;
import net.brdle.collectorsreap.common.entity.BeeGrowFruitGoal;
import net.brdle.collectorsreap.common.event.CRSoundEvents;
import net.brdle.collectorsreap.common.item.CRItems;
import net.brdle.collectorsreap.common.item.food.GummyItem;
import net.brdle.collectorsreap.data.CRDamageSources;
import net.brdle.collectorsreap.data.CREntityTags;
import net.brdle.collectorsreap.data.CRItemTags;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.village.WandererTradesEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import vectorwing.farmersdelight.common.registry.ModParticleTypes;
import vectorwing.farmersdelight.common.utility.MathUtils;

public class ForgeEvents {
    @SubscribeEvent
    public void onBeeJoin(EntityJoinLevelEvent e) {
        Entity entity = e.getEntity();
        if (entity instanceof Bee) {
            Bee bee = (Bee)entity;
            bee.m_148772_().m_25352_(3, (Goal)new BeeGrowFruitGoal(bee));
            bee.m_148772_().m_25352_(4, (Goal)new BeeGoToFruitBushGoal(bee));
        }
    }

    @SubscribeEvent
    public void onWanderingTrader(WandererTradesEvent e) {
        List trades = e.getGenericTrades();
        if (Util.enabled(CRBlocks.PORTOBELLO)) {
            trades.add((ent, r) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_41952_, 4), Util.getStack(CRBlocks.PORTOBELLO, new int[0]), 10, 1, 1.0f));
        }
        if (Util.enabled(CRItems.LIME) && Util.enabled(CRItems.LIME_SEEDS)) {
            trades.add((ent, r) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 1), Util.getStack(CRItems.LIME_SEEDS, new int[0]), 5, 1, 1.0f));
        }
        if (Util.enabled(CRItems.PINK_DRAGON_FRUIT) && Util.enabled(CRItems.DRAGON_FRUIT_SEEDS)) {
            trades.add((ent, r) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 1), Util.getStack(CRItems.DRAGON_FRUIT_SEEDS, new int[0]), 5, 1, 1.0f));
        }
        if (Util.enabled(CRItems.LUCUMA)) {
            trades.add((ent, r) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 3), Util.getStack(CRItems.LUCUMA, new int[]{3}), 5, 1, 1.0f));
            if (Util.enabled(CRItems.GILDED_LUCUMA)) {
                trades.add((ent, r) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 10), Util.getStack(CRItems.GILDED_LUCUMA, new int[]{1}), 5, 1, 1.0f));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onReboundDamage(LivingDamageEvent e) {
        MobEffectInstance effectInstance;
        ServerLevel server;
        Level level;
        LivingEntity hurt = e.getEntity();
        MobEffect rebound = (MobEffect)CREffects.REBOUND.get();
        if (!hurt.m_9236_().m_5776_() && hurt.m_21023_(rebound) && e.getAmount() > 0.0f && (level = hurt.m_9236_()) instanceof ServerLevel && (double)(server = (ServerLevel)level).m_213780_().m_188501_() <= (Double)CRConfig.REBOUND_CHANCE.get() && (effectInstance = hurt.m_21124_(rebound)) != null) {
            float initialDamage;
            float recoveredHealth = 6.0f * (float)effectInstance.m_19564_() + 10.0f;
            if (recoveredHealth > (initialDamage = e.getAmount())) {
                e.setAmount(0.0f);
                hurt.m_5634_(recoveredHealth - initialDamage);
            } else {
                e.setAmount(initialDamage - recoveredHealth);
            }
            server.m_6263_(null, hurt.m_20185_(), hurt.m_20186_(), hurt.m_20189_(), (SoundEvent)CRSoundEvents.REBOUND_HEAL.get(), SoundSource.NEUTRAL, 0.8f, 0.8f);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onSurgeDamage(LivingDamageEvent e) {
        MobEffectInstance effectInstance;
        Player player;
        LivingEntity living;
        Entity entity;
        MobEffect surge = (MobEffect)CREffects.SURGE.get();
        DamageSource source = e.getSource();
        LivingEntity hurt = e.getEntity();
        if (source.m_269533_(CRDamageSources.TRIGGERS_SURGE) && (entity = source.m_7639_()) instanceof LivingEntity && !(living = (LivingEntity)entity).m_9236_().m_5776_() && living.m_21023_(surge) && (!(living instanceof Player) || (player = (Player)living).m_36403_(0.0f) > 0.8f) && (effectInstance = living.m_21124_(surge)) != null) {
            float beforeDamage = e.getAmount();
            int amplifier = effectInstance.m_19564_();
            float f = beforeDamage + (float)amplifier + 1.0f;
            e.setAmount(Util.roundToHalf(f * (switch (amplifier) {
                case 0 -> (float)((Double)CRConfig.SURGE_ZERO_MULTIPLIER.get()).doubleValue();
                case 1 -> (float)((Double)CRConfig.SURGE_ONE_MULTIPLIER.get()).doubleValue();
                case 2 -> (float)((Double)CRConfig.SURGE_TWO_MULTIPLIER.get()).doubleValue();
                default -> 1.0f;
            })));
            if (amplifier == 2) {
                SurgeEffect.emitParticles(hurt, 12);
                hurt.m_147240_(2.2, -living.m_20154_().m_7096_(), -living.m_20154_().m_7094_());
            } else {
                SurgeEffect.emitParticles(hurt, 3);
            }
            Util.removeEffect(living, surge);
            living.m_7292_(new MobEffectInstance(surge, effectInstance.m_19557_(), amplifier >= 2 ? 0 : Math.min(2, amplifier + 1), effectInstance.m_19571_(), effectInstance.m_19572_(), effectInstance.m_19575_()));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onCorrodeWeapon(LivingDamageEvent e) {
        LivingEntity victim = e.getEntity();
        Entity entity = e.getSource().m_7640_();
        if (entity instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)entity;
            if (victim.m_21023_((MobEffect)CREffects.CORROSION.get())) {
                int amplifier = victim.m_21124_((MobEffect)CREffects.CORROSION.get()).m_19564_();
                InteractionHand hand = attacker.m_7655_();
                ItemStack stack = attacker.m_21120_(hand);
                Level level = victim.m_9236_();
                if (level instanceof ServerLevel) {
                    ServerLevel server = (ServerLevel)level;
                    if (stack.m_41763_()) {
                        stack.m_41622_(amplifier, victim, en -> en.m_21190_(hand));
                        CorrosionEffect.emitParticles(victim, amplifier);
                        server.m_6263_(null, victim.m_20185_(), victim.m_20186_(), victim.m_20189_(), (SoundEvent)CRSoundEvents.CORROSION_CORRODE.get(), SoundSource.NEUTRAL, 0.8f, 1.1f);
                    }
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onCorrodeProjectile(ProjectileImpactEvent e) {
        LivingEntity victim;
        EntityHitResult result;
        HitResult hitResult;
        Projectile projectile = e.getProjectile();
        if (!projectile.m_6095_().m_204039_(CREntityTags.CORROSION_IMMUNE) && (hitResult = e.getRayTraceResult()) instanceof EntityHitResult && (hitResult = (result = (EntityHitResult)hitResult).m_82443_()) instanceof LivingEntity && (victim = (LivingEntity)hitResult).m_21023_((MobEffect)CREffects.CORROSION.get())) {
            int amplifier = victim.m_21124_((MobEffect)CREffects.CORROSION.get()).m_19564_();
            Level level = victim.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel server = (ServerLevel)level;
                e.setCanceled(true);
                if (projectile instanceof ThrownTrident) {
                    ThrownTrident trident = (ThrownTrident)projectile;
                    trident.f_37555_.m_220157_(5 * amplifier, victim.m_217043_(), null);
                } else {
                    projectile.m_146870_();
                    projectile.m_146850_(GameEvent.f_223707_);
                }
                CorrosionEffect.emitParticles(victim, amplifier);
                server.m_6263_(null, victim.m_20185_(), victim.m_20186_(), victim.m_20189_(), (SoundEvent)CRSoundEvents.CORROSION_CORRODE.get(), SoundSource.NEUTRAL, 0.8f, 1.1f);
            }
        }
    }

    private boolean validateVolatile(LivingEntity attacker) {
        Player p;
        return attacker != null && attacker.m_21023_((MobEffect)CREffects.VOLATILITY.get()) && !attacker.m_6095_().m_204039_(CREntityTags.INVOLATILE) && (!(attacker instanceof Player) || (p = (Player)attacker).m_36403_(0.0f) == 1.0f);
    }

    @SubscribeEvent
    public void onVolatile(LivingDamageEvent e) {
        Level level;
        LivingEntity victim = e.getEntity();
        if (victim instanceof Mob && e.getSource().m_7639_() != null && !victim.m_9236_().m_5776_() && (level = victim.m_9236_()) instanceof ServerLevel) {
            LivingEntity attacker;
            ServerLevel server = (ServerLevel)level;
            if (!victim.m_21023_(MobEffects.f_19606_) && (level = e.getSource().m_7639_()) instanceof LivingEntity && (attacker = (LivingEntity)level) != victim && this.validateVolatile(attacker)) {
                server.m_8767_((ParticleOptions)((SimpleParticleType)CRParticleTypes.SHOCKWAVE.get()), victim.m_20185_(), victim.m_20186_(), victim.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
                int level2 = Objects.requireNonNull(attacker.m_21124_((MobEffect)CREffects.VOLATILITY.get())).m_19564_();
                List mobs = server.m_45971_(Mob.class, TargetingConditions.f_26872_.m_26888_(mob -> {
                    TamableAnimal tame;
                    return mob != attacker && mob != victim && !mob.m_6095_().m_204039_(CREntityTags.VOLATILITY_IMMUNE) && (!(mob instanceof TamableAnimal) || !(tame = (TamableAnimal)mob).m_21824_());
                }), victim, victim.m_20191_().m_82377_(4.0 + (double)level2, 2.0, 4.0 + (double)level2)).stream().limit(3 + level2).toList();
                if (!mobs.isEmpty()) {
                    float hurtAmount = (float)Math.round((e.getAmount() + ((float)level2 + 2.0f) * 0.85f) / (float)(mobs.size() + 1) * 2.0f) / 2.0f;
                    mobs.forEach(mob -> {
                        mob.m_147215_(new MobEffectInstance(MobEffects.f_19606_, 10, 0), null);
                        Vec3 vec32 = mob.m_146892_().m_82546_(victim.m_20182_().m_82520_(0.0, 1.0, 0.0)).m_82541_();
                        mob.m_5496_(SoundEvents.f_12090_, 0.2f, 1.75f);
                        mob.m_6469_(e.getSource(), hurtAmount);
                        double d1 = (1.0 - mob.m_21133_(Attributes.f_22278_)) * 0.75;
                        mob.m_5997_(vec32.m_7096_() * d1, vec32.m_7098_() * d1 * 0.35, vec32.m_7094_() * d1);
                    });
                }
            }
        }
    }

    @SubscribeEvent
    public void onFeedGummy(PlayerInteractEvent.EntityInteractSpecific e) {
        Player player = e.getEntity();
        ItemStack heldStack = e.getItemStack();
        Item item = heldStack.m_41720_();
        if (item instanceof GummyItem) {
            Mob mob;
            GummyItem gummy = (GummyItem)item;
            if (heldStack.m_204117_(CRItemTags.GUMMIES_MOB_FEEDABLE) && (item = e.getTarget()) instanceof Mob && (mob = (Mob)item).m_6084_() && mob.m_5801_()) {
                Level level = player.m_9236_();
                if (level instanceof ServerLevel) {
                    ServerLevel server = (ServerLevel)level;
                    gummy.addEffects(heldStack, (LivingEntity)mob);
                    server.m_5594_(null, mob.m_20183_(), SoundEvents.f_11912_, SoundSource.PLAYERS, 0.65f, 0.65f);
                    for (int i = 0; i < 4; ++i) {
                        server.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.STAR.get()), mob.m_20208_(0.6), mob.m_20187_(), mob.m_20262_(0.6), 1, MathUtils.RAND.nextGaussian() * 0.02, MathUtils.RAND.nextGaussian() * 0.02, MathUtils.RAND.nextGaussian() * 0.02, 0.0);
                    }
                    if (!player.m_150110_().f_35937_) {
                        heldStack.m_41774_(1);
                    }
                }
                e.setCancellationResult(InteractionResult.m_19078_((boolean)player.m_9236_().m_5776_()));
                e.setCanceled(true);
            }
        }
    }
}

