/*
 * Decompiled with CFR 0.152.
 */
package net.brdle.collectorsreap.common.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import net.brdle.collectorsreap.Util;
import net.brdle.collectorsreap.common.config.CRConfig;
import net.brdle.collectorsreap.common.loot.CRLootItemConditions;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public class LootItemEnabledCondition
implements LootItemCondition {
    final String item;

    LootItemEnabledCondition(String item) {
        this.item = item;
    }

    private static LootItemCondition.Builder enabled(String item) {
        return () -> new LootItemEnabledCondition(item);
    }

    public static LootItemCondition.Builder enabled(RegistryObject<? extends ItemLike> item) {
        return LootItemEnabledCondition.enabled(Util.name(item));
    }

    @NotNull
    public LootItemConditionType m_7940_() {
        return (LootItemConditionType)CRLootItemConditions.ENABLED.get();
    }

    public boolean test(LootContext context) {
        return CRConfig.verify(this.item);
    }

    public static class Serializer
    implements net.minecraft.world.level.storage.loot.Serializer<LootItemEnabledCondition> {
        public void serialize(JsonObject object, LootItemEnabledCondition condition, @NotNull JsonSerializationContext context) {
            object.addProperty("item", condition.item);
        }

        @NotNull
        public LootItemEnabledCondition deserialize(@NotNull JsonObject object, @NotNull JsonDeserializationContext context) {
            return new LootItemEnabledCondition(GsonHelper.m_13906_((JsonObject)object, (String)"item"));
        }
    }
}

