/*
 * Decompiled with CFR 0.152.
 */
package net.brdle.collectorsreap.compat;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.runtime.IIngredientManager;
import net.brdle.collectorsreap.Util;
import net.brdle.collectorsreap.common.block.CRBlocks;
import net.brdle.collectorsreap.common.config.CRConfig;
import net.brdle.collectorsreap.common.fluid.CRFluids;
import net.brdle.collectorsreap.common.item.CRItems;
import net.brdle.collectorsreap.compat.Modid;
import net.brdle.collectorsreap.proxy.CommonProxy;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    private static final ResourceLocation ID = Util.cr("jei_plugin");

    public void registerRecipes(IRecipeRegistration registration) {
        IIngredientManager manager = registration.getIngredientManager();
        ArrayList<FluidStack> hiddenFluids = new ArrayList<FluidStack>();
        if (!Modid.FR.loaded()) {
            hiddenFluids.addAll(List.of(new FluidStack((Fluid)CRFluids.LIME_JUICE.get(), 1000), new FluidStack((Fluid)CRFluids.STRONG_LIME_JUICE.get(), 1000), new FluidStack((Fluid)CRFluids.BERRY_LIMEADE.get(), 1000), new FluidStack((Fluid)CRFluids.PINK_LIMEADE.get(), 1000), new FluidStack((Fluid)CRFluids.MINT_LIMEADE.get(), 1000), new FluidStack((Fluid)CRFluids.LIME_GREEN_TEA.get(), 1000), new FluidStack((Fluid)CRFluids.POMEGRANATE_BLACK_TEA.get(), 1000), new FluidStack((Fluid)CRFluids.VERNAL_PURGE.get(), 1000), new FluidStack((Fluid)CRFluids.STRONG_VERNAL_PURGE.get(), 1000), new FluidStack((Fluid)CRFluids.LIMBO_BREW.get(), 1000), new FluidStack((Fluid)CRFluids.LONG_LIMBO_BREW.get(), 1000), new FluidStack((Fluid)CRFluids.STRONG_LIMBO_BREW.get(), 1000), new FluidStack((Fluid)CRFluids.SWEET_RECOVERY.get(), 1000), new FluidStack((Fluid)CRFluids.LONG_SWEET_RECOVERY.get(), 1000), new FluidStack((Fluid)CRFluids.STRONG_SWEET_RECOVERY.get(), 1000)));
        }
        if (!Modid.BC.loaded()) {
            hiddenFluids.addAll(List.of(new FluidStack((Fluid)CRFluids.CREAM_CHEESE.get(), 1000), new FluidStack((Fluid)CRFluids.DEIFIC_BLOOD.get(), 1000), new FluidStack((Fluid)CRFluids.HERMITS_SOUR.get(), 1000), new FluidStack((Fluid)CRFluids.ROSE_MOON.get(), 1000), new FluidStack((Fluid)CRFluids.REANIMATORS_GARDEN.get(), 1000), new FluidStack((Fluid)CRFluids.HEAVENS_CREAM.get(), 1000)));
        }
        if (!CommonProxy.getHiddenItems().isEmpty()) {
            manager.removeIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, CommonProxy.getHiddenItems().stream().map(RegistryObject::get).map(ItemStack::new).toList());
        }
        if (!hiddenFluids.isEmpty()) {
            manager.removeIngredientsAtRuntime((IIngredientType)ForgeTypes.FLUID_STACK, hiddenFluids);
        }
        registration.addItemStackInfo(Util.getStack(CRBlocks.PORTOBELLO, new int[0]), new Component[]{Component.m_237115_((String)("desc.collectorsreap." + Util.name(CRBlocks.PORTOBELLO)))});
        String limeTranslationKey = "desc.collectorsreap." + Util.name(CRItems.LIME);
        List<ItemStack> limeStack = List.of(Util.getStack(CRItems.LIME, new int[0]), Util.getStack(CRItems.LIME_SLICE, new int[0]));
        if (CRConfig.verify(CRItems.LIME) && ((Boolean)CRConfig.LIME_POLLINATION.get()).booleanValue()) {
            registration.addItemStackInfo(limeStack, new Component[]{Component.m_237115_((String)limeTranslationKey), Component.m_237115_((String)(limeTranslationKey + ".pollination"))});
        } else {
            registration.addItemStackInfo(limeStack, new Component[]{Component.m_237115_((String)limeTranslationKey)});
        }
        String pomTranslationKey = "desc.collectorsreap." + Util.name(CRItems.POMEGRANATE);
        List<ItemStack> pomStack = List.of(Util.getStack(CRItems.POMEGRANATE, new int[0]), Util.getStack(CRItems.POMEGRANATE_SLICE, new int[0]));
        if (CRConfig.verify(CRItems.POMEGRANATE)) {
            if (((Boolean)CRConfig.POMEGRANATE_POLLINATION.get()).booleanValue()) {
                registration.addItemStackInfo(pomStack, new Component[]{Component.m_237115_((String)pomTranslationKey), Component.m_237115_((String)(pomTranslationKey + ".pollination"))});
            } else {
                registration.addItemStackInfo(pomStack, new Component[]{Component.m_237115_((String)pomTranslationKey)});
            }
        }
        String dragonFruitTranslationKey = "desc.collectorsreap." + Util.name(CRItems.PINK_DRAGON_FRUIT);
        List<ItemStack> dragonFruitStack = List.of(Util.getStack(CRBlocks.DRAGON_BUSH, new int[0]), Util.getStack(CRItems.PINK_DRAGON_FRUIT, new int[0]));
        if (CRConfig.verify(CRItems.PINK_DRAGON_FRUIT)) {
            registration.addItemStackInfo(dragonFruitStack, new Component[]{Component.m_237115_((String)dragonFruitTranslationKey)});
        }
        String lucumaTranslationKey = "desc.collectorsreap." + Util.name(CRItems.LUCUMA);
        List<ItemStack> lucumaStack = List.of(Util.getStack(CRBlocks.LUCUMA_SAPLING, new int[0]), Util.getStack(CRItems.LUCUMA, new int[0]));
        if (CRConfig.verify(CRItems.LUCUMA)) {
            registration.addItemStackInfo(lucumaStack, new Component[]{Component.m_237115_((String)lucumaTranslationKey)});
        }
        String dartTranslationKey = "desc.collectorsreap." + Util.name(CRItems.URCHIN_DART);
        if (CRConfig.verify(CRItems.URCHIN_DART)) {
            registration.addItemStackInfo(Util.getStack(CRItems.URCHIN_DART, new int[0]), new Component[]{Component.m_237115_((String)dartTranslationKey)});
        }
        if (Modid.MND.loaded()) {
            if (CRConfig.verify(CRItems.STYGIAN_POMEGRANATE)) {
                registration.addItemStackInfo(Util.getStack(CRItems.STYGIAN_POMEGRANATE, new int[0]), new Component[]{Component.m_237115_((String)("desc.collectorsreap." + Util.name(CRItems.STYGIAN_POMEGRANATE)))});
            }
            registration.addItemStackInfo(Util.getStack(CRItems.PORTOBELLO_COLONY, new int[0]), new Component[]{Component.m_237115_((String)"mynethersdelight.jei.info.mushroom_colony")});
        }
    }

    @NotNull
    public ResourceLocation getPluginUid() {
        return ID;
    }
}

