/*
 * Decompiled with CFR 0.152.
 */
package net.brdle.collectorsreap.compat;

import java.util.Arrays;
import net.brdle.collectorsreap.compat.Modid;
import net.minecraftforge.fml.ModList;
import org.jetbrains.annotations.NotNull;

public class Mods {
    public static String[] names(@NotNull Modid[] modids) {
        return (String[])Arrays.stream(modids).map(Modid::get).toArray(String[]::new);
    }

    public static boolean stringLoaded(@NotNull String stringId) {
        return stringId.equals("collectorsreap") || stringId.equals("farmersdelight") || stringId.equals("minecraft") || ModList.get().isLoaded(stringId);
    }

    public static boolean loaded(Strategy strategy, Modid ... modids) {
        if (modids.length < 1) {
            return true;
        }
        return switch (strategy) {
            default -> throw new IncompatibleClassChangeError();
            case Strategy.AND -> {
                for (Modid mod : modids) {
                    if (mod.loaded()) continue;
                    yield false;
                }
                yield true;
            }
            case Strategy.OR -> {
                for (Modid mod : modids) {
                    if (!mod.loaded()) continue;
                    yield true;
                }
                yield false;
            }
        };
    }

    public static boolean loaded(Modid ... modids) {
        return Mods.loaded(Strategy.AND, modids);
    }

    public static enum Strategy {
        AND,
        OR;

    }
}

