/*
 * Decompiled with CFR 0.152.
 */
package net.brdle.collectorsreap.data.gen;

import java.util.function.Supplier;
import net.brdle.collectorsreap.Util;
import net.brdle.collectorsreap.common.block.CRBlocks;
import net.brdle.collectorsreap.common.effect.CREffects;
import net.brdle.collectorsreap.common.entity.CREntities;
import net.brdle.collectorsreap.common.item.CRItems;
import net.minecraft.data.PackOutput;
import net.minecraft.world.effect.MobEffect;
import net.minecraftforge.common.data.LanguageProvider;

public class CRLanguageProvider
extends LanguageProvider {
    public CRLanguageProvider(PackOutput output) {
        super(output, "collectorsreap", "en_us");
    }

    protected void addTranslations() {
        this.addEntities();
        this.addFluids();
        this.addTooltips();
        this.addText();
        this.addEffects();
        this.addBlocks();
        this.addItems();
        this.addSubtitles();
    }

    private void addEntities() {
        this.addEntityType((Supplier)CREntities.TIGER_PRAWN, "Tiger Prawn");
        this.addEntityType((Supplier)CREntities.PLATINUM_BASS, "Platinum Bass");
        this.addEntityType((Supplier)CREntities.CHIEFTAIN_CRAB, "Chieftain Crab");
        this.addEntityType((Supplier)CREntities.CLAM, "Tide Clam");
        this.addEntityType((Supplier)CREntities.URCHIN, "Urchin");
        this.addEntityType((Supplier)CREntities.URCHIN_DART, "Thrown Urchin Dart");
        this.addEntityType((Supplier)CREntities.SHIMMERING_PEARL, "Thrown Shimmering Pearl");
    }

    private void addFluids() {
        this.add("fluid_type.collectorsreap.cream_cheese_type", "Cream Cheese");
        this.add("fluid_type.collectorsreap.lime_juice_type", "Limeade");
        this.add("fluid_type.collectorsreap.strong_lime_juice_type", "Limeade");
        this.add("fluid_type.collectorsreap.berry_limeade_type", "Berry Limeade");
        this.add("fluid_type.collectorsreap.pink_limeade_type", "Pink Limeade");
        this.add("fluid_type.collectorsreap.mint_limeade_type", "Mint Limeade");
        this.add("fluid_type.collectorsreap.lime_green_tea_type", "Lime Green Tea");
        this.add("fluid_type.collectorsreap.pomegranate_black_tea_type", "Pomegranate Black Tea");
        this.add("fluid_type.collectorsreap.vernal_purge_type", "Vernal Purge");
        this.add("fluid_type.collectorsreap.strong_vernal_purge_type", "Vernal Purge");
        this.add("fluid_type.collectorsreap.limbo_brew_type", "Limbo Brew");
        this.add("fluid_type.collectorsreap.long_limbo_brew_type", "Limbo Brew");
        this.add("fluid_type.collectorsreap.strong_limbo_brew_type", "Limbo Brew");
        this.add("fluid_type.collectorsreap.sweet_recovery_type", "Sweet Recovery");
        this.add("fluid_type.collectorsreap.long_sweet_recovery_type", "Sweet Recovery");
        this.add("fluid_type.collectorsreap.strong_sweet_recovery_type", "Sweet Recovery");
        this.add("fluid_type.collectorsreap.deific_blood_type", "Deific Blood");
        this.add("fluid_type.collectorsreap.hermits_sour_type", "Hermit's Sour");
        this.add("fluid_type.collectorsreap.rose_moon_type", "Ros\u00e9 Moon");
        this.add("fluid_type.collectorsreap.reanimators_garden_type", "Reanimator's Garden");
        this.add("fluid_type.collectorsreap.heavens_cream_type", "Heaven's Cream");
    }

    private void addTooltips() {
        this.addTooltip("disabled", "Disabled");
        this.addTooltip("requires_empty_tag", "Requires empty tag:");
        this.addTooltip("requires_tag", "Requires tag:");
        this.addTooltip("requires_modid", "Requires modid:");
        this.addCRTooltip(Util.name(CRItems.HEMP_GUMMY) + ".when_feeding", "When fed to a mob:");
        this.add("farmersdelight.tooltip.asparagus_aspic", "Tastes Funny");
        this.add("farmersdelight.tooltip.stygian_pomegranate", "Explosive");
        this.add("farmersdelight.tooltip.vernal_purge", "Clears Harmful Effects");
        this.add("farmersdelight.tooltip.strong_vernal_purge", "Clears Harmful Effects");
        this.add("farmersdelight.tooltip.limbo_brew", "Extends Beneficial Effects by 30s");
        this.add("farmersdelight.tooltip.long_limbo_brew", "Extends Beneficial Effects by 15s");
        this.add("farmersdelight.tooltip.strong_limbo_brew", "Extends Beneficial Effects by 60s");
    }

    private void addText() {
        this.add("trim_material.collectorsreap.pearl", "Pearl Material");
        this.add("desc.collectorsreap." + Util.name(CRBlocks.PORTOBELLO), "Portobellos can be rarely found in meadows.");
        this.add("desc.collectorsreap." + Util.name(CRItems.LIME), "Limes can be found as a wild bush in flower forests.");
        this.add("desc.collectorsreap." + Util.name(CRItems.LIME) + ".pollination", "A flowering Lime Bush will grow fruit when pollinated by a Bee.");
        this.add("desc.collectorsreap." + Util.name(CRItems.POMEGRANATE), "Pomegranates can be found as a wild bush in warped forests.");
        this.add("desc.collectorsreap." + Util.name(CRItems.POMEGRANATE) + ".pollination", "A flowering Pomegranate Bush will grow fruit in the Overworld when pollinated by a Bee.");
        this.add("desc.collectorsreap." + Util.name(CRItems.STYGIAN_POMEGRANATE), "A dangerous variant that can be rarely picked from Pomegranate Bushes growing on Resurgent Soil.");
        this.add("desc.collectorsreap." + Util.name(CRItems.PINK_DRAGON_FRUIT), "Pink Dragon Fruits can be found as a wild bush in the badlands.");
        this.add("desc.collectorsreap." + Util.name(CRItems.LUCUMA), "Lucuma Saplings can be found in Ancient Cities, growing a tree that provides a powerful fruit.");
        this.add("desc.collectorsreap." + Util.name(CRItems.URCHIN_DART), "Poisonous projectiles that can be thrown by hand or fired using Bamboo in your offhand.");
        this.add("itemGroup.collectorsreap", "Collector's Reap");
        this.add("config.jade.plugin_collectorsreap.crop_progress", "Crop Progress");
    }

    private void addEffects() {
        this.addEffect((Supplier)CREffects.CORROSION, "Corrosion");
        this.add(((MobEffect)CREffects.CORROSION.get()).m_19481_() + ".description", "A defensive acid shield that corrodes incoming projectiles and weapons.");
        this.addEffect((Supplier)CREffects.VOLATILITY, "Volatility");
        this.add(((MobEffect)CREffects.VOLATILITY.get()).m_19481_() + ".description", "Striking an enemy creates a shockwave of splash damage.");
        this.addEffect((Supplier)CREffects.SURGE, "Surge");
        this.add(((MobEffect)CREffects.SURGE.get()).m_19481_() + ".description", "Increases melee damage; gaining amplifier with successful strikes. Resets upon landing a hit at maximum amplifier.");
        this.addEffect((Supplier)CREffects.REBOUND, "Rebound");
        this.add(((MobEffect)CREffects.REBOUND.get()).m_19481_() + ".description", "Provides a chance to recover health when taking damage.");
    }

    private void addBlocks() {
        this.addBlock((Supplier)CRBlocks.PORTOBELLO, "Portobello Mushroom");
        this.addBlock((Supplier)CRBlocks.PORTOBELLO_COLONY, "Portobello Mushroom Colony");
        this.addBlock((Supplier)CRBlocks.PORTOBELLO_QUICHE, "Portobello Quiche");
        this.addBlock((Supplier)CRBlocks.LIME_PIE, "Key Lime Pie");
        this.addBlock((Supplier)CRBlocks.LIME_BUSH, "Lime Bush");
        this.addBlock((Supplier)CRBlocks.LIME_CRATE, "Lime Crate");
        this.addBlock((Supplier)CRBlocks.POMEGRANATE_BUSH, "Pomegranate Bush");
        this.addBlock((Supplier)CRBlocks.POMEGRANATE_CRATE, "Pomegranate Crate");
        this.addBlock((Supplier)CRBlocks.STYGIAN_POMEGRANATE_CRATE, "Stygian Pomegranate Crate");
        this.addBlock((Supplier)CRBlocks.DRAGON_BUSH, "Dragon Bush");
        this.addBlock((Supplier)CRBlocks.BUDDING_PINK_DRAGON_FRUIT_CROP, "Budding Pink Dragon Fruit Vine");
        this.addBlock((Supplier)CRBlocks.PINK_DRAGON_FRUIT_CROP, "Pink Dragon Fruit Vine");
        this.addBlock((Supplier)CRBlocks.PINK_DRAGON_FRUIT_CRATE, "Pink Dragon Fruit Crate");
        this.addBlock((Supplier)CRBlocks.LUCUMA_CRATE, "Lucuma Crate");
        this.addBlock((Supplier)CRBlocks.GILDED_LUCUMA_CRATE, "Gilded Lucuma Crate");
        this.addBlock((Supplier)CRBlocks.LIME_CAKE, "Lime Cake");
        this.addBlock((Supplier)CRBlocks.CANDLE_LIME_CAKE, "Lime Cake with Candle");
        this.addBlock((Supplier)CRBlocks.WHITE_CANDLE_LIME_CAKE, "Lime Cake with White Candle");
        this.addBlock((Supplier)CRBlocks.ORANGE_CANDLE_LIME_CAKE, "Lime Cake with Orange Candle");
        this.addBlock((Supplier)CRBlocks.MAGENTA_CANDLE_LIME_CAKE, "Lime Cake with Magenta Candle");
        this.addBlock((Supplier)CRBlocks.LIME_CANDLE_LIME_CAKE, "Lime Cake with Lime Candle");
        this.addBlock((Supplier)CRBlocks.PINK_CANDLE_LIME_CAKE, "Lime Cake with Pink Candle");
        this.addBlock((Supplier)CRBlocks.GRAY_CANDLE_LIME_CAKE, "Lime Cake with Gray Candle");
        this.addBlock((Supplier)CRBlocks.LIGHT_GRAY_CANDLE_LIME_CAKE, "Lime Cake with Light Gray Candle");
        this.addBlock((Supplier)CRBlocks.CYAN_CANDLE_LIME_CAKE, "Lime Cake with Cyan Candle");
        this.addBlock((Supplier)CRBlocks.PURPLE_CANDLE_LIME_CAKE, "Lime Cake with Purple Candle");
        this.addBlock((Supplier)CRBlocks.BLUE_CANDLE_LIME_CAKE, "Lime Cake with Blue Candle");
        this.addBlock((Supplier)CRBlocks.BROWN_CANDLE_LIME_CAKE, "Lime Cake with Brown Candle");
        this.addBlock((Supplier)CRBlocks.GREEN_CANDLE_LIME_CAKE, "Lime Cake with Green Candle");
        this.addBlock((Supplier)CRBlocks.RED_CANDLE_LIME_CAKE, "Lime Cake with Red Candle");
        this.addBlock((Supplier)CRBlocks.BLACK_CANDLE_LIME_CAKE, "Lime Cake with Black Candle");
        this.addBlock((Supplier)CRBlocks.POMEGRANATE_CAKE, "Pomegranate Cake");
        this.addBlock((Supplier)CRBlocks.CANDLE_POMEGRANATE_CAKE, "Pomegranate Cake with Candle");
        this.addBlock((Supplier)CRBlocks.WHITE_CANDLE_POMEGRANATE_CAKE, "Pomegranate Cake with White Candle");
        this.addBlock((Supplier)CRBlocks.ORANGE_CANDLE_POMEGRANATE_CAKE, "Pomegranate Cake with Orange Candle");
        this.addBlock((Supplier)CRBlocks.MAGENTA_CANDLE_POMEGRANATE_CAKE, "Pomegranate Cake with Magenta Candle");
        this.addBlock((Supplier)CRBlocks.LIME_CANDLE_POMEGRANATE_CAKE, "Pomegranate Cake with Lime Candle");
        this.addBlock((Supplier)CRBlocks.PINK_CANDLE_POMEGRANATE_CAKE, "Pomegranate Cake with Pink Candle");
        this.addBlock((Supplier)CRBlocks.GRAY_CANDLE_POMEGRANATE_CAKE, "Pomegranate Cake with Gray Candle");
        this.addBlock((Supplier)CRBlocks.LIGHT_GRAY_CANDLE_POMEGRANATE_CAKE, "Pomegranate Cake with Light Gray Candle");
        this.addBlock((Supplier)CRBlocks.CYAN_CANDLE_POMEGRANATE_CAKE, "Pomegranate Cake with Cyan Candle");
        this.addBlock((Supplier)CRBlocks.PURPLE_CANDLE_POMEGRANATE_CAKE, "Pomegranate Cake with Purple Candle");
        this.addBlock((Supplier)CRBlocks.BLUE_CANDLE_POMEGRANATE_CAKE, "Pomegranate Cake with Blue Candle");
        this.addBlock((Supplier)CRBlocks.BROWN_CANDLE_POMEGRANATE_CAKE, "Pomegranate Cake with Brown Candle");
        this.addBlock((Supplier)CRBlocks.GREEN_CANDLE_POMEGRANATE_CAKE, "Pomegranate Cake with Green Candle");
        this.addBlock((Supplier)CRBlocks.RED_CANDLE_POMEGRANATE_CAKE, "Pomegranate Cake with Red Candle");
        this.addBlock((Supplier)CRBlocks.BLACK_CANDLE_POMEGRANATE_CAKE, "Pomegranate Cake with Black Candle");
        this.addBlock((Supplier)CRBlocks.PINK_DRAGON_FRUIT_CAKE, "Pink Dragon Fruit Cake");
        this.addBlock((Supplier)CRBlocks.CANDLE_PINK_DRAGON_FRUIT_CAKE, "Pink Dragon Fruit Cake with Candle");
        this.addBlock((Supplier)CRBlocks.WHITE_CANDLE_PINK_DRAGON_FRUIT_CAKE, "Pink Dragon Fruit Cake with White Candle");
        this.addBlock((Supplier)CRBlocks.ORANGE_CANDLE_PINK_DRAGON_FRUIT_CAKE, "Pink Dragon Fruit Cake with Orange Candle");
        this.addBlock((Supplier)CRBlocks.MAGENTA_CANDLE_PINK_DRAGON_FRUIT_CAKE, "Pink Dragon Fruit Cake with Magenta Candle");
        this.addBlock((Supplier)CRBlocks.LIME_CANDLE_PINK_DRAGON_FRUIT_CAKE, "Pink Dragon Fruit Cake with Lime Candle");
        this.addBlock((Supplier)CRBlocks.PINK_CANDLE_PINK_DRAGON_FRUIT_CAKE, "Pink Dragon Fruit Cake with Pink Candle");
        this.addBlock((Supplier)CRBlocks.GRAY_CANDLE_PINK_DRAGON_FRUIT_CAKE, "Pink Dragon Fruit Cake with Gray Candle");
        this.addBlock((Supplier)CRBlocks.LIGHT_GRAY_CANDLE_PINK_DRAGON_FRUIT_CAKE, "Pink Dragon Fruit Cake with Light Gray Candle");
        this.addBlock((Supplier)CRBlocks.CYAN_CANDLE_PINK_DRAGON_FRUIT_CAKE, "Pink Dragon Fruit Cake with Cyan Candle");
        this.addBlock((Supplier)CRBlocks.PURPLE_CANDLE_PINK_DRAGON_FRUIT_CAKE, "Pink Dragon Fruit Cake with Purple Candle");
        this.addBlock((Supplier)CRBlocks.BLUE_CANDLE_PINK_DRAGON_FRUIT_CAKE, "Pink Dragon Fruit Cake with Blue Candle");
        this.addBlock((Supplier)CRBlocks.BROWN_CANDLE_PINK_DRAGON_FRUIT_CAKE, "Pink Dragon Fruit Cake with Brown Candle");
        this.addBlock((Supplier)CRBlocks.GREEN_CANDLE_PINK_DRAGON_FRUIT_CAKE, "Pink Dragon Fruit Cake with Green Candle");
        this.addBlock((Supplier)CRBlocks.RED_CANDLE_PINK_DRAGON_FRUIT_CAKE, "Pink Dragon Fruit Cake with Red Candle");
        this.addBlock((Supplier)CRBlocks.BLACK_CANDLE_PINK_DRAGON_FRUIT_CAKE, "Pink Dragon Fruit Cake with Black Candle");
        this.addBlock((Supplier)CRBlocks.LUCUMA_CAKE, "Lucuma Cake");
        this.addBlock((Supplier)CRBlocks.CANDLE_LUCUMA_CAKE, "Lucuma Cake with Candle");
        this.addBlock((Supplier)CRBlocks.WHITE_CANDLE_LUCUMA_CAKE, "Lucuma Cake with White Candle");
        this.addBlock((Supplier)CRBlocks.ORANGE_CANDLE_LUCUMA_CAKE, "Lucuma Cake with Orange Candle");
        this.addBlock((Supplier)CRBlocks.MAGENTA_CANDLE_LUCUMA_CAKE, "Lucuma Cake with Magenta Candle");
        this.addBlock((Supplier)CRBlocks.LIME_CANDLE_LUCUMA_CAKE, "Lucuma Cake with Lime Candle");
        this.addBlock((Supplier)CRBlocks.PINK_CANDLE_LUCUMA_CAKE, "Lucuma Cake with Pink Candle");
        this.addBlock((Supplier)CRBlocks.GRAY_CANDLE_LUCUMA_CAKE, "Lucuma Cake with Gray Candle");
        this.addBlock((Supplier)CRBlocks.LIGHT_GRAY_CANDLE_LUCUMA_CAKE, "Lucuma Cake with Light Gray Candle");
        this.addBlock((Supplier)CRBlocks.CYAN_CANDLE_LUCUMA_CAKE, "Lucuma Cake with Cyan Candle");
        this.addBlock((Supplier)CRBlocks.PURPLE_CANDLE_LUCUMA_CAKE, "Lucuma Cake with Purple Candle");
        this.addBlock((Supplier)CRBlocks.BLUE_CANDLE_LUCUMA_CAKE, "Lucuma Cake with Blue Candle");
        this.addBlock((Supplier)CRBlocks.BROWN_CANDLE_LUCUMA_CAKE, "Lucuma Cake with Brown Candle");
        this.addBlock((Supplier)CRBlocks.GREEN_CANDLE_LUCUMA_CAKE, "Lucuma Cake with Green Candle");
        this.addBlock((Supplier)CRBlocks.RED_CANDLE_LUCUMA_CAKE, "Lucuma Cake with Red Candle");
        this.addBlock((Supplier)CRBlocks.BLACK_CANDLE_LUCUMA_CAKE, "Lucuma Cake with Black Candle");
        this.addBlock((Supplier)CRBlocks.LIME_ICE_CREAM_BLOCK, "Lime Ice Cream Block");
        this.addBlock((Supplier)CRBlocks.POMEGRANATE_ICE_CREAM_BLOCK, "Pomegranate Ice Cream Block");
        this.addBlock((Supplier)CRBlocks.PINK_DRAGON_FRUIT_ICE_CREAM_BLOCK, "Pink Dragon Fruit Ice Cream Block");
        this.addBlock((Supplier)CRBlocks.LUCUMA_ICE_CREAM_BLOCK, "Lucuma Ice Cream Block");
        this.addBlock((Supplier)CRBlocks.LIME_MILKSHAKE_CAULDRON, "Lime Milkshake Cauldron");
        this.addBlock((Supplier)CRBlocks.POMEGRANATE_MILKSHAKE_CAULDRON, "Pomegranate Milkshake Cauldron");
        this.addBlock((Supplier)CRBlocks.PINK_DRAGON_FRUIT_MILKSHAKE_CAULDRON, "Pink Dragon Fruit Milkshake Cauldron");
        this.addBlock((Supplier)CRBlocks.LUCUMA_MILKSHAKE_CAULDRON, "Lucuma Milkshake Cauldron");
        this.addBlock((Supplier)CRBlocks.URCHIN_TEST_BLOCK, "Urchin Test Block");
        this.addBlock((Supplier)CRBlocks.URCHIN_TEST_BRICKS, "Urchin Test Bricks");
        this.addBlock((Supplier)CRBlocks.URCHIN_TEST_BRICK_SLAB, "Urchin Test Brick Slab");
        this.addBlock((Supplier)CRBlocks.URCHIN_TEST_BRICK_STAIRS, "Urchin Test Brick Stairs");
        this.addBlock((Supplier)CRBlocks.URCHIN_TEST_BRICK_WALL, "Urchin Test Brick Wall");
        this.addBlock((Supplier)CRBlocks.CHISELED_URCHIN_TEST_BRICKS, "Chiseled Urchin Test Bricks");
        this.addBlock((Supplier)CRBlocks.URCHIN_TEST_TILES, "Urchin Test Tiles");
        this.addBlock((Supplier)CRBlocks.URCHIN_TEST_TILE_SLAB, "Urchin Test Tile Slab");
        this.addBlock((Supplier)CRBlocks.URCHIN_TEST_TILE_STAIRS, "Urchin Test Tile Stairs");
        this.addBlock((Supplier)CRBlocks.URCHIN_TEST_TILE_WALL, "Urchin Test Tile Wall");
        this.addBlock((Supplier)CRBlocks.PLATINUM_BASS_ROE, "Platinum Bass Roe");
        this.addBlock((Supplier)CRBlocks.TIGER_PRAWN_ROE, "Tiger Prawn Roe");
        this.addBlock((Supplier)CRBlocks.LUCUMA_LOG, "Lucuma Log");
        this.addBlock((Supplier)CRBlocks.LUCUMA_WOOD, "Lucuma Wood");
        this.addBlock((Supplier)CRBlocks.STRIPPED_LUCUMA_LOG, "Stripped Lucuma Log");
        this.addBlock((Supplier)CRBlocks.STRIPPED_LUCUMA_WOOD, "Stripped Lucuma Wood");
        this.addBlock((Supplier)CRBlocks.LUCUMA_PLANKS, "Lucuma Planks");
        this.addBlock((Supplier)CRBlocks.LUCUMA_STAIRS, "Lucuma Stairs");
        this.addBlock((Supplier)CRBlocks.LUCUMA_SLAB, "Lucuma Slab");
        this.addBlock((Supplier)CRBlocks.LUCUMA_FENCE, "Lucuma Fence");
        this.addBlock((Supplier)CRBlocks.LUCUMA_FENCE_GATE, "Lucuma Fence Gate");
        this.addBlock((Supplier)CRBlocks.LUCUMA_DOOR, "Lucuma Door");
        this.addBlock((Supplier)CRBlocks.LUCUMA_TRAPDOOR, "Lucuma Trapdoor");
        this.addBlock((Supplier)CRBlocks.LUCUMA_PRESSURE_PLATE, "Lucuma Pressure Plate");
        this.addBlock((Supplier)CRBlocks.LUCUMA_BUTTON, "Lucuma Button");
        this.addBlock((Supplier)CRBlocks.LUCUMA_SIGN, "Lucuma Sign");
        this.addBlock((Supplier)CRBlocks.LUCUMA_HANGING_SIGN, "Lucuma Hanging Sign");
        this.addBlock((Supplier)CRBlocks.LUCUMA_SAPLING, "Lucuma Sapling");
        this.addBlock((Supplier)CRBlocks.POTTED_LUCUMA_SAPLING, "Potted Lucuma Sapling");
        this.addBlock((Supplier)CRBlocks.LUCUMA_LEAVES, "Lucuma Leaves");
        this.addBlock((Supplier)CRBlocks.LUCUMA_LEAF_PILE, "Pile of Lucuma Leaves");
        this.addBlock((Supplier)CRBlocks.LUCUMA_CABINET, "Lucuma Cabinet");
        this.addBlock((Supplier)CRBlocks.LUCUMA_BEEHIVE, "Lucuma Beehive");
        this.addBlock((Supplier)CRBlocks.LUCUMA_LADDER, "Lucuma Ladder");
        this.addBlock((Supplier)CRBlocks.LUCUMA_BOOKSHELF, "Lucuma Bookshelf");
        this.addBlock((Supplier)CRBlocks.CHISELED_LUCUMA_BOOKSHELF, "Chiseled Lucuma Bookshelf");
        this.addBlock((Supplier)CRBlocks.LUCUMA_BOARDS, "Lucuma Boards");
        this.addBlock((Supplier)CRBlocks.LUCUMA_CHEST, "Lucuma Chest");
        this.addBlock((Supplier)CRBlocks.TRAPPED_LUCUMA_CHEST, "Trapped Lucuma Chest");
    }

    private void addItems() {
        this.addItem((Supplier)CRItems.LUCUMA_BOAT, "Lucuma Boat");
        this.addItem((Supplier)CRItems.LUCUMA_CHEST_BOAT, "Lucuma Boat with Chest");
        this.addItem((Supplier)CRItems.LUCUMA_FURNACE_BOAT, "Lucuma Boat with Furnace");
        this.addItem((Supplier)CRItems.LARGE_LUCUMA_BOAT, "Large Lucuma Boat");
        this.addItem((Supplier)CRItems.BAKED_PORTOBELLO_CAP, "Baked Portobello Cap");
        this.addItem((Supplier)CRItems.STUFFED_PORTOBELLO_CAP, "Stuffed Portobello");
        this.addItem((Supplier)CRItems.PORTOBELLO_BURGER, "Portoburger");
        this.addItem((Supplier)CRItems.PORTOBELLO_PASTA, "Pasta with Mushroom");
        this.addItem((Supplier)CRItems.PORTOBELLO_RISOTTO, "Portobello Risotto");
        this.addItem((Supplier)CRItems.PORTOBELLO_WRAP, "Portobello Wrap");
        this.addItem((Supplier)CRItems.PORTOBELLO_RICE_SOUP, "Wild Rice Soup");
        this.addItem((Supplier)CRItems.PORTOBELLO_RICE_SOUP_CUP, "Wild Rice Soup Cup");
        this.addItem((Supplier)CRItems.PORTOBELLO_QUICHE_SLICE, "Slice of Portobello Quiche");
        this.addItem((Supplier)CRItems.LUCUMA, "Lucuma");
        this.addItem((Supplier)CRItems.GILDED_LUCUMA, "Gilded Lucuma");
        this.addItem((Supplier)CRItems.LUCUMA_BREAD, "Lucuma Bread");
        this.addItem((Supplier)CRItems.LUCUMA_PUDDING, "Lucuma Pudding");
        this.addItem((Supplier)CRItems.LUCUMA_GAZPACHO, "Lucuma Gazpacho");
        this.addItem((Supplier)CRItems.LUCUMA_GAZPACHO_CUP, "Lucuma Gazpacho Cup");
        this.addItem((Supplier)CRItems.PINK_DRAGON_FRUIT, "Pink Dragon Fruit");
        this.addItem((Supplier)CRItems.DRIED_PINK_DRAGON_FRUIT, "Dried Pink Dragon Fruit");
        this.addItem((Supplier)CRItems.PINK_NOODLES, "Pink Noodles");
        this.addItem((Supplier)CRItems.DRAGON_STEW, "Dragon Stew");
        this.addItem((Supplier)CRItems.DRAGON_STEW_CUP, "Dragon Stew Cup");
        this.addItem((Supplier)CRItems.TROPICAL_SHAVED_ICE, "Tropical Shaved Ice");
        this.addItem((Supplier)CRItems.DRAGONS_PASSION, "Dragon's Passion");
        this.addItem((Supplier)CRItems.DRAGON_FRUIT_SEEDS, "Dragon Fruit Seeds");
        this.addItem((Supplier)CRItems.LIME_PIE_SLICE, "Slice of Key Lime Pie");
        this.addItem((Supplier)CRItems.LIME, "Lime");
        this.addItem((Supplier)CRItems.LIME_SEEDS, "Lime Seeds");
        this.addItem((Supplier)CRItems.LIME_SLICE, "Lime Slice");
        this.addItem((Supplier)CRItems.LIME_POPSICLE, "Lime Popsicle");
        this.addItem((Supplier)CRItems.LIME_COOKIE, "Lime Cookie");
        this.addItem((Supplier)CRItems.CANDIED_LIME, "Candied Lime");
        this.addItem((Supplier)CRItems.HONEY_LIME_CHICKEN, "Honey Lime Chicken");
        this.addItem((Supplier)CRItems.COD_CEVICHE, "Cod Ceviche");
        this.addItem((Supplier)CRItems.MEDITERRANEAN_SALMON, "Mediterranean Salmon");
        this.addItem((Supplier)CRItems.SALMON_TARTARE, "Salmon Tartare");
        this.addItem((Supplier)CRItems.POTATO_FRITTERS, "Potato Fritters");
        this.addItem((Supplier)CRItems.LIMEADE, "Limeade");
        this.addItem((Supplier)CRItems.STRONG_LIMEADE, "Limeade");
        this.addItem((Supplier)CRItems.BERRY_LIMEADE, "Berry Limeade");
        this.addItem((Supplier)CRItems.MINT_LIMEADE, "Mint Limeade");
        this.addItem((Supplier)CRItems.LIME_GREEN_TEA, "Lime Green Tea");
        this.addItem((Supplier)CRItems.POMEGRANATE_BLACK_TEA, "Pomegranate Black Tea");
        this.addItem((Supplier)CRItems.VERNAL_PURGE, "Vernal Purge");
        this.addItem((Supplier)CRItems.STRONG_VERNAL_PURGE, "Vernal Purge");
        this.addItem((Supplier)CRItems.LIMBO_BREW, "Limbo Brew");
        this.addItem((Supplier)CRItems.LONG_LIMBO_BREW, "Limbo Brew");
        this.addItem((Supplier)CRItems.STRONG_LIMBO_BREW, "Limbo Brew");
        this.addItem((Supplier)CRItems.SWEET_RECOVERY, "Sweet Recovery");
        this.addItem((Supplier)CRItems.LONG_SWEET_RECOVERY, "Sweet Recovery");
        this.addItem((Supplier)CRItems.STRONG_SWEET_RECOVERY, "Sweet Recovery");
        this.addItem((Supplier)CRItems.POMEGRANATE_SMOOTHIE, "Pomegranate Smoothie");
        this.addItem((Supplier)CRItems.POMEGRANATE, "Pomegranate");
        this.addItem((Supplier)CRItems.POMEGRANATE_SEEDS, "Pomegranate Seeds");
        this.addItem((Supplier)CRItems.POMEGRANATE_SLICE, "Pomegranate Slice");
        this.addItem((Supplier)CRItems.POMEGRANATE_MUTTON, "Pomegranate Mutton");
        this.addItem((Supplier)CRItems.POMEGRANATE_CHICKEN, "Pomegranate Chicken");
        this.addItem((Supplier)CRItems.POMEGRANATE_PORK, "Pomegranate Pork");
        this.addItem((Supplier)CRItems.POMEGRANATE_CUSTARD, "Pomegranate Custard");
        this.addItem((Supplier)CRItems.STYGIAN_POMEGRANATE, "Stygian Pomegranate");
        this.addItem((Supplier)CRItems.PINK_LIMEADE, "Pink Limeade");
        this.addItem((Supplier)CRItems.SPICY_GRENADINE_JELLY, "Spicy Grenadine Jelly");
        this.addItem((Supplier)CRItems.GLAZED_STRIDER, "Glazed Strider");
        this.addItem((Supplier)CRItems.CRIMSON_CARROT_ROAST, "Crimson Carrot Roast");
        this.addItem((Supplier)CRItems.DELUXE_SALAD, "Deluxe Salad");
        this.addItem((Supplier)CRItems.CREAM_CHEESE, "Cream Cheese");
        this.addItem((Supplier)CRItems.LIME_CAKE_SLICE, "Slice of Lime Cake");
        this.addItem((Supplier)CRItems.POMEGRANATE_CAKE_SLICE, "Slice of Pomegranate Cake");
        this.addItem((Supplier)CRItems.PINK_DRAGON_FRUIT_CAKE_SLICE, "Slice of Pink Dragon Fruit Cake");
        this.addItem((Supplier)CRItems.LUCUMA_CAKE_SLICE, "Slice of Lucuma Cake");
        this.addItem((Supplier)CRItems.LIME_ICE_CREAM, "Lime Ice Cream");
        this.addItem((Supplier)CRItems.POMEGRANATE_ICE_CREAM, "Pomegranate Ice Cream");
        this.addItem((Supplier)CRItems.PINK_DRAGON_FRUIT_ICE_CREAM, "Pink Dragon Fruit Ice Cream");
        this.addItem((Supplier)CRItems.LUCUMA_ICE_CREAM, "Lucuma Ice Cream");
        this.addItem((Supplier)CRItems.SUNNY_ICE_CREAM, "Sunny Ice Cream");
        this.addItem((Supplier)CRItems.LIME_MILKSHAKE, "Lime Milkshake");
        this.addItem((Supplier)CRItems.POMEGRANATE_MILKSHAKE, "Pomegranate Milkshake");
        this.addItem((Supplier)CRItems.PINK_DRAGON_FRUIT_MILKSHAKE, "Pink Dragon Fruit Milkshake");
        this.addItem((Supplier)CRItems.LUCUMA_MILKSHAKE, "Lucuma Milkshake");
        this.addItem((Supplier)CRItems.CHOCOLATE_ARILS, "Chocolate Arils");
        this.addItem((Supplier)CRItems.POMEGRANATE_BEAN_SALAD, "Pomegranate and Bean Salad");
        this.addItem((Supplier)CRItems.STRAWBERRY_JAM_BUN, "Strawberry Jam Bun");
        this.addItem((Supplier)CRItems.DEIFIC_BLOOD, "Deific Blood");
        this.addItem((Supplier)CRItems.HERMITS_SOUR, "Hermit's Sour");
        this.addItem((Supplier)CRItems.ROSE_MOON, "Ros\u00e9 Moon");
        this.addItem((Supplier)CRItems.REANIMATORS_GARDEN, "Reanimator's Garden");
        this.addItem((Supplier)CRItems.HEAVENS_CREAM, "Heaven's Cream");
        this.addItem((Supplier)CRItems.LIME_GUMMY, "Lime Gummy");
        this.addItem((Supplier)CRItems.POMEGRANATE_GUMMY, "Pomegranate Gummy");
        this.addItem((Supplier)CRItems.PINK_DRAGON_FRUIT_GUMMY, "Pink Dragon Fruit Gummy");
        this.addItem((Supplier)CRItems.LUCUMA_GUMMY, "Lucuma Gummy");
        this.addItem((Supplier)CRItems.MELON_GUMMY, "Melon Gummy");
        this.addItem((Supplier)CRItems.APPLE_GUMMY, "Apple Gummy");
        this.addItem((Supplier)CRItems.GLOW_BERRY_GUMMY, "Glow Berry Gummy");
        this.addItem((Supplier)CRItems.CARROT_GUMMY, "Carrot Gummy");
        this.addItem((Supplier)CRItems.BANANA_GUMMY, "Banana Gummy");
        this.addItem((Supplier)CRItems.VANILLA_GUMMY, "Vanilla Gummy");
        this.addItem((Supplier)CRItems.CHOCOLATE_GUMMY, "Chocolate Gummy");
        this.addItem((Supplier)CRItems.STRAWBERRY_GUMMY, "Strawberry Gummy");
        this.addItem((Supplier)CRItems.MINT_GUMMY, "Mint Gummy");
        this.addItem((Supplier)CRItems.ADZUKI_GUMMY, "Adzuki Gummy");
        this.addItem((Supplier)CRItems.PUMPKIN_GUMMY, "Pumpkin Gummy");
        this.addItem((Supplier)CRItems.SWEET_BERRY_GUMMY, "Sweet Berry Gummy");
        this.addItem((Supplier)CRItems.BEETROOT_GUMMY, "Beetroot Gummy");
        this.addItem((Supplier)CRItems.ALOE_GUMMY, "Aloe Gummy");
        this.addItem((Supplier)CRItems.WILD_BERRY_GUMMY, "Wild Berry Gummy");
        this.addItem((Supplier)CRItems.PASSION_FRUIT_GUMMY, "Passion Fruit Gummy");
        this.addItem((Supplier)CRItems.YUCCA_GUMMY, "Yucca Gummy");
        this.addItem((Supplier)CRItems.GREEN_TEA_GUMMY, "Green Tea Gummy");
        this.addItem((Supplier)CRItems.YELLOW_TEA_GUMMY, "Yellow Tea Gummy");
        this.addItem((Supplier)CRItems.BLACK_TEA_GUMMY, "Black Tea Gummy");
        this.addItem((Supplier)CRItems.COFFEE_GUMMY, "Coffee Gummy");
        this.addItem((Supplier)CRItems.BULLET_PEPPER_GUMMY, "Bullet Pepper Gummy");
        this.addItem((Supplier)CRItems.PRICKLY_PEAR_GUMMY, "Prickly Pear Gummy");
        this.addItem((Supplier)CRItems.PEANUT_GUMMY, "Peanut Gummy");
        this.addItem((Supplier)CRItems.ASPARAGUS_ASPIC, "Asparagus Aspic");
        this.addItem((Supplier)CRItems.HEMP_GUMMY, "Weed Gummy");
        this.addItem((Supplier)CRItems.TIGER_PRAWN_SPAWN_EGG, "Tiger Prawn Spawn Egg");
        this.addItem((Supplier)CRItems.TIGER_PRAWN_BUCKET, "Bucket of Tiger Prawn");
        this.addItem((Supplier)CRItems.TIGER_PRAWN, "Raw Tiger Prawn");
        this.addItem((Supplier)CRItems.COOKED_TIGER_PRAWN, "Cooked Tiger Prawn");
        this.addItem((Supplier)CRItems.PRAWN_ROLL, "Prawn Roll");
        this.addItem((Supplier)CRItems.PRAWN_PO_BOY, "Prawn Po' Boy");
        this.addItem((Supplier)CRItems.PRAWN_STEW, "Prawn Stew");
        this.addItem((Supplier)CRItems.PRAWN_STEW_CUP, "Prawn Stew Cup");
        this.addItem((Supplier)CRItems.PRAWN_CEVICHE, "Prawn Ceviche");
        this.addItem((Supplier)CRItems.PRAWN_NOODLES, "Prawn Noodles");
        this.addItem((Supplier)CRItems.SALMON_WRAPPED_PRAWN, "Salmon Wrapped Prawn");
        this.addItem((Supplier)CRItems.URCHIN_SPAWN_EGG, "Urchin Spawn Egg");
        this.addItem((Supplier)CRItems.URCHIN_BUCKET, "Bucket of Urchin");
        this.addItem((Supplier)CRItems.URCHIN, "Urchin");
        this.addItem((Supplier)CRItems.URCHIN_TEST, "Urchin Test");
        this.addItem((Supplier)CRItems.URCHIN_NEEDLE, "Urchin Needle");
        this.addItem((Supplier)CRItems.URCHIN_DART, "Urchin Dart");
        this.addItem((Supplier)CRItems.UNI, "Uni");
        this.addItem((Supplier)CRItems.UNI_ROLL, "Uni Roll");
        this.addItem((Supplier)CRItems.PLATINUM_BASS_SPAWN_EGG, "Platinum Bass Spawn Egg");
        this.addItem((Supplier)CRItems.PLATINUM_BASS_BUCKET, "Bucket of Platinum Bass");
        this.addItem((Supplier)CRItems.PLATINUM_BASS, "Raw Platinum Bass");
        this.addItem((Supplier)CRItems.COOKED_PLATINUM_BASS, "Cooked Platinum Bass");
        this.addItem((Supplier)CRItems.PLATINUM_BASS_HEAD, "Platinum Bass Head");
        this.addItem((Supplier)CRItems.COOKED_PLATINUM_BASS_HEAD, "Cooked Platinum Bass Head");
        this.addItem((Supplier)CRItems.PLATINUM_BASS_SLICE, "Raw Platinum Bass Slice");
        this.addItem((Supplier)CRItems.COOKED_PLATINUM_BASS_SLICE, "Cooked Platinum Bass Slice");
        this.addItem((Supplier)CRItems.PLATINUM_BASS_STEW, "Platinum Bass Stew");
        this.addItem((Supplier)CRItems.PLATINUM_BASS_STEW_CUP, "Platinum Bass Stew Cup");
        this.addItem((Supplier)CRItems.FISH_MIX, "Fish Mix");
        this.addItem((Supplier)CRItems.CHIEFTAIN_CRAB_SPAWN_EGG, "Chieftain Crab Spawn Egg");
        this.addItem((Supplier)CRItems.CHIEFTAIN_CRAB_BUCKET, "Bucket of Chieftain Crab");
        this.addItem((Supplier)CRItems.CHIEFTAIN_CRAB, "Chieftain Crab");
        this.addItem((Supplier)CRItems.CHIEFTAIN_CLAW, "Chieftain Crab Claw");
        this.addItem((Supplier)CRItems.CHIEFTAIN_LEG, "Chieftain Crab Leg");
        this.addItem((Supplier)CRItems.CHIEFTAIN_CRAB_MEAT, "Chieftain Crab Meat");
        this.addItem((Supplier)CRItems.CRAB_MISO, "Crab Miso");
        this.addItem((Supplier)CRItems.LAND_AND_SEA_BURGER, "Land and Sea Burger");
        this.addItem((Supplier)CRItems.CRAB_NOODLES, "Crab Noodles");
        this.addItem((Supplier)CRItems.CRAB_LASAGNA, "Crab Lasagna");
        this.addItem((Supplier)CRItems.BUTTERED_LEGS, "Buttered Legs");
        this.addItem((Supplier)CRItems.BIG_RICE_BALL, "Big Rice Ball");
        this.addItem((Supplier)CRItems.LUNAR_PEARL, "Lunar Pearl");
        this.addItem((Supplier)CRItems.SHIMMERING_APPLE, "Shimmering Apple");
        this.addItem((Supplier)CRItems.SHIMMERING_PEARL, "Shimmering Pearl");
        this.addItem((Supplier)CRItems.PEARLY_CLAW, "Pearly Claw");
        this.addItem((Supplier)CRItems.CLAM_SPAWN_EGG, "Tide Clam Spawn Egg");
        this.addItem((Supplier)CRItems.CLAM_BUCKET, "Bucket of Tide Clam");
        this.addItem((Supplier)CRItems.CLAM, "Tide Clam");
        this.addItem((Supplier)CRItems.CLAM_MEAT, "Tide Clam Meat");
        this.addItem((Supplier)CRItems.CLAM_ROLL, "Clam Roll");
        this.addItem((Supplier)CRItems.CLAM_CHOWDER, "Clam Chowder");
        this.addItem((Supplier)CRItems.CLAM_PASTA, "Pasta with Clams");
        this.addItem((Supplier)CRItems.CLAM_MEATBALL_STEW, "Clam and Meatball Stew");
        this.addItem((Supplier)CRItems.CLAM_MEATBALL_STEW_CUP, "Clam and Meatball Stew Cup");
        this.addItem((Supplier)CRItems.SEA_WRAP, "Sea Wrap");
    }

    private void addSubtitles() {
        this.add("collectorsreap.subtitle.urchin_dart.throw", "Urchin Dart thrown");
        this.add("collectorsreap.subtitle.urchin_dart.hit", "Urchin Dart hits");
        this.add("collectorsreap.subtitle.shimmering_pearl.throw", "Shimmering Pearl flies");
        this.add("collectorsreap.subtitle.shimmering_pearl.break", "Shimmering Pearl shatters");
        this.add("collectorsreap.subtitle.platinum_bass.death", "Platinum Bass dies");
        this.add("collectorsreap.subtitle.platinum_bass.flop", "Platinum Bass flops");
        this.add("collectorsreap.subtitle.platinum_bass.hurt", "Platinum Bass hurts");
        this.add("collectorsreap.subtitle.lime.pick", "Lime pops");
        this.add("collectorsreap.subtitle.pomegranate.pick", "Pomegranate pops");
        this.add("collectorsreap.subtitle.dragon_fruit.pick", "Dragon Fruit pops");
        this.add("collectorsreap.subtitle.rebound.heal", "Health rebounds");
        this.add("collectorsreap.subtitle.corrosion.corrode", "Acid corrodes");
    }

    public void addTooltip(String key, String translation) {
        this.add("tooltip." + key, translation);
    }

    public void addCRTooltip(String key, String translation) {
        this.addTooltip("collectorsreap." + key, translation);
    }
}

