/*
 * Decompiled with CFR 0.152.
 */
package net.brdle.collectorsreap;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Supplier;
import net.brdle.collectorsreap.common.config.CRConfig;
import net.brdle.collectorsreap.common.item.CRItems;
import net.brdle.collectorsreap.common.item.IConfigured;
import net.brdle.collectorsreap.compat.Modid;
import net.brdle.collectorsreap.compat.Mods;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import net.minecraftforge.registries.tags.ITagManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Util {
    public static final String EMPTY_STR = "";
    public static final Modid[] EMPTY = new Modid[0];
    public static final String MC = "minecraft";
    public static final String LOADER = "forge";
    public static final UUID BLOCK_REACH = UUID.fromString("6ba3d68d-2e14-4b88-92c8-5a6796650af3");

    public static ResourceLocation rl(@NotNull String modid, @NotNull String path) {
        return new ResourceLocation(modid, path);
    }

    public static ResourceLocation rl(@NotNull Modid modid, @NotNull String path) {
        return Util.rl(modid.get(), path);
    }

    public static ResourceLocation rl(@NotNull String separated) {
        return new ResourceLocation(separated);
    }

    public static ResourceLocation rl(ItemLike itemLike) {
        Block block;
        IForgeRegistry reg;
        if (itemLike instanceof Item) {
            IForgeRegistry reg2 = ForgeRegistries.ITEMS;
            Item item = (Item)itemLike;
            if (reg2.containsValue((Object)item)) {
                return reg2.getKey((Object)item);
            }
        } else if (itemLike instanceof Block && (reg = ForgeRegistries.BLOCKS).containsValue((Object)(block = (Block)itemLike))) {
            return reg.getKey((Object)block);
        }
        return Util.rl(EMPTY_STR, EMPTY_STR);
    }

    public static ResourceLocation cr(String path) {
        return Util.rl("collectorsreap", path);
    }

    public static TagKey<Item> it(String id, String path) {
        return ItemTags.create((ResourceLocation)Util.rl(id, path));
    }

    public static TagKey<EntityType<?>> et(Modid modid, String path) {
        return TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)Util.rl(modid, path));
    }

    public static TagKey<EntityType<?>> et(String id, String path) {
        return TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)Util.rl(id, path));
    }

    public static boolean tagEmpty(@Nullable TagKey<Item> tag) {
        if (tag == null) {
            return true;
        }
        ITagManager tags = ForgeRegistries.ITEMS.tags();
        return tags != null && (!tags.isKnownTagName(tag) || tags.getTag(tag).isEmpty());
    }

    public static boolean tagPopulated(@Nullable TagKey<Item> tag) {
        if (tag == null) {
            return true;
        }
        ITagManager tags = ForgeRegistries.ITEMS.tags();
        return tags != null && tags.isKnownTagName(tag) && !tags.getTag(tag).isEmpty();
    }

    public static String tagName(TagKey<?> tagKey) {
        return tagKey.f_203868_().toString();
    }

    public static MutableComponent tagComponent(TagKey<?> tagKey) {
        return Component.m_237113_((String)Util.tagName(tagKey));
    }

    public static ObjectArrayList<ItemStack> with(ObjectArrayList<ItemStack> before, ItemStack addition) {
        before.add((Object)addition);
        return before.clone();
    }

    public static ObjectArrayList<ItemStack> with(ObjectArrayList<ItemStack> before, Item addition, int count) {
        return count < 1 ? before : Util.with(before, new ItemStack((ItemLike)addition, count));
    }

    public static ObjectArrayList<ItemStack> with(ObjectArrayList<ItemStack> before, Item addition, RandomSource rand, int min, int max) {
        if (max < min) {
            return before;
        }
        return Util.with(before, addition, max == min ? min : rand.m_216332_(min, max));
    }

    public static ObjectArrayList<ItemStack> with(ObjectArrayList<ItemStack> before, Item addition) {
        return Util.with(before, addition, 1);
    }

    public static boolean itemExists(ResourceLocation location) {
        return Mods.stringLoaded(location.m_135827_()) && ForgeRegistries.ITEMS.containsKey(location);
    }

    public static boolean blockExists(ResourceLocation location) {
        return Mods.stringLoaded(location.m_135827_()) && ForgeRegistries.BLOCKS.containsKey(location);
    }

    @Nullable
    public static Item item(ResourceLocation rl) {
        return (Item)ForgeRegistries.ITEMS.getValue(rl);
    }

    @Nullable
    public static Item item(String id, String path) {
        return Util.item(Util.rl(id, path));
    }

    @NotNull
    public static Item item(ResourceLocation location, @NotNull Item backup) {
        Item item;
        if (Util.itemExists(location) && (item = Util.item(location)) != null) {
            return item;
        }
        return backup;
    }

    @NotNull
    public static Item item(ResourceLocation location, @NotNull Supplier<Item> backup) {
        return Util.item(location, backup.get());
    }

    @NotNull
    public static ItemStack itemStack(ResourceLocation location, @NotNull ItemStack backup) {
        Item returnItem;
        if (Util.itemExists(location) && (returnItem = Util.item(location)) != null) {
            return new ItemStack((ItemLike)returnItem);
        }
        return backup;
    }

    public static boolean itemStackIs(ItemStack stack, ResourceLocation location) {
        return Util.itemExists(location) && stack.m_150930_(Util.item(location));
    }

    @Nullable
    public static Block block(Modid modid, String path) {
        return Util.block(Util.rl(modid, path));
    }

    @Nullable
    public static Block block(String id, String path) {
        return Util.block(Util.rl(id, path));
    }

    @Nullable
    public static Block block(ResourceLocation rl) {
        return (Block)ForgeRegistries.BLOCKS.getValue(rl);
    }

    public static boolean effectExists(ResourceLocation effect) {
        return Mods.stringLoaded(effect.m_135827_()) && ForgeRegistries.MOB_EFFECTS.containsKey(effect);
    }

    @Nullable
    private static MobEffect getBackup(@Nullable MobEffect[] backup) {
        return backup != null && backup.length > 0 ? backup[0] : null;
    }

    @Nullable
    public static MobEffect effect(ResourceLocation effLocation, MobEffect ... backup) {
        return Util.effectExists(effLocation) ? (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(effLocation) : Util.getBackup(backup);
    }

    @Nullable
    public static MobEffect effect(String id, String name, MobEffect ... backup) {
        return Util.effect(Util.rl(id, name), backup);
    }

    @Nullable
    public static MobEffect effect(Modid modid, String name, MobEffect ... backup) {
        return modid.loaded() ? Util.effect(Util.rl(modid, name), backup) : Util.getBackup(backup);
    }

    public static boolean removeEffect(@NotNull LivingEntity entity, @NotNull MobEffect effect) {
        if (entity.m_21023_(effect) && !MinecraftForge.EVENT_BUS.post((Event)new MobEffectEvent.Remove(entity, effect))) {
            entity.m_21195_(effect);
            return true;
        }
        return false;
    }

    public static void removeEffects(@NotNull LivingEntity entity, @NotNull Collection<MobEffect> effects) {
        for (MobEffect effect : effects) {
            Util.removeEffect(entity, effect);
        }
    }

    public static void addEffect(LivingEntity entity, @Nullable MobEffect effect, int duration, int amp) {
        if (effect != null) {
            entity.m_7292_(new MobEffectInstance(effect, duration, amp));
        }
    }

    public static void addEffect(LivingEntity entity, String modid, String name, int duration, int amp, MobEffect ... backup) {
        MobEffect me = Util.effect(modid, name, backup);
        if (me != null) {
            Util.addEffect(entity, me, duration, amp);
        }
    }

    public static void addEffects(@NotNull LivingEntity entity, @NotNull List<MobEffectInstance> effects) {
        for (MobEffectInstance effect : effects) {
            entity.m_7292_(new MobEffectInstance(effect));
        }
    }

    @NotNull
    public static List<MobEffectInstance> getFoodEffects(@Nullable FoodProperties food) {
        return food == null ? Collections.emptyList() : food.m_38749_().stream().map(Pair::getFirst).map(MobEffectInstance::new).toList();
    }

    public static void addFoodEffects(@NotNull LivingEntity entity, @NotNull FoodProperties food) {
        Util.addEffects(entity, Util.getFoodEffects(food));
    }

    public static List<MobEffect> getCurableEffects(@NotNull LivingEntity entity) {
        Collection active = entity.m_21220_();
        return active.stream().filter(instance -> instance.m_19544_().m_19483_().equals((Object)MobEffectCategory.HARMFUL) && instance.isCurativeItem(new ItemStack((ItemLike)Items.f_42455_))).map(MobEffectInstance::m_19544_).toList();
    }

    public static void removeCurableEffects(@NotNull LivingEntity entity) {
        Util.removeEffects(entity, Util.getCurableEffects(entity));
    }

    public static List<MobEffect> getBeneficialEffects(@NotNull LivingEntity entity) {
        Collection active = entity.m_21220_();
        return active.stream().map(MobEffectInstance::m_19544_).filter(effect -> effect.m_19483_().equals((Object)MobEffectCategory.BENEFICIAL)).toList();
    }

    public static ItemStack getStack(@Nullable Supplier<? extends ItemLike> r, int ... count) {
        if (r == null || r.get() == null) {
            return ItemStack.f_41583_;
        }
        return new ItemStack(Objects.requireNonNull(r.get()), count.length > 0 ? count[0] : 1);
    }

    public static String nameSpace(ItemLike itemLike) {
        return Util.rl(itemLike).m_135827_();
    }

    public static String name(ItemLike itemLike) {
        return Util.rl(itemLike).m_135815_();
    }

    public static String name(RegistryObject<?> reg) {
        return reg.getId().m_135815_();
    }

    public static String nameSpace(ItemStack stack) {
        return Util.nameSpace((ItemLike)stack.m_41720_());
    }

    public static String name(ItemStack stack) {
        return Util.name((ItemLike)stack.m_41720_());
    }

    public static String id(ItemLike item) {
        return Util.rl(item).toString();
    }

    public static Ingredient ing(Supplier<? extends ItemLike> i) {
        return Ingredient.m_43929_((ItemLike[])new ItemLike[]{i.get()});
    }

    public static ItemStack enchant(ItemStack stack, Enchantment enchantment, int level) {
        ItemStack enchanted = stack.m_41777_();
        enchanted.m_41663_(enchantment, level);
        return enchanted;
    }

    public static void drop(Level level, ItemStack stack, BlockPos pos, Direction dir) {
        RandomSource random = level.m_213780_();
        ItemEntity dropItem = new ItemEntity(level, (double)pos.m_123341_() + 0.5 + (double)dir.m_122429_() * 0.65, (double)pos.m_123342_() + 0.1, (double)pos.m_123343_() + 0.5 + (double)dir.m_122431_() * 0.65, stack);
        dropItem.m_20334_(0.05 * (double)dir.m_122429_() + random.m_188500_() * 0.02, 0.05, 0.05 * (double)dir.m_122431_() + random.m_188500_() * 0.02);
        level.m_7967_((Entity)dropItem);
    }

    public static boolean hasTagString(ItemStack stack, String key, String value) {
        if (stack.m_41782_()) {
            CompoundTag tag = stack.m_41783_();
            return tag != null && tag.m_128441_(key) && tag.m_128461_(key).equals(value);
        }
        return false;
    }

    public static boolean configEnabled(String feature) {
        return CRConfig.verify(feature);
    }

    public static boolean configEnabled(@NotNull ItemLike item) {
        return Util.configEnabled(Util.name(item));
    }

    public static boolean enabled(@NotNull ItemLike item) {
        boolean bl;
        if (item instanceof IConfigured) {
            IConfigured conf = (IConfigured)item;
            bl = conf.enabled();
        } else {
            bl = Util.configEnabled(item);
        }
        return bl;
    }

    public static boolean enabled(Supplier<? extends ItemLike> item) {
        return Util.enabled(item.get());
    }

    public static boolean enabled(String item) {
        return CRItems.HELPER.getDeferredRegister().getEntries().stream().filter(reg -> reg.getId().m_135815_().equals(item)).map(Util::enabled).findAny().orElse(Util.configEnabled(item));
    }

    public static MutableComponent translation(String modid, String key) {
        return Component.m_237115_((String)(modid + "." + key));
    }

    public static MutableComponent translation(String modid, String prefix, String key) {
        return Component.m_237115_((String)(prefix + "." + modid + "." + key));
    }

    public static MutableComponent description(String key) {
        return Component.m_237115_((String)("desc.collectorsreap." + key));
    }

    public static MutableComponent tooltip(String key) {
        return Component.m_237115_((String)("tooltip." + key));
    }

    public static MutableComponent crTooltip(String key) {
        return Util.tooltip("collectorsreap." + key);
    }

    public static float roundToHalf(float x) {
        return (float)Math.round(x * 0.5f) / 0.5f;
    }
}

