/*
 * Decompiled with CFR 0.152.
 */
package net.brdle.collectorsreap.common.block;

import java.util.Optional;
import net.brdle.collectorsreap.common.block.PomegranateBushBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.PlantType;
import net.minecraftforge.common.Tags;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FruitBushBlock
extends DoublePlantBlock
implements BonemealableBlock {
    public static final int MAX_AGE = 4;
    public static final IntegerProperty AGE = BlockStateProperties.f_222999_;
    public static BooleanProperty STUNTED = BooleanProperty.m_61465_((String)"stunted");

    public FruitBushBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)AGE, (Comparable)Integer.valueOf(0))).m_61124_((Property)f_52858_, (Comparable)DoubleBlockHalf.LOWER)).m_61124_((Property)STUNTED, (Comparable)Boolean.valueOf(false)));
    }

    public static void placeAt(LevelAccessor level, BlockState state, BlockPos pos, int flags) {
        FruitBushBlock fruit;
        Block block;
        BlockState belowState = (BlockState)((BlockState)state.m_61124_((Property)f_52858_, (Comparable)DoubleBlockHalf.LOWER)).m_61124_((Property)STUNTED, (Comparable)Boolean.valueOf(false));
        if (!belowState.m_61138_((Property)AGE)) {
            belowState.m_61124_((Property)AGE, (Comparable)Integer.valueOf(4));
        }
        if ((Integer)belowState.m_61143_((Property)AGE) <= 1) {
            level.m_7731_(pos, FruitBushBlock.m_182453_((LevelReader)level, (BlockPos)pos, (BlockState)belowState), flags);
        } else if ((Integer)belowState.m_61143_((Property)AGE) > 1 && (block = belowState.m_60734_()) instanceof FruitBushBlock && (fruit = (FruitBushBlock)block).m_7898_(state, (LevelReader)level, pos)) {
            DoublePlantBlock.m_153173_((LevelAccessor)level, (BlockState)belowState, (BlockPos)pos, (int)flags);
        }
    }

    public PlantType getPlantType(BlockGetter level, BlockPos pos) {
        return PlantType.PLAINS;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AGE, STUNTED, f_52858_});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos blockpos = context.m_8083_();
        Level level = context.m_43725_();
        return blockpos.m_123342_() < level.m_151558_() && level.m_8055_(blockpos.m_7494_()).m_60629_(context) ? this.m_49966_() : null;
    }

    public void m_6402_(@NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull BlockState pState, @NotNull LivingEntity pPlacer, @NotNull ItemStack pStack) {
    }

    public boolean m_6724_(BlockState state) {
        return (Integer)state.m_61143_((Property)AGE) < 4 && state.m_61143_((Property)f_52858_) == DoubleBlockHalf.LOWER && (Boolean)state.m_61143_((Property)STUNTED) == false;
    }

    public abstract Item getFruit();

    public abstract Item getSeeds();

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        return new ItemStack((ItemLike)this.getSeeds());
    }

    public Optional<Item> getSpecialFruit() {
        return Optional.empty();
    }

    public boolean hasSpecialFruit() {
        return this.getSpecialFruit().isPresent();
    }

    public int getSpecialChance() {
        return 0;
    }

    public boolean isSpecial(Level level, BlockPos pos) {
        int chance = this.getSpecialChance();
        return this.hasSpecialFruit() & chance > 0 && level.m_213780_().m_188503_(chance) == 0;
    }

    @NotNull
    public InteractionResult m_6227_(BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        if ((Integer)state.m_61143_((Property)AGE) != 4 && player.m_21120_(hand).m_150930_(Items.f_42499_)) {
            return InteractionResult.PASS;
        }
        if (state.m_61143_((Property)f_52858_) == DoubleBlockHalf.UPPER) {
            state = level.m_8055_(pos.m_7495_());
            pos = pos.m_7495_();
        }
        if ((Integer)state.m_61143_((Property)AGE) == 4) {
            if (state.m_60734_() instanceof PomegranateBushBlock && !player.m_21120_(hand).m_204117_(Tags.Items.SHEARS)) {
                player.m_6469_(player.m_269291_().m_269555_(), 1.0f);
            }
            this.dropFruit(level, pos);
            level.m_5594_(null, pos, this.getPickSound(), SoundSource.BLOCKS, 1.0f, 0.8f + level.m_213780_().m_188501_() * 0.4f);
            BlockState picked = (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(2));
            level.m_7731_(pos, picked, 2);
            level.m_7731_(pos.m_7494_(), (BlockState)picked.m_61124_((Property)f_52858_, (Comparable)DoubleBlockHalf.UPPER), 2);
            level.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223719_((Entity)player, (BlockState)picked));
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        if (player.m_21120_(hand).m_41720_() instanceof AxeItem && !state.m_61138_((Property)STUNTED)) {
            BlockState stunted = (BlockState)state.m_61124_((Property)STUNTED, (Comparable)Boolean.valueOf(true));
            level.m_5594_(player, pos, SoundEvents.f_11688_, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.m_46597_(pos, stunted);
            level.m_46597_(pos.m_7494_(), (BlockState)stunted.m_61124_((Property)f_52858_, (Comparable)DoubleBlockHalf.UPPER));
            level.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223719_((Entity)player, (BlockState)stunted));
            player.m_21120_(hand).m_41622_(1, (LivingEntity)player, b -> b.m_21190_(b.m_7655_()));
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        return InteractionResult.PASS;
    }

    public void m_214148_(@NotNull ServerLevel level, @NotNull RandomSource random, @NotNull BlockPos pos, BlockState state) {
        if (state.m_61138_((Property)f_52858_) && state.m_61143_((Property)f_52858_) == DoubleBlockHalf.UPPER) {
            pos = pos.m_7495_();
            state = level.m_8055_(pos);
        }
        state = (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(Math.min(4, (Integer)state.m_61143_((Property)AGE) + 1)));
        level.m_46597_(pos, state);
        if ((Integer)state.m_61143_((Property)AGE) > 1) {
            level.m_46597_(pos.m_7494_(), (BlockState)state.m_61124_((Property)f_52858_, (Comparable)DoubleBlockHalf.UPPER));
        }
    }

    public boolean m_214167_(@NotNull Level level, @NotNull RandomSource randomSource, @NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        return true;
    }

    public int getMaxBonus() {
        return 1;
    }

    public void dropFruit(Level level, BlockPos pos) {
        if (!level.m_5776_()) {
            ItemStack stack = this.isSpecial(level, pos) ? new ItemStack((ItemLike)this.getSpecialFruit().get()) : new ItemStack((ItemLike)this.getFruit(), level.m_213780_().m_216332_(1, 1 + this.getMaxBonus()));
            FruitBushBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)stack);
        }
    }

    public SoundEvent getPickSound() {
        return SoundEvents.f_12457_;
    }
}

