/*
 * Decompiled with CFR 0.152.
 */
package net.brdle.collectorsreap.common.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.IPlantable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TallBushCropBlock
extends DoublePlantBlock
implements BonemealableBlock {
    public TallBushCropBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(0))).m_61124_((Property)f_52858_, (Comparable)DoubleBlockHalf.LOWER));
    }

    public abstract IntegerProperty getAgeProperty();

    public abstract int getMaxAge();

    public abstract int getShortThreshold();

    public boolean isMaxAge(@NotNull BlockState state) {
        return (Integer)state.m_61143_((Property)this.getAgeProperty()) >= this.getMaxAge();
    }

    public void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{this.getAgeProperty()});
        super.m_7926_(builder);
    }

    @NotNull
    public BlockState getStateForAge(int age) {
        return (BlockState)this.m_49966_().m_61124_((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(age));
    }

    @Nullable
    public BlockState m_5573_(@NotNull BlockPlaceContext context) {
        return this.m_49966_();
    }

    public boolean isLower(@NotNull BlockState state) {
        return state.m_60713_((Block)this) && state.m_61143_((Property)f_52858_) == DoubleBlockHalf.LOWER;
    }

    public boolean isUpper(@NotNull BlockState state) {
        return state.m_60713_((Block)this) && state.m_61143_((Property)f_52858_) == DoubleBlockHalf.UPPER;
    }

    public boolean sufficientLight(LevelReader level, BlockPos pos) {
        return level.m_45524_(pos, 0) >= 8 || level.m_45527_(pos);
    }

    public boolean isTall(int age) {
        return age > this.getShortThreshold();
    }

    public boolean isTall(@NotNull BlockState state) {
        return this.isTall((Integer)state.m_61143_((Property)this.getAgeProperty()));
    }

    public boolean m_7898_(@NotNull BlockState state, @NotNull LevelReader level, @NotNull BlockPos pos) {
        if (this.isLower(state)) {
            BlockPos below = pos.m_7495_();
            BlockState belowState = level.m_8055_(below);
            return this.m_6266_(belowState, (BlockGetter)level, below) && belowState.canSustainPlant((BlockGetter)level, below, Direction.UP, (IPlantable)this) && this.sufficientLight(level, pos) && (!this.isTall(state) || this.isUpper(level.m_8055_(pos.m_7494_())));
        }
        return super.m_7898_(state, level, pos);
    }

    public boolean canGrowInto(LevelReader level, BlockPos pos) {
        BlockState blockstate = level.m_8055_(pos);
        return blockstate.m_60795_() || blockstate.m_60713_((Block)this);
    }

    public boolean canGrow(LevelReader level, BlockPos pos, BlockState state, int newAge) {
        return !this.isMaxAge(state) && this.isLower(state) && this.sufficientLight(level, pos) && (!this.isTall(newAge) || this.canGrowInto(level, pos.m_7494_()));
    }

    public void grow(ServerLevel level, BlockState state, BlockPos pos, int ageIncrement) {
        int newAge = Math.min((Integer)state.m_61143_((Property)this.getAgeProperty()) + ageIncrement, this.getMaxAge());
        if (this.canGrow((LevelReader)level, pos, state, newAge)) {
            BlockState newState = this.getStateForAge(newAge);
            level.m_7731_(pos, TallBushCropBlock.m_182453_((LevelReader)level, (BlockPos)pos, (BlockState)((BlockState)newState.m_61124_((Property)f_52858_, (Comparable)DoubleBlockHalf.LOWER))), 2);
            if (this.isTall(newAge)) {
                BlockPos above = pos.m_7494_();
                level.m_7731_(above, TallBushCropBlock.m_182453_((LevelReader)level, (BlockPos)above, (BlockState)((BlockState)newState.m_61124_((Property)f_52858_, (Comparable)DoubleBlockHalf.UPPER))), 3);
            }
        }
    }

    @NotNull
    public BlockState m_7417_(BlockState state, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor level, @NotNull BlockPos pos, @NotNull BlockPos facingPos) {
        return !state.m_60710_((LevelReader)level, pos) ? Blocks.f_50016_.m_49966_() : state;
    }

    public boolean m_6266_(BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos) {
        return state.m_60713_(Blocks.f_50093_);
    }

    public boolean m_6724_(@NotNull BlockState state) {
        return this.isLower(state) && !this.isMaxAge(state);
    }

    public void m_213898_(@NotNull BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, RandomSource random) {
        float f = CropBlock.m_52272_((Block)this, (BlockGetter)level, (BlockPos)pos);
        if (random.m_188503_((int)(25.0f / f) + 1) == 0) {
            this.grow(level, state, pos, 1);
        }
    }

    public void m_7892_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Entity entity) {
        if (entity instanceof Ravager && level.m_46469_().m_46207_(GameRules.f_46132_)) {
            level.m_46953_(pos, true, entity);
        }
        super.m_7892_(state, level, pos, entity);
    }

    public boolean m_6864_(@NotNull BlockState state, @NotNull BlockPlaceContext context) {
        return false;
    }

    public void m_6402_(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull LivingEntity placer, @NotNull ItemStack stack) {
    }

    public boolean m_214167_(@NotNull Level level, @NotNull RandomSource random, @NotNull BlockPos pos, @NotNull BlockState state) {
        return true;
    }

    @Nullable
    private PosAndState getLowerHalf(LevelReader level, BlockPos pos, BlockState state) {
        if (this.isLower(state)) {
            return new PosAndState(pos, state);
        }
        BlockPos blockpos = pos.m_7495_();
        BlockState blockstate = level.m_8055_(blockpos);
        return this.isLower(blockstate) ? new PosAndState(blockpos, blockstate) : null;
    }

    public boolean m_7370_(@NotNull LevelReader level, @NotNull BlockPos pos, @NotNull BlockState state, boolean isClient) {
        PosAndState posAndState = this.getLowerHalf(level, pos, state);
        return posAndState != null && this.canGrow(level, posAndState.pos, posAndState.state, (Integer)posAndState.state.m_61143_((Property)this.getAgeProperty()) + 1);
    }

    public void m_214148_(@NotNull ServerLevel pLevel, @NotNull RandomSource random, @NotNull BlockPos pos, @NotNull BlockState state) {
        PosAndState posAndState = this.getLowerHalf((LevelReader)pLevel, pos, state);
        if (posAndState != null) {
            this.grow(pLevel, posAndState.state, posAndState.pos, 1);
        }
    }

    record PosAndState(BlockPos pos, BlockState state) {
    }
}

