/*
 * Decompiled with CFR 0.152.
 */
package net.brdle.collectorsreap.common.item.food;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.brdle.collectorsreap.Util;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import vectorwing.farmersdelight.common.item.ConsumableItem;

public class ShimmeringAppleItem
extends ConsumableItem {
    public ShimmeringAppleItem(Item.Properties properties) {
        super(properties);
    }

    public boolean m_5812_(@NotNull ItemStack stack) {
        return true;
    }

    public void affectConsumer(@NotNull ItemStack stack, @NotNull Level level, @NotNull LivingEntity consumer) {
        super.affectConsumer(stack, level, consumer);
        HashMap active = new HashMap(consumer.m_21221_());
        if (active.isEmpty()) {
            consumer.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 400, 1));
            return;
        }
        ArrayList allBuffs = new ArrayList();
        ArrayList allDebuffs = new ArrayList();
        ForgeRegistries.MOB_EFFECTS.getValues().forEach(mobEffect -> {
            if (!mobEffect.m_8093_()) {
                if (mobEffect.m_19483_() == MobEffectCategory.BENEFICIAL) {
                    allBuffs.add(mobEffect);
                } else if (mobEffect.m_19483_() == MobEffectCategory.HARMFUL) {
                    allDebuffs.add(mobEffect);
                }
            }
        });
        List<MobEffect> activeBuffs = Util.getBeneficialEffects(consumer);
        allBuffs.removeAll(activeBuffs);
        List<MobEffect> activeDebuffs = Util.getCurableEffects(consumer);
        allDebuffs.removeAll(activeDebuffs);
        RandomSource random = consumer.m_217043_();
        active.entrySet().stream().filter(pair -> !((MobEffect)pair.getKey()).m_8093_() && !((MobEffectInstance)pair.getValue()).m_19571_() && !((MobEffectInstance)pair.getValue()).m_267577_() && ((MobEffectInstance)pair.getValue()).m_19557_() > 200 && ((MobEffectInstance)pair.getValue()).m_19575_()).forEach(entry -> {
            List effectList;
            MobEffect effect = (MobEffect)entry.getKey();
            MobEffectInstance instance = (MobEffectInstance)entry.getValue();
            if (effect.m_19483_() == MobEffectCategory.BENEFICIAL) {
                effectList = allBuffs;
            } else if (effect.m_19483_() == MobEffectCategory.HARMFUL) {
                effectList = allDebuffs;
            } else {
                return;
            }
            if (!effectList.isEmpty()) {
                MobEffect selectedEffect = (MobEffect)effectList.remove(random.m_188503_(effectList.size()));
                int duration = Math.min(instance.m_19557_(), random.m_216332_(800, 2400));
                int amp = Math.min(instance.m_19564_(), 2);
                if (Util.removeEffect(consumer, effect)) {
                    consumer.m_147215_(new MobEffectInstance(selectedEffect, duration, amp), (Entity)consumer);
                }
            }
        });
    }
}

