/*
 * Decompiled with CFR 0.152.
 */
package net.brdle.collectorsreap.common.loot;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.Supplier;
import net.brdle.collectorsreap.Util;
import net.brdle.collectorsreap.common.loot.CRLootModifiers;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class AddItemLootModifier
extends LootModifier {
    public static final Supplier<Codec<AddItemLootModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> AddItemLootModifier.codecStart((RecordCodecBuilder.Instance)inst).and((App)ForgeRegistries.ITEMS.getCodec().fieldOf("item").forGetter(g -> g.item)).and((App)Codec.INT.fieldOf("minAmount").forGetter(g -> g.minAmount)).and((App)Codec.INT.fieldOf("maxAmount").forGetter(g -> g.maxAmount)).and((App)Codec.FLOAT.fieldOf("chance").forGetter(g -> Float.valueOf(g.chance))).apply((Applicative)inst, AddItemLootModifier::new)));
    protected final Item item;
    protected final int minAmount;
    protected final int maxAmount;
    protected final float chance;

    public AddItemLootModifier(LootItemCondition[] conditions, Item item, int minAmount, int maxAmount, float chance) {
        super(conditions);
        this.item = item;
        this.minAmount = minAmount;
        this.maxAmount = maxAmount;
        this.chance = chance;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        try {
            if (context.m_230907_().m_188501_() > this.chance || this.maxAmount < 1) {
                return generatedLoot;
            }
            int amount = this.minAmount == this.maxAmount ? this.minAmount : context.m_230907_().m_188503_(this.maxAmount + 1 - this.minAmount) + this.minAmount;
            return amount >= 1 ? Util.with(generatedLoot, new ItemStack((ItemLike)this.item, amount)) : generatedLoot;
        }
        catch (Exception e) {
            throw new RuntimeException("Collector's Reap add item loot modifier error", e);
        }
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return (Codec)CRLootModifiers.ADD_ITEM.get();
    }
}

