/*
 * Decompiled with CFR 0.152.
 */
package net.brdle.collectorsreap.data.gen;

import com.mojang.datafixers.util.Pair;
import com.teamabnormals.blueprint.common.block.chest.BlueprintChestBlock;
import com.teamabnormals.blueprint.common.block.chest.BlueprintTrappedChestBlock;
import com.teamabnormals.blueprint.common.block.sign.BlueprintStandingSignBlock;
import com.teamabnormals.blueprint.common.block.sign.BlueprintWallSignBlock;
import com.teamabnormals.blueprint.core.data.client.BlueprintBlockStateProvider;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.brdle.collectorsreap.Util;
import net.brdle.collectorsreap.common.block.BuddingDragonFruitBlock;
import net.brdle.collectorsreap.common.block.CRBlocks;
import net.brdle.collectorsreap.common.block.DamselflowerCropBlock;
import net.brdle.collectorsreap.common.block.MoontearCropBlock;
import net.brdle.collectorsreap.common.block.PortobelloColonyBlock;
import net.brdle.collectorsreap.common.block.SkullLilyCropBlock;
import net.brdle.collectorsreap.compat.Modid;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.AbstractCandleBlock;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.CakeBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.Nullable;
import vectorwing.farmersdelight.common.block.CabinetBlock;
import vectorwing.farmersdelight.common.block.PieBlock;

public class CRBlockModelProvider
extends BlueprintBlockStateProvider {
    public CRBlockModelProvider(PackOutput output, ExistingFileHelper helper) {
        super(output, "collectorsreap", helper);
    }

    protected void registerStatesAndModels() {
        this.pieBlock(CRBlocks.PORTOBELLO_QUICHE);
        this.pieBlock(CRBlocks.LIME_PIE);
        this.stageBlock((Block)CRBlocks.PORTOBELLO_COLONY.get(), PortobelloColonyBlock.COLONY_AGE, new Property[0]);
        this.cross((Block)CRBlocks.PORTOBELLO.get());
        this.cross((Block)CRBlocks.DRAGON_BUSH.get());
        this.crateBlock((Block)CRBlocks.LIME_CRATE.get(), "lime", false);
        this.crateBlock((Block)CRBlocks.POMEGRANATE_CRATE.get(), "pomegranate", true);
        this.crateBlock((Block)CRBlocks.STYGIAN_POMEGRANATE_CRATE.get(), "stygian_pomegranate", true);
        this.crateBlock((Block)CRBlocks.PINK_DRAGON_FRUIT_CRATE.get(), "pink_dragon_fruit", false);
        this.crateBlock((Block)CRBlocks.LUCUMA_CRATE.get(), "lucuma", true);
        this.crateBlock((Block)CRBlocks.GILDED_LUCUMA_CRATE.get(), "gilded_lucuma", true);
        this.customStageBlock((Block)CRBlocks.BUDDING_PINK_DRAGON_FRUIT_CROP.get(), Util.rl("farmersdelight", "crop_cross"), "cross", BuddingDragonFruitBlock.AGE, Arrays.asList(0, 1, 2, 3, 3), new Property[0]);
        this.cakeBlock(CRBlocks.LIME_CAKE);
        this.candleCakeBlock(CRBlocks.CANDLE_LIME_CAKE, CRBlocks.LIME_CAKE);
        this.candleCakeBlock(CRBlocks.WHITE_CANDLE_LIME_CAKE, CRBlocks.LIME_CAKE);
        this.candleCakeBlock(CRBlocks.ORANGE_CANDLE_LIME_CAKE, CRBlocks.LIME_CAKE);
        this.candleCakeBlock(CRBlocks.MAGENTA_CANDLE_LIME_CAKE, CRBlocks.LIME_CAKE);
        this.candleCakeBlock(CRBlocks.LIGHT_BLUE_CANDLE_LIME_CAKE, CRBlocks.LIME_CAKE);
        this.candleCakeBlock(CRBlocks.YELLOW_CANDLE_LIME_CAKE, CRBlocks.LIME_CAKE);
        this.candleCakeBlock(CRBlocks.LIME_CANDLE_LIME_CAKE, CRBlocks.LIME_CAKE);
        this.candleCakeBlock(CRBlocks.PINK_CANDLE_LIME_CAKE, CRBlocks.LIME_CAKE);
        this.candleCakeBlock(CRBlocks.GRAY_CANDLE_LIME_CAKE, CRBlocks.LIME_CAKE);
        this.candleCakeBlock(CRBlocks.LIGHT_GRAY_CANDLE_LIME_CAKE, CRBlocks.LIME_CAKE);
        this.candleCakeBlock(CRBlocks.CYAN_CANDLE_LIME_CAKE, CRBlocks.LIME_CAKE);
        this.candleCakeBlock(CRBlocks.PURPLE_CANDLE_LIME_CAKE, CRBlocks.LIME_CAKE);
        this.candleCakeBlock(CRBlocks.BLUE_CANDLE_LIME_CAKE, CRBlocks.LIME_CAKE);
        this.candleCakeBlock(CRBlocks.BROWN_CANDLE_LIME_CAKE, CRBlocks.LIME_CAKE);
        this.candleCakeBlock(CRBlocks.GREEN_CANDLE_LIME_CAKE, CRBlocks.LIME_CAKE);
        this.candleCakeBlock(CRBlocks.RED_CANDLE_LIME_CAKE, CRBlocks.LIME_CAKE);
        this.candleCakeBlock(CRBlocks.BLACK_CANDLE_LIME_CAKE, CRBlocks.LIME_CAKE);
        this.cakeBlock(CRBlocks.POMEGRANATE_CAKE);
        this.candleCakeBlock(CRBlocks.CANDLE_POMEGRANATE_CAKE, CRBlocks.POMEGRANATE_CAKE);
        this.candleCakeBlock(CRBlocks.WHITE_CANDLE_POMEGRANATE_CAKE, CRBlocks.POMEGRANATE_CAKE);
        this.candleCakeBlock(CRBlocks.ORANGE_CANDLE_POMEGRANATE_CAKE, CRBlocks.POMEGRANATE_CAKE);
        this.candleCakeBlock(CRBlocks.MAGENTA_CANDLE_POMEGRANATE_CAKE, CRBlocks.POMEGRANATE_CAKE);
        this.candleCakeBlock(CRBlocks.LIGHT_BLUE_CANDLE_POMEGRANATE_CAKE, CRBlocks.POMEGRANATE_CAKE);
        this.candleCakeBlock(CRBlocks.YELLOW_CANDLE_POMEGRANATE_CAKE, CRBlocks.POMEGRANATE_CAKE);
        this.candleCakeBlock(CRBlocks.LIME_CANDLE_POMEGRANATE_CAKE, CRBlocks.POMEGRANATE_CAKE);
        this.candleCakeBlock(CRBlocks.PINK_CANDLE_POMEGRANATE_CAKE, CRBlocks.POMEGRANATE_CAKE);
        this.candleCakeBlock(CRBlocks.GRAY_CANDLE_POMEGRANATE_CAKE, CRBlocks.POMEGRANATE_CAKE);
        this.candleCakeBlock(CRBlocks.LIGHT_GRAY_CANDLE_POMEGRANATE_CAKE, CRBlocks.POMEGRANATE_CAKE);
        this.candleCakeBlock(CRBlocks.CYAN_CANDLE_POMEGRANATE_CAKE, CRBlocks.POMEGRANATE_CAKE);
        this.candleCakeBlock(CRBlocks.PURPLE_CANDLE_POMEGRANATE_CAKE, CRBlocks.POMEGRANATE_CAKE);
        this.candleCakeBlock(CRBlocks.BLUE_CANDLE_POMEGRANATE_CAKE, CRBlocks.POMEGRANATE_CAKE);
        this.candleCakeBlock(CRBlocks.BROWN_CANDLE_POMEGRANATE_CAKE, CRBlocks.POMEGRANATE_CAKE);
        this.candleCakeBlock(CRBlocks.GREEN_CANDLE_POMEGRANATE_CAKE, CRBlocks.POMEGRANATE_CAKE);
        this.candleCakeBlock(CRBlocks.RED_CANDLE_POMEGRANATE_CAKE, CRBlocks.POMEGRANATE_CAKE);
        this.candleCakeBlock(CRBlocks.BLACK_CANDLE_POMEGRANATE_CAKE, CRBlocks.POMEGRANATE_CAKE);
        this.cakeBlock(CRBlocks.PINK_DRAGON_FRUIT_CAKE);
        this.candleCakeBlock(CRBlocks.CANDLE_PINK_DRAGON_FRUIT_CAKE, CRBlocks.PINK_DRAGON_FRUIT_CAKE);
        this.candleCakeBlock(CRBlocks.WHITE_CANDLE_PINK_DRAGON_FRUIT_CAKE, CRBlocks.PINK_DRAGON_FRUIT_CAKE);
        this.candleCakeBlock(CRBlocks.ORANGE_CANDLE_PINK_DRAGON_FRUIT_CAKE, CRBlocks.PINK_DRAGON_FRUIT_CAKE);
        this.candleCakeBlock(CRBlocks.MAGENTA_CANDLE_PINK_DRAGON_FRUIT_CAKE, CRBlocks.PINK_DRAGON_FRUIT_CAKE);
        this.candleCakeBlock(CRBlocks.LIGHT_BLUE_CANDLE_PINK_DRAGON_FRUIT_CAKE, CRBlocks.PINK_DRAGON_FRUIT_CAKE);
        this.candleCakeBlock(CRBlocks.YELLOW_CANDLE_PINK_DRAGON_FRUIT_CAKE, CRBlocks.PINK_DRAGON_FRUIT_CAKE);
        this.candleCakeBlock(CRBlocks.LIME_CANDLE_PINK_DRAGON_FRUIT_CAKE, CRBlocks.PINK_DRAGON_FRUIT_CAKE);
        this.candleCakeBlock(CRBlocks.PINK_CANDLE_PINK_DRAGON_FRUIT_CAKE, CRBlocks.PINK_DRAGON_FRUIT_CAKE);
        this.candleCakeBlock(CRBlocks.GRAY_CANDLE_PINK_DRAGON_FRUIT_CAKE, CRBlocks.PINK_DRAGON_FRUIT_CAKE);
        this.candleCakeBlock(CRBlocks.LIGHT_GRAY_CANDLE_PINK_DRAGON_FRUIT_CAKE, CRBlocks.PINK_DRAGON_FRUIT_CAKE);
        this.candleCakeBlock(CRBlocks.CYAN_CANDLE_PINK_DRAGON_FRUIT_CAKE, CRBlocks.PINK_DRAGON_FRUIT_CAKE);
        this.candleCakeBlock(CRBlocks.PURPLE_CANDLE_PINK_DRAGON_FRUIT_CAKE, CRBlocks.PINK_DRAGON_FRUIT_CAKE);
        this.candleCakeBlock(CRBlocks.BLUE_CANDLE_PINK_DRAGON_FRUIT_CAKE, CRBlocks.PINK_DRAGON_FRUIT_CAKE);
        this.candleCakeBlock(CRBlocks.BROWN_CANDLE_PINK_DRAGON_FRUIT_CAKE, CRBlocks.PINK_DRAGON_FRUIT_CAKE);
        this.candleCakeBlock(CRBlocks.GREEN_CANDLE_PINK_DRAGON_FRUIT_CAKE, CRBlocks.PINK_DRAGON_FRUIT_CAKE);
        this.candleCakeBlock(CRBlocks.RED_CANDLE_PINK_DRAGON_FRUIT_CAKE, CRBlocks.PINK_DRAGON_FRUIT_CAKE);
        this.candleCakeBlock(CRBlocks.BLACK_CANDLE_PINK_DRAGON_FRUIT_CAKE, CRBlocks.PINK_DRAGON_FRUIT_CAKE);
        this.cakeBlock(CRBlocks.LUCUMA_CAKE);
        this.candleCakeBlock(CRBlocks.CANDLE_LUCUMA_CAKE, CRBlocks.LUCUMA_CAKE);
        this.candleCakeBlock(CRBlocks.WHITE_CANDLE_LUCUMA_CAKE, CRBlocks.LUCUMA_CAKE);
        this.candleCakeBlock(CRBlocks.ORANGE_CANDLE_LUCUMA_CAKE, CRBlocks.LUCUMA_CAKE);
        this.candleCakeBlock(CRBlocks.MAGENTA_CANDLE_LUCUMA_CAKE, CRBlocks.LUCUMA_CAKE);
        this.candleCakeBlock(CRBlocks.LIGHT_BLUE_CANDLE_LUCUMA_CAKE, CRBlocks.LUCUMA_CAKE);
        this.candleCakeBlock(CRBlocks.YELLOW_CANDLE_LUCUMA_CAKE, CRBlocks.LUCUMA_CAKE);
        this.candleCakeBlock(CRBlocks.LIME_CANDLE_LUCUMA_CAKE, CRBlocks.LUCUMA_CAKE);
        this.candleCakeBlock(CRBlocks.PINK_CANDLE_LUCUMA_CAKE, CRBlocks.LUCUMA_CAKE);
        this.candleCakeBlock(CRBlocks.GRAY_CANDLE_LUCUMA_CAKE, CRBlocks.LUCUMA_CAKE);
        this.candleCakeBlock(CRBlocks.LIGHT_GRAY_CANDLE_LUCUMA_CAKE, CRBlocks.LUCUMA_CAKE);
        this.candleCakeBlock(CRBlocks.CYAN_CANDLE_LUCUMA_CAKE, CRBlocks.LUCUMA_CAKE);
        this.candleCakeBlock(CRBlocks.PURPLE_CANDLE_LUCUMA_CAKE, CRBlocks.LUCUMA_CAKE);
        this.candleCakeBlock(CRBlocks.BLUE_CANDLE_LUCUMA_CAKE, CRBlocks.LUCUMA_CAKE);
        this.candleCakeBlock(CRBlocks.BROWN_CANDLE_LUCUMA_CAKE, CRBlocks.LUCUMA_CAKE);
        this.candleCakeBlock(CRBlocks.GREEN_CANDLE_LUCUMA_CAKE, CRBlocks.LUCUMA_CAKE);
        this.candleCakeBlock(CRBlocks.RED_CANDLE_LUCUMA_CAKE, CRBlocks.LUCUMA_CAKE);
        this.candleCakeBlock(CRBlocks.BLACK_CANDLE_LUCUMA_CAKE, CRBlocks.LUCUMA_CAKE);
        this.simpleBlock((Block)CRBlocks.LIME_ICE_CREAM_BLOCK.get());
        this.simpleBlock((Block)CRBlocks.POMEGRANATE_ICE_CREAM_BLOCK.get());
        this.simpleBlock((Block)CRBlocks.PINK_DRAGON_FRUIT_ICE_CREAM_BLOCK.get());
        this.simpleBlock((Block)CRBlocks.LUCUMA_ICE_CREAM_BLOCK.get());
        this.stageBlock((Block)CRBlocks.DAMSELFLOWER_CROP.get(), DamselflowerCropBlock.AGE, new Property[0]);
        this.pottedPlant(CRBlocks.DAMSELFLOWER, CRBlocks.POTTED_DAMSELFLOWER);
        this.stageBlock((Block)CRBlocks.MOONTEAR_CROP.get(), MoontearCropBlock.AGE, new Property[0]);
        this.pottedPlant(CRBlocks.MOONTEAR, CRBlocks.POTTED_MOONTEAR);
        this.stageBlock((Block)CRBlocks.SKULL_LILY_CROP.get(), SkullLilyCropBlock.AGE, new Property[0]);
        this.pottedPlant(CRBlocks.SKULL_LILY, CRBlocks.POTTED_SKULL_LILY);
        this.tallPlant(CRBlocks.BULBOUS_ROSE);
        this.tallPlant(CRBlocks.HEARTPETALS);
        this.simpleBlock((Block)CRBlocks.URCHIN_TEST_BLOCK.get(), (ModelFile)this.models().cubeBottomTop("urchin_test_block", CRBlockModelProvider.resourceBlock("urchin_test_block_side"), CRBlockModelProvider.resourceBlock("urchin_test_block_bottom"), CRBlockModelProvider.resourceBlock("urchin_test_block_top")));
        this.simpleBlock((Block)CRBlocks.URCHIN_TEST_BRICKS.get());
        this.slab(CRBlocks.URCHIN_TEST_BRICK_SLAB, this.blockTexture((Block)CRBlocks.URCHIN_TEST_BRICKS.get()));
        this.stairs(CRBlocks.URCHIN_TEST_BRICK_STAIRS, this.blockTexture((Block)CRBlocks.URCHIN_TEST_BRICKS.get()));
        this.wall(CRBlocks.URCHIN_TEST_BRICK_WALL, this.blockTexture((Block)CRBlocks.URCHIN_TEST_BRICKS.get()));
        this.simpleBlock((Block)CRBlocks.URCHIN_TEST_TILES.get());
        this.slab(CRBlocks.URCHIN_TEST_TILE_SLAB, this.blockTexture((Block)CRBlocks.URCHIN_TEST_TILES.get()));
        this.stairs(CRBlocks.URCHIN_TEST_TILE_STAIRS, this.blockTexture((Block)CRBlocks.URCHIN_TEST_TILES.get()));
        this.wall(CRBlocks.URCHIN_TEST_TILE_WALL, this.blockTexture((Block)CRBlocks.URCHIN_TEST_TILES.get()));
        this.simpleBlock((Block)CRBlocks.CHISELED_URCHIN_TEST_BRICKS.get());
        this.pillar(CRBlocks.STRIPPED_LUCUMA_LOG);
        this.wood(CRBlocks.STRIPPED_LUCUMA_WOOD, this.blockTexture((Block)CRBlocks.STRIPPED_LUCUMA_LOG.get()));
        this.pillar(CRBlocks.LUCUMA_LOG);
        this.wood(CRBlocks.LUCUMA_WOOD, this.blockTexture((Block)CRBlocks.LUCUMA_LOG.get()));
        this.simpleBlock((Block)CRBlocks.LUCUMA_PLANKS.get());
        this.slab(CRBlocks.LUCUMA_SLAB, this.blockTexture((Block)CRBlocks.LUCUMA_PLANKS.get()));
        this.stairs(CRBlocks.LUCUMA_STAIRS, this.blockTexture((Block)CRBlocks.LUCUMA_PLANKS.get()));
        this.fence(CRBlocks.LUCUMA_FENCE, this.blockTexture((Block)CRBlocks.LUCUMA_PLANKS.get()));
        this.fenceGate(CRBlocks.LUCUMA_FENCE_GATE, this.blockTexture((Block)CRBlocks.LUCUMA_PLANKS.get()));
        this.doorCutout(CRBlocks.LUCUMA_DOOR);
        this.trapdoorCutout(CRBlocks.LUCUMA_TRAPDOOR);
        this.pressurePlate(CRBlocks.LUCUMA_PRESSURE_PLATE, this.blockTexture((Block)CRBlocks.LUCUMA_PLANKS.get()));
        this.button(CRBlocks.LUCUMA_BUTTON, this.blockTexture((Block)CRBlocks.LUCUMA_PLANKS.get()));
        this.signs(CRBlocks.LUCUMA_SIGNS, (Supplier<Block>)CRBlocks.LUCUMA_PLANKS);
        this.hangingSignBlocks(CRBlocks.STRIPPED_LUCUMA_LOG, CRBlocks.LUCUMA_HANGING_SIGNS);
        this.pottedPlant(CRBlocks.LUCUMA_SAPLING, CRBlocks.POTTED_LUCUMA_SAPLING);
        this.leavesBlock(CRBlocks.LUCUMA_LEAVES);
        this.leafPile(CRBlocks.LUCUMA_LEAF_PILE, this.blockTexture((Block)CRBlocks.LUCUMA_LEAVES.get()), true);
        this.cabinetBlock((Block)CRBlocks.LUCUMA_CABINET.get(), "lucuma");
        this.beehive(CRBlocks.LUCUMA_BEEHIVE);
        this.ladder(CRBlocks.LUCUMA_LADDER);
        this.bookshelf(CRBlocks.LUCUMA_BOOKSHELF, (Supplier<Block>)CRBlocks.LUCUMA_PLANKS);
        this.chiseledBookshelfBlock(CRBlocks.CHISELED_LUCUMA_BOOKSHELF, ALTERNATE_BOOKSHELF_POSITIONS);
        this.boards(CRBlocks.LUCUMA_BOARDS);
        this.chests(CRBlocks.LUCUMA_CHEST, CRBlocks.TRAPPED_LUCUMA_CHEST, this.blockTexture((Block)CRBlocks.LUCUMA_PLANKS.get()));
        this.roeBlock((Block)CRBlocks.PLATINUM_BASS_ROE.get());
        this.roeBlock((Block)CRBlocks.TIGER_PRAWN_ROE.get());
    }

    private void stairs(RegistryObject<Block> stairs, ResourceLocation texture) {
        this.stairsBlock((StairBlock)stairs.get(), texture);
    }

    private void slab(RegistryObject<Block> slab, ResourceLocation texture) {
        this.slabBlock((SlabBlock)slab.get(), texture, texture);
    }

    private void wall(RegistryObject<Block> wall, ResourceLocation texture) {
        this.wallBlock((WallBlock)wall.get(), texture);
    }

    private void wood(RegistryObject<Block> log, ResourceLocation texture) {
        this.axisBlock((RotatedPillarBlock)log.get(), texture, texture);
    }

    private void pillar(RegistryObject<Block> pillar) {
        this.axisBlock((RotatedPillarBlock)pillar.get(), this.blockTexture((Block)pillar.get()), this.modLoc("block/" + Util.name(pillar) + "_top"));
    }

    private void fence(RegistryObject<Block> fence, ResourceLocation texture) {
        this.fenceBlock((FenceBlock)fence.get(), texture);
    }

    private void fenceGate(RegistryObject<Block> gate, ResourceLocation texture) {
        this.fenceGateBlock((FenceGateBlock)gate.get(), texture);
    }

    private void door(RegistryObject<Block> door) {
        String name = Util.name(door);
        this.doorBlock((DoorBlock)door.get(), name.replace("_door", ""), this.modLoc("block/" + name + "_bottom"), this.modLoc("block/" + name + "_top"));
    }

    private void doorCutout(RegistryObject<Block> door) {
        String name = Util.name(door);
        this.doorBlockWithRenderType((DoorBlock)door.get(), name.replace("_door", ""), this.modLoc("block/" + name + "_bottom"), this.modLoc("block/" + name + "_top"), "cutout");
    }

    private void trapdoor(RegistryObject<Block> trapdoor) {
        this.trapdoorBlock((TrapDoorBlock)trapdoor.get(), this.blockTexture((Block)trapdoor.get()), true);
    }

    private void trapdoorCutout(RegistryObject<Block> trapdoor) {
        this.trapdoorBlockWithRenderType((TrapDoorBlock)trapdoor.get(), this.blockTexture((Block)trapdoor.get()), true, "cutout");
    }

    private void pressurePlate(RegistryObject<Block> pressurePlate, ResourceLocation texture) {
        this.pressurePlateBlock((PressurePlateBlock)pressurePlate.get(), texture);
    }

    private void button(RegistryObject<Block> button, ResourceLocation texture) {
        this.buttonBlock((ButtonBlock)button.get(), texture);
    }

    private void signs(Pair<RegistryObject<BlueprintStandingSignBlock>, RegistryObject<BlueprintWallSignBlock>> signs, Supplier<Block> planks) {
        this.signBlock((StandingSignBlock)((RegistryObject)signs.getFirst()).get(), (WallSignBlock)((RegistryObject)signs.getSecond()).get(), this.blockTexture(planks.get()));
    }

    private void leafPile(RegistryObject<Block> leafPile, ResourceLocation texture, boolean tinted) {
        ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(Util.name(leafPile), "blueprint:block/" + (tinted ? "tinted_" : "") + "leaf_pile")).texture("all", texture)).renderType("cutout");
        ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder((Block)leafPile.get()).part().modelFile((ModelFile)model).uvLock(true).rotationX(270).addModel()).condition((Property)BlockStateProperties.f_61366_, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)model).uvLock(true).rotationX(90).addModel()).condition((Property)BlockStateProperties.f_61367_, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)model).addModel()).condition((Property)BlockStateProperties.f_61368_, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)model).uvLock(true).rotationY(180).addModel()).condition((Property)BlockStateProperties.f_61370_, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)model).uvLock(true).rotationY(90).addModel()).condition((Property)BlockStateProperties.f_61369_, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)model).uvLock(true).rotationY(270).addModel()).condition((Property)BlockStateProperties.f_61371_, (Comparable[])new Boolean[]{true}).end();
    }

    private void tallPlant(RegistryObject<Block> flower) {
        String name = Util.name(flower);
        Function<String, ModelFile> model = s -> ((BlockModelBuilder)this.models().cross(name + "_" + s, this.modLoc("block/" + name + "_" + s))).renderType("cutout");
        ((ItemModelBuilder)this.itemModels().withExistingParent(name, "item/generated")).texture("layer0", this.modLoc("block/" + name + "_top"));
        this.getVariantBuilder((Block)flower.get()).partialState().with((Property)DoublePlantBlock.f_52858_, (Comparable)DoubleBlockHalf.UPPER).addModels(new ConfiguredModel[]{new ConfiguredModel(model.apply("top"))}).partialState().with((Property)DoublePlantBlock.f_52858_, (Comparable)DoubleBlockHalf.LOWER).addModels(new ConfiguredModel[]{new ConfiguredModel(model.apply("bottom"))});
    }

    private void pottedPlant(RegistryObject<Block> plant, RegistryObject<Block> pot) {
        this.pot(pot, this.blockTexture((Block)plant.get()));
        this.simpleCross(plant);
    }

    private void pot(RegistryObject<Block> pot, ResourceLocation texture) {
        ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(Util.name(pot), "block/flower_pot_cross")).texture("plant", texture)).renderType("cutout");
        this.simpleBlock((Block)pot.get(), (ModelFile)model);
    }

    private void simpleCross(RegistryObject<Block> block) {
        this.simpleBlock((Block)block.get(), (ModelFile)((BlockModelBuilder)this.models().cross(Util.name(block), this.blockTexture((Block)block.get()))).renderType("cutout"));
    }

    private void crateBlock(Block block, String cropName, boolean customBottom) {
        this.simpleBlock(block, (ModelFile)this.models().cubeBottomTop(Util.name((ItemLike)block), CRBlockModelProvider.resourceBlock(cropName + "_crate_side"), customBottom ? CRBlockModelProvider.resourceBlock(cropName + "_crate_bottom") : Util.rl("farmersdelight", "block/crate_bottom"), CRBlockModelProvider.resourceBlock(cropName + "_crate_top")));
    }

    public void cabinetBlock(Block block, String woodType) {
        this.horizontalBlock(block, state -> {
            String suffix = (Boolean)state.m_61143_((Property)CabinetBlock.OPEN) != false ? "_open" : "";
            return this.models().orientable(Util.name((ItemLike)block) + suffix, CRBlockModelProvider.resourceBlock(woodType + "_cabinet_side"), CRBlockModelProvider.resourceBlock(woodType + "_cabinet_front" + suffix), CRBlockModelProvider.resourceBlock(woodType + "_cabinet_top"));
        });
    }

    private void beehive(RegistryObject<Block> beehive) {
        String name = Util.name(beehive);
        ModelBuilder model = this.models().orientable(name, this.modLoc("block/" + name + "_side"), this.modLoc("block/" + name + "_front"), this.modLoc("block/" + name + "_end"));
        ModelBuilder model_honey = this.models().orientable(name + "_honey", this.modLoc("block/" + name + "_side"), this.modLoc("block/" + name + "_front_honey"), this.modLoc("block/" + name + "_end"));
        this.horizontalBlock((Block)beehive.get(), arg_0 -> CRBlockModelProvider.lambda$beehive$2((ModelFile)model_honey, (ModelFile)model, arg_0));
    }

    private void ladder(RegistryObject<Block> ladder) {
        ResourceLocation texture = this.blockTexture((Block)ladder.get());
        this.horizontalBlock((Block)ladder.get(), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(Util.name(ladder), "block/ladder")).texture("particle", texture)).renderType("cutout")).texture("texture", texture));
    }

    private void bookshelf(RegistryObject<Block> bookshelf, Supplier<Block> planks) {
        this.simpleBlock((Block)bookshelf.get(), (ModelFile)this.models().cubeColumn(Util.name(bookshelf), this.blockTexture((Block)bookshelf.get()), this.blockTexture(planks.get())));
    }

    private void boards(RegistryObject<Block> boards) {
        ResourceLocation texture = this.blockTexture((Block)boards.get());
        ModelBuilder boardsModel = ((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(Util.name(boards))).parent((ModelFile)new ModelFile.UncheckedModelFile(Modid.BP.rl("block/template_boards")))).texture("all", texture);
        ModelBuilder boardsHorizontalModel = ((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(Util.name(boards) + "_horizontal")).parent((ModelFile)new ModelFile.UncheckedModelFile(Modid.BP.rl("block/template_boards_horizontal")))).texture("all", texture);
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder((Block)boards.get()).partialState().with((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.Y).modelForState().modelFile((ModelFile)boardsModel).addModel()).partialState().with((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.Z).modelForState().modelFile((ModelFile)boardsHorizontalModel).addModel()).partialState().with((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.X).modelForState().modelFile((ModelFile)boardsHorizontalModel).rotationY(270).addModel();
    }

    private void chests(RegistryObject<BlueprintChestBlock> chest, RegistryObject<BlueprintTrappedChestBlock> trapped, ResourceLocation texture) {
        ModelBuilder model = ((BlockModelBuilder)this.models().getBuilder(Util.name(chest))).texture("particle", texture);
        this.simpleBlock((Block)chest.get(), (ModelFile)model);
        this.simpleBlock((Block)trapped.get(), (ModelFile)model);
    }

    private ModelFile existingModel(String path) {
        return new ModelFile.ExistingModelFile(CRBlockModelProvider.resourceBlock(path), this.models().existingFileHelper);
    }

    private void cross(Block block) {
        this.simpleBlock(block, (ModelFile)((BlockModelBuilder)this.models().cross("block/" + Util.name((ItemLike)block), CRBlockModelProvider.resourceBlock(Util.name((ItemLike)block)))).renderType("cutout"));
    }

    public void customStageBlock(Block block, @Nullable ResourceLocation parent, String textureKey, IntegerProperty ageProperty, List<Integer> suffixes, Property<?> ... ignored) {
        this.getVariantBuilder(block).forAllStatesExcept(state -> {
            int ageSuffix = (Integer)state.m_61143_((Property)ageProperty);
            String stageName = Util.name((ItemLike)block) + "_stage";
            stageName = stageName + (suffixes.isEmpty() ? ageSuffix : (Integer)suffixes.get(Math.min(suffixes.size(), ageSuffix)));
            if (parent == null) {
                return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)this.models().cross(stageName, CRBlockModelProvider.resourceBlock(stageName))).renderType("cutout")).build();
            }
            return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)this.models().singleTexture(stageName, parent, textureKey, CRBlockModelProvider.resourceBlock(stageName))).renderType("cutout")).build();
        }, ignored);
    }

    private void stageBlock(Block block, IntegerProperty ageProperty, Property<?> ... ignored) {
        this.getVariantBuilder(block).forAllStatesExcept(state -> {
            String stageName = Util.name((ItemLike)block) + "_stage" + String.valueOf(state.m_61143_((Property)ageProperty));
            return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)this.models().cross(stageName, CRBlockModelProvider.resourceBlock(stageName))).renderType("cutout")).build();
        }, ignored);
    }

    private void pomegranateBushBlock(Block block, IntegerProperty ageProperty, EnumProperty<DoubleBlockHalf> halfProperty) {
        this.getVariantBuilder(block).forAllStates(state -> {
            String halfStageName = Util.name((ItemLike)block) + "_" + ((DoubleBlockHalf)state.m_61143_((Property)halfProperty)).m_7912_() + "_stage" + String.valueOf(state.m_61143_((Property)ageProperty));
            String name = Util.name((ItemLike)block) + "_stage" + String.valueOf(state.m_61143_((Property)ageProperty));
            return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)this.models().withExistingParent("block/" + halfStageName, Util.cr(Util.name((ItemLike)block) + "_" + ((DoubleBlockHalf)state.m_61143_((Property)halfProperty)).m_7912_()))).texture("0", CRBlockModelProvider.resourceBlock(name))).build();
        });
    }

    private void pieBlock(RegistryObject<Block> block) {
        this.getVariantBuilder((Block)block.get()).forAllStates(state -> {
            int bites = (Integer)state.m_61143_((Property)PieBlock.BITES);
            String name = Util.name(block);
            Object suffix = bites > 0 ? "_slice" + bites : "";
            BlockModelBuilder mod = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("block/" + name + (String)suffix, Util.rl("farmersdelight", "pie" + (String)suffix))).texture("top", CRBlockModelProvider.resourceBlock(name + "_top"))).texture("bottom", CRBlockModelProvider.resourceBlock(name + "_bottom"))).texture("side", CRBlockModelProvider.resourceBlock(name + "_side"))).texture("particle", CRBlockModelProvider.resourceBlock(name + "_top"));
            if (bites > 0) {
                mod.texture("inner", CRBlockModelProvider.resourceBlock(name + "_inner"));
            }
            return ConfiguredModel.builder().modelFile((ModelFile)mod).rotationY(((int)((Direction)state.m_61143_((Property)PieBlock.FACING)).m_122435_() + 180) % 360).build();
        });
    }

    private void cakeBlock(RegistryObject<Block> block) {
        this.getVariantBuilder((Block)block.get()).forAllStates(state -> {
            int bites = (Integer)state.m_61143_((Property)CakeBlock.f_51180_);
            String name = Util.name(block);
            Object suffix = bites > 0 ? "_slice" + bites : "";
            BlockModelBuilder mod = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("block/" + name + (String)suffix, Util.rl("minecraft", "cake" + (String)suffix))).texture("top", CRBlockModelProvider.resourceBlock(name + "_top"))).texture("bottom", CRBlockModelProvider.resourceBlock(name + "_bottom"))).texture("side", CRBlockModelProvider.resourceBlock(name + "_side"))).texture("particle", CRBlockModelProvider.resourceBlock(name + "_side"));
            if (bites > 0) {
                mod.texture("inside", CRBlockModelProvider.resourceBlock(name + "_inner"));
            }
            return ConfiguredModel.builder().modelFile((ModelFile)mod).build();
        });
    }

    private void candleCakeBlock(RegistryObject<Block> block, RegistryObject<Block> cake) {
        this.getVariantBuilder((Block)block.get()).forAllStates(state -> {
            String lit = (Boolean)state.m_61143_((Property)AbstractCandleBlock.f_151895_) != false ? "_lit" : "";
            String name = Util.name(block);
            String cakeName = Util.name(cake);
            String candle = name.replace("_" + cakeName, "") + lit;
            return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("block/" + name + lit, Modid.MC.rl("template_cake_with_candle"))).texture("bottom", CRBlockModelProvider.resourceBlock(cakeName + "_bottom"))).texture("candle", CRBlockModelProvider.vanillaBlock(candle))).texture("particle", CRBlockModelProvider.resourceBlock(cakeName + "_side"))).texture("side", CRBlockModelProvider.resourceBlock(cakeName + "_side"))).texture("top", CRBlockModelProvider.resourceBlock(cakeName + "_top"))).build();
        });
    }

    private void roeBlock(Block block) {
        this.getVariantBuilder(block).forAllStates(state -> {
            String name = Util.name((ItemLike)block);
            return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, CRBlockModelProvider.vanillaBlock("frogspawn"))).texture("particle", CRBlockModelProvider.resourceBlock(name))).texture("texture", CRBlockModelProvider.resourceBlock(name))).renderType("translucent")).build();
        });
    }

    public static ResourceLocation resourceBlock(String path) {
        return Util.cr("block/" + path);
    }

    public static ResourceLocation vanillaBlock(String path) {
        return Modid.MC.rl("block/" + path);
    }

    private static /* synthetic */ ModelFile lambda$beehive$2(ModelFile model_honey, ModelFile model, BlockState s) {
        return (Integer)s.m_61143_((Property)BeehiveBlock.f_49564_) == 5 ? model_honey : model;
    }
}

