/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.fruitphone;

import com.elytradev.fruitphone.FruitPhone$$Lambda$1;
import com.elytradev.fruitphone.FruitPhone$$Lambda$2;
import com.elytradev.fruitphone.FruitPhone$$Lambda$3;
import com.elytradev.fruitphone.FruitPhone$$Lambda$4;
import com.elytradev.fruitphone.FruitPhone$$Lambda$5;
import com.elytradev.fruitphone.FruitSounds;
import com.elytradev.fruitphone.GameRulePoller;
import com.elytradev.fruitphone.Gravity;
import com.elytradev.fruitphone.capability.FruitEquipmentCapability;
import com.elytradev.fruitphone.capability.FruitEquipmentStorage;
import com.elytradev.fruitphone.compat.waila.WailaCompat;
import com.elytradev.fruitphone.item.FruitItems;
import com.elytradev.fruitphone.network.EquipmentDataPacket;
import com.elytradev.fruitphone.network.ProbeDataPacket;
import com.elytradev.fruitphone.network.SetAlwaysOnPacket;
import com.elytradev.fruitphone.proxy.ClientProxy;
import com.elytradev.fruitphone.proxy.Proxy;
import com.elytradev.fruitphone.recipe.FruitRecipes;
import com.elytradev.fruitphone.recipe.FruitUpgradeRecipe;
import com.elytradev.fruitphone.repackage.com.elytradev.concrete.network.NetworkContext;
import com.elytradev.fruitphone.vanilla.VanillaProviders;
import com.elytradev.probe.api.IProbeData;
import com.elytradev.probe.api.IProbeDataProvider;
import com.elytradev.probe.api.IUnit;
import com.elytradev.probe.api.UnitDictionary;
import com.elytradev.probe.api.impl.ProbeData;
import com.elytradev.probe.api.impl.Unit;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.WeakHashMap;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.impl.ModuleRegistrar;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityEnderChest;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.NetworkCheckHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import net.minecraftforge.oredict.RecipeSorter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="fruitphone", name="Fruit Phone", version="1.11.2-0.1.7-80e4f38d", dependencies="required-after:probedataprovider;after:waila")
public class FruitPhone {
    public static final String MODID = "fruitphone";
    public static final String NAME = "Fruit Phone";
    public static final String VERSION = "1.11.2-0.1.7-80e4f38d";
    public static final String DEPENDENCIES = "required-after:probedataprovider;after:waila";
    public static final Logger log = LogManager.getLogger((String)"FruitPhone");
    public static CreativeTabs tab = new CreativeTabs("fruitphone"){
        private ItemStack icon;

        @SideOnly(value=Side.CLIENT)
        public ItemStack func_151244_d() {
            int iTicks;
            if (this.icon == null) {
                this.icon = new ItemStack((Item)FruitItems.HANDHELD);
                this.icon.func_77982_d(new NBTTagCompound());
            }
            if ((iTicks = (int)ClientProxy.ticks) % 20 == 0) {
                int col = FruitRecipes.craftableColors.get(iTicks / 20 % FruitRecipes.craftableColors.size());
                this.icon.func_77978_p().func_74768_a("fruitphone:color", col);
            }
            return this.icon;
        }

        public ItemStack func_78016_d() {
            return this.func_151244_d();
        }
    };
    @SidedProxy(clientSide="com.elytradev.fruitphone.proxy.ClientProxy", serverSide="com.elytradev.fruitphone.proxy.Proxy")
    public static Proxy proxy;
    @Mod.Instance
    public static FruitPhone inst;
    public Configuration config;
    public Gravity glassesGravity;
    public int glassesXOffset;
    public int glassesYOffset;
    public float maxGlassesWidth;
    public float maxGlassesHeight;
    public float glassesScale;
    public boolean optionalMode;
    public boolean disableWaila;
    public boolean showWailaInformation;
    @CapabilityInject(value=FruitEquipmentCapability.class)
    public static Capability<FruitEquipmentCapability> CAPABILITY_EQUIPMENT;
    @CapabilityInject(value=IProbeDataProvider.class)
    public static Capability<IProbeDataProvider> CAPABILITY_PROBE;
    public NetworkContext NETWORK;
    private Map<EntityPlayer, ProbeDataPacket> lastData = new WeakHashMap<EntityPlayer, ProbeDataPacket>();

    @Mod.EventHandler
    public void onPreInit(FMLPreInitializationEvent e) {
        this.config = new Configuration(e.getSuggestedConfigurationFile());
        this.optionalMode = this.config.getBoolean("optional", "General", false, "Don't register any items or blocks. If set to true on a server,\nFruit Phone will not be required to connect to the server. If\nset to true on a client, Fruit Phone will pretend you're\nwearing glasses at all times. Since this disables all of Fruit\nPhone's items, if you try to enable this on the client and\nconnect to a server with it disabled, you will get a 'Fatally\nmissing blocks and items' error and will not be able to connect.\n\nNot required to connect to servers that don't have Fruit\nPhone. The mod will pretend you're wearing glasses when\nconnected to servers that lack the mod.\n\nIf you just want to have the mod pretend you're wearing Fruit\nGlass at all times, use /gamerule fruitphone:alwaysOn true\n\n");
        this.disableWaila = this.config.getBoolean("disableWaila", "General", true, "If true and Waila is installed, Fruit Phone will disable it. Automatically turned off on first run.");
        this.showWailaInformation = this.config.getBoolean("showWailaInformation", "General", true, "If true and Waila is installed, Fruit Phone will display information from Waila plugins.");
        Gravity[] grav = Gravity.values();
        String[] valid = new String[grav.length];
        for (int i = 0; i < valid.length; ++i) {
            valid[i] = grav[i].toString();
        }
        this.glassesGravity = Gravity.valueOf(this.config.getString("gravity", "Glasses", "north_west", "The gravity for the glasses overlay.", valid).toUpperCase(Locale.ROOT));
        this.glassesXOffset = this.config.getInt("xOffset", "Glasses", 10, 0, 65535, "The X offset for the glasses overlay, dependent on gravity");
        this.glassesYOffset = this.config.getInt("yOffset", "Glasses", 10, 0, 65535, "The Y offset for the glasses overlay, dependent on gravity");
        this.maxGlassesWidth = this.config.getFloat("maxWidth", "Glasses", 33.333332f, 0.0f, 100.0f, "The maximum width for the glasses overlay, as a percentage of the screen width") / 100.0f;
        this.maxGlassesHeight = this.config.getFloat("maxHeight", "Glasses", 66.666664f, 0.0f, 100.0f, "The maximum height for the glasses overlay, as a percentage of the screen height") / 100.0f;
        this.glassesScale = this.config.getFloat("scale", "Glasses", 100.0f, 0.0f, 100000.0f, "The scale for the glasses overlay, as a percentage of the default") / 100.0f;
        this.config.setCategoryComment("Glasses", "Configuration for the glasses overlay. This can be configured ingame much more easily with the Power Drill.");
        if (!Loader.isModLoaded((String)"waila")) {
            this.showWailaInformation = false;
            this.disableWaila = false;
        }
        this.config.save();
        if (!this.optionalMode) {
            RecipeSorter.register((String)"fruitphone:upgrade", FruitUpgradeRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"after:forge:shapedore");
            FruitItems.register();
            FruitRecipes.register();
            FruitSounds.register();
            CapabilityManager.INSTANCE.register(FruitEquipmentCapability.class, (Capability.IStorage)new FruitEquipmentStorage(), FruitPhone$$Lambda$1.lambdaFactory$());
            proxy.preInit();
        }
        this.NETWORK = NetworkContext.forChannel("FruitPhone").register(EquipmentDataPacket.class).register(SetAlwaysOnPacket.class).register(ProbeDataPacket.class);
        MinecraftForge.EVENT_BUS.register((Object)proxy);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void saveConfig() {
        this.config.get("Glasses", "gravity", "north_west").set(this.glassesGravity.toString());
        this.config.get("Glasses", "xOffset", 10).set(this.glassesXOffset);
        this.config.get("Glasses", "yOffset", 10).set(this.glassesYOffset);
        this.config.get("Glasses", "maxWidth", 33.33333206176758).set((double)(this.maxGlassesWidth * 100.0f));
        this.config.get("Glasses", "maxHeight", 66.66666412353516).set((double)(this.maxGlassesHeight * 100.0f));
        this.config.get("Glasses", "scale", 100.0).set((double)(this.glassesScale * 100.0f));
        this.config.get("General", "optional", false).set(this.optionalMode);
        this.config.save();
    }

    @Mod.EventHandler
    public void onPostInit(FMLPostInitializationEvent e) {
        proxy.postInit();
        if (this.disableWaila) {
            WailaCompat.init();
            this.config.get("General", "disableWaila", true).set(false);
            this.config.save();
        }
    }

    @NetworkCheckHandler
    public boolean onConnectionOffered(Map<String, String> mods, Side offerer) {
        if (this.optionalMode) {
            return true;
        }
        if (offerer == Side.SERVER) {
            return true;
        }
        return mods.containsKey(MODID) && VERSION.equals(mods.get(MODID));
    }

    @SubscribeEvent
    public void onStartTracking(PlayerEvent.StartTracking e) {
        EquipmentDataPacket.forEntity(e.getTarget()).ifPresent(FruitPhone$$Lambda$2.lambdaFactory$(e));
    }

    @SubscribeEvent
    public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent e) {
        new SetAlwaysOnPacket(e.player.field_70170_p.func_82736_K().func_82766_b("fruitphone:alwaysOn")).sendTo(e.player);
        EquipmentDataPacket.forEntity((Entity)e.player).ifPresent(FruitPhone$$Lambda$3.lambdaFactory$(e));
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load e) {
        if (!e.getWorld().func_82736_K().func_82766_b("fruitphone:alwaysOn")) {
            e.getWorld().func_82736_K().func_180262_a("fruitphone:alwaysOn", "false", GameRules.ValueType.BOOLEAN_VALUE);
        }
        World world = e.getWorld();
        GameRulePoller.forBooleanRule("fruitphone:alwaysOn", world, FruitPhone$$Lambda$4.lambdaFactory$(world));
    }

    @SubscribeEvent
    public void onCapabilityAttachEntity(AttachCapabilitiesEvent<Entity> e) {
        if (this.optionalMode) {
            return;
        }
        if (e.getObject() instanceof EntityPlayer) {
            e.addCapability(new ResourceLocation(MODID, "equipment"), (ICapabilityProvider)new FruitEquipmentCapability());
        }
    }

    @SubscribeEvent
    public void onSwitchDimensions(PlayerEvent.PlayerChangedDimensionEvent e) {
        new SetAlwaysOnPacket(e.player.field_70170_p.func_82736_K().func_82766_b("fruitphone:alwaysOn")).sendTo(e.player);
        EquipmentDataPacket.forEntity((Entity)e.player).ifPresent(FruitPhone$$Lambda$5.lambdaFactory$(e));
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone e) {
        if (!e.isWasDeath() && e.getOriginal().hasCapability(CAPABILITY_EQUIPMENT, null) && e.getEntityPlayer().hasCapability(CAPABILITY_EQUIPMENT, null)) {
            FruitEquipmentCapability orig = (FruitEquipmentCapability)e.getOriginal().getCapability(CAPABILITY_EQUIPMENT, null);
            FruitEquipmentCapability nw = (FruitEquipmentCapability)e.getEntityPlayer().getCapability(CAPABILITY_EQUIPMENT, null);
            nw.glasses = orig.glasses;
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent e) {
        if (e.phase == TickEvent.Phase.START) {
            if (e.player.field_70170_p.field_72995_K) {
                return;
            }
            Vec3d eyes = e.player.func_174824_e(1.0f);
            Vec3d look = e.player.func_70040_Z();
            double dist = 4.0;
            Vec3d max = eyes.func_72441_c(look.field_72450_a * dist, look.field_72448_b * dist, look.field_72449_c * dist);
            RayTraceResult rtr = e.player.field_70170_p.func_147447_a(eyes, max, false, false, false);
            if (rtr != null && rtr.field_72313_a == RayTraceResult.Type.BLOCK) {
                ArrayList list = Lists.newArrayList();
                BlockPos pos = rtr.func_178782_a();
                TileEntity te = e.player.field_70170_p.func_175625_s(pos);
                if (te != null) {
                    NBTTagCompound tag = this.generateProbeData(e.player, te, rtr.field_178784_b, list);
                    ProbeDataPacket pkt = new ProbeDataPacket(pos, list, tag);
                    if (!Objects.equal((Object)pkt, (Object)this.lastData.get(e.player))) {
                        pkt.sendTo(e.player);
                    }
                    this.lastData.put(e.player, pkt);
                } else {
                    this.lastData.remove(e.player);
                }
            }
        }
    }

    public NBTTagCompound generateProbeData(EntityPlayer player, TileEntity te, EnumFacing sideHit, List<IProbeData> list) {
        NBTTagCompound tag = new NBTTagCompound();
        try {
            if (player instanceof EntityPlayerMP && this.showWailaInformation) {
                boolean hasBlockOrTile = false;
                if (ModuleRegistrar.instance().hasNBTProviders((Object)te.func_145838_q())) {
                    hasBlockOrTile = true;
                }
                if (ModuleRegistrar.instance().hasNBTProviders((Object)te)) {
                    hasBlockOrTile = true;
                }
                if (hasBlockOrTile) {
                    tag.func_74768_a("x", te.func_174877_v().func_177958_n());
                    tag.func_74768_a("y", te.func_174877_v().func_177956_o());
                    tag.func_74768_a("z", te.func_174877_v().func_177952_p());
                    tag.func_74778_a("id", TileEntity.func_190559_a(te.getClass()).toString());
                    for (List li : ModuleRegistrar.instance().getNBTProviders((Object)te.func_145838_q()).values()) {
                        for (IWailaDataProvider iwdp : li) {
                            tag = iwdp.getNBTData((EntityPlayerMP)player, te, tag, player.field_70170_p, te.func_174877_v());
                        }
                    }
                    for (List li : ModuleRegistrar.instance().getNBTProviders((Object)te).values()) {
                        for (IWailaDataProvider iwdp : li) {
                            tag = iwdp.getNBTData((EntityPlayerMP)player, te, tag, player.field_70170_p, te.func_174877_v());
                        }
                    }
                }
                tag.func_74768_a("WailaX", te.func_174877_v().func_177958_n());
                tag.func_74768_a("WailaY", te.func_174877_v().func_177956_o());
                tag.func_74768_a("WailaZ", te.func_174877_v().func_177952_p());
                tag.func_74778_a("WailaID", TileEntity.func_190559_a(te.getClass()).toString());
            }
        }
        catch (Throwable t) {
            log.warn("Exception thrown while building Waila data for {}, {}, {} in DIM{}", new Object[]{te.func_174877_v().func_177958_n(), te.func_174877_v().func_177956_o(), te.func_174877_v().func_177952_p(), te.func_145831_w().field_73011_w.getDimension(), t});
            tag = new NBTTagCompound();
            list.add((IProbeData)new ProbeData().withLabel((ITextComponent)new TextComponentTranslation("fruitphone.wailaError", new Object[0])));
        }
        try {
            if (te.hasCapability(CAPABILITY_PROBE, sideHit)) {
                ((IProbeDataProvider)te.getCapability(CAPABILITY_PROBE, sideHit)).provideProbeData(list);
                return tag;
            }
            if (te.hasCapability(CAPABILITY_PROBE, null)) {
                ((IProbeDataProvider)te.getCapability(CAPABILITY_PROBE, null)).provideProbeData(list);
                return tag;
            }
        }
        catch (Throwable t) {
            log.warn("Exception thrown while building probe data for {}, {}, {} in DIM{}", new Object[]{te.func_174877_v().func_177958_n(), te.func_174877_v().func_177956_o(), te.func_174877_v().func_177952_p(), te.func_145831_w().field_73011_w.getDimension(), t});
            list.clear();
            list.add((IProbeData)new ProbeData().withLabel((ITextComponent)new TextComponentTranslation("fruitphone.probeError", new Object[0])));
            return new NBTTagCompound();
        }
        try {
            VanillaProviders.provideProbeData(te, list);
            IEnergyStorage sidelessEnergy = null;
            try {
                if (te.hasCapability(CapabilityEnergy.ENERGY, null)) {
                    sidelessEnergy = (IEnergyStorage)te.getCapability(CapabilityEnergy.ENERGY, null);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            IFluidHandler sidelessFluid = null;
            try {
                if (te.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)) {
                    sidelessFluid = (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
                }
            }
            catch (Throwable li) {
                // empty catch block
            }
            IItemHandler sidelessItem = null;
            try {
                if (te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
                    sidelessItem = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (sidelessItem == null && te instanceof IInventory) {
                sidelessItem = new InvWrapper((IInventory)te);
            }
            if (te instanceof TileEntityEnderChest) {
                sidelessItem = new InvWrapper((IInventory)player.func_71005_bN());
            }
            IEnergyStorage sidedEnergy = null;
            if (te.hasCapability(CapabilityEnergy.ENERGY, sideHit)) {
                sidedEnergy = (IEnergyStorage)te.getCapability(CapabilityEnergy.ENERGY, sideHit);
            }
            IFluidHandler sidedFluid = null;
            if (te.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, sideHit)) {
                sidedFluid = (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, sideHit);
            }
            IItemHandler sidedItem = null;
            if (te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, sideHit)) {
                sidedItem = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, sideHit);
            } else if (te instanceof ISidedInventory) {
                sidedItem = new SidedInvWrapper((ISidedInventory)te, sideHit);
            }
            if (sidelessEnergy != null) {
                try {
                    this.addEnergyData(list, sidelessEnergy);
                }
                catch (Throwable t) {
                    if (sidedEnergy != null) {
                        this.addEnergyData(list, sidedEnergy);
                    }
                }
            } else if (sidedEnergy != null) {
                this.addEnergyData(list, sidedEnergy);
            }
            if (sidelessFluid != null) {
                try {
                    this.addFluidData(list, sidelessFluid);
                }
                catch (Throwable t) {
                    if (sidedFluid != null) {
                        this.addFluidData(list, sidedFluid);
                    }
                }
            } else if (sidedFluid != null) {
                this.addFluidData(list, sidedFluid);
            }
            if (sidelessItem != null) {
                try {
                    this.addItemData(list, sidelessItem);
                }
                catch (Throwable t) {
                    if (sidedItem != null) {
                        this.addItemData(list, sidedItem);
                    }
                }
            } else if (sidedItem != null) {
                this.addItemData(list, sidedItem);
            }
            return tag;
        }
        catch (Throwable t) {
            log.warn("Exception thrown while building default probe data for {}, {}, {} in DIM{}", new Object[]{te.func_174877_v().func_177958_n(), te.func_174877_v().func_177956_o(), te.func_174877_v().func_177952_p(), te.func_145831_w().field_73011_w.getDimension(), t});
            list.clear();
            list.add((IProbeData)new ProbeData().withLabel((ITextComponent)new TextComponentTranslation("fruitphone.capError", new Object[0])));
            return new NBTTagCompound();
        }
    }

    private void addItemData(List<IProbeData> list, IItemHandler item) {
        ArrayList is = Lists.newArrayListWithCapacity((int)item.getSlots());
        for (int i = 0; i < item.getSlots(); ++i) {
            is.add(item.getStackInSlot(i).func_77946_l());
        }
        list.add((IProbeData)new ProbeData().withInventory(ImmutableList.copyOf((Collection)is)));
    }

    private void addFluidData(List<IProbeData> list, IFluidHandler fluid) {
        for (IFluidTankProperties tank : fluid.getTankProperties()) {
            int amt;
            Unit unit;
            if (tank.getContents() == null) {
                unit = UnitDictionary.BUCKETS_ANY;
                amt = 0;
            } else {
                unit = UnitDictionary.getInstance().getUnit(tank.getContents().getFluid());
                amt = tank.getContents().amount;
            }
            list.add((IProbeData)new ProbeData().withBar(0.0, (double)amt / 1000.0, (double)tank.getCapacity() / 1000.0, (IUnit)unit));
        }
    }

    private void addEnergyData(List<IProbeData> list, IEnergyStorage energy) {
        list.add((IProbeData)new ProbeData().withBar(0.0, (double)energy.getEnergyStored(), (double)energy.getMaxEnergyStored(), (IUnit)UnitDictionary.FORGE_ENERGY));
    }

    @SubscribeEvent
    public void onDrops(PlayerDropsEvent e) {
        ItemStack glasses;
        if (this.optionalMode) {
            return;
        }
        if (e.getEntityPlayer().hasCapability(CAPABILITY_EQUIPMENT, null) && !(glasses = ((FruitEquipmentCapability)e.getEntityPlayer().getCapability(FruitPhone.CAPABILITY_EQUIPMENT, null)).glasses).func_190926_b()) {
            EntityItem ei = new EntityItem(e.getEntityPlayer().field_70170_p, e.getEntityPlayer().field_70165_t, e.getEntityPlayer().field_70163_u + 1.2, e.getEntityPlayer().field_70161_v, glasses);
            ei.func_174869_p();
            e.getDrops().add(ei);
            ((FruitEquipmentCapability)e.getEntityPlayer().getCapability(FruitPhone.CAPABILITY_EQUIPMENT, null)).glasses = ItemStack.field_190927_a;
        }
    }

    private static /* synthetic */ void lambda$onWorldLoad$2(World world, Boolean newValue) {
        log.info("Always-on mode {}abled", new Object[]{newValue != false ? "en" : "dis"});
        new SetAlwaysOnPacket(newValue).sendToAllIn(world);
    }

    static /* synthetic */ void access$lambda$0(PlayerEvent.StartTracking startTracking, EquipmentDataPacket equipmentDataPacket) {
        equipmentDataPacket.sendTo(startTracking.getEntityPlayer());
    }

    static /* synthetic */ void access$lambda$1(PlayerEvent.PlayerLoggedInEvent playerLoggedInEvent, EquipmentDataPacket equipmentDataPacket) {
        equipmentDataPacket.sendTo(playerLoggedInEvent.player);
    }

    static /* synthetic */ void access$lambda$2(World world, Boolean bl) {
        FruitPhone.lambda$onWorldLoad$2(world, bl);
    }

    static /* synthetic */ void access$lambda$3(PlayerEvent.PlayerChangedDimensionEvent playerChangedDimensionEvent, EquipmentDataPacket equipmentDataPacket) {
        equipmentDataPacket.sendTo(playerChangedDimensionEvent.player);
    }
}

