/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.fruitphone.client.render;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class Rendering {
    private static final DummyScreen GUI = new DummyScreen();

    public static void bindTexture(ResourceLocation resloc) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(resloc);
    }

    public static void drawRect(int left, int top, int right, int bottom, int color) {
        Gui.func_73734_a((int)left, (int)top, (int)right, (int)bottom, (int)color);
    }

    public static void color3(int color) {
        Rendering.color4(color | 0xFF000000);
    }

    public static void color4(int color) {
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)a);
    }

    public static void drawRect(double left, double top, double right, double bottom, int color) {
        double swap;
        if (left < right) {
            swap = left;
            left = right;
            right = swap;
        }
        if (top < bottom) {
            swap = top;
            top = bottom;
            bottom = swap;
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer vertexbuffer = tessellator.func_178180_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        Rendering.color4(color);
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        vertexbuffer.func_181662_b(left, bottom, 0.0).func_181675_d();
        vertexbuffer.func_181662_b(right, bottom, 0.0).func_181675_d();
        vertexbuffer.func_181662_b(right, top, 0.0).func_181675_d();
        vertexbuffer.func_181662_b(left, top, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
    }

    public static void drawTexturedRect(double left, double top, double right, double bottom, float minU, float minV, float maxU, float maxV, int color) {
        double swap;
        if (left < right) {
            swap = left;
            left = right;
            right = swap;
        }
        if (top < bottom) {
            swap = top;
            top = bottom;
            bottom = swap;
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer vertexbuffer = tessellator.func_178180_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        Rendering.color4(color);
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vertexbuffer.func_181662_b(left, bottom, 0.0).func_187315_a((double)minU, (double)maxV).func_181675_d();
        vertexbuffer.func_181662_b(right, bottom, 0.0).func_187315_a((double)maxU, (double)maxV).func_181675_d();
        vertexbuffer.func_181662_b(right, top, 0.0).func_187315_a((double)maxU, (double)minV).func_181675_d();
        vertexbuffer.func_181662_b(left, top, 0.0).func_187315_a((double)minU, (double)minV).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179084_k();
    }

    public static void drawTexturedRect(double left, double top, double right, double bottom, TextureAtlasSprite textureSprite) {
        double swap;
        if (left < right) {
            swap = left;
            left = right;
            right = swap;
        }
        if (top < bottom) {
            swap = top;
            top = bottom;
            bottom = swap;
        }
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer vertexbuffer = tessellator.func_178180_c();
        double maxU = textureSprite.func_94209_e();
        double maxV = textureSprite.func_94206_g();
        double minU = textureSprite.func_94214_a(left - right);
        double minV = textureSprite.func_94207_b(top - bottom);
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vertexbuffer.func_181662_b(left, bottom, 0.0).func_187315_a(minU, maxV).func_181675_d();
        vertexbuffer.func_181662_b(right, bottom, 0.0).func_187315_a(maxU, maxV).func_181675_d();
        vertexbuffer.func_181662_b(right, top, 0.0).func_187315_a(maxU, minV).func_181675_d();
        vertexbuffer.func_181662_b(left, top, 0.0).func_187315_a(minU, minV).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void drawGradientRect(int left, int top, int right, int bottom, int startColor, int endColor) {
        GUI.func_73733_a(left, top, right, bottom, startColor, endColor);
    }

    public static void drawHorizontalLine(int startX, int endX, int y, int color) {
        GUI.func_73730_a(startX, endX, y, color);
    }

    public static void drawHoveringText(List<String> textLines, int x, int y) {
        GUI.func_146283_a(textLines, x, y);
    }

    public static void drawHoveringText(List<String> textLines, int x, int y, FontRenderer font) {
        GUI.drawHoveringText(textLines, x, y, font);
    }

    public static void drawVerticalLine(int x, int startY, int endY, int color) {
        GUI.func_73728_b(x, startY, endY, color);
    }

    public static void renderToolTip(ItemStack stack, int x, int y) {
        GUI.func_146285_a(stack, x, y);
    }

    public static void drawBackground(int tint) {
        GUI.func_146278_c(tint);
    }

    public static void drawCenteredString(FontRenderer fontRendererIn, String text, int x, int y, int color) {
        GUI.func_73732_a(fontRendererIn, text, x, y, color);
    }

    public static void drawDefaultBackground() {
        GUI.func_146276_q_();
    }

    public static void drawString(FontRenderer fontRendererIn, String text, int x, int y, int color) {
        GUI.func_73731_b(fontRendererIn, text, x, y, color);
    }

    public static void drawTexturedModalRect(float xCoord, float yCoord, int minU, int minV, int maxU, int maxV) {
        GUI.func_175174_a(xCoord, yCoord, minU, minV, maxU, maxV);
    }

    public static void drawTexturedModalRect(int x, int y, int textureX, int textureY, int width, int height) {
        GUI.func_73729_b(x, y, textureX, textureY, width, height);
    }

    public static void drawTexturedModalRect(int xCoord, int yCoord, TextureAtlasSprite textureSprite, int widthIn, int heightIn) {
        GUI.func_175175_a(xCoord, yCoord, textureSprite, widthIn, heightIn);
    }

    public static void drawWorldBackground(int tint) {
        GUI.func_146270_b(tint);
    }

    private Rendering() {
    }

    private static class DummyScreen
    extends GuiScreen {
        private DummyScreen() {
        }

        public void func_73733_a(int left, int top, int right, int bottom, int startColor, int endColor) {
            super.func_73733_a(left, top, right, bottom, startColor, endColor);
        }

        public void func_73730_a(int startX, int endX, int y, int color) {
            super.func_73730_a(startX, endX, y, color);
        }

        public void func_146283_a(List<String> textLines, int x, int y) {
            super.func_146283_a(textLines, x, y);
        }

        public void drawHoveringText(List<String> textLines, int x, int y, FontRenderer font) {
            super.drawHoveringText(textLines, x, y, font);
        }

        public void func_73728_b(int x, int startY, int endY, int color) {
            super.func_73728_b(x, startY, endY, color);
        }

        public void func_146285_a(ItemStack stack, int x, int y) {
            super.func_146285_a(stack, x, y);
        }
    }
}

