/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.fruitphone.repackage.com.elytradev.concrete.network;

import com.elytradev.fruitphone.repackage.com.elytradev.concrete.network.DefaultMarshallers$$Lambda$1;
import com.elytradev.fruitphone.repackage.com.elytradev.concrete.network.DefaultMarshallers$$Lambda$10;
import com.elytradev.fruitphone.repackage.com.elytradev.concrete.network.DefaultMarshallers$$Lambda$11;
import com.elytradev.fruitphone.repackage.com.elytradev.concrete.network.DefaultMarshallers$$Lambda$12;
import com.elytradev.fruitphone.repackage.com.elytradev.concrete.network.DefaultMarshallers$$Lambda$13;
import com.elytradev.fruitphone.repackage.com.elytradev.concrete.network.DefaultMarshallers$$Lambda$14;
import com.elytradev.fruitphone.repackage.com.elytradev.concrete.network.DefaultMarshallers$$Lambda$15;
import com.elytradev.fruitphone.repackage.com.elytradev.concrete.network.DefaultMarshallers$$Lambda$16;
import com.elytradev.fruitphone.repackage.com.elytradev.concrete.network.DefaultMarshallers$$Lambda$17;
import com.elytradev.fruitphone.repackage.com.elytradev.concrete.network.DefaultMarshallers$$Lambda$18;
import com.elytradev.fruitphone.repackage.com.elytradev.concrete.network.DefaultMarshallers$$Lambda$19;
import com.elytradev.fruitphone.repackage.com.elytradev.concrete.network.DefaultMarshallers$$Lambda$2;
import com.elytradev.fruitphone.repackage.com.elytradev.concrete.network.DefaultMarshallers$$Lambda$20;
import com.elytradev.fruitphone.repackage.com.elytradev.concrete.network.DefaultMarshallers$$Lambda$21;
import com.elytradev.fruitphone.repackage.com.elytradev.concrete.network.DefaultMarshallers$$Lambda$22;
import com.elytradev.fruitphone.repackage.com.elytradev.concrete.network.DefaultMarshallers$$Lambda$23;
import com.elytradev.fruitphone.repackage.com.elytradev.concrete.network.DefaultMarshallers$$Lambda$24;
import com.elytradev.fruitphone.repackage.com.elytradev.concrete.network.DefaultMarshallers$$Lambda$25;
import com.elytradev.fruitphone.repackage.com.elytradev.concrete.network.DefaultMarshallers$$Lambda$26;
import com.elytradev.fruitphone.repackage.com.elytradev.concrete.network.DefaultMarshallers$$Lambda$27;
import com.elytradev.fruitphone.repackage.com.elytradev.concrete.network.DefaultMarshallers$$Lambda$28;
import com.elytradev.fruitphone.repackage.com.elytradev.concrete.network.DefaultMarshallers$$Lambda$3;
import com.elytradev.fruitphone.repackage.com.elytradev.concrete.network.DefaultMarshallers$$Lambda$4;
import com.elytradev.fruitphone.repackage.com.elytradev.concrete.network.DefaultMarshallers$$Lambda$5;
import com.elytradev.fruitphone.repackage.com.elytradev.concrete.network.DefaultMarshallers$$Lambda$6;
import com.elytradev.fruitphone.repackage.com.elytradev.concrete.network.DefaultMarshallers$$Lambda$7;
import com.elytradev.fruitphone.repackage.com.elytradev.concrete.network.DefaultMarshallers$$Lambda$8;
import com.elytradev.fruitphone.repackage.com.elytradev.concrete.network.DefaultMarshallers$$Lambda$9;
import com.elytradev.fruitphone.repackage.com.elytradev.concrete.network.Marshaller;
import com.elytradev.fruitphone.repackage.com.elytradev.concrete.network.NetworkContext;
import com.elytradev.fruitphone.repackage.com.elytradev.concrete.network.exception.BadMessageException;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.primitives.Ints;
import io.netty.buffer.ByteBuf;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class DefaultMarshallers {
    public static final Marshaller<? extends Number> UINT8 = DefaultMarshallers.weld(DefaultMarshallers$$Lambda$1.lambdaFactory$(), DefaultMarshallers$$Lambda$2.lambdaFactory$());
    public static final Marshaller<? extends Number> INT8 = DefaultMarshallers.weld(DefaultMarshallers$$Lambda$3.lambdaFactory$(), DefaultMarshallers$$Lambda$4.lambdaFactory$());
    public static final Marshaller<? extends Number> UINT16 = DefaultMarshallers.weld(DefaultMarshallers$$Lambda$5.lambdaFactory$(), DefaultMarshallers$$Lambda$6.lambdaFactory$());
    public static final Marshaller<? extends Number> INT16 = DefaultMarshallers.weld(DefaultMarshallers$$Lambda$7.lambdaFactory$(), DefaultMarshallers$$Lambda$8.lambdaFactory$());
    public static final Marshaller<? extends Number> UINT24 = DefaultMarshallers.weld(DefaultMarshallers$$Lambda$9.lambdaFactory$(), DefaultMarshallers$$Lambda$10.lambdaFactory$());
    public static final Marshaller<? extends Number> INT24 = DefaultMarshallers.weld(DefaultMarshallers$$Lambda$11.lambdaFactory$(), DefaultMarshallers$$Lambda$12.lambdaFactory$());
    public static final Marshaller<? extends Number> UINT32 = DefaultMarshallers.weld(DefaultMarshallers$$Lambda$13.lambdaFactory$(), DefaultMarshallers$$Lambda$14.lambdaFactory$());
    public static final Marshaller<? extends Number> INT32 = DefaultMarshallers.weld(DefaultMarshallers$$Lambda$15.lambdaFactory$(), DefaultMarshallers$$Lambda$16.lambdaFactory$());
    public static final Marshaller<? extends Number> INT64 = DefaultMarshallers.weld(DefaultMarshallers$$Lambda$17.lambdaFactory$(), DefaultMarshallers$$Lambda$18.lambdaFactory$());
    public static final Marshaller<? extends Number> FLOAT = DefaultMarshallers.weld(DefaultMarshallers$$Lambda$19.lambdaFactory$(), DefaultMarshallers$$Lambda$20.lambdaFactory$());
    public static final Marshaller<? extends Number> DOUBLE = DefaultMarshallers.weld(DefaultMarshallers$$Lambda$21.lambdaFactory$(), DefaultMarshallers$$Lambda$22.lambdaFactory$());
    public static final Marshaller<? extends Number> VARINT = new VarIntMarshaller();
    public static final Marshaller<NBTTagCompound> NBT = DefaultMarshallers.weld(DefaultMarshallers$$Lambda$23.lambdaFactory$(), DefaultMarshallers$$Lambda$24.lambdaFactory$());
    public static final Marshaller<BlockPos> BLOCKPOS = new BlockPosMarshaller();
    public static final Marshaller<String> STRING = DefaultMarshallers.weld(DefaultMarshallers$$Lambda$25.lambdaFactory$(), DefaultMarshallers$$Lambda$26.lambdaFactory$());
    public static final Marshaller<ItemStack> ITEMSTACK = DefaultMarshallers.weld(DefaultMarshallers$$Lambda$27.lambdaFactory$(), DefaultMarshallers$$Lambda$28.lambdaFactory$());
    public static final Marshaller<? extends ByteBuf> BYTEBUF = new ByteBufMarshaller();
    private static final Map<String, Marshaller<?>> byName = Maps.newHashMap();

    private static void put(Marshaller<?> m, String ... names) {
        for (String name : names) {
            byName.put(name, m);
        }
    }

    private static <T> Marshaller<T> weld(final Serializer<T> serializer, final Deserializer deserializer) {
        return new Marshaller<T>(){

            @Override
            public void marshal(ByteBuf out, T t) {
                serializer.serialize(out, t);
            }

            @Override
            public T unmarshal(ByteBuf in) {
                return deserializer.deserialize(in);
            }
        };
    }

    public static <T> Marshaller<T> getByName(String name) {
        Marshaller marshaller;
        block9: {
            if (name.endsWith("-list")) {
                Marshaller<T> m = DefaultMarshallers.getByName(name = name.substring(0, name.length() - 5));
                if (m != null) {
                    return new ListMarshaller<T>(m);
                }
                return null;
            }
            if (byName.containsKey(name.toLowerCase(Locale.ROOT))) {
                return byName.get(name.toLowerCase(Locale.ROOT));
            }
            marshaller = null;
            try {
                Class<?> clazz = Class.forName(name);
                if (!Marshaller.class.isAssignableFrom(clazz)) break block9;
                try {
                    Field inst = clazz.getDeclaredField("INSTANCE");
                    inst.setAccessible(true);
                    marshaller = (Marshaller)inst.get(null);
                }
                catch (Exception e) {
                    NetworkContext.log.warn(clazz.getName() + " does not appear to define an INSTANCE field, but it should");
                }
                if (marshaller != null) break block9;
                try {
                    Constructor<?> cons = clazz.getConstructor(new Class[0]);
                    marshaller = (Marshaller)cons.newInstance(new Object[0]);
                }
                catch (Exception e) {
                    throw new BadMessageException("Cannot instanciate marshaller class " + clazz.getName());
                }
            }
            catch (Exception e) {
                return null;
            }
        }
        return marshaller;
    }

    public static <T> Marshaller<T> getByType(Class<T> type) {
        if (String.class.isAssignableFrom(type)) {
            return STRING;
        }
        if (BlockPos.class.isAssignableFrom(type)) {
            return BLOCKPOS;
        }
        if (NBTTagCompound.class.isAssignableFrom(type)) {
            return NBT;
        }
        if (type.isEnum()) {
            return new EnumMarshaller<T>(type);
        }
        if (ItemStack.class.isAssignableFrom(type)) {
            return ITEMSTACK;
        }
        if (ByteBuf.class.isAssignableFrom(type)) {
            return BYTEBUF;
        }
        return null;
    }

    static {
        DefaultMarshallers.put(UINT8, "u8", "uint8", "ubyte");
        DefaultMarshallers.put(INT8, "i8", "int8", "byte");
        DefaultMarshallers.put(UINT16, "u16", "uint16", "char", "ushort");
        DefaultMarshallers.put(INT16, "i16", "int16", "short");
        DefaultMarshallers.put(UINT24, "u24", "uint24", "umedium");
        DefaultMarshallers.put(INT24, "i24", "int24", "medium");
        DefaultMarshallers.put(UINT32, "u32", "uint32", "uint", "uinteger");
        DefaultMarshallers.put(INT32, "i32", "int32", "int", "integer");
        DefaultMarshallers.put(INT64, "i64", "int64", "long");
        DefaultMarshallers.put(FLOAT, "f32", "float");
        DefaultMarshallers.put(DOUBLE, "f64", "double");
        DefaultMarshallers.put(VARINT, "varint");
        DefaultMarshallers.put(NBT, "nbt");
        DefaultMarshallers.put(BLOCKPOS, "blockpos");
        DefaultMarshallers.put(STRING, "string", "str", "utf8");
        DefaultMarshallers.put(ITEMSTACK, "item", "stack", "itemstack");
    }

    private static interface Deserializer {
        public Object deserialize(ByteBuf var1);
    }

    private static interface Serializer<T> {
        public void serialize(ByteBuf var1, T var2);
    }

    private static class ByteBufMarshaller
    implements Marshaller<ByteBuf> {
        private ByteBufMarshaller() {
        }

        @Override
        public ByteBuf unmarshal(ByteBuf in) {
            int length = ByteBufUtils.readVarInt((ByteBuf)in, (int)5);
            return in.readBytes(length);
        }

        @Override
        public void marshal(ByteBuf out, ByteBuf t) {
            if (t != null) {
                ByteBufUtils.writeVarInt((ByteBuf)out, (int)t.readableBytes(), (int)5);
                out.writeBytes(t.readBytes(t.readableBytes()));
            } else {
                ByteBufUtils.writeVarInt((ByteBuf)out, (int)0, (int)5);
            }
        }
    }

    private static class EnumMarshaller<T extends Enum<T>>
    implements Marshaller<T> {
        private final Class<T> clazz;
        private final T[] constants;

        public EnumMarshaller(Class<T> clazz) {
            this.clazz = clazz;
            this.constants = (Enum[])clazz.getEnumConstants();
        }

        @Override
        public T unmarshal(ByteBuf in) {
            int ordinal = this.constants.length < 256 ? in.readUnsignedByte() : (this.constants.length < 65536 ? in.readUnsignedShort() : (this.constants.length < 0x1000000 ? in.readUnsignedMedium() : Ints.checkedCast((long)in.readUnsignedInt())));
            return this.constants[ordinal];
        }

        @Override
        public void marshal(ByteBuf out, T t) {
            if (this.constants.length < 256) {
                out.writeByte(((Enum)t).ordinal());
            } else if (this.constants.length < 65536) {
                out.writeShort(((Enum)t).ordinal());
            } else if (this.constants.length < 0x1000000) {
                out.writeMedium(((Enum)t).ordinal());
            } else {
                out.writeInt(((Enum)t).ordinal());
            }
        }
    }

    private static class VarIntMarshaller
    implements Marshaller<Number> {
        private VarIntMarshaller() {
        }

        @Override
        public Number unmarshal(ByteBuf in) {
            return ByteBufUtils.readVarInt((ByteBuf)in, (int)5);
        }

        @Override
        public void marshal(ByteBuf out, Number t) {
            ByteBufUtils.writeVarInt((ByteBuf)out, (int)t.intValue(), (int)5);
        }
    }

    private static class BlockPosMarshaller
    implements Marshaller<BlockPos> {
        private BlockPosMarshaller() {
        }

        @Override
        public BlockPos unmarshal(ByteBuf in) {
            return BlockPos.func_177969_a((long)in.readLong());
        }

        @Override
        public void marshal(ByteBuf out, BlockPos t) {
            out.writeLong(t.func_177986_g());
        }
    }

    public static class ListMarshaller<T>
    implements Marshaller<List<T>> {
        private Marshaller<T> underlying;

        public ListMarshaller(Marshaller<T> underlying) {
            this.underlying = underlying;
        }

        @Override
        public List<T> unmarshal(ByteBuf in) {
            int size = ByteBufUtils.readVarInt((ByteBuf)in, (int)5);
            ArrayList li = Lists.newArrayListWithExpectedSize((int)size);
            for (int i = 0; i < size; ++i) {
                li.add(this.underlying.unmarshal(in));
            }
            return li;
        }

        @Override
        public void marshal(ByteBuf out, List<T> li) {
            if (li == null) {
                ByteBufUtils.writeVarInt((ByteBuf)out, (int)0, (int)5);
            } else {
                ByteBufUtils.writeVarInt((ByteBuf)out, (int)li.size(), (int)5);
                for (T t : li) {
                    this.underlying.marshal(out, t);
                }
            }
        }
    }
}

