/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.fruitphone;

import com.google.common.primitives.Doubles;
import com.google.common.primitives.Ints;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class GameRulePoller {
    private final String rule;
    private final Consumer<String> listener;
    private final World world;
    private String lastValue;

    private GameRulePoller(String rule, Consumer<String> listener, World world) {
        this.rule = rule;
        this.listener = listener;
        this.world = world;
        this.lastValue = world.func_82736_K().func_82767_a(rule);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onTick(TickEvent.WorldTickEvent e) {
        String value;
        if (e.world == this.world && !Objects.equals(this.lastValue, value = this.world.func_82736_K().func_82767_a(this.rule))) {
            this.lastValue = value;
            this.listener.accept(value);
        }
    }

    @SubscribeEvent
    public void onUnload(WorldEvent.Unload e) {
        if (e.getWorld() == this.world) {
            MinecraftForge.EVENT_BUS.unregister((Object)this);
        }
    }

    public static GameRulePoller forBooleanRule(String rule, World world, Consumer<Boolean> listener) {
        return new GameRulePoller(rule, str -> listener.accept(Boolean.parseBoolean(str)), world);
    }

    public static GameRulePoller forStringRule(String rule, World world, Consumer<String> listener) {
        return new GameRulePoller(rule, listener, world);
    }

    public static GameRulePoller forIntegerRule(String rule, World world, Consumer<Integer> listener) {
        return new GameRulePoller(rule, str -> {
            Integer i = Ints.tryParse((String)str);
            if (i != null) {
                listener.accept(i);
            } else {
                listener.accept(Boolean.parseBoolean(str) ? 1 : 0);
            }
        }, world);
    }

    public static GameRulePoller forDoubleRule(String rule, World world, Consumer<Double> listener) {
        return new GameRulePoller(rule, str -> {
            Double i = Doubles.tryParse((String)str);
            if (i != null) {
                listener.accept(i);
            } else {
                listener.accept(Boolean.parseBoolean(str) ? 1.0 : 0.0);
            }
        }, world);
    }
}

